/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.DateTimeUtil;
import com.xmlmind.xml.wxs.datatype.DateTimeValue;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.Value;

public class DurationValue
extends Value {
    private boolean negative;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private double second;
    private static final DateTimeValue[] dateTimes = new DateTimeValue[]{new DateTimeValue(1696, 9, 1, 0, 0, 0.0, 1, 0, 0), new DateTimeValue(1697, 2, 1, 0, 0, 0.0, 1, 0, 0), new DateTimeValue(1903, 3, 1, 0, 0, 0.0, 1, 0, 0), new DateTimeValue(1903, 7, 1, 0, 0, 0.0, 1, 0, 0)};

    public static DurationValue parseDuration(String string) throws InvalidDataException {
        int n;
        int n2 = string.length();
        if (n2 <= 1) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("durationSyntax", string));
        }
        DurationValue durationValue = new DurationValue();
        int n3 = 0;
        if (string.charAt(0) == '-') {
            durationValue.negative = true;
            ++n3;
        }
        if (n3 + 2 >= n2 || string.charAt(n3) != 'P') {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("durationSyntax", string));
        }
        boolean bl = false;
        boolean bl2 = false;
        int n4 = string.indexOf(84);
        if ((n = string.indexOf(89, ++n3)) > n3) {
            durationValue.year = DateTimeUtil.parseNonNegativeInt(string, n3, n);
            bl = true;
            n3 = n + 1;
        }
        if ((n = string.indexOf(77, n3)) > n3 && (n4 < 0 || n < n4)) {
            durationValue.month = DateTimeUtil.parseNonNegativeInt(string, n3, n);
            bl = true;
            n3 = n + 1;
        }
        if ((n = string.indexOf(68, n3)) > n3) {
            durationValue.day = DateTimeUtil.parseNonNegativeInt(string, n3, n);
            bl = true;
            n3 = n + 1;
        }
        if (n4 >= 0) {
            if (n4 == n3) {
                if ((n = string.indexOf(72, ++n3)) > n3) {
                    durationValue.hour = DateTimeUtil.parseNonNegativeInt(string, n3, n);
                    bl2 = true;
                    n3 = n + 1;
                }
                if ((n = string.indexOf(77, n3)) > n3) {
                    durationValue.minute = DateTimeUtil.parseNonNegativeInt(string, n3, n);
                    bl2 = true;
                    n3 = n + 1;
                }
                if ((n = string.indexOf(83, n3)) > n3) {
                    durationValue.second = DateTimeUtil.parseNonNegativeDouble(string, n3, n);
                    bl2 = true;
                    n3 = n + 1;
                }
            }
            if (!bl2) {
                throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("durationSyntax", string));
            }
        }
        if (n3 != n2 || !bl && !bl2) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("durationSyntax", string));
        }
        return durationValue;
    }

    public DurationValue() {
    }

    public DurationValue(int n, int n2, int n3, int n4, int n5, double d) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDay(n3);
        this.setHour(n4);
        this.setMinute(n5);
        this.setSecond(d);
    }

    public void setNegative(boolean bl) {
        this.negative = bl;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setYear(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative year component");
        }
        this.year = n;
    }

    public int getYear() {
        return this.year;
    }

    public void setMonth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative month component");
        }
        this.month = n;
    }

    public int getMonth() {
        return this.month;
    }

    public void setDay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative day component");
        }
        this.day = n;
    }

    public int getDay() {
        return this.day;
    }

    public void setHour(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative hour component");
        }
        this.hour = n;
    }

    public int getHour() {
        return this.hour;
    }

    public void setMinute(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative minute component");
        }
        this.minute = n;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setSecond(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("negative second component");
        }
        this.second = d;
    }

    public double getSecond() {
        return this.second;
    }

    @Override
    public String toString() {
        if (this.year == 0 && this.month == 0 && this.day == 0 && this.hour == 0 && this.minute == 0 && this.second == 0.0) {
            return "PT0S";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.negative) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        if (this.year > 0) {
            stringBuilder.append(this.year);
            stringBuilder.append('Y');
        }
        if (this.month > 0) {
            stringBuilder.append(this.month);
            stringBuilder.append('M');
        }
        if (this.day > 0) {
            stringBuilder.append(this.day);
            stringBuilder.append('D');
        }
        if (this.hour > 0 || this.minute > 0 || this.second > 0.0) {
            stringBuilder.append('T');
            if (this.hour > 0) {
                stringBuilder.append(this.hour);
                stringBuilder.append('H');
            }
            if (this.minute > 0) {
                stringBuilder.append(this.minute);
                stringBuilder.append('M');
            }
            if (this.second > 0.0) {
                stringBuilder.append(DateTimeUtil.formatSeconds(this.second));
                stringBuilder.append('S');
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        if (this.year <= 0 && this.month <= 0) {
            return 1 + (this.day * 24 * 3600 + this.hour * 3600 + this.minute * 60 + (int)this.second);
        }
        if (this.day <= 0 && this.hour <= 0 && this.minute <= 0 && this.second <= 0.0) {
            return -1 - (this.year * 12 + this.month);
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DurationValue)) {
            return false;
        }
        return this.compareTo((DurationValue)object) == 0;
    }

    @Override
    public int compareTo(Value value) {
        if (value == null || !(value instanceof DurationValue)) {
            return -2;
        }
        DurationValue durationValue = (DurationValue)value;
        if (this.year <= 0 && this.month <= 0 && durationValue.year <= 0 && durationValue.month <= 0) {
            double d = (double)(this.day * 24 * 3600 + this.hour * 3600 + this.minute * 60) + this.second;
            if (this.negative) {
                d = -d;
            }
            double d2 = (double)(durationValue.day * 24 * 3600 + durationValue.hour * 3600 + durationValue.minute * 60) + durationValue.second;
            if (this.negative) {
                d2 = -d2;
            }
            return d < d2 ? -1 : (d > d2 ? 1 : 0);
        }
        if (this.day <= 0 && this.hour <= 0 && this.minute <= 0 && this.second <= 0.0 && durationValue.day <= 0 && durationValue.hour <= 0 && durationValue.minute <= 0 && durationValue.second <= 0.0) {
            long l = this.year * 12 + this.month;
            if (this.negative) {
                l = -l;
            }
            long l2 = durationValue.year * 12 + durationValue.month;
            if (durationValue.negative) {
                l2 = -l2;
            }
            return l < l2 ? -1 : (l > l2 ? 1 : 0);
        }
        if (this.negative == durationValue.negative && this.year == durationValue.year && this.month == durationValue.month && this.day == durationValue.day && this.hour == durationValue.hour && this.minute == durationValue.minute && this.second == durationValue.second) {
            return 0;
        }
        int n = -2;
        block3: for (int i = 0; i < dateTimes.length; ++i) {
            DateTimeValue dateTimeValue = dateTimes[i];
            DateTimeValue dateTimeValue2 = dateTimeValue.add(this);
            DateTimeValue dateTimeValue3 = dateTimeValue.add(durationValue);
            int n2 = dateTimeValue2.compareTo(dateTimeValue3);
            switch (n2) {
                case -1: 
                case 0: 
                case 1: {
                    if (n == -2) {
                        n = n2;
                    }
                    if (n2 == n) continue block3;
                    return -2;
                }
                default: {
                    return -2;
                }
            }
        }
        return n;
    }
}

