/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class DateTimeUtil {
    private static final DecimalFormat FORMAT_SECONDS = new DecimalFormat("0.####################", new DecimalFormatSymbols(Locale.US));

    private DateTimeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatSeconds(double d) {
        DecimalFormat decimalFormat = FORMAT_SECONDS;
        synchronized (decimalFormat) {
            return FORMAT_SECONDS.format(d);
        }
    }

    public static int parseNonNegativeInt(String string, int n, int n2) throws InvalidDataException {
        int n3 = DateTimeUtil.parseInt(string, n, n2);
        if (n3 < 0) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("syntaxError", string));
        }
        return n3;
    }

    public static int parseInt(String string, int n, int n2) throws InvalidDataException {
        int n3;
        try {
            n3 = Integer.parseInt(string.substring(n, n2));
        }
        catch (Exception exception) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("syntaxError", string));
        }
        return n3;
    }

    public static double parseNonNegativeDouble(String string, int n, int n2) throws InvalidDataException {
        double d = DateTimeUtil.parseDouble(string, n, n2);
        if (d < 0.0) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("syntaxError", string));
        }
        return d;
    }

    public static double parseDouble(String string, int n, int n2) throws InvalidDataException {
        double d;
        String string2 = string.substring(n, n2);
        int n3 = string2.length();
        block5: for (int i = 0; i < n3; ++i) {
            switch (string2.charAt(i)) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block5;
                }
                default: {
                    throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("syntaxError", string));
                }
            }
        }
        try {
            d = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("syntaxError", string));
        }
        return d;
    }

    public static int parseTimeZone(String string, int n, int[] nArray) throws InvalidDataException {
        int n2;
        int n3;
        boolean bl;
        int n4;
        int n5 = string.length();
        int n6 = string.indexOf(90, n);
        if (n6 < 0) {
            n6 = string.indexOf(43, n);
            if (n6 < 0) {
                n6 = string.indexOf(45, n);
                if (n6 < 0) {
                    n4 = 0;
                    bl = false;
                    n = n6 = n5;
                } else {
                    n4 = -1;
                    bl = true;
                    n = n6 + 1;
                }
            } else {
                n4 = 1;
                bl = true;
                n = n6 + 1;
            }
        } else {
            n4 = 1;
            bl = false;
            n = n6 + 1;
        }
        if (bl) {
            if (n + 2 >= n5 || string.charAt(n + 2) != ':') {
                throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("tzSyntax", string));
            }
            n3 = DateTimeUtil.parseInt(string, n, n + 2);
            if ((n += 3) + 2 != n5) {
                throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("tzSyntax", string));
            }
            n2 = DateTimeUtil.parseInt(string, n, n5);
        } else {
            if (n != n5) {
                throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("tzSyntax", string));
            }
            n2 = 0;
            n3 = 0;
        }
        nArray[0] = n4;
        nArray[1] = n3;
        nArray[2] = n2;
        return n6;
    }

    public static int lastDayOfMonth(int n, int n2) {
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                if (!DateTimeUtil.isLeapYear(n2)) break;
                return 29;
            }
        }
        return 28;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static void appendPadded(int n, int n2, StringBuilder stringBuilder) {
        String string = Integer.toString(n);
        for (int i = string.length(); i < n2; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
    }

    public static void appendPadded(double d, int n, StringBuilder stringBuilder) {
        String string = DateTimeUtil.formatSeconds(d);
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            n2 = string.length();
        }
        while (n2 < n) {
            stringBuilder.append('0');
            ++n2;
        }
        stringBuilder.append(string);
    }

    public static void appendTimeZone(int n, int n2, int n3, StringBuilder stringBuilder) {
        if (n == 0) {
            return;
        }
        if (n2 == 0 && n3 == 0) {
            stringBuilder.append('Z');
            return;
        }
        stringBuilder.append(n == -1 ? (char)'-' : '+');
        DateTimeUtil.appendPadded(n2, 2, stringBuilder);
        stringBuilder.append(':');
        DateTimeUtil.appendPadded(n3, 2, stringBuilder);
    }

    static {
        FORMAT_SECONDS.setParseIntegerOnly(false);
        FORMAT_SECONDS.setGroupingUsed(false);
        FORMAT_SECONDS.setDecimalSeparatorAlwaysShown(false);
        FORMAT_SECONDS.setMinimumFractionDigits(0);
    }
}

