/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.validate.CommentItem;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.Item;
import com.xmlmind.xml.validate.ProcessingInstructionItem;
import com.xmlmind.xml.validate.TextItem;

public final class Structure {
    public static final Name[] NO_NAMES = new Name[0];
    public static final Field[] NO_FIELDS = new Field[0];
    public static final Item[] NO_ITEMS = new Item[0];
    public Name[] attributeNames = NO_NAMES;
    public Field[] attributeFields = NO_FIELDS;
    public int attributeFieldCount;
    public Item[] childNodeItems = NO_ITEMS;
    public int childNodeItemCount;

    public void addAttributeField(Name name, Field field) {
        if (this.attributeFieldCount == this.attributeFields.length) {
            int n = Math.max(2, 2 * this.attributeFields.length);
            Name[] nameArray = new Name[n];
            Field[] fieldArray = new Field[n];
            System.arraycopy(this.attributeNames, 0, nameArray, 0, this.attributeFields.length);
            System.arraycopy(this.attributeFields, 0, fieldArray, 0, this.attributeFields.length);
            this.attributeNames = nameArray;
            this.attributeFields = fieldArray;
        }
        this.attributeNames[this.attributeFieldCount] = name;
        this.attributeFields[this.attributeFieldCount] = field;
        ++this.attributeFieldCount;
    }

    public void addChildNodeItem(Item item) {
        if (this.childNodeItemCount == this.childNodeItems.length) {
            Item[] itemArray = new Item[Math.max(2, 2 * this.childNodeItems.length)];
            System.arraycopy(this.childNodeItems, 0, itemArray, 0, this.childNodeItems.length);
            this.childNodeItems = itemArray;
        }
        this.childNodeItems[this.childNodeItemCount++] = item;
    }

    public void addTextItem() {
        this.addChildNodeItem(TextItem.INSTANCE);
    }

    public void addCommentItem() {
        this.addChildNodeItem(CommentItem.INSTANCE);
    }

    public void addProcessingInstructionItem() {
        this.addChildNodeItem(ProcessingInstructionItem.INSTANCE);
    }

    public void clear() {
        this.attributeFieldCount = 0;
        this.childNodeItemCount = 0;
    }

    public Structure copy() {
        Structure structure = new Structure();
        if (this.attributeFields.length > 0) {
            structure.attributeNames = new Name[this.attributeFieldCount];
            System.arraycopy(this.attributeNames, 0, structure.attributeNames, 0, this.attributeFieldCount);
            structure.attributeFields = new Field[this.attributeFieldCount];
            System.arraycopy(this.attributeFields, 0, structure.attributeFields, 0, this.attributeFieldCount);
            structure.attributeFieldCount = this.attributeFieldCount;
        }
        if (this.childNodeItems.length > 0) {
            structure.childNodeItems = new Item[this.childNodeItemCount];
            System.arraycopy(this.childNodeItems, 0, structure.childNodeItems, 0, this.childNodeItemCount);
            structure.childNodeItemCount = this.childNodeItemCount;
        }
        return structure;
    }
}

