/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.validate.AnyField;
import com.xmlmind.xml.validate.AttributeType;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.Item;
import com.xmlmind.xml.validate.NameClass;
import com.xmlmind.xml.validate.Structure;
import com.xmlmind.xml.validate.XMLIDAttributeType;
import java.util.List;

public final class LaxElementType
implements ElementType {
    private ElementType strictElementType;
    private ContentType contentType;
    private Field[] attributeFields;
    private Field[] childElementFields;

    public LaxElementType(ElementType elementType) {
        NameClass nameClass;
        int n;
        this.strictElementType = elementType;
        switch (elementType.getElementContentType()) {
            case EMPTY: 
            case ELEMENT_ONLY: {
                this.contentType = ContentType.ELEMENT_ONLY;
                break;
            }
            default: {
                this.contentType = ContentType.MIXED2;
            }
        }
        Field[] fieldArray = elementType.getAttributeFields();
        boolean bl = true;
        for (n = 0; n < fieldArray.length; ++n) {
            nameClass = fieldArray[n].getFieldNameClass();
            if (nameClass == null || !nameClass.containsAnyName()) continue;
            bl = false;
            break;
        }
        this.attributeFields = new Field[fieldArray.length + (bl ? 1 : 0)];
        System.arraycopy(fieldArray, 0, this.attributeFields, 0, fieldArray.length);
        if (bl) {
            this.attributeFields[fieldArray.length] = AnyField.INSTANCE;
        }
        fieldArray = elementType.getChildElementFields();
        bl = true;
        for (n = 0; n < fieldArray.length; ++n) {
            nameClass = fieldArray[n].getFieldNameClass();
            if (nameClass == null || !nameClass.containsAnyName()) continue;
            bl = false;
            break;
        }
        this.childElementFields = new Field[fieldArray.length + (bl ? 1 : 0)];
        System.arraycopy(fieldArray, 0, this.childElementFields, 0, fieldArray.length);
        if (bl) {
            this.childElementFields[fieldArray.length] = AnyField.INSTANCE;
        }
    }

    public ElementType getStrictElementType() {
        return this.strictElementType;
    }

    @Override
    public ContentType getElementContentType() {
        return this.contentType;
    }

    @Override
    public DataType getElementDataType() {
        return null;
    }

    @Override
    public Object getElementDefaultValue() {
        return null;
    }

    @Override
    public Object getElementFixedValue() {
        return null;
    }

    @Override
    public Field[] getAttributeFields() {
        return this.attributeFields;
    }

    @Override
    public void getAttributeFields(Name name, List<Field> list) {
        list.clear();
        for (int i = 0; i < this.attributeFields.length; ++i) {
            Field field = this.attributeFields[i];
            Name name2 = field.getFieldName();
            if (name2 == null) {
                if (!field.getFieldNameClass().containsName(name)) continue;
                list.add(field);
                continue;
            }
            if (name != name2) continue;
            list.add(field);
        }
    }

    @Override
    public boolean isRequiredAttribute(Field field) {
        return false;
    }

    @Override
    public Data getAttributeDefaultValue(Name name) {
        return null;
    }

    @Override
    public Field[] getChildElementFields() {
        return this.childElementFields;
    }

    @Override
    public void getChildElementFields(Name name, List<Field> list) {
        list.clear();
        for (int i = 0; i < this.childElementFields.length; ++i) {
            Field field = this.childElementFields[i];
            Name name2 = field.getFieldName();
            if (name2 == null) {
                if (!field.getFieldNameClass().containsName(name)) continue;
                list.add(field);
                continue;
            }
            if (name != name2) continue;
            list.add(field);
        }
    }

    @Override
    public boolean canCheckAttributeStructure() {
        return true;
    }

    @Override
    public boolean checkStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return true;
    }

    @Override
    public boolean checkAttributeStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return true;
    }

    @Override
    public boolean checkElementStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return true;
    }

    @Override
    public boolean getStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        Comparable<Name> comparable;
        int n3;
        structure.clear();
        for (n3 = 0; n3 < n; ++n3) {
            comparable = attributeArray[n3].name;
            structure.addAttributeField((Name)comparable, this.getAttributeField((Name)comparable));
        }
        block6: for (n3 = 0; n3 < n2; ++n3) {
            comparable = nodeArray[n3];
            switch (((Node)comparable).getType()) {
                case TEXT: {
                    structure.addTextItem();
                    continue block6;
                }
                case COMMENT: {
                    structure.addCommentItem();
                    continue block6;
                }
                case PROCESSING_INSTRUCTION: {
                    structure.addProcessingInstructionItem();
                    continue block6;
                }
                default: {
                    Element element = (Element)comparable;
                    structure.addChildNodeItem(this.getChildElementField(element.getName()));
                }
            }
        }
        return true;
    }

    private Field getAttributeField(Name name) {
        Field field = null;
        Field field2 = null;
        int n = 0;
        for (int i = 0; i < this.attributeFields.length; ++i) {
            Field field3 = this.attributeFields[i];
            NameClass nameClass = field3.getFieldNameClass();
            if (nameClass != null) {
                if (nameClass.containsAnyName()) {
                    field = field3;
                    continue;
                }
                if (!nameClass.containsName(name)) continue;
                field2 = field3;
                ++n;
                continue;
            }
            if (field3.getFieldName() != name) continue;
            field2 = field3;
            ++n;
        }
        if (n != 1) {
            field2 = field;
        }
        return field2;
    }

    private Field getChildElementField(Name name) {
        Field field = null;
        Field field2 = null;
        int n = 0;
        for (int i = 0; i < this.childElementFields.length; ++i) {
            Field field3 = this.childElementFields[i];
            NameClass nameClass = field3.getFieldNameClass();
            if (nameClass != null) {
                if (nameClass.containsAnyName()) {
                    field = field3;
                    continue;
                }
                if (!nameClass.containsName(name)) continue;
                field2 = field3;
                ++n;
                continue;
            }
            if (field3.getFieldName() != name) continue;
            field2 = field3;
            ++n;
        }
        if (n != 1) {
            field2 = field;
        }
        return field2;
    }

    @Override
    public boolean getStructure(Element element, boolean bl, Structure structure) {
        XNode xNode;
        Object object;
        structure.clear();
        if (element.getAttributeCount() > 0) {
            object = element.getAttributes();
            while (object.hasNext()) {
                xNode = (Attribute)object.next();
                structure.addAttributeField(((Attribute)xNode).name, this.getAttributeField(((Attribute)xNode).name));
            }
        }
        block6: for (object = element.getFirstChild(); object != null; object = ((Node)object).getNextSibling()) {
            switch (((Node)object).getType()) {
                case TEXT: {
                    structure.addTextItem();
                    continue block6;
                }
                case COMMENT: {
                    structure.addCommentItem();
                    continue block6;
                }
                case PROCESSING_INSTRUCTION: {
                    structure.addProcessingInstructionItem();
                    continue block6;
                }
                default: {
                    xNode = (Element)object;
                    structure.addChildNodeItem(this.getChildElementField(((Element)xNode).getName()));
                }
            }
        }
        return true;
    }

    @Override
    public boolean getAttributeStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        return this.getStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    @Override
    public boolean getAttributeStructure(Element element, boolean bl, Structure structure) {
        return this.getStructure(element, bl, structure);
    }

    @Override
    public boolean getElementStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        return this.getStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    @Override
    public boolean getElementStructure(Element element, boolean bl, Structure structure) {
        return this.getStructure(element, bl, structure);
    }

    @Override
    public AttributeType getAttributeType(Field field, Name name) {
        if (name == Name.XML_ID) {
            return XMLIDAttributeType.INSTANCE;
        }
        return null;
    }

    @Override
    public ElementType getChildElementType(Field field, Name name) {
        return null;
    }

    @Override
    public ElementType getChildElementType(Field field, Element element) {
        return null;
    }

    @Override
    public Element createInstance(Name name, int n) {
        return this.strictElementType.createInstance(name, n);
    }
}

