/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.ObjectUtil;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.TextNode;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.validate.DiagnosticImpl;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.IdEntry;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

public final class DiagnosticUtil {
    private static final SortByInclusion sortByInclusion = new SortByInclusion();

    private DiagnosticUtil() {
    }

    public static Diagnostic.Severity getDiagnosticSeverity(Diagnostic[] diagnosticArray) {
        Diagnostic.Severity severity = Diagnostic.Severity.NONE;
        if (diagnosticArray != null) {
            for (Diagnostic diagnostic : diagnosticArray) {
                Diagnostic.Severity severity2 = diagnostic.getDiagnosticSeverity();
                if (severity2.getImportance() <= severity.getImportance()) continue;
                severity = severity2;
            }
        }
        return severity;
    }

    public static boolean hasSevereValidityErrors(Diagnostic[] diagnosticArray) {
        return DiagnosticUtil.getDiagnosticSeverity(diagnosticArray).compareTo(Diagnostic.Severity.INVALID_DATA) >= 0;
    }

    public static boolean canCheckDocument(Document document) {
        DocumentType documentType = (DocumentType)document.getProperty(Constants.DOCUMENT_TYPE_PROPERTY);
        return documentType != null && !(documentType instanceof AnyDocumentType);
    }

    public static Diagnostic[] checkDocument(Document document) {
        return DiagnosticUtil.checkDocument(document, false);
    }

    public static Diagnostic[] checkDocument(Document document, boolean bl) {
        DocumentType documentType = (DocumentType)document.getProperty(Constants.DOCUMENT_TYPE_PROPERTY);
        if (documentType == null || documentType instanceof AnyDocumentType) {
            return null;
        }
        Diagnostic[] diagnosticArray = documentType.checkDocument(document);
        if (bl && document.getProperty(Constants.XINCLUSION_SCHEMES_PROPERTY) == null) {
            bl = false;
        }
        if (bl) {
            diagnosticArray = DiagnosticUtil.filterDuplicateIDs(diagnosticArray);
        }
        return diagnosticArray;
    }

    public static Diagnostic[] filterDuplicateIDs(Diagnostic[] diagnosticArray) {
        Element element = null;
        for (Diagnostic diagnostic : diagnosticArray) {
            if ("DUPLICATE_ID" != diagnostic.getDiagnosticDetailId()) continue;
            element = diagnostic.getDiagnosedElement();
            break;
        }
        if (element == null) {
            return diagnosticArray;
        }
        Document document = element.getDocument();
        DuplicateIDFilter duplicateIDFilter = DiagnosticUtil.createDuplicateIDFilter(document);
        if (duplicateIDFilter == null) {
            return diagnosticArray;
        }
        IdentityHashMap<Element, String[]> identityHashMap = duplicateIDFilter.falseDuplicateIDs;
        ArrayList<Diagnostic> arrayList = new ArrayList<Diagnostic>();
        for (Diagnostic diagnostic : diagnosticArray) {
            String string = diagnostic.getDiagnosticDetailId();
            if (string == "DUPLICATE_ID" || string == "ORIGINAL_ID") {
                if (identityHashMap.containsKey(diagnostic.getDiagnosedElement()) || string == "ORIGINAL_ID" && DiagnosticUtil.containsDiagnostic(arrayList, diagnostic)) continue;
                arrayList.add(diagnostic);
                continue;
            }
            arrayList.add(diagnostic);
        }
        Diagnostic[] diagnosticArray2 = new Diagnostic[arrayList.size()];
        arrayList.toArray(diagnosticArray2);
        return diagnosticArray2;
    }

    private static final boolean containsDiagnostic(ArrayList<Diagnostic> arrayList, Diagnostic diagnostic) {
        for (Diagnostic diagnostic2 : arrayList) {
            if (!DiagnosticImpl.equals(diagnostic2, diagnostic)) continue;
            return true;
        }
        return false;
    }

    public static DuplicateIDFilter createDuplicateIDFilter(Document document) {
        DocumentType documentType = (DocumentType)document.getProperty(Constants.DOCUMENT_TYPE_PROPERTY);
        if (documentType == null || documentType instanceof AnyDocumentType) {
            return null;
        }
        HashMap<String, IdEntry> hashMap = new HashMap<String, IdEntry>();
        documentType.collectIds(document.getRootElement(), hashMap);
        if (hashMap.size() == 0) {
            return null;
        }
        IdentityHashMap<Element, String[]> identityHashMap = new IdentityHashMap<Element, String[]>();
        ArrayList<Name> arrayList = new ArrayList<Name>();
        ArrayList<Name> arrayList2 = new ArrayList<Name>();
        for (IdEntry idEntry : hashMap.values()) {
            int n;
            int n2;
            if (idEntry.elements.length <= 1) continue;
            String string = idEntry.id;
            Element[] elementArray = (Element[])idEntry.elements.clone();
            int n3 = elementArray.length;
            if (n3 > 1) {
                Arrays.sort(elementArray, sortByInclusion);
            }
            int n4 = 0;
            boolean[] blArray = new boolean[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                if (elementArray[n2].lookupInclusion() != null) {
                    blArray[n2] = true;
                    ++n4;
                    continue;
                }
                blArray[n2] = false;
            }
            if (n4 <= 0) continue;
            for (n2 = 0; n2 < n3; ++n2) {
                Element element = elementArray[n2];
                if (element == null) continue;
                n = blArray[n2];
                for (int i = n2 + 1; i < n3; ++i) {
                    Element element2 = elementArray[i];
                    if (element2 == null) continue;
                    boolean bl = blArray[i];
                    if (n == 0 && !bl || !DiagnosticUtil.sameElement(element, element2, arrayList, arrayList2)) continue;
                    String string2 = Integer.toString(System.identityHashCode(element2), 36);
                    identityHashMap.put(element2, new String[]{string, string2});
                    elementArray[i] = null;
                }
            }
            Element element = null;
            int n5 = 0;
            for (n = 0; n < n3; ++n) {
                if (elementArray[n] == null) continue;
                element = elementArray[n];
                ++n5;
            }
            if (n5 != true) continue;
            identityHashMap.put(element, new String[]{string, null});
        }
        if (identityHashMap.size() == 0) {
            return null;
        }
        return new DuplicateIDFilter(identityHashMap);
    }

    private static boolean sameElement(Element element, Element element2, ArrayList<Name> arrayList, ArrayList<Name> arrayList2) {
        Object object;
        XNode xNode;
        Attribute[] attributeArray;
        URL uRL;
        URL uRL2 = DiagnosticUtil.collectAncestorNames(element, arrayList);
        if (!ObjectUtil.equals(uRL2, uRL = DiagnosticUtil.collectAncestorNames(element2, arrayList2))) {
            return false;
        }
        int n = Math.min(arrayList.size(), arrayList2.size());
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) == arrayList2.get(i)) continue;
            return false;
        }
        Attribute[] attributeArray2 = DiagnosticUtil.getAllAttributes(element);
        n = attributeArray2.length;
        if (n != (attributeArray = DiagnosticUtil.getAllAttributes(element2)).length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            xNode = attributeArray2[i];
            object = attributeArray[i];
            if (((Attribute)xNode).name == ((Attribute)object).name && ((Attribute)xNode).value != null && ((Attribute)xNode).value.equals(((Attribute)object).value)) continue;
            return false;
        }
        Node node = element.getFirstChild();
        xNode = element2.getFirstChild();
        while (node != null) {
            object = null;
            if (xNode == null || (object = ((Node)xNode).getType()) != node.getType()) {
                return false;
            }
            switch (1.$SwitchMap$com$xmlmind$xml$doc$Node$Type[((Enum)object).ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    String string = ((TextNode)node).getText();
                    String string2 = ((TextNode)xNode).getText();
                    if (string.equals(string2)) break;
                    return false;
                }
            }
            node = node.getNextSibling();
            xNode = ((Node)xNode).getNextSibling();
        }
        return true;
    }

    private static URL collectAncestorNames(Element element, ArrayList<Name> arrayList) {
        URL uRL = null;
        arrayList.clear();
        for (Element element2 = element; element2 != null; element2 = element2.getParentElement()) {
            arrayList.add(element2.getName());
            uRL = (URL)element2.getProperty(Constants.SOURCE_URL_PROPERTY);
            if (uRL == null) continue;
            return uRL;
        }
        return (URL)element.getDocument().getProperty(Constants.SOURCE_URL_PROPERTY);
    }

    private static Attribute[] getAllAttributes(Element element) {
        int n = element.getAttributeCount();
        if (n == 0) {
            return Attribute.EMPTY_LIST;
        }
        Attribute[] attributeArray = new Attribute[n];
        n = 0;
        Iterator<Attribute> iterator = element.getAttributes(false);
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            Name name = attribute.name;
            if (name.namespace == Namespace.DOCBOOK_TRANSCLUSION || name == Name.XML_BASE || name == Name.XML_LANG || name == Name.LANG) continue;
            attributeArray[n++] = attribute.copy();
        }
        if (n != attributeArray.length) {
            attributeArray = ArrayUtil.trimToSize(attributeArray, n);
        }
        if (n > 1) {
            Arrays.sort(attributeArray, Attribute.COMPARE_BY_NAME);
        }
        return attributeArray;
    }

    private static final class SortByInclusion
    implements Comparator<Element> {
        private SortByInclusion() {
        }

        @Override
        public int compare(Element element, Element element2) {
            int n = element.lookupInclusion() == null ? 0 : 1;
            int n2 = element2.lookupInclusion() == null ? 0 : 1;
            return n - n2;
        }
    }

    public static final class DuplicateIDFilter {
        private final IdentityHashMap<Element, String[]> falseDuplicateIDs;

        private DuplicateIDFilter(IdentityHashMap<Element, String[]> identityHashMap) {
            this.falseDuplicateIDs = identityHashMap;
        }

        public String filter(Element element, Name name, String object) {
            String[] stringArray = this.falseDuplicateIDs.get(element);
            if (stringArray == null || stringArray[1] == null || !stringArray[0].equals(object)) {
                return object;
            }
            boolean bl = true;
            if (name != Name.XML_ID) {
                Iterator<Attribute> iterator = element.getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.name == name || !attribute.value.equals(object)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                object = ((String)object).trim() + "." + stringArray[1];
            }
            return object;
        }
    }
}

