/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.schematron;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.schematron.KeySpec;
import com.xmlmind.xml.schematron.ValidateExprContext;
import com.xmlmind.xml.xpath.ArrayNodeIterator;
import com.xmlmind.xml.xpath.Converter;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NullNodeIterator;
import com.xmlmind.xml.xpath.SingleNodeIterator;
import com.xmlmind.xml.xpath.Variant;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

final class KeyedNodes {
    private KeySpec[] keySpecs;
    private IdentityHashMap<Document, IdentityHashMap<Name, HashMap<String, XNode[]>>> docToMap;

    public KeyedNodes(KeySpec[] keySpecArray) {
        this.keySpecs = keySpecArray;
        this.docToMap = new IdentityHashMap(3);
    }

    public NodeIterator getKeyedNodes(Name name, String string, XNode xNode, ExprContext exprContext) throws EvalException {
        HashMap<String, XNode[]> hashMap;
        Document document = (Document)xNode.document();
        if (document == null) {
            return NullNodeIterator.INSTANCE;
        }
        IdentityHashMap<Name, HashMap<String, Object>> identityHashMap = this.docToMap.get(document);
        if (identityHashMap == null) {
            identityHashMap = new IdentityHashMap();
            this.indexDocument(document, exprContext, identityHashMap);
            this.docToMap.put(document, identityHashMap);
        }
        if ((hashMap = identityHashMap.get(name)) == null) {
            return NullNodeIterator.INSTANCE;
        }
        XNode[] xNodeArray = hashMap.get(string);
        if (xNodeArray == null) {
            return NullNodeIterator.INSTANCE;
        }
        if (xNodeArray.length == 1) {
            return new SingleNodeIterator(xNodeArray[0]);
        }
        return new ArrayNodeIterator(xNodeArray);
    }

    private void indexDocument(Document document, ExprContext exprContext, IdentityHashMap<Name, HashMap<String, XNode[]>> identityHashMap) throws EvalException {
        for (int i = 0; i < this.keySpecs.length; ++i) {
            this.applyKeySpec(this.keySpecs[i], document, exprContext, identityHashMap);
        }
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean bl = false;
            boolean bl2 = false;
            switch (node.getType()) {
                case ELEMENT: {
                    bl2 = true;
                }
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    bl = true;
                }
            }
            if (!bl) continue;
            for (int i = 0; i < this.keySpecs.length; ++i) {
                this.applyKeySpec(this.keySpecs[i], node, exprContext, identityHashMap);
            }
            if (!bl2) continue;
            this.doIndexDocument((Element)node, exprContext, identityHashMap);
        }
    }

    private void doIndexDocument(Element element, ExprContext exprContext, IdentityHashMap<Name, HashMap<String, XNode[]>> identityHashMap) throws EvalException {
        int n;
        XNode xNode;
        Iterator<Attribute> iterator = element.getAttributes();
        while (iterator.hasNext()) {
            xNode = iterator.next();
            for (n = 0; n < this.keySpecs.length; ++n) {
                this.applyKeySpec(this.keySpecs[n], xNode, exprContext, identityHashMap);
            }
        }
        for (xNode = element.getFirstChild(); xNode != null; xNode = ((Node)xNode).getNextSibling()) {
            for (n = 0; n < this.keySpecs.length; ++n) {
                this.applyKeySpec(this.keySpecs[n], xNode, exprContext, identityHashMap);
            }
            if (!(xNode instanceof Element)) continue;
            this.doIndexDocument((Element)xNode, exprContext, identityHashMap);
        }
    }

    private void applyKeySpec(KeySpec keySpec, XNode xNode, ExprContext exprContext, IdentityHashMap<Name, HashMap<String, XNode[]>> identityHashMap) throws EvalException {
        Variant variant;
        if (!keySpec.matchPattern.matches(xNode, exprContext)) {
            return;
        }
        if (xNode instanceof Attribute) {
            xNode = xNode.deepCopy();
        }
        if (exprContext instanceof ValidateExprContext) {
            ((ValidateExprContext)exprContext).defaultBaseURL = keySpec.specURL;
        }
        if ((variant = keySpec.useExpr.eval(xNode, exprContext)).isNodeSet()) {
            XNode xNode2;
            NodeIterator nodeIterator = variant.convertToNodeSet();
            while ((xNode2 = nodeIterator.next()) != null) {
                String string = Converter.toString(xNode2);
                KeyedNodes.addKeyedNode(xNode, keySpec.keyName, string, identityHashMap);
            }
        } else {
            String string = variant.convertToString();
            KeyedNodes.addKeyedNode(xNode, keySpec.keyName, string, identityHashMap);
        }
    }

    private static void addKeyedNode(XNode xNode, Name name, String string, IdentityHashMap<Name, HashMap<String, XNode[]>> identityHashMap) {
        HashMap<String, Object> hashMap = identityHashMap.get(name);
        if (hashMap == null) {
            hashMap = new HashMap();
            identityHashMap.put(name, hashMap);
        }
        XNode[] xNodeArray = null;
        XNode[] xNodeArray2 = hashMap.get(string);
        if (xNodeArray2 == null) {
            xNodeArray = new XNode[]{xNode};
        } else {
            boolean bl = true;
            int n = xNodeArray2.length;
            for (int i = 0; i < n; ++i) {
                if (!xNodeArray2[i].equals(xNode)) continue;
                bl = false;
                break;
            }
            if (bl) {
                xNodeArray = new XNode[n + 1];
                System.arraycopy(xNodeArray2, 0, xNodeArray, 0, n);
                xNodeArray[n] = xNode;
            }
        }
        if (xNodeArray != null) {
            hashMap.put(string, xNodeArray);
        }
    }
}

