/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.save;

import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.load.CharEntities;
import com.xmlmind.xml.save.CharRange;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;

final class TextHelper {
    private String encoding = "UTF-8";
    private int charMax = 65535;
    private CharsetEncoder encoder;
    private CharEntities charEntities;
    private CharRange[] charsSavedAsEntityRefs;
    private boolean preferHexaCharRefs;

    public void setEncoding(String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF-8";
        }
        this.encoding = string = string.toLowerCase();
        this.charMax = -1;
        this.encoder = null;
        if ("utf-8".equals(string) || "utf-16".equals(string) || "utf-16be".equals(string) || "utf-16le".equals(string)) {
            this.charMax = 65535;
        } else if ("iso-8859-1".equals(string)) {
            this.charMax = 255;
        } else if ("us-ascii".equals(string)) {
            this.charMax = 127;
        } else {
            try {
                Charset charset = Charset.forName(this.encoding);
                this.encoder = charset.newEncoder();
            }
            catch (Exception exception) {
                throw new UnsupportedEncodingException(ThrowableUtil.reason(exception));
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setCharEntities(CharEntities charEntities) {
        this.charEntities = charEntities;
    }

    public CharEntities getCharEntities() {
        return this.charEntities;
    }

    public void setCharsSavedAsEntityRefs(CharRange[] charRangeArray) {
        if (charRangeArray != null) {
            if (charRangeArray.length == 0) {
                charRangeArray = null;
            } else if (charRangeArray.length > 1) {
                Arrays.sort(charRangeArray);
            }
        }
        this.charsSavedAsEntityRefs = charRangeArray;
    }

    public CharRange[] getCharsSavedAsEntityRefs() {
        return this.charsSavedAsEntityRefs;
    }

    public void setPrefHexaCharRefs(boolean bl) {
        this.preferHexaCharRefs = bl;
    }

    public boolean getPrefHexaCharRefs() {
        return this.preferHexaCharRefs;
    }

    public void escapeXML(boolean bl, char[] cArray, int n, int n2, StringBuilder stringBuilder) {
        int n3 = n + n2;
        block6: for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\"': {
                    if (bl) {
                        stringBuilder.append("&quot;");
                        continue block6;
                    }
                    stringBuilder.append(c);
                    continue block6;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                default: {
                    String string;
                    boolean bl2 = this.charMax > 0 ? c <= this.charMax : this.encoder.canEncode(c);
                    if (bl2) {
                        if (this.charsSavedAsEntityRefs != null && CharRange.contains(this.charsSavedAsEntityRefs, c)) {
                            if (this.charEntities != null && (string = this.charEntities.getName(c)) != null) {
                                stringBuilder.append('&');
                                stringBuilder.append(string);
                                stringBuilder.append(';');
                                continue block6;
                            }
                            if (this.preferHexaCharRefs) {
                                stringBuilder.append("&#x");
                                stringBuilder.append(Integer.toHexString(c));
                                stringBuilder.append(';');
                                continue block6;
                            }
                            stringBuilder.append("&#");
                            stringBuilder.append(Integer.toString(c));
                            stringBuilder.append(';');
                            continue block6;
                        }
                        stringBuilder.append(c);
                        continue block6;
                    }
                    if (this.charEntities != null && (string = this.charEntities.getName(c)) != null) {
                        stringBuilder.append('&');
                        stringBuilder.append(string);
                        stringBuilder.append(';');
                        continue block6;
                    }
                    if (this.preferHexaCharRefs) {
                        stringBuilder.append("&#x");
                        stringBuilder.append(Integer.toHexString(c));
                        stringBuilder.append(';');
                        continue block6;
                    }
                    stringBuilder.append("&#");
                    stringBuilder.append(Integer.toString(c));
                    stringBuilder.append(';');
                }
            }
        }
    }
}

