/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.save;

import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.util.XMLUtil;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Comment;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentTypeDeclaration;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.load.CharEntities;
import com.xmlmind.xml.load.EntityRef;
import com.xmlmind.xml.load.XInclusion;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.save.CharRange;
import com.xmlmind.xml.save.LineWriter;
import com.xmlmind.xml.save.Msg;
import com.xmlmind.xml.save.QNameHelper;
import com.xmlmind.xml.save.TextHelper;
import com.xmlmind.xml.sxpath.ElementMatcher;
import com.xmlmind.xml.sxpath.XPath;
import com.xmlmind.xml.validate.DiagnosticUtil;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.SchemaKind;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class DocumentWriter {
    protected Writer out;
    protected QNameHelper qNameHelper;
    protected TextHelper textHelper;
    protected boolean preserveInclusions;
    protected boolean filterDuplicateIDs;
    protected DiagnosticUtil.DuplicateIDFilter duplicateIDFilter;
    protected ElementMatcher cdataSections;
    protected DocumentType documentType;
    protected boolean favorInteroperability;
    protected Boolean predeclarePrefixPrefs;

    public DocumentWriter(Writer writer) {
        this.out = writer;
        this.qNameHelper = new QNameHelper();
        this.textHelper = new TextHelper();
        this.preserveInclusions = true;
        this.filterDuplicateIDs = true;
        this.duplicateIDFilter = null;
        this.cdataSections = null;
        this.documentType = null;
        this.favorInteroperability = false;
        this.predeclarePrefixPrefs = null;
    }

    public Writer getWriter() {
        return this.out;
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        this.textHelper.setEncoding(string);
    }

    public String getEncoding() {
        return this.textHelper.getEncoding();
    }

    public void setCharEntities(CharEntities charEntities) {
        this.textHelper.setCharEntities(charEntities);
    }

    public CharEntities getCharEntities() {
        return this.textHelper.getCharEntities();
    }

    public void setCharsSavedAsEntityRefs(CharRange[] charRangeArray) {
        this.textHelper.setCharsSavedAsEntityRefs(charRangeArray);
    }

    public CharRange[] getCharsSavedAsEntityRefs() {
        return this.textHelper.getCharsSavedAsEntityRefs();
    }

    public void setPrefixPreferences(PrefixEntry[] prefixEntryArray) {
        this.qNameHelper.setPrefixPreferences(prefixEntryArray);
    }

    public PrefixEntry[] getPrefixPreferences() {
        return this.qNameHelper.getPrefixPreferences();
    }

    public void setPreserveInclusions(boolean bl) {
        this.preserveInclusions = bl;
    }

    public boolean getPreserveInclusions() {
        return this.preserveInclusions;
    }

    public void setFilterDuplicateIDs(boolean bl) {
        this.filterDuplicateIDs = bl;
    }

    public boolean getFilterDuplicateIDs() {
        return this.filterDuplicateIDs;
    }

    public void setCdataSectionElements(XPath[] xPathArray) {
        this.cdataSections = xPathArray != null && xPathArray.length > 0 ? new ElementMatcher(xPathArray) : null;
    }

    public XPath[] getCdataSectionElements() {
        return this.cdataSections == null ? null : this.cdataSections.xpaths;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setFavorInteroperability(boolean bl) {
        if (bl != this.favorInteroperability) {
            this.favorInteroperability = bl;
            this.qNameHelper.setFavorInteroperability(bl);
        }
    }

    public boolean getFavorInteroperability() {
        return this.favorInteroperability;
    }

    public void setPredeclarePrefixPreferences(Boolean bl) {
        this.predeclarePrefixPrefs = bl;
    }

    public Boolean getPredeclarePrefixPreferences() {
        return this.predeclarePrefixPrefs;
    }

    protected boolean predeclarePrefixPrefs() {
        boolean bl;
        if (this.predeclarePrefixPrefs != null) {
            bl = this.predeclarePrefixPrefs;
        } else {
            bl = true;
            if (this.favorInteroperability || this.documentType != null && this.documentType.getSchemaKind() == SchemaKind.DTD) {
                bl = false;
            }
        }
        return bl;
    }

    public void write(Document document) throws IOException {
        this.beginWrite(document);
        Node node = document.getFirstChild();
        while (node != null) {
            Node node2;
            Inclusion inclusion;
            if (this.preserveInclusions && (inclusion = node.getInclusion()) != null) {
                Inclusion inclusion2;
                Node node3 = node;
                for (node2 = node.getNextSibling(); node2 != null && (inclusion2 = node2.getInclusion()) == inclusion; node2 = node2.getNextSibling()) {
                    node3 = node2;
                }
                this.writeInclusion(inclusion, node, node3);
            } else {
                switch (node.getType()) {
                    case COMMENT: {
                        this.writeComment((Comment)node);
                        break;
                    }
                    case PROCESSING_INSTRUCTION: {
                        this.writeProcessingInstruction((ProcessingInstruction)node);
                        break;
                    }
                    case DOCUMENT_TYPE_DECLARATION: {
                        this.writeDocumentTypeDeclaration((DocumentTypeDeclaration)node);
                        break;
                    }
                    case ELEMENT: {
                        this.writeElement((Element)node);
                    }
                }
            }
            this.out.write(10);
            node = node2;
        }
        this.endWrite(document);
    }

    protected void beginWrite(Document document) throws IOException {
        this.qNameHelper.setPredeclarePrefixPreferences(this.predeclarePrefixPrefs());
        if (!this.preserveInclusions && this.filterDuplicateIDs) {
            this.duplicateIDFilter = DiagnosticUtil.createDuplicateIDFilter(document);
        }
    }

    protected void endWrite(Document document) throws IOException {
        this.flush();
    }

    public void write(Element element) throws IOException {
        this.beginWrite(element);
        this.writeElement(element);
        this.endWrite(element);
    }

    protected void beginWrite(Element element) throws IOException {
        this.qNameHelper.setPredeclarePrefixPreferences(this.predeclarePrefixPrefs());
        this.duplicateIDFilter = null;
    }

    protected void endWrite(Element element) throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    protected void writeDocumentTypeDeclaration(DocumentTypeDeclaration documentTypeDeclaration) throws IOException {
        String string;
        this.out.write("<!DOCTYPE ");
        this.out.write(documentTypeDeclaration.rootElementName);
        String string2 = documentTypeDeclaration.systemId;
        if (string2 != null) {
            string = documentTypeDeclaration.publicId;
            if (string == null) {
                this.out.write(" SYSTEM ");
            } else {
                this.out.write(" PUBLIC \"");
                this.out.write(string);
                this.out.write("\"\n");
            }
            int n = string2.indexOf(34) < 0 ? 34 : 39;
            this.out.write(n);
            this.out.write(string2);
            this.out.write(n);
        }
        if ((string = documentTypeDeclaration.internalSubset) != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (string != null) {
            this.out.write(" [\n");
            this.out.write(string);
            this.out.write("\n]");
        }
        this.out.write(">");
    }

    protected void writeComment(Comment comment) throws IOException {
        DocumentWriter.checkComment(comment);
        this.out.write("<!--");
        this.out.write(comment.getText());
        this.out.write("-->");
    }

    protected static void checkComment(Comment comment) throws IOException {
        String string = comment.getText();
        if (string.indexOf("--") >= 0 || string.endsWith("-")) {
            throw new IOException(Msg.msg("badCommentChars", DocumentWriter.shorten(string)));
        }
    }

    protected static String shorten(String string) {
        int n = string.length();
        Object object = n <= 70 ? string : string.substring(0, 33) + " ... " + string.substring(n - 32);
        if (((String)object).indexOf(13) >= 0) {
            object = ((String)object).replace('\r', ' ');
        }
        if (((String)object).indexOf(10) >= 0) {
            object = ((String)object).replace('\n', ' ');
        }
        return object;
    }

    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        DocumentWriter.checkProcessingInstruction(processingInstruction);
        this.out.write("<?");
        this.out.write(processingInstruction.getTarget());
        this.out.write(32);
        this.out.write(processingInstruction.getText());
        this.out.write("?>");
    }

    protected static void checkProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        String string = processingInstruction.getTarget();
        if (!XMLText.isName(string)) {
            throw new IOException(Msg.msg("badPITarget", string));
        }
        String string2 = processingInstruction.getText();
        if (string2.indexOf("?>") >= 0) {
            throw new IOException(Msg.msg("badPIChars", DocumentWriter.shorten(string2)));
        }
    }

    protected void writeInclusion(Inclusion inclusion, Node node, Node node2) throws IOException {
        if (this.out instanceof LineWriter) {
            ((LineWriter)this.out).writingInclusion(inclusion);
        }
        if (inclusion instanceof EntityRef) {
            this.writeEntityRef((EntityRef)inclusion);
        } else if (inclusion instanceof XInclusion) {
            Node[] nodeArray;
            block6: for (Node node3 : nodeArray = ((XInclusion)inclusion).uninclude(node, node2)) {
                switch (node3.getType()) {
                    case TEXT: {
                        this.writeText((Text)node3);
                        continue block6;
                    }
                    case COMMENT: {
                        this.writeComment((Comment)node3);
                        continue block6;
                    }
                    case PROCESSING_INSTRUCTION: {
                        this.writeProcessingInstruction((ProcessingInstruction)node3);
                        continue block6;
                    }
                    case ELEMENT: {
                        this.writeElement((Element)node3);
                    }
                }
            }
        } else {
            throw new IOException(Msg.msg("unsupportedInclusion", inclusion.getClass().getName()));
        }
    }

    protected void writeEntityRef(EntityRef entityRef) throws IOException {
        this.out.write(38);
        this.out.write(entityRef.name);
        this.out.write(59);
    }

    protected void writeElement(Element element) throws IOException {
        this.pushElement(element);
        Name name = element.getName();
        String string = this.qNameHelper.toQName(name, false);
        this.writeStartTag(string, element);
        this.writeAttributes(element);
        this.writeFrame();
        if (this.isEmptyElement(element)) {
            this.writeEmptyEndTag(string, element);
        } else {
            this.out.write("\n>");
            this.writeElementProperties(element);
            Node node = element.getFirstChild();
            while (node != null) {
                Node node2;
                Inclusion inclusion;
                if (this.preserveInclusions && (inclusion = node.getInclusion()) != null) {
                    Inclusion inclusion2;
                    Node node3 = node;
                    for (node2 = node.getNextSibling(); node2 != null && (inclusion2 = node2.getInclusion()) == inclusion; node2 = node2.getNextSibling()) {
                        node3 = node2;
                    }
                    this.writeInclusion(inclusion, node, node3);
                } else {
                    switch (node.getType()) {
                        case TEXT: {
                            if (this.cdataSections != null && this.cdataSections.match(element)) {
                                this.writeCDATA((Text)node, element);
                                break;
                            }
                            this.writeText((Text)node);
                            break;
                        }
                        case COMMENT: {
                            this.writeComment((Comment)node);
                            break;
                        }
                        case PROCESSING_INSTRUCTION: {
                            this.writeProcessingInstruction((ProcessingInstruction)node);
                            break;
                        }
                        case ELEMENT: {
                            this.writeElement((Element)node);
                        }
                    }
                }
                node = node2;
            }
            this.writeEndTag(string, element);
        }
        this.popElement();
    }

    protected void writeStartTag(String string, Element element) throws IOException {
        if (this.out instanceof LineWriter) {
            ((LineWriter)this.out).writingElement(element);
        }
        this.out.write(60);
        this.out.write(string);
    }

    protected void writeAttributes(Element element) throws IOException {
        String string = null;
        if (!this.preserveInclusions) {
            string = (String)element.getProperty(Name.XML_BASE);
        }
        switch (element.getAttributeCount()) {
            case 0: {
                break;
            }
            case 1: {
                Attribute attribute = element.getAttributes().next();
                Name name = attribute.name;
                String string2 = attribute.value;
                if (string != null && name == Name.XML_BASE) {
                    string2 = string;
                    string = null;
                }
                if (this.duplicateIDFilter != null) {
                    string2 = this.duplicateIDFilter.filter(element, name, string2);
                }
                this.writeAttribute(this.qNameHelper.toQName(name, true), string2);
                break;
            }
            default: {
                Attribute[] attributeArray = element.getAllAttributes();
                Arrays.sort(attributeArray, Attribute.COMPARE_BY_NAME);
                for (Attribute attribute : attributeArray) {
                    Name name = attribute.name;
                    String string3 = attribute.value;
                    if (string != null && name == Name.XML_BASE) {
                        string3 = string;
                        string = null;
                    }
                    if (this.duplicateIDFilter != null) {
                        string3 = this.duplicateIDFilter.filter(element, name, string3);
                    }
                    this.writeAttribute(this.qNameHelper.toQName(name, true), string3);
                }
            }
        }
        if (string != null) {
            this.writeAttribute("xml:base", string);
        }
    }

    protected void writeFrame() throws IOException {
        List<String> list = this.qNameHelper.listFrame();
        int n = list.size();
        for (int i = 0; i < n; i += 2) {
            String string = list.get(i);
            String string2 = list.get(i + 1);
            this.writeAttribute(string, string2);
        }
    }

    protected void writeAttribute(String string, String string2) throws IOException {
        this.out.write(10);
        this.out.write(string);
        this.out.write("=\"");
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string2.toCharArray();
        this.textHelper.escapeXML(true, cArray, 0, cArray.length, stringBuilder);
        this.out.write(stringBuilder.toString());
        this.out.write(34);
    }

    protected void writeElementProperties(Element element) throws IOException {
    }

    protected void writeEmptyEndTag(String string, Element element) throws IOException {
        if (this.favorInteroperability && this.hasEmptyContentType(element) && this.isEmptyElement(element)) {
            this.out.write("\n/>");
        } else {
            this.out.write("\n>");
            this.writeEndTag(string, element);
        }
    }

    protected boolean isEmptyElement(Element element) {
        Node node = element.getFirstChild();
        if (node == null) {
            return true;
        }
        if (node.getNextSibling() != null) {
            return false;
        }
        return node.getType() == Node.Type.TEXT && ((Text)node).getTextLength() == 0;
    }

    protected boolean hasEmptyContentType(Element element) {
        Name name = element.getName();
        if (name.namespace == Namespace.XHTML) {
            return XMLUtil.HTML_NO_END_TAG.contains(name.localPart);
        }
        return false;
    }

    protected void writeEndTag(String string, Element element) throws IOException {
        this.out.write("</");
        this.out.write(string);
        this.out.write("\n>");
    }

    protected void writeCDATA(Text text, Element element) throws IOException {
        String string;
        String string2;
        Name name = element.getName();
        if (this.favorInteroperability && (name == Name.SCRIPT || name == Name.STYLE)) {
            string2 = "/*<![CDATA[*/";
            string = "/*]]>*/";
        } else {
            string2 = "<![CDATA[";
            string = "]]>";
        }
        String string3 = text.getText();
        if (string3.indexOf("]]>") < 0) {
            this.out.write(string2);
            this.out.write(string3);
            this.out.write(string);
        } else {
            this.writeText(text);
        }
    }

    protected void writeText(Text text) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.textHelper.escapeXML(false, text.getTextChars(), 0, text.getTextLength(), stringBuilder);
        this.out.write(stringBuilder.toString());
    }

    protected void pushElement(Element element) {
        this.qNameHelper.pushFrame();
    }

    protected void popElement() {
        this.qNameHelper.popFrame();
    }

    public static void addXMLBase(Document document, boolean bl) {
        Element element = document.getRootElement();
        if (element != null) {
            DocumentWriter.addXMLBase(element, bl, element.getInclusion() != null);
        }
    }

    private static final void addXMLBase(Element element, boolean bl, boolean bl2) {
        Serializable serializable;
        if (!bl2) {
            boolean bl3 = bl2 = element.getInclusion() != null;
        }
        if (bl2 && (serializable = (URL)element.getProperty(Constants.SOURCE_URL_PROPERTY)) != null) {
            URL uRL = DocumentWriter.getBaseURL(element, (URL)serializable);
            URL uRL2 = element.getParent().getBaseURL();
            String string = null;
            if (!uRL.equals(uRL2)) {
                string = uRL2 != null ? URLUtil.getRawRelativePath(uRL, uRL2) : uRL.toExternalForm();
            }
            if (string != null) {
                if (bl) {
                    element.putAttribute(Name.XML_BASE, string);
                } else {
                    element.putProperty(Name.XML_BASE, string);
                }
            }
        }
        for (serializable = element.getFirstChild(); serializable != null; serializable = ((Node)serializable).getNextSibling()) {
            if (((Node)serializable).getType() != Node.Type.ELEMENT) continue;
            DocumentWriter.addXMLBase((Element)serializable, bl, bl2);
        }
    }

    private static final URL getBaseURL(Element element, URL uRL) {
        URL uRL2 = null;
        String string = element.getAttribute(Name.XML_BASE);
        if (string != null) {
            String string2 = XMLCatalogs.resolveURI(string);
            if (string2 != null) {
                try {
                    uRL2 = URLUtil.createURL(string2);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                try {
                    uRL2 = URLUtil.createURL(uRL, string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (uRL2 == null) {
            uRL2 = uRL;
        }
        return uRL2;
    }
}

