/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.CombineSchema;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NullNameClass;
import com.thaiopensource.relaxng.impl.PatternSchema;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.relaxng.impl.StringDatatype;
import com.thaiopensource.relaxng.impl.TokenDatatype;
import com.thaiopensource.validate.Schema;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.rng.datatype.TypeImpl;
import com.xmlmind.xml.rng.validate.AnyNameClass;
import com.xmlmind.xml.rng.validate.AnyNameExceptNameClass;
import com.xmlmind.xml.rng.validate.AttributeField;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.ChoiceNameClass;
import com.xmlmind.xml.rng.validate.ChoicePattern;
import com.xmlmind.xml.rng.validate.DTDCompatibilityException;
import com.xmlmind.xml.rng.validate.DataExceptPattern;
import com.xmlmind.xml.rng.validate.DataPattern;
import com.xmlmind.xml.rng.validate.ElementField;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.FieldBase;
import com.xmlmind.xml.rng.validate.FieldSet;
import com.xmlmind.xml.rng.validate.GroupPattern;
import com.xmlmind.xml.rng.validate.InterleavePattern;
import com.xmlmind.xml.rng.validate.ListPattern;
import com.xmlmind.xml.rng.validate.Msg;
import com.xmlmind.xml.rng.validate.NameClassBase;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.NsNameClass;
import com.xmlmind.xml.rng.validate.NsNameExceptNameClass;
import com.xmlmind.xml.rng.validate.OneOrMorePattern;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.SingleNameClass;
import com.xmlmind.xml.rng.validate.TextPattern;
import com.xmlmind.xml.rng.validate.TranslatorException;
import com.xmlmind.xml.rng.validate.ValuePattern;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.wxs.datatype.StringType;
import com.xmlmind.xml.wxs.datatype.StringValue;
import com.xmlmind.xml.wxs.datatype.TokenType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Locator;

final class Translator {
    private Builder builder;
    private IdentityHashMap<com.thaiopensource.relaxng.impl.Pattern, Pattern> translated = new IdentityHashMap();
    private IdentityHashMap<FieldBase, com.thaiopensource.relaxng.impl.Pattern> uniqueFields = new IdentityHashMap();
    private HashSet<String> sources = new HashSet();
    private PrefixPreferences declaredPrefixes = new PrefixPreferences();
    private boolean checkAttributeDefaultValues;

    Translator() {
    }

    public Pattern translate(Schema schema, Builder builder) throws TranslatorException {
        com.thaiopensource.relaxng.impl.Pattern pattern = this.findStartPattern(schema);
        if (pattern == null) {
            throw new TranslatorException("cannot find start pattern");
        }
        this.builder = builder;
        this.translated.clear();
        this.uniqueFields.clear();
        this.sources.clear();
        this.declaredPrefixes.clear();
        this.checkAttributeDefaultValues = false;
        Pattern pattern2 = this.translate(pattern);
        pattern2 = this.finishTranslation(pattern2);
        if (this.checkAttributeDefaultValues) {
            this.checkAttributeDefaultValues();
        }
        return pattern2;
    }

    public URL[] getSourceURLs() {
        int n = this.sources.size();
        URL[] uRLArray = new URL[n];
        n = 0;
        for (String uRLArray2 : this.sources) {
            try {
                uRLArray[n++] = URLUtil.newURL(uRLArray2);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (n != uRLArray.length) {
            URL[] uRLArray2 = new URL[n];
            System.arraycopy(uRLArray, 0, uRLArray2, 0, n);
            uRLArray = uRLArray2;
        }
        return uRLArray;
    }

    public PrefixEntry[] getDeclaredPrefixes() {
        if (this.declaredPrefixes.size() == 0) {
            return null;
        }
        return this.declaredPrefixes.getAll();
    }

    private com.thaiopensource.relaxng.impl.Pattern findStartPattern(Schema schema) {
        if (schema instanceof PatternSchema) {
            PatternSchema patternSchema = (PatternSchema)schema;
            return patternSchema.getStartPattern();
        }
        if (schema instanceof CombineSchema) {
            CombineSchema combineSchema = (CombineSchema)schema;
            com.thaiopensource.relaxng.impl.Pattern pattern = this.findStartPattern(combineSchema.getSchema1());
            if (pattern != null) {
                return pattern;
            }
            return this.findStartPattern(combineSchema.getSchema2());
        }
        return null;
    }

    private Pattern translate(com.thaiopensource.relaxng.impl.Pattern pattern) throws TranslatorException {
        Pattern pattern2 = this.translated.get(pattern);
        if (pattern2 != null) {
            return pattern2;
        }
        boolean bl = true;
        if (pattern instanceof com.thaiopensource.relaxng.impl.GroupPattern) {
            com.thaiopensource.relaxng.impl.GroupPattern groupPattern = (com.thaiopensource.relaxng.impl.GroupPattern)pattern;
            Pattern pattern3 = this.translate(groupPattern.getOperand1());
            Pattern pattern4 = this.translate(groupPattern.getOperand2());
            pattern2 = pattern3 == NotAllowedPattern.INSTANCE || pattern4 == NotAllowedPattern.INSTANCE ? NotAllowedPattern.INSTANCE : new GroupPattern(pattern3, pattern4);
        } else if (pattern instanceof com.thaiopensource.relaxng.impl.ChoicePattern) {
            com.thaiopensource.relaxng.impl.ChoicePattern choicePattern = (com.thaiopensource.relaxng.impl.ChoicePattern)pattern;
            Pattern pattern5 = this.translate(choicePattern.getOperand1());
            Pattern pattern6 = this.translate(choicePattern.getOperand2());
            pattern2 = pattern5 == NotAllowedPattern.INSTANCE ? pattern6 : (pattern6 == NotAllowedPattern.INSTANCE ? pattern5 : new ChoicePattern(pattern5, pattern6));
        } else if (pattern instanceof com.thaiopensource.relaxng.impl.EmptyPattern) {
            pattern2 = EmptyPattern.INSTANCE;
        } else if (pattern instanceof com.thaiopensource.relaxng.impl.OneOrMorePattern) {
            com.thaiopensource.relaxng.impl.OneOrMorePattern oneOrMorePattern = (com.thaiopensource.relaxng.impl.OneOrMorePattern)pattern;
            Pattern pattern7 = this.translate(oneOrMorePattern.getOperand());
            pattern2 = pattern7 == NotAllowedPattern.INSTANCE ? NotAllowedPattern.INSTANCE : new OneOrMorePattern(pattern7);
        } else {
            if (pattern instanceof RefPattern) {
                RefPattern refPattern = (RefPattern)pattern;
                return this.translate(refPattern.getPattern());
            }
            if (pattern instanceof ElementPattern) {
                SimpleNameClass[] simpleNameClassArray;
                ElementPattern elementPattern = (ElementPattern)pattern;
                this.sources.add(elementPattern.getLocator().getSystemId());
                NameClass nameClass = elementPattern.getNameClass();
                pattern2 = nameClass instanceof NullNameClass ? NotAllowedPattern.INSTANCE : ((simpleNameClassArray = Translator.getChoiceOfSimpleNameClass(nameClass)) != null ? Translator.makeChoiceOfElements((NameClass[])simpleNameClassArray, 0) : new ElementField());
                this.translated.put(pattern, pattern2);
                bl = false;
                this.translate(elementPattern.getContent());
            } else if (pattern instanceof AttributePattern) {
                AttributePattern attributePattern = (AttributePattern)pattern;
                this.sources.add(attributePattern.getLocator().getSystemId());
                NameClass nameClass = attributePattern.getNameClass();
                if (nameClass instanceof NullNameClass) {
                    pattern2 = NotAllowedPattern.INSTANCE;
                    this.translate(attributePattern.getContent());
                } else {
                    String string = attributePattern.getDefaultValue();
                    if (!this.checkAttributeDefaultValues && string != null) {
                        this.checkAttributeDefaultValues = true;
                    }
                    SimpleNameClass[] simpleNameClassArray = Translator.getChoiceOfSimpleNameClass(nameClass);
                    Pattern pattern8 = this.translate(attributePattern.getContent());
                    if (simpleNameClassArray != null) {
                        pattern2 = this.makeChoiceOfAttributes((NameClass[])simpleNameClassArray, 0, pattern8, string, this.builder);
                    } else {
                        AttributeField attributeField = new AttributeField();
                        attributeField.initialize(this.translate(nameClass), pattern8, string, this.builder);
                        pattern2 = attributeField;
                    }
                }
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.TextPattern) {
                pattern2 = TextPattern.INSTANCE;
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.InterleavePattern) {
                com.thaiopensource.relaxng.impl.InterleavePattern interleavePattern = (com.thaiopensource.relaxng.impl.InterleavePattern)pattern;
                Pattern pattern9 = this.translate(interleavePattern.getOperand1());
                Pattern pattern10 = this.translate(interleavePattern.getOperand2());
                pattern2 = pattern9 == NotAllowedPattern.INSTANCE || pattern10 == NotAllowedPattern.INSTANCE ? NotAllowedPattern.INSTANCE : new InterleavePattern(pattern9, pattern10);
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.ValuePattern) {
                com.thaiopensource.relaxng.impl.ValuePattern valuePattern = (com.thaiopensource.relaxng.impl.ValuePattern)pattern;
                pattern2 = new ValuePattern(Translator.translate(valuePattern.getValue(), valuePattern.getDatatype()), Translator.translate(valuePattern.getDatatype()));
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.DataPattern) {
                com.thaiopensource.relaxng.impl.DataPattern dataPattern = (com.thaiopensource.relaxng.impl.DataPattern)pattern;
                pattern2 = new DataPattern(Translator.translate(dataPattern.getDatatype()));
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.ListPattern) {
                com.thaiopensource.relaxng.impl.ListPattern listPattern = (com.thaiopensource.relaxng.impl.ListPattern)pattern;
                pattern2 = new ListPattern(this.translate(listPattern.getOperand()));
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.DataExceptPattern) {
                com.thaiopensource.relaxng.impl.DataExceptPattern dataExceptPattern = (com.thaiopensource.relaxng.impl.DataExceptPattern)pattern;
                pattern2 = new DataExceptPattern(Translator.translate(dataExceptPattern.getDatatype()), this.translate(dataExceptPattern.getExcept()));
            } else if (pattern instanceof com.thaiopensource.relaxng.impl.NotAllowedPattern) {
                pattern2 = NotAllowedPattern.INSTANCE;
            } else {
                throw new TranslatorException("unexpected " + pattern.getClass().getName());
            }
        }
        if (bl) {
            this.translated.put(pattern, pattern2);
        }
        return pattern2;
    }

    private static SimpleNameClass[] getChoiceOfSimpleNameClass(NameClass nameClass) {
        if (!(nameClass instanceof com.thaiopensource.relaxng.impl.ChoiceNameClass)) {
            return null;
        }
        ArrayList<SimpleNameClass> arrayList = new ArrayList<SimpleNameClass>();
        if (!Translator.getChoiceOfSimpleNameClass(nameClass, arrayList)) {
            return null;
        }
        SimpleNameClass[] simpleNameClassArray = new SimpleNameClass[arrayList.size()];
        arrayList.toArray(simpleNameClassArray);
        return simpleNameClassArray;
    }

    private static boolean getChoiceOfSimpleNameClass(NameClass nameClass, ArrayList<SimpleNameClass> arrayList) {
        if (nameClass instanceof SimpleNameClass) {
            arrayList.add((SimpleNameClass)nameClass);
            return true;
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.ChoiceNameClass) {
            com.thaiopensource.relaxng.impl.ChoiceNameClass choiceNameClass = (com.thaiopensource.relaxng.impl.ChoiceNameClass)nameClass;
            return Translator.getChoiceOfSimpleNameClass(choiceNameClass.getOperand1(), arrayList) && Translator.getChoiceOfSimpleNameClass(choiceNameClass.getOperand2(), arrayList);
        }
        return false;
    }

    private static Pattern makeChoiceOfElements(NameClass[] nameClassArray, int n) throws TranslatorException {
        if (n + 1 == nameClassArray.length) {
            return new ElementField();
        }
        return new ChoicePattern(new ElementField(), Translator.makeChoiceOfElements(nameClassArray, n + 1));
    }

    private Pattern makeChoiceOfAttributes(NameClass[] nameClassArray, int n, Pattern pattern, String string, Builder builder) throws TranslatorException {
        if (n + 1 == nameClassArray.length) {
            AttributeField attributeField = new AttributeField();
            attributeField.initialize(this.translate(nameClassArray[n]), pattern, string, builder);
            return attributeField;
        }
        AttributeField attributeField = new AttributeField();
        attributeField.initialize(this.translate(nameClassArray[n]), pattern, string, builder);
        return new ChoicePattern(attributeField, this.makeChoiceOfAttributes(nameClassArray, n + 1, pattern, string, builder));
    }

    private NameClassBase translate(NameClass nameClass) throws TranslatorException {
        if (nameClass instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
            com.thaiopensource.xml.util.Name name = simpleNameClass.getName();
            Namespace namespace = Namespace.get(name.getNamespaceUri());
            if (namespace != Namespace.NONE && namespace != Namespace.XML) {
                this.declaredPrefixes.add(namespace, null);
            }
            return new SingleNameClass(Name.get(namespace, name.getLocalName()));
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.AnyNameClass) {
            return new AnyNameClass();
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.AnyNameExceptNameClass) {
            com.thaiopensource.relaxng.impl.AnyNameExceptNameClass anyNameExceptNameClass = (com.thaiopensource.relaxng.impl.AnyNameExceptNameClass)nameClass;
            return new AnyNameExceptNameClass(this.translate(anyNameExceptNameClass.getExcept()));
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.NsNameClass) {
            com.thaiopensource.relaxng.impl.NsNameClass nsNameClass = (com.thaiopensource.relaxng.impl.NsNameClass)nameClass;
            Namespace namespace = Namespace.get(nsNameClass.getNamespace());
            if (namespace != Namespace.NONE && namespace != Namespace.XML) {
                this.declaredPrefixes.add(namespace, null);
            }
            return new NsNameClass(namespace);
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.NsNameExceptNameClass) {
            com.thaiopensource.relaxng.impl.NsNameExceptNameClass nsNameExceptNameClass = (com.thaiopensource.relaxng.impl.NsNameExceptNameClass)nameClass;
            Namespace namespace = Namespace.get(nsNameExceptNameClass.getNamespace());
            if (namespace != Namespace.NONE && namespace != Namespace.XML) {
                this.declaredPrefixes.add(namespace, null);
            }
            return new NsNameExceptNameClass(namespace, this.translate(nsNameExceptNameClass.getExcept()));
        }
        if (nameClass instanceof com.thaiopensource.relaxng.impl.ChoiceNameClass) {
            com.thaiopensource.relaxng.impl.ChoiceNameClass choiceNameClass = (com.thaiopensource.relaxng.impl.ChoiceNameClass)nameClass;
            return new ChoiceNameClass(this.translate(choiceNameClass.getOperand1()), this.translate(choiceNameClass.getOperand2()));
        }
        throw new TranslatorException("unexpected " + nameClass.getClass().getName());
    }

    private static DataType translate(Datatype datatype) throws TranslatorException {
        if (datatype instanceof TokenDatatype) {
            return TokenType.BASE;
        }
        if (datatype instanceof StringDatatype) {
            return StringType.BASE;
        }
        if (datatype instanceof TypeImpl) {
            return ((TypeImpl)datatype).getDataType();
        }
        throw new TranslatorException("datatype not supported " + datatype.getClass().getName());
    }

    private static Data translate(Object object, Datatype datatype) throws TranslatorException {
        if (datatype instanceof TokenDatatype || datatype instanceof StringDatatype) {
            return new StringValue((String)object);
        }
        if (datatype instanceof TypeImpl) {
            return (Data)object;
        }
        throw new TranslatorException("datatype not supported " + datatype.getClass().getName());
    }

    private Pattern finishTranslation(Pattern pattern) throws TranslatorException {
        block0: for (Map.Entry<com.thaiopensource.relaxng.impl.Pattern, Pattern> object : this.translated.entrySet()) {
            com.thaiopensource.relaxng.impl.Pattern pattern2 = object.getKey();
            Pattern pattern3 = object.getValue();
            if (!(pattern2 instanceof ElementPattern)) continue;
            ElementPattern elementPattern = (ElementPattern)pattern2;
            Pattern pattern4 = this.translate(elementPattern.getContent());
            if (pattern3 instanceof ChoicePattern) {
                ChoicePattern choicePattern = (ChoicePattern)pattern3;
                SimpleNameClass[] simpleNameClassArray = Translator.getChoiceOfSimpleNameClass(elementPattern.getNameClass());
                int n = 0;
                while (true) {
                    ((ElementField)choicePattern.pattern1).initialize(this.translate((NameClass)simpleNameClassArray[n++]), pattern4, this.builder);
                    if (choicePattern.pattern2 instanceof ElementField) {
                        ((ElementField)choicePattern.pattern2).initialize(this.translate((NameClass)simpleNameClassArray[n++]), pattern4, this.builder);
                        continue block0;
                    }
                    choicePattern = (ChoicePattern)choicePattern.pattern2;
                }
            }
            if (!(pattern3 instanceof ElementField)) continue;
            ((ElementField)pattern3).initialize(this.translate(elementPattern.getNameClass()), pattern4, this.builder);
        }
        pattern = this.factorize(pattern);
        for (FieldBase fieldBase : this.uniqueFields.keySet()) {
            fieldBase.prepare();
        }
        return pattern;
    }

    private Pattern factorize(Pattern pattern) {
        FieldSet fieldSet = new FieldSet();
        FieldSet fieldSet2 = new FieldSet();
        IdentityHashMap<Pattern, Pattern> identityHashMap = new IdentityHashMap<Pattern, Pattern>();
        for (Pattern object : this.translated.values()) {
            object.factorize(this.builder, fieldSet, fieldSet2, identityHashMap);
        }
        block1: for (Map.Entry<com.thaiopensource.relaxng.impl.Pattern, Pattern> entry : this.translated.entrySet()) {
            Pattern pattern2;
            com.thaiopensource.relaxng.impl.Pattern pattern3 = entry.getKey();
            Pattern pattern4 = entry.getValue();
            if (!(pattern3 instanceof ElementPattern) && !(pattern3 instanceof AttributePattern)) continue;
            if (pattern4 instanceof ChoicePattern) {
                pattern2 = (ChoicePattern)pattern4;
                while (true) {
                    FieldBase fieldBase = (FieldBase)pattern2.pattern1;
                    this.uniqueFields.put((FieldBase)identityHashMap.get(fieldBase), pattern3);
                    if (pattern2.pattern2 instanceof FieldBase) {
                        fieldBase = (FieldBase)pattern2.pattern2;
                        this.uniqueFields.put((FieldBase)identityHashMap.get(fieldBase), pattern3);
                        continue block1;
                    }
                    pattern2 = (ChoicePattern)pattern2.pattern2;
                }
            }
            if (!(pattern4 instanceof FieldBase)) continue;
            pattern2 = (FieldBase)pattern4;
            this.uniqueFields.put((FieldBase)identityHashMap.get(pattern2), pattern3);
        }
        this.translated.clear();
        return identityHashMap.get(pattern);
    }

    private void checkAttributeDefaultValues() throws TranslatorException {
        DTDCompatibilityException dTDCompatibilityException = new DTDCompatibilityException();
        IdentityHashMap<Name, Object[]> identityHashMap = new IdentityHashMap<Name, Object[]>();
        for (Map.Entry<FieldBase, com.thaiopensource.relaxng.impl.Pattern> object : this.uniqueFields.entrySet()) {
            Object[] objectArray = object.getKey();
            com.thaiopensource.relaxng.impl.Pattern i = object.getValue();
            if (objectArray instanceof AttributeField) {
                Translator.checkAttributeField((AttributeField)objectArray, (AttributePattern)i, dTDCompatibilityException);
                continue;
            }
            if (!(objectArray instanceof ElementField)) continue;
            Translator.checkElementField((ElementField)objectArray, identityHashMap, (ElementPattern)i, dTDCompatibilityException);
        }
        if (dTDCompatibilityException.getErrorCount() == 0) {
            for (Object[] objectArray : identityHashMap.values()) {
                if (objectArray.length <= 2) continue;
                for (int i = 0; i < objectArray.length; i += 2) {
                    ElementField elementField = (ElementField)objectArray[i + 1];
                    if (!elementField.hasAttributeDefaultValues) continue;
                    ElementPattern elementPattern = (ElementPattern)objectArray[i];
                    AttributeField[] attributeFieldArray = elementField.attributeFields;
                    for (int j = 0; j < attributeFieldArray.length; ++j) {
                        AttributeField attributeField = attributeFieldArray[j];
                        if (attributeField.defaultValue == null || Translator.checkConsistency(objectArray, attributeField, elementField)) continue;
                        Translator.addError(elementPattern.getLocator(), elementField, Msg.msg("inconsistentAttributeDefaultValue", objectArray.length / 2, elementField.nameClass, attributeField.nameClass, attributeField.defaultValueAnnotation), dTDCompatibilityException);
                    }
                }
            }
        }
        if (dTDCompatibilityException.getErrorCount() > 0) {
            throw dTDCompatibilityException;
        }
    }

    private static final void checkAttributeField(AttributeField attributeField, AttributePattern attributePattern, DTDCompatibilityException dTDCompatibilityException) throws TranslatorException {
        if (attributeField.defaultValueAnnotation != null) {
            if (attributeField.getFieldName() == null) {
                Translator.addError(attributePattern.getLocator(), attributeField, Msg.msg("defaultValueForWildcard"), dTDCompatibilityException);
            } else if (attributeField.dataType.isContextDependentDataType()) {
                Translator.addError(attributePattern.getLocator(), attributeField, Msg.msg("defaultValueForContextDependentDataType", attributeField.dataType.getDataTypeLabel(null)), dTDCompatibilityException);
            } else if (attributeField.defaultValue == null) {
                Translator.addError(attributePattern.getLocator(), attributeField, Msg.msg("invalidAttributeDefaultValue", attributeField.defaultValueAnnotation), dTDCompatibilityException);
            }
        }
    }

    private static final void checkElementField(ElementField elementField, IdentityHashMap<Name, Object[]> identityHashMap, ElementPattern elementPattern, DTDCompatibilityException dTDCompatibilityException) throws TranslatorException {
        Object[] objectArray;
        Name name = elementField.getFieldName();
        if (elementField.hasAttributeDefaultValues) {
            if (name == null) {
                Translator.addError(elementPattern.getLocator(), elementField, Msg.msg("wildcardHasAttributeDefaultValues"), dTDCompatibilityException);
            } else {
                objectArray = elementField.attributeFields;
                boolean[] blArray = elementField.attributeIsRequired;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (((AttributeField)object).defaultValueAnnotation == null || !blArray[i]) continue;
                    Translator.addError(elementPattern.getLocator(), elementField, Msg.msg("defaultValueForRequiredAttribute", ((AttributeField)object).nameClass), dTDCompatibilityException);
                }
            }
        }
        if (name != null) {
            objectArray = identityHashMap.get(name);
            if (objectArray == null) {
                objectArray = new Object[]{elementPattern, elementField};
            } else {
                int n = objectArray.length;
                Object[] objectArray2 = new Object[n + 2];
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
                objectArray2[n] = elementPattern;
                objectArray2[n + 1] = elementField;
                objectArray = objectArray2;
            }
            identityHashMap.put(name, objectArray);
        }
    }

    private static final boolean checkConsistency(Object[] objectArray, AttributeField attributeField, ElementField elementField) {
        Name name = attributeField.getFieldName();
        for (int i = 0; i < objectArray.length; i += 2) {
            ElementField elementField2 = (ElementField)objectArray[i + 1];
            if (elementField2 == elementField) continue;
            if (!elementField2.hasAttributeDefaultValues) {
                return false;
            }
            boolean bl = false;
            AttributeField[] attributeFieldArray = elementField2.attributeFields;
            for (int j = 0; j < attributeFieldArray.length; ++j) {
                AttributeField attributeField2 = attributeFieldArray[j];
                if (name != attributeField2.getFieldName() || !attributeField.defaultValue.equals(attributeField2.defaultValue)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static final void addError(Locator locator, FieldBase fieldBase, String string, DTDCompatibilityException dTDCompatibilityException) {
        StringBuilder stringBuilder = new StringBuilder();
        if (fieldBase instanceof AttributeField) {
            stringBuilder.append(Msg.msg("attribute"));
        } else {
            stringBuilder.append(Msg.msg("element"));
        }
        stringBuilder.append(" \"");
        stringBuilder.append(fieldBase.nameClass);
        stringBuilder.append("\": ");
        stringBuilder.append(string);
        DTDCompatibilityException.Error error = new DTDCompatibilityException.Error(locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber(), stringBuilder.toString());
        dTDCompatibilityException.addError(error);
    }
}

