/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.thaiopensource.validate.Schema;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.load.LoadError;
import com.xmlmind.xml.load.LoadErrorImpl;
import com.xmlmind.xml.rng.validate.RNGLoaderImpl;
import com.xmlmind.xml.rng.validate.SubDocumentTypeImpl;
import com.xmlmind.xml.rng.validate.TranslatorException;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.validate.DiagnosticImpl;
import com.xmlmind.xml.validate.SubDocumentType;
import java.net.URL;

public final class RNGSchemaForRNGSchema
extends SubDocumentTypeImpl {
    private static final boolean[] INSTANCE_LOADED = new boolean[1];
    private static SubDocumentType INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubDocumentType getInstance() {
        boolean[] blArray = INSTANCE_LOADED;
        synchronized (INSTANCE_LOADED) {
            if (!INSTANCE_LOADED[0]) {
                RNGSchemaForRNGSchema.INSTANCE_LOADED[0] = true;
                INSTANCE = RNGSchemaForRNGSchema.doGetInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static SubDocumentType doGetInstance() {
        SubDocumentType subDocumentType = null;
        try {
            URL uRL = RNGSchemaForRNGSchema.class.getResource("relaxng.rng");
            if (uRL == null) {
                throw new RuntimeException("'relaxng.rng' not found");
            }
            RNGLoaderImpl rNGLoaderImpl = new RNGLoaderImpl(){

                @Override
                protected SubDocumentTypeImpl createSubDocumentType(Schema schema, URL uRL) throws TranslatorException {
                    return new RNGSchemaForRNGSchema(schema, uRL);
                }
            };
            subDocumentType = rNGLoaderImpl.loadSubDocumentType(uRL);
            if (subDocumentType == null) {
                String string = "'relaxng.rng' has errors";
                LoadError[] loadErrorArray = rNGLoaderImpl.getLoadErrors();
                if (loadErrorArray != null && loadErrorArray.length > 0) {
                    string = LoadErrorImpl.format(loadErrorArray[0], false);
                }
                throw new RuntimeException(string);
            }
        }
        catch (Exception exception) {
            System.err.println("Internal error: cannot load 'relaxng.rng':\n" + ThrowableUtil.detailedReason(exception));
        }
        return subDocumentType;
    }

    private RNGSchemaForRNGSchema(Schema schema, URL uRL) throws TranslatorException {
        super(schema, uRL);
    }

    @Override
    public Diagnostic[] checkDocument(Element element) {
        Element element2;
        Node node;
        LoadError loadError;
        int n;
        Diagnostic[] diagnosticArray = super.checkDocument(element);
        if (diagnosticArray != null && diagnosticArray.length > 0) {
            return diagnosticArray;
        }
        Document document = element.getDocument();
        if (document.getRootElement() != element) {
            return DiagnosticImpl.NO_DIAGNOSTICS;
        }
        RNGLoaderImpl rNGLoaderImpl = new RNGLoaderImpl();
        rNGLoaderImpl.loadSubDocumentType(document);
        LoadError[] loadErrorArray = rNGLoaderImpl.getLoadErrors();
        LoadError[] loadErrorArray2 = rNGLoaderImpl.getLoadWarnings();
        if (loadErrorArray.length == 0 && loadErrorArray2.length == 0) {
            return DiagnosticImpl.NO_DIAGNOSTICS;
        }
        Diagnostic[] diagnosticArray2 = new DiagnosticImpl[loadErrorArray.length + loadErrorArray2.length];
        int n2 = 0;
        for (n = 0; n < loadErrorArray.length; ++n) {
            loadError = loadErrorArray[n];
            node = loadError.getNodeInError();
            if (node == null || node.getDocument() != document) continue;
            element2 = null;
            element2 = node.getType() == Node.Type.ELEMENT ? (Element)node : node.getParentElement();
            if (element2 == null) continue;
            diagnosticArray2[n2++] = new DiagnosticImpl(element2, loadError.getErrorMessage(), Diagnostic.Severity.SEMANTIC_ERROR);
        }
        for (n = 0; n < loadErrorArray2.length; ++n) {
            loadError = loadErrorArray2[n];
            node = loadError.getNodeInError();
            if (node == null || node.getDocument() != document) continue;
            element2 = null;
            element2 = node.getType() == Node.Type.ELEMENT ? (Element)node : node.getParentElement();
            if (element2 == null) continue;
            diagnosticArray2[n2++] = new DiagnosticImpl(element2, loadError.getErrorMessage(), Diagnostic.Severity.SEMANTIC_WARNING);
        }
        if (n2 != diagnosticArray2.length) {
            DiagnosticImpl[] diagnosticImplArray = new DiagnosticImpl[n2];
            System.arraycopy(diagnosticArray2, 0, diagnosticImplArray, 0, n2);
            diagnosticArray2 = diagnosticImplArray;
        }
        return diagnosticArray2;
    }
}

