/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.util.StringUtil;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.rng.validate.AttributeField;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.ElementField;
import com.xmlmind.xml.rng.validate.FieldBase;
import com.xmlmind.xml.rng.validate.FieldSet;
import com.xmlmind.xml.rng.validate.ItemList;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.PatternStack;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.UnparsedEntities;
import java.util.IdentityHashMap;

abstract class Pattern {
    public boolean nullable;
    protected static final int INCR_INDENT = 2;
    protected static final int WEIGHT_EMPTY = 0;
    protected static final int WEIGHT_ATTRIBUTE = 1;
    protected static final int WEIGHT_ELEMENT = 2;
    protected static final int EMPTY_COMPLEXITY = 0;
    protected static final int TEXT_COMPLEXITY = 1;
    protected static final int DATA_COMPLEXITY = 2;
    protected static final int ATTRIBUTE_COMPLEXITY = 100;
    protected static final int ELEMENT_COMPLEXITY = 200;
    protected static final int NOT_ALLOWED_COMPLEXITY = 1000000;
    protected static final int WILDCARD_COMPLEXITY = 1000;

    protected Pattern(boolean bl) {
        this.nullable = bl;
    }

    protected Pattern() {
    }

    public abstract boolean samePatternAs(Pattern var1, PatternStack var2);

    public static final boolean samePattern(Pattern pattern, Pattern pattern2, PatternStack patternStack) {
        return pattern == pattern2 || pattern != null && pattern.samePatternAs(pattern2, patternStack);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(0, namespaceToPrefixes, stringBuilder);
        return stringBuilder.toString();
    }

    public abstract void toString(int var1, NamespaceToPrefixes var2, StringBuilder var3);

    protected static final void indent(int n, StringBuilder stringBuilder) {
        while (n > 0) {
            stringBuilder.append(' ');
            --n;
        }
    }

    public Pattern attributeDeriv(AttributeField attributeField, Builder builder) {
        return NotAllowedPattern.INSTANCE;
    }

    public Pattern attributeDeriv(Attribute attribute, IdentityHashMap<Field, Field[]> identityHashMap, FieldBase[] fieldBaseArray, Builder builder) {
        return NotAllowedPattern.INSTANCE;
    }

    public Pattern elementDeriv(ElementField elementField, Builder builder) {
        return NotAllowedPattern.INSTANCE;
    }

    public Pattern elementDeriv(Element element, IdentityHashMap<Field, Field[]> identityHashMap, boolean bl, FieldBase[] fieldBaseArray, Builder builder) {
        return NotAllowedPattern.INSTANCE;
    }

    public Pattern textDeriv(boolean bl, Builder builder) {
        if (bl) {
            return this;
        }
        return this.textDeriv(builder);
    }

    public Pattern textDeriv(Builder builder) {
        return NotAllowedPattern.INSTANCE;
    }

    public Pattern textDeriv(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, Builder builder) {
        return NotAllowedPattern.INSTANCE;
    }

    public Pattern listDeriv(String[] stringArray, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, Builder builder) {
        String[] stringArray2;
        if (stringArray.length == 0) {
            return this;
        }
        String string = stringArray[0];
        if (stringArray.length > 1) {
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        } else {
            stringArray2 = StringUtil.EMPTY_LIST;
        }
        Pattern pattern = this.textDeriv(string, prefixToNamespace, unparsedEntities, builder);
        return pattern.listDeriv(stringArray2, prefixToNamespace, unparsedEntities, builder);
    }

    protected Pattern factorize(Builder builder, FieldSet fieldSet, FieldSet fieldSet2, IdentityHashMap<Pattern, Pattern> identityHashMap) {
        Pattern pattern = identityHashMap.get(this);
        if (pattern == null) {
            pattern = this.doFactorize(builder, fieldSet, fieldSet2, identityHashMap);
            identityHashMap.put(this, pattern);
        }
        return pattern;
    }

    protected Pattern doFactorize(Builder builder, FieldSet fieldSet, FieldSet fieldSet2, IdentityHashMap<Pattern, Pattern> identityHashMap) {
        return this;
    }

    protected abstract ContentType scan(PatternStack var1, IdentityHashMap<AttributeField, Boolean> var2, IdentityHashMap<ElementField, Boolean> var3);

    protected int attributesSeparatedFromElements() {
        return 2;
    }

    protected Pattern withoutAttributes(Builder builder) {
        return this;
    }

    protected Pattern findDataPattern() {
        return null;
    }

    protected abstract int getComplexity(boolean var1);

    protected abstract boolean expand(int var1, ItemList var2);
}

