/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.rng.validate.AnyDataPattern;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternStack;
import com.xmlmind.xml.validate.UnparsedEntities;

final class ListPattern
extends AnyDataPattern {
    public Pattern pattern;

    public ListPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public ListPattern() {
    }

    @Override
    public boolean samePatternAs(Pattern pattern, PatternStack patternStack) {
        if (pattern == null || !(pattern instanceof ListPattern)) {
            return false;
        }
        return ListPattern.samePattern(this.pattern, ((ListPattern)pattern).pattern, patternStack);
    }

    @Override
    public void toString(int n, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        stringBuilder.append("list {");
        if (n >= 0) {
            stringBuilder.append('\n');
            ListPattern.indent(n + 2, stringBuilder);
        }
        this.pattern.toString(n >= 0 ? n + 2 : -1, namespaceToPrefixes, stringBuilder);
        if (n >= 0) {
            stringBuilder.append('\n');
            ListPattern.indent(n, stringBuilder);
        }
        stringBuilder.append('}');
    }

    public int hashCode() {
        return System.identityHashCode(this.pattern);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ListPattern)) {
            return false;
        }
        return this.pattern == ((ListPattern)object).pattern;
    }

    @Override
    public Pattern textDeriv(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, Builder builder) {
        Pattern pattern = this.pattern.listDeriv(XMLText.splitList(string), prefixToNamespace, unparsedEntities, builder);
        if (pattern.nullable) {
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }
}

