/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.rng.validate.Msg;
import com.xmlmind.xml.rng.validate.TranslatorException;

class DTDCompatibilityException
extends TranslatorException {
    private Error[] errors = new Error[0];

    public void addError(Error error) {
        Error[] errorArray = new Error[this.errors.length + 1];
        if (this.errors.length > 0) {
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
        }
        errorArray[this.errors.length] = error;
        this.errors = errorArray;
    }

    public Error[] getErrors() {
        return this.errors;
    }

    public int getErrorCount() {
        return this.errors.length;
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.errors.length; ++i) {
            if (i > 0) {
                stringBuilder.append('\n');
            }
            this.errors[i].toString(stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static final class Error {
        public final String systemId;
        public final int lineNumber;
        public final int columnNumber;
        public final String message;

        public Error(String string, int n, int n2, String string2) {
            this.systemId = string;
            this.lineNumber = n;
            this.columnNumber = n2;
            this.message = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            if (this.systemId != null) {
                stringBuilder.append(this.systemId);
            }
            stringBuilder.append(':');
            if (this.lineNumber > 0) {
                stringBuilder.append(this.lineNumber);
            }
            stringBuilder.append(':');
            if (this.columnNumber > 0) {
                stringBuilder.append(this.columnNumber);
            }
            stringBuilder.append(':');
            stringBuilder.append(Msg.msg("error"));
            stringBuilder.append(": ");
            stringBuilder.append(this.message);
        }
    }
}

