/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.DataExceptPattern;
import com.xmlmind.xml.rng.validate.DataPattern;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternTraversal;
import com.xmlmind.xml.rng.validate.ValuePattern;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataFormatException;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.UnparsedEntities;
import com.xmlmind.xml.wxs.datatype.StringValue;

final class ComplexDataType
implements DataType {
    private Pattern pattern;
    private Builder builder;
    private byte contextDependent;

    public ComplexDataType(Pattern pattern, Builder builder) {
        this.pattern = pattern;
        this.builder = builder;
        this.contextDependent = (byte)-1;
    }

    public int hashCode() {
        return System.identityHashCode(this.pattern);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ComplexDataType)) {
            return false;
        }
        return this.pattern == ((ComplexDataType)object).pattern;
    }

    public String toString() {
        return this.getDataTypeLabel(null);
    }

    @Override
    public String normalizeWhiteSpace(String string) {
        return string;
    }

    @Override
    public Data parseData(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws DataFormatException {
        Pattern pattern = this.pattern.textDeriv(string, prefixToNamespace, unparsedEntities, this.builder);
        if (!pattern.nullable) {
            throw new DataFormatException("'" + string + "' does not match " + this.getDataTypeLabel(null));
        }
        return new StringValue(string);
    }

    @Override
    public boolean isContextDependentDataType() {
        if (this.contextDependent < 0) {
            Object object = PatternTraversal.traverse(this.pattern, new PatternTraversal.HandlerBase(){

                @Override
                public Object dataPattern(DataPattern dataPattern) {
                    if (dataPattern.dataType.isContextDependentDataType()) {
                        return Boolean.TRUE;
                    }
                    return null;
                }

                @Override
                public Object valuePattern(ValuePattern valuePattern) {
                    if (valuePattern.dataType.isContextDependentDataType()) {
                        return Boolean.TRUE;
                    }
                    return null;
                }

                @Override
                public Object dataExceptPattern(DataExceptPattern dataExceptPattern) {
                    if (dataExceptPattern.dataType.isContextDependentDataType()) {
                        return Boolean.TRUE;
                    }
                    return null;
                }
            });
            this.contextDependent = (byte)(object != null ? 1 : 0);
        }
        return this.contextDependent == 1;
    }

    @Override
    public Data[] getEnumeratedValues() {
        return null;
    }

    @Override
    public String getDataTypeLabel(NamespaceToPrefixes namespaceToPrefixes) {
        return XMLText.collapseWhiteSpace(this.pattern.toString(namespaceToPrefixes));
    }
}

