/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.ChoicePattern;
import com.xmlmind.xml.rng.validate.ElementField;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.FieldBase;
import com.xmlmind.xml.rng.validate.FieldSet;
import com.xmlmind.xml.rng.validate.ItemList;
import com.xmlmind.xml.rng.validate.NameClassBase;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternStack;
import com.xmlmind.xml.rng.validate.SingleNameClass;
import com.xmlmind.xml.rng.validate.TextPattern;
import com.xmlmind.xml.validate.AttributeType;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataFormatException;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.UncheckedUnparsedEntities;
import com.xmlmind.xml.wxs.datatype.StringType;
import java.util.IdentityHashMap;

final class AttributeField
extends FieldBase
implements AttributeType {
    public String defaultValueAnnotation;
    public Data defaultValue;

    public AttributeField(NameClassBase nameClassBase, Pattern pattern, String string, Builder builder) {
        this.initialize(nameClassBase, pattern, string, builder);
        this.prepare();
    }

    public AttributeField() {
    }

    protected void initialize(NameClassBase nameClassBase, Pattern pattern, String string, Builder builder) {
        super.initialize(nameClassBase, pattern, builder);
        this.defaultValueAnnotation = string;
    }

    @Override
    protected void prepare() {
        if (this.pattern == TextPattern.INSTANCE) {
            this.dataType = StringType.BASE;
        } else {
            this.initDataType();
        }
        if (this.defaultValueAnnotation != null) {
            try {
                this.defaultValue = this.dataType.parseData(this.defaultValueAnnotation, null, UncheckedUnparsedEntities.INSTANCE);
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean samePatternAs(Pattern pattern, PatternStack patternStack) {
        if (pattern == null || !(pattern instanceof AttributeField)) {
            return false;
        }
        AttributeField attributeField = (AttributeField)pattern;
        return this.nameClass.equals(attributeField.nameClass) && AttributeField.samePattern(this.pattern, attributeField.pattern, patternStack) && (this.defaultValueAnnotation == null && attributeField.defaultValueAnnotation == null || this.defaultValueAnnotation != null && this.defaultValueAnnotation.equals(attributeField.defaultValueAnnotation));
    }

    @Override
    public void toString(int n, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        stringBuilder.append("attribute ");
        this.nameClass.toLabel(true, namespaceToPrefixes, stringBuilder);
        stringBuilder.append(" {");
        if (n >= 0) {
            stringBuilder.append('\n');
            AttributeField.indent(n + 2, stringBuilder);
        }
        this.pattern.toString(n >= 0 ? n + 2 : -1, namespaceToPrefixes, stringBuilder);
        if (n >= 0) {
            stringBuilder.append('\n');
            AttributeField.indent(n, stringBuilder);
        }
        stringBuilder.append("}");
    }

    public int hashCode() {
        int n = this.nameClass.hashCode() ^ System.identityHashCode(this.pattern);
        if (this.defaultValueAnnotation != null) {
            n ^= this.defaultValueAnnotation.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AttributeField)) {
            return false;
        }
        AttributeField attributeField = (AttributeField)object;
        return this.nameClass.equals(attributeField.nameClass) && this.pattern == attributeField.pattern && (this.defaultValueAnnotation == null && attributeField.defaultValueAnnotation == null || this.defaultValueAnnotation != null && this.defaultValueAnnotation.equals(attributeField.defaultValueAnnotation));
    }

    @Override
    public Pattern attributeDeriv(AttributeField attributeField, Builder builder) {
        if (attributeField == this) {
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }

    @Override
    public Pattern attributeDeriv(Attribute attribute, IdentityHashMap<Field, Field[]> identityHashMap, FieldBase[] fieldBaseArray, Builder builder) {
        if (this.nameClass.containsName(attribute.name)) {
            if (identityHashMap != null && identityHashMap.containsKey(this)) {
                if (!this.matchValue(attribute)) {
                    return NotAllowedPattern.INSTANCE;
                }
                fieldBaseArray[0] = this;
                return EmptyPattern.INSTANCE;
            }
            if (this.fixedValue != null && !this.matchValue(attribute)) {
                return NotAllowedPattern.INSTANCE;
            }
            fieldBaseArray[0] = this;
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }

    private boolean matchValue(Attribute attribute) {
        Data data = null;
        try {
            data = this.dataType.parseData(attribute.value, attribute.element, UncheckedUnparsedEntities.INSTANCE);
        }
        catch (DataFormatException dataFormatException) {
            return false;
        }
        return this.fixedValue == null || this.fixedValue.equals(data);
    }

    @Override
    protected Pattern doFactorize(Builder builder, FieldSet fieldSet, FieldSet fieldSet2, IdentityHashMap<Pattern, Pattern> identityHashMap) {
        AttributeField attributeField = (AttributeField)fieldSet.add(this);
        if (attributeField == this) {
            AttributeField attributeField2 = new AttributeField();
            identityHashMap.put(this, attributeField2);
            attributeField2.initialize(this.nameClass, this.pattern.factorize(builder, fieldSet, fieldSet2, identityHashMap), this.defaultValueAnnotation, builder);
            return attributeField2;
        }
        return identityHashMap.get(attributeField);
    }

    @Override
    protected ContentType scan(PatternStack patternStack, IdentityHashMap<AttributeField, Boolean> identityHashMap, IdentityHashMap<ElementField, Boolean> identityHashMap2) {
        int n;
        boolean bl = true;
        for (n = patternStack.size - 1; n >= 0; --n) {
            Pattern pattern = patternStack.list[n];
            if (!(pattern instanceof ChoicePattern)) continue;
            bl = false;
            break;
        }
        n = identityHashMap.get(this) == Boolean.TRUE ? 1 : 0;
        bl = n != 0 || bl;
        identityHashMap.put(this, bl ? Boolean.TRUE : Boolean.FALSE);
        return ContentType.EMPTY;
    }

    @Override
    protected int attributesSeparatedFromElements() {
        return 1;
    }

    @Override
    protected Pattern withoutAttributes(Builder builder) {
        return EmptyPattern.INSTANCE;
    }

    @Override
    protected int getComplexity(boolean bl) {
        int n = 100;
        if (this.nameClass instanceof SingleNameClass) {
            Name name = ((SingleNameClass)this.nameClass).name;
            n += name.localPart.length();
            if (name.namespace != Namespace.NONE) {
                n += 20;
            }
        } else {
            n += 1000;
        }
        return n;
    }

    @Override
    protected boolean expand(int n, ItemList itemList) {
        if ((n & 1) != 0) {
            itemList.add(this);
        }
        return true;
    }

    @Override
    public DataType getAttributeDataType() {
        return this.dataType;
    }

    @Override
    public Data getAttributeFixedValue() {
        return this.fixedValue;
    }

    @Override
    public Data getAttributeDefaultValue() {
        return this.defaultValue;
    }
}

