/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.resolve;

import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLResolver;
import com.xmlmind.util.XMLText;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.xml.sax.InputSource;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.XMLResolverConfiguration;

public final class XMLResolverImpl
implements XMLResolver {
    private final CatalogManager catalogManager;
    private final boolean verbose;

    public XMLResolverImpl() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLResolverImpl(URL[] uRLArray) {
        String string = System.clearProperty("xml.catalog.files");
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (uRLArray == null) {
            if (string != null) {
                uRLArray = XMLResolverImpl.parseCatalogFiles(string);
            }
            if (uRLArray == null) {
                uRLArray = URLUtil.EMPTY_LIST;
            }
        }
        String[] stringArray = new String[]{"xml.catalog.classpathCatalogs", "false", "xml.catalog.maskJarUris", "false", "xml.catalog.uriForSystem", "true"};
        for (int i = 0; i < stringArray.length; i += 2) {
            System.setProperty(stringArray[i], stringArray[i + 1]);
        }
        XMLResolverConfiguration xMLResolverConfiguration = new XMLResolverConfiguration();
        String string2 = xMLResolverConfiguration.getFeature(ResolverFeature.DEFAULT_LOGGER_LOG_LEVEL);
        this.verbose = "info".equals(string2) || "debug".equals(string2);
        for (URL uRL : uRLArray) {
            InputStream inputStream = null;
            try {
                inputStream = URLUtil.openStreamNoCache(uRL);
                InputSource inputSource = new InputSource(inputStream);
                URI uRI = uRL.toURI();
                inputSource.setSystemId(uRI.toASCIIString());
                xMLResolverConfiguration.addCatalog(uRI, inputSource);
                this.verbose("added XML catalog " + String.valueOf(uRI));
            }
            catch (Exception exception) {
                System.err.println("Cannot load XML catalog '" + String.valueOf(uRL) + "':\n" + ThrowableUtil.reason(exception));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.catalogManager = xMLResolverConfiguration.getFeature(ResolverFeature.CATALOG_MANAGER);
        if (string != null) {
            System.setProperty("xml.catalog.files", string);
        }
    }

    private void verbose(String string) {
        if (this.verbose) {
            System.err.println("verbose: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRewriteURIEntry(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version='1.0' ?>\n");
        stringBuilder.append("<catalog");
        stringBuilder.append(" xmlns='urn:oasis:names:tc:entity:xmlns:xml:catalog'");
        stringBuilder.append(" prefer='public'>\n");
        stringBuilder.append("<rewriteURI uriStartString='");
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("' rewritePrefix='");
        XMLText.escapeXML(string2, stringBuilder);
        stringBuilder.append("' />\n");
        stringBuilder.append("</catalog>\n");
        InputSource inputSource = new InputSource(new StringReader(stringBuilder.toString()));
        stringBuilder.setLength(0);
        String string3 = System.getProperty("java.io.tmpdir");
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        stringBuilder.append(File.separatorChar);
        stringBuilder.append("catalog_");
        stringBuilder.append(Integer.toString(System.identityHashCode(string), 36));
        stringBuilder.append(".xml");
        URI uRI = new File(stringBuilder.toString()).toURI();
        inputSource.setSystemId(uRI.toASCIIString());
        CatalogManager catalogManager = this.catalogManager;
        synchronized (catalogManager) {
            ((XMLResolverConfiguration)this.catalogManager.getResolverConfiguration()).addCatalog(uRI, inputSource);
        }
        this.verbose("added XML catalog " + String.valueOf(uRI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResolvedEntity(String string, String string2) {
        String string3 = null;
        CatalogManager catalogManager = this.catalogManager;
        synchronized (catalogManager) {
            URI uRI = this.catalogManager.lookupPublic(string2, string);
            if (uRI != null) {
                string3 = uRI.toASCIIString();
            } else if (string2 != null) {
                string3 = XMLResolverImpl.lookupURI(this.catalogManager, string2);
            }
        }
        this.verbose("publicId='" + string + "', systemId='" + string2 + "' resolved to " + string3);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolveURI(String string) {
        String string2 = null;
        CatalogManager catalogManager = this.catalogManager;
        synchronized (catalogManager) {
            string2 = XMLResolverImpl.lookupURI(this.catalogManager, string);
        }
        this.verbose("URI " + string + " resolved to " + string2);
        return string2;
    }

    private static String lookupURI(CatalogManager catalogManager, String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf(35);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        } else {
            string3 = string;
            string2 = null;
        }
        Object object = null;
        URI uRI = catalogManager.lookupURI(string3);
        if (uRI != null) {
            object = uRI.toASCIIString();
        }
        if (object != null && string2 != null) {
            object = (String)object + string2;
        }
        return object;
    }

    static URL[] parseCatalogFiles(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            return URLUtil.EMPTY_LIST;
        }
        String[] stringArray = StringUtil.split(string, ';');
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string2 : stringArray) {
            URL uRL;
            if ((string2 = string2.trim()).length() == 0 || (uRL = URLUtil.urlOrFile(string2)) == null) continue;
            arrayList.add(uRL);
        }
        return arrayList.toArray(URLUtil.EMPTY_LIST);
    }

    static String joinCatalogFiles(URL[] uRLArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = uRLArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(uRLArray[i]);
        }
        return stringBuilder.toString();
    }
}

