/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.name;

import com.xmlmind.util.XMLText;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.IdentityHashMap;

public final class Namespace
implements Serializable,
Comparable<Namespace> {
    public static final Namespace NONE;
    public static final Namespace XML;
    public static final Namespace XMLNS;
    public static final Namespace XHTML;
    public static final Namespace XSLT;
    public static final Namespace FO;
    public static final Namespace XSD;
    public static final Namespace XSI;
    public static final Namespace XI;
    public static final Namespace XI_LOCAL_ATTRIBUTES;
    public static final Namespace SVG;
    public static final Namespace MATHML;
    public static final Namespace XLINK;
    public static final Namespace DOCBOOK;
    public static final Namespace DOCBOOK_TRANSCLUSION;
    public static final Namespace RNG;
    public static final Namespace SCHEMATRON;
    public static final Namespace ANY_NAMESPACE;
    public static final Namespace CONFIGURATION;
    private static final HashMap<String, Namespace> namespaces;
    private static final IdentityHashMap<Namespace, String> usualPrefixes;
    public final String uri;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null uri");
        }
        string = string.trim();
        HashMap<String, Namespace> hashMap = namespaces;
        synchronized (hashMap) {
            Namespace namespace = namespaces.get(string);
            if (namespace == null) {
                namespace = new Namespace(string);
                namespaces.put(string, namespace);
            }
            return namespace;
        }
    }

    private Namespace(String string) {
        this.uri = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace get(String string, String string2) {
        HashMap<String, Namespace> hashMap = namespaces;
        synchronized (hashMap) {
            Namespace namespace = Namespace.get(string);
            if (string2 != null && usualPrefixes.get(namespace) == null && namespace != NONE && namespace != XML && namespace != ANY_NAMESPACE && XMLText.isNCName(string2) && !string2.regionMatches(true, 0, "xml", 0, 3)) {
                usualPrefixes.put(namespace, string2);
            }
            return namespace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUsualPrefix() {
        HashMap<String, Namespace> hashMap = namespaces;
        synchronized (hashMap) {
            return usualPrefixes.get(this);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Namespace)) {
            return false;
        }
        return this.uri.equals(((Namespace)object).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri;
    }

    @Override
    public int compareTo(Namespace namespace) {
        return this.uri.compareTo(namespace.uri);
    }

    private Object readResolve() throws ObjectStreamException {
        return Namespace.get(this.uri);
    }

    static {
        namespaces = new HashMap();
        usualPrefixes = new IdentityHashMap();
        NONE = new Namespace("");
        namespaces.put(Namespace.NONE.uri, NONE);
        XML = new Namespace("http://www.w3.org/XML/1998/namespace");
        namespaces.put(Namespace.XML.uri, XML);
        XMLNS = new Namespace("http://www.w3.org/2000/xmlns/");
        namespaces.put(Namespace.XMLNS.uri, XMLNS);
        XHTML = new Namespace("http://www.w3.org/1999/xhtml");
        namespaces.put(Namespace.XHTML.uri, XHTML);
        usualPrefixes.put(XHTML, "html");
        XSLT = new Namespace("http://www.w3.org/1999/XSL/Transform");
        namespaces.put(Namespace.XSLT.uri, XSLT);
        usualPrefixes.put(XSLT, "xsl");
        FO = new Namespace("http://www.w3.org/1999/XSL/Format");
        namespaces.put(Namespace.FO.uri, FO);
        usualPrefixes.put(FO, "fo");
        XSD = new Namespace("http://www.w3.org/2001/XMLSchema");
        namespaces.put(Namespace.XSD.uri, XSD);
        usualPrefixes.put(XSD, "xsd");
        XSI = new Namespace("http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put(Namespace.XSI.uri, XSI);
        usualPrefixes.put(XSI, "xsi");
        XI = new Namespace("http://www.w3.org/2001/XInclude");
        namespaces.put(Namespace.XI.uri, XI);
        usualPrefixes.put(XI, "xi");
        XI_LOCAL_ATTRIBUTES = new Namespace("http://www.w3.org/2001/XInclude/local-attributes");
        namespaces.put(Namespace.XI_LOCAL_ATTRIBUTES.uri, XI_LOCAL_ATTRIBUTES);
        usualPrefixes.put(XI_LOCAL_ATTRIBUTES, "xila");
        SVG = new Namespace("http://www.w3.org/2000/svg");
        namespaces.put(Namespace.SVG.uri, SVG);
        usualPrefixes.put(SVG, "svg");
        MATHML = new Namespace("http://www.w3.org/1998/Math/MathML");
        namespaces.put(Namespace.MATHML.uri, MATHML);
        usualPrefixes.put(MATHML, "mml");
        XLINK = new Namespace("http://www.w3.org/1999/xlink");
        namespaces.put(Namespace.XLINK.uri, XLINK);
        usualPrefixes.put(XLINK, "xlink");
        DOCBOOK = new Namespace("http://docbook.org/ns/docbook");
        namespaces.put(Namespace.DOCBOOK.uri, DOCBOOK);
        usualPrefixes.put(DOCBOOK, "db");
        DOCBOOK_TRANSCLUSION = new Namespace("http://docbook.org/ns/transclusion");
        namespaces.put(Namespace.DOCBOOK_TRANSCLUSION.uri, DOCBOOK_TRANSCLUSION);
        usualPrefixes.put(DOCBOOK_TRANSCLUSION, "trans");
        RNG = new Namespace("http://relaxng.org/ns/structure/1.0");
        namespaces.put(Namespace.RNG.uri, RNG);
        usualPrefixes.put(RNG, "rng");
        SCHEMATRON = new Namespace("http://purl.oclc.org/dsdl/schematron");
        namespaces.put(Namespace.SCHEMATRON.uri, SCHEMATRON);
        usualPrefixes.put(SCHEMATRON, "sch");
        CONFIGURATION = new Namespace("http://www.xmlmind.com/xmleditor/schema/configuration");
        namespaces.put(Namespace.CONFIGURATION.uri, CONFIGURATION);
        usualPrefixes.put(CONFIGURATION, "cfg");
        ANY_NAMESPACE = new Namespace("*");
        namespaces.put(Namespace.ANY_NAMESPACE.uri, ANY_NAMESPACE);
    }
}

