/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.Console;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.doc.InclusionException;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.load.LoadDocument;
import com.xmlmind.xml.load.LoadError;
import com.xmlmind.xml.load.LoadErrorImpl;
import com.xmlmind.xml.load.Msg;
import com.xmlmind.xml.load.SpaceNormalizer;
import com.xmlmind.xml.load.XInclusion;
import com.xmlmind.xml.load.XInclusionContext;
import com.xmlmind.xml.load.XInclusionScheme;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.DocumentTypeUtil;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.IdEntry;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import org.xml.sax.SAXParseException;

public final class XIncluder
implements XInclusionContext {
    public final XInclusionScheme[] xInclusionSchemes;
    private Console console;
    private List<LoadError> loadErrors;
    private List<LoadError> loadWarnings;
    private boolean updating;
    private HashMap<URL, Doc> urlToDoc;
    private ArrayList<Doc> docList;
    private int processedDocCount;
    private int inclCounter;
    private SpaceNormalizer spaceNormalizer;
    private Node[] directive = new Node[2];
    private XInclusion[] detected = new XInclusion[1];
    private static final int MAX_ITERATIONS = 100;
    private static final Name INCL_ID_PROPERTY = Name.get(Constants.PROPERTY_NAMESPACE, "inclId");
    private static final Name[] PROCESS_PROPERTIES = new Name[]{INCL_ID_PROPERTY};
    private static final Name[] INCLUSION_PROPERTIES = new Name[]{Constants.INCLUSION_PROPERTY, Constants.READ_ONLY_PROPERTY};

    public XIncluder(XInclusionScheme[] xInclusionSchemeArray) {
        this.xInclusionSchemes = xInclusionSchemeArray;
    }

    public boolean process(Tree tree, List<Node[]> list, Console console, List<LoadError> list2, List<LoadError> list3) {
        Incl incl;
        int n;
        Tree tree2;
        this.console = console;
        this.loadErrors = list2;
        this.loadWarnings = list3;
        this.updating = false;
        this.urlToDoc = new HashMap();
        this.docList = new ArrayList();
        Document document = tree.getDocument();
        if (document == null) {
            throw new IllegalArgumentException("tree not attached to the document tree");
        }
        URL uRL = document.getSourceURL();
        if (uRL == null) {
            throw new IllegalArgumentException("tree's document has no source URL");
        }
        Doc doc = new Doc(document, false);
        this.urlToDoc.put(uRL, doc);
        this.docList.add(doc);
        this.processedDocCount = 1;
        document.setNotifyDisabled(true);
        if (tree.getType() == Node.Type.DOCUMENT) {
            tree2 = tree;
            this.collectIncludes(InclType.INCLUDED, null, tree, doc);
        } else {
            tree2 = tree.getParent();
            this.collectIncludes(InclType.INCLUDED, null, tree, tree, doc);
        }
        this.process();
        ArrayList<Incl> arrayList = doc.inclList;
        int n2 = arrayList.size();
        boolean bl = false;
        if (n2 > 0) {
            n2 = XIncluder.findReplacementNodes(tree2, arrayList);
            for (n = 0; n < n2; ++n) {
                incl = arrayList.get(n);
                incl.replacementNodes = this.normalizeSpace(incl.replacementNodes, document);
                XIncluder.replaceNodes(incl.replacementNodes, incl.replacedNodes);
            }
        }
        document.setNotifyDisabled(false);
        if (n2 > 0) {
            document.beginEdit();
            for (n = 0; n < n2; ++n) {
                incl = arrayList.get(n);
                XIncluder.replaceNodes(incl.replacedNodes, incl.replacementNodes);
                if (list == null) continue;
                list.add(incl.replacedNodes);
                list.add(incl.replacementNodes);
            }
            document.endEdit();
            bl = true;
        }
        return bl;
    }

    private Node[] normalizeSpace(Node[] nodeArray, Document document) {
        DocumentType documentType = (DocumentType)document.getProperty(Constants.DOCUMENT_TYPE_PROPERTY);
        if (this.spaceNormalizer == null || !this.spaceNormalizer.getDocumentType().equals(documentType)) {
            this.spaceNormalizer = documentType != null && !(documentType instanceof AnyDocumentType) ? new SpaceNormalizer(documentType) : null;
        }
        if (this.spaceNormalizer != null) {
            ElementType elementType;
            boolean bl = false;
            Element element = null;
            int n = nodeArray.length;
            if (n > 1 && (element = nodeArray[0].getParentElement()) != null && (elementType = documentType.getElementType(element)) != null) {
                bl = elementType.getElementContentType() == ContentType.ELEMENT_ONLY;
            }
            int n2 = n;
            block4: for (int i = 0; i < n; ++i) {
                Node node = nodeArray[i];
                switch (node.getType()) {
                    case TEXT: {
                        if (!bl || !((Text)node).isXMLSpace() || n2 <= 1) continue block4;
                        element.removeChild(node);
                        nodeArray[i] = null;
                        --n2;
                        continue block4;
                    }
                    case ELEMENT: {
                        this.spaceNormalizer.processSpace((Element)node);
                    }
                }
            }
            if (n2 != n) {
                Node[] nodeArray2 = new Node[n2];
                n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Node node = nodeArray[i];
                    if (node == null) continue;
                    nodeArray2[n2++] = node;
                }
                nodeArray = nodeArray2;
            }
        }
        return nodeArray;
    }

    private static void replaceNodes(Node[] nodeArray, Node[] nodeArray2) {
        int n;
        Tree tree = nodeArray[0].getParent();
        int n2 = nodeArray.length;
        Node node = nodeArray[n2 - 1].getNextSibling();
        for (n = 0; n < n2; ++n) {
            tree.removeChild(nodeArray[n]);
        }
        for (n = 0; n < nodeArray2.length; ++n) {
            tree.insertChild(node, nodeArray2[n]);
        }
    }

    private static int findReplacementNodes(Tree tree, ArrayList<Incl> arrayList) {
        Incl incl;
        int n;
        int n2 = arrayList.size();
        IdentityHashMap<Inclusion, Incl> identityHashMap = new IdentityHashMap<Inclusion, Incl>(n2);
        for (n = 0; n < n2; ++n) {
            incl = arrayList.get(n);
            identityHashMap.put(incl.xInclusion, incl);
        }
        XIncluder.doFindReplacementNodes(tree, false, identityHashMap);
        n = n2 - 1;
        n2 = 0;
        while (n >= 0) {
            incl = arrayList.get(n);
            if (incl.replacementNodes == null) {
                arrayList.remove(n);
            } else {
                ++n2;
            }
            --n;
        }
        return n2;
    }

    private static void doFindReplacementNodes(Tree tree, boolean bl, IdentityHashMap<Inclusion, Incl> identityHashMap) {
        Node node = tree.getFirstChild();
        while (node != null) {
            Node node2;
            Inclusion inclusion = node.getInclusion();
            if (inclusion != null) {
                if (inclusion instanceof XInclusion) {
                    Node node3 = node;
                    Node node4 = node;
                    for (node2 = node.getNextSibling(); node2 != null && node2.getInclusion() == inclusion; node2 = node2.getNextSibling()) {
                        node4 = node2;
                    }
                    Incl incl = identityHashMap.get(inclusion);
                    if (incl != null) {
                        if (bl) {
                            XIncluder.unsetInclusionProperties(node3, node4);
                            incl.replacementNodes = null;
                        } else {
                            incl.replacementNodes = XIncluder.copyNodeRange(node3, node4);
                        }
                    }
                } else if (node.getType() == Node.Type.ELEMENT) {
                    XIncluder.doFindReplacementNodes((Element)node, true, identityHashMap);
                }
            } else if (node.getType() == Node.Type.ELEMENT) {
                XIncluder.doFindReplacementNodes((Element)node, bl, identityHashMap);
            }
            node = node2;
        }
    }

    private static void unsetInclusionProperties(Node node, Node node2) {
        for (Node node3 = node; node3 != null; node3 = node3.getNextSibling()) {
            node3.removeProperty(Constants.INCLUSION_PROPERTY);
            node3.removeProperty(Constants.READ_ONLY_PROPERTY);
            if (node3 == node2) break;
        }
    }

    private static Node[] copyNodeRange(Node node, Node node2) {
        Node node3;
        int n = 0;
        for (node3 = node; node3 != node2; node3 = node3.getNextSibling()) {
            ++n;
        }
        Node[] nodeArray = new Node[++n];
        n = 0;
        for (node3 = node; node3 != node2; node3 = node3.getNextSibling()) {
            nodeArray[n++] = node3;
        }
        nodeArray[n] = node2;
        return nodeArray;
    }

    public boolean update(Document[] documentArray, Console console, List<LoadError> list, List<LoadError> list2) {
        Object object;
        Object object2;
        int n;
        this.console = console;
        this.loadErrors = list;
        this.loadWarnings = list2;
        this.updating = true;
        this.urlToDoc = new HashMap();
        this.docList = new ArrayList();
        this.processedDocCount = 0;
        for (n = 0; n < documentArray.length; ++n) {
            Document document = documentArray[n];
            object2 = document.getSourceURL();
            if (object2 == null) {
                throw new IllegalArgumentException("documents[" + n + "] has no source URL");
            }
            object = new Doc(document, false);
            this.urlToDoc.put((URL)object2, (Doc)object);
            this.docList.add((Doc)object);
            ++this.processedDocCount;
            document.setNotifyDisabled(true);
            this.collectUpdates(document.getRootElement(), (Doc)object);
        }
        this.process();
        n = 0;
        for (int i = 0; i < this.processedDocCount; ++i) {
            Incl incl;
            int n2;
            object2 = this.docList.get(i);
            object = ((Doc)object2).document;
            ArrayList<Incl> arrayList = ((Doc)object2).inclList;
            int n3 = arrayList.size();
            if (n3 > 0) {
                n3 = XIncluder.findReplacementNodes(((Doc)object2).document, arrayList);
                for (n2 = 0; n2 < n3; ++n2) {
                    incl = arrayList.get(n2);
                    incl.replacementNodes = this.normalizeSpace(incl.replacementNodes, (Document)object);
                    XIncluder.replaceNodes(incl.replacementNodes, incl.replacedNodes);
                }
            }
            ((Document)object).setNotifyDisabled(false);
            if (n3 <= 0) continue;
            ((Document)object).beginEdit();
            for (n2 = 0; n2 < n3; ++n2) {
                incl = arrayList.get(n2);
                Node[] nodeArray = incl.replacedNodes;
                Tree tree = nodeArray[0].getParent();
                tree.updateInclusion(nodeArray[0], nodeArray[nodeArray.length - 1], incl.replacementNodes);
            }
            ((Document)object).endEdit();
            n = 1;
        }
        return n != 0;
    }

    private boolean collectIncludes(InclType inclType, int[] nArray, Tree tree, Doc doc) {
        Node node = tree.getFirstChild();
        if (node == null) {
            return true;
        }
        Node node2 = tree.getLastChild();
        return this.collectIncludes(inclType, nArray, node, node2, doc);
    }

    private boolean collectIncludes(InclType inclType, int[] nArray, Node node, Node node2, Doc doc) {
        Node node3 = node;
        while (node3 != null) {
            Node node4 = XIncluder.nextSibling(node3, node2);
            this.directive[0] = null;
            boolean bl = true;
            switch (node3.getType()) {
                case PROCESSING_INSTRUCTION: {
                    this.directive[0] = this.directive[1] = node3;
                    bl = false;
                    break;
                }
                case ELEMENT: {
                    this.directive[0] = this.directive[1] = node3;
                }
            }
            if (this.directive[0] != null) {
                int n;
                XInclusion xInclusion = null;
                String string = null;
                for (n = 0; n < this.xInclusionSchemes.length; ++n) {
                    try {
                        this.detected[0] = null;
                        if (!this.xInclusionSchemes[n].detectXInclusion(this.directive, bl, this.detected)) continue;
                        xInclusion = this.detected[0];
                        this.detected[0] = null;
                    }
                    catch (InclusionException inclusionException) {
                        string = Msg.msg("XI.cannotParseDirective", ThrowableUtil.reason(inclusionException));
                    }
                    break;
                }
                if (xInclusion == null && string == null) {
                    if (bl && !this.collectIncludes(inclType, nArray, (Element)this.directive[0], doc)) {
                        return false;
                    }
                } else if (string != null) {
                    this.addError(this.directive[0], string);
                } else {
                    n = 0;
                    boolean bl2 = false;
                    Node node5 = this.directive[0];
                    while (node5 != null) {
                        ++n;
                        if (node5 == this.directive[1]) {
                            bl2 = true;
                            break;
                        }
                        node5 = XIncluder.nextSibling(node5, node2);
                    }
                    if (n == 0 || !bl2) {
                        this.addError(this.directive[0], Msg.msg("XI.inconsistentDetectedDirective"));
                    } else {
                        int[] nArray2 = this.newInclId(nArray, this.directive[0]);
                        if (nArray2 == null) {
                            return false;
                        }
                        Node[] nodeArray = new Node[n];
                        nodeArray[0] = node5 = this.directive[0];
                        for (int i = 1; i < n; ++i) {
                            nodeArray[i] = node5 = XIncluder.nextSibling(node5, node2);
                        }
                        Incl incl = new Incl(inclType, nArray2, xInclusion, nodeArray);
                        doc.processList.add(incl);
                        node4 = XIncluder.nextSibling(this.directive[1], node2);
                    }
                }
            }
            node3 = node4;
        }
        return true;
    }

    private static Node nextSibling(Node node, Node node2) {
        if (node == node2) {
            return null;
        }
        return node.getNextSibling();
    }

    private int[] newInclId(int[] nArray, Node node) {
        int n;
        int n2;
        Integer n3 = (Integer)node.getProperty(INCL_ID_PROPERTY);
        if (n3 == null) {
            n2 = this.inclCounter++;
            node.putProperty(INCL_ID_PROPERTY, n2);
        } else {
            n2 = n3;
            if (nArray != null) {
                for (n = nArray.length - 1; n >= 0; --n) {
                    if (nArray[n] != n2) continue;
                    return null;
                }
            }
        }
        if (nArray == null) {
            return new int[]{n2};
        }
        n = nArray.length;
        int[] nArray2 = new int[n + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        nArray2[n] = n2;
        return nArray2;
    }

    private void addError(Node node, String string) {
        if (this.loadErrors != null) {
            this.loadErrors.add(new LoadErrorImpl(LoadError.Type.INCLUSION, node, string));
        }
    }

    private void collectUpdates(Element element, Doc doc) {
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            Inclusion inclusion = node.getInclusion();
            if (inclusion == null) {
                if (node.getType() == Node.Type.ELEMENT) {
                    this.collectUpdates((Element)node, doc);
                }
            } else {
                XInclusion xInclusion;
                Node node3;
                node2 = null;
                int n = 0;
                for (node3 = node; node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getInclusion() != inclusion) {
                        node2 = node3;
                        break;
                    }
                    ++n;
                }
                if (inclusion instanceof XInclusion && (xInclusion = (XInclusion)inclusion).isMarkedForUpdate()) {
                    xInclusion.setMarkedForUpdate(false);
                    if (this.isProcessedXInclusion(xInclusion)) {
                        Node[] nodeArray = new Node[n];
                        nodeArray[0] = node3 = node;
                        for (int i = 1; i < n; ++i) {
                            nodeArray[i] = node3 = node3.getNextSibling();
                        }
                        Incl incl = new Incl(InclType.UPDATED, new int[]{this.inclCounter++}, xInclusion, nodeArray);
                        doc.processList.add(incl);
                    }
                }
            }
            node = node2;
        }
    }

    private boolean isProcessedXInclusion(XInclusion xInclusion) {
        String string = xInclusion.getSchemeName();
        int n = this.xInclusionSchemes.length;
        for (int i = 0; i < n; ++i) {
            if (!this.xInclusionSchemes[i].getSchemeName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void process() {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        boolean bl = false;
        for (n2 = 0; n2 < 100; ++n2) {
            int n3;
            this.debug(Msg.msg("XI.iteration", n2));
            n = this.processedDocCount;
            int n4 = this.docList.size();
            int n5 = 0;
            for (n3 = 0; n3 < this.processedDocCount; ++n3) {
                Doc doc = this.docList.get(n3);
                if (doc.processList.size() > 0) {
                    this.debug(Msg.msg("XI.processingDoc", doc.document.getSourceURL(), doc.processList.size()));
                    if (this.process(doc, bl)) {
                        ++n5;
                    }
                    this.debug(Msg.msg("XI.docProcessed", doc.document.getSourceURL(), doc.processList.size()));
                }
                if (doc.processList.size() != 0) continue;
                --n;
            }
            if (n == 0) break;
            n3 = this.docList.size();
            for (int i = this.processedDocCount; i < n3; ++i) {
                Doc doc = this.docList.get(i);
                if (doc.processList.size() <= 0) continue;
                this.debug(Msg.msg("XI.processingDoc", doc.document.getSourceURL(), doc.processList.size()));
                if (this.process(doc, bl)) {
                    ++n5;
                }
                this.debug(Msg.msg("XI.docProcessed", doc.document.getSourceURL(), doc.processList.size()));
            }
            if (bl) break;
            if (this.docList.size() > n4) {
                ++n5;
            }
            if (n5 != 0) continue;
            bl = true;
        }
        for (n = 0; n < this.processedDocCount; ++n) {
            Doc doc = this.docList.get(n);
            Document document = doc.document;
            document.removeProperties(PROCESS_PROPERTIES, true);
            if (doc.processList.size() <= 0) continue;
            this.addError(document, Msg.msg("XI.notFullyProcessed", 1 + n2));
        }
        this.debug(Msg.msg("XI.allDocsProcessed", 1 + n2, System.currentTimeMillis() - l));
    }

    private boolean process(Doc doc, boolean bl) {
        Node[] nodeArray;
        int n = doc.processList.size();
        Incl[] inclArray = new Incl[n];
        doc.processList.toArray(inclArray);
        doc.processList.clear();
        int n2 = n;
        int n3 = 0;
        for (Incl incl : inclArray) {
            boolean bl2;
            nodeArray = incl.replacedNodes;
            boolean bl3 = bl2 = incl.type == InclType.UPDATED;
            if (bl2 && incl.directiveNodes != null) {
                nodeArray = incl.directiveNodes;
            }
            Node[] nodeArray2 = null;
            try {
                nodeArray2 = incl.xInclusion.include(nodeArray[0], nodeArray[nodeArray.length - 1], bl2, this);
                if (nodeArray2 == null || nodeArray2.length == 0) {
                    this.addProcessError(incl, Msg.msg("XI.noReplacementNodes"));
                    nodeArray2 = null;
                } else {
                    for (Node node : nodeArray2) {
                        if (node.getProperty(Constants.SOURCE_URL_PROPERTY) != null) continue;
                        this.addProcessError(incl, Msg.msg("XI.missingSourceURL"));
                        nodeArray2 = null;
                        break;
                    }
                    if (nodeArray2 != null && nodeArray[0].getParentElement() == null && !XIncluder.isRootReplacement(nodeArray2)) {
                        this.addProcessError(incl, Msg.msg("XI.notAReplacementForRoot"));
                        nodeArray2 = null;
                    }
                }
            }
            catch (InclusionException inclusionException) {
                if (bl) {
                    this.addProcessError(incl, Msg.msg("XI.cannotFetchIncludedNodes", ThrowableUtil.reason(inclusionException)));
                }
                doc.processList.add(incl);
                --n2;
                ++n3;
                nodeArray2 = null;
            }
            if (nodeArray2 != null) {
                for (Node node : nodeArray2) {
                    node.removeProperties(INCLUSION_PROPERTIES, true);
                    PrefixEntry[] prefixEntryArray = (PrefixEntry[])node.removeProperty(Constants.DECLARED_PREFIXES_PROPERTY);
                    if (prefixEntryArray == null || this.addPrefixPreferences(doc.document, prefixEntryArray)) continue;
                    node.putProperty(Constants.DECLARED_PREFIXES_PROPERTY, prefixEntryArray);
                }
            }
            incl.replacementNodes = nodeArray2;
        }
        for (Incl incl : inclArray) {
            nodeArray = incl.replacementNodes;
            if (nodeArray == null) continue;
            incl.replacementNodes = null;
            Node[] nodeArray3 = incl.replacedNodes;
            if (incl.type == InclType.UPDATED && incl.directiveNodes != null) {
                nodeArray3 = incl.directiveNodes;
            }
            XIncluder.substituteNodes(nodeArray3, nodeArray);
            if (!this.collectIncludes(InclType.NESTED, incl.id, nodeArray[0], nodeArray[nodeArray.length - 1], doc)) {
                XIncluder.replaceNodes(nodeArray, nodeArray3);
                this.addProcessError(incl, Msg.msg("XI.inclusionLoop"));
                continue;
            }
            doc.ids = null;
            if (incl.type == InclType.NESTED) continue;
            doc.inclList.add(incl);
            XIncluder.setInclusionProperties(nodeArray, incl.xInclusion);
        }
        int n4 = doc.processList.size() - n3;
        return n4 != 0 || n2 != 0;
    }

    private void addProcessError(Incl incl, String string) {
        Node node = incl.replacedNodes[0];
        if (incl.type == InclType.UPDATED) {
            if (incl.directiveNodes != null) {
                XIncluder.replaceNodes(incl.directiveNodes, incl.replacedNodes);
            }
            node = node.getParent();
        }
        if (this.loadErrors != null) {
            this.loadErrors.add(new LoadErrorImpl(LoadError.Type.INCLUSION, node, string));
        }
    }

    private static boolean isRootReplacement(Node[] nodeArray) {
        int n = 0;
        block5: for (Node node : nodeArray) {
            switch (node.getType()) {
                case PROCESSING_INSTRUCTION: 
                case COMMENT: {
                    continue block5;
                }
                case TEXT: {
                    if (((Text)node).isXMLSpace()) continue block5;
                    return false;
                }
                case ELEMENT: {
                    ++n;
                }
            }
        }
        return n == 1;
    }

    private boolean addPrefixPreferences(Document document, PrefixEntry[] prefixEntryArray) {
        Object object = document.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY);
        if (object == null || !(object instanceof PrefixPreferences)) {
            this.debug(Msg.msg("XI.cannotAddPrefixPrefs", PrefixEntry.toString(prefixEntryArray), document.getSourceURL()));
            return false;
        }
        PrefixPreferences prefixPreferences = (PrefixPreferences)object;
        prefixPreferences.add(prefixEntryArray, false);
        return true;
    }

    private static void substituteNodes(Node[] nodeArray, Node[] nodeArray2) {
        Inclusion inclusion = nodeArray[0].getInclusion();
        XIncluder.replaceNodes(nodeArray, nodeArray2);
        if (inclusion != null) {
            XIncluder.setInclusionProperties(nodeArray2, inclusion);
        }
    }

    private static void setInclusionProperties(Node[] nodeArray, Inclusion inclusion) {
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            node.putProperty(Constants.INCLUSION_PROPERTY, inclusion);
            node.putProperty(Constants.READ_ONLY_PROPERTY, Boolean.TRUE);
        }
    }

    @Override
    public Document getDocument(URL uRL) throws InclusionException {
        Doc doc = this.urlToDoc.get(uRL);
        if (doc == null) {
            Document document;
            long l = System.currentTimeMillis();
            String string = URLUtil.toLabel(uRL);
            this.verbose(Msg.msg("XI.cachingDocument", string));
            try {
                document = LoadDocument.load(uRL, 5122, null, null, null);
            }
            catch (SAXParseException sAXParseException) {
                throw new InclusionException(DocumentLoader.format(sAXParseException));
            }
            catch (Exception exception) {
                throw new InclusionException(ThrowableUtil.reason(exception));
            }
            DocumentType documentType = (DocumentType)document.getProperty(Constants.DOCUMENT_TYPE_PROPERTY);
            if ((documentType == null || documentType instanceof AnyDocumentType) && ((documentType = (DocumentType)this.docList.get((int)0).document.getProperty(Constants.DOCUMENT_TYPE_PROPERTY)) == null || documentType instanceof AnyDocumentType)) {
                documentType = AnyDocumentType.INSTANCE;
            }
            document.putProperty(Constants.DOCUMENT_TYPE_PROPERTY, documentType);
            doc = new Doc(document, true);
            this.urlToDoc.put(uRL, doc);
            this.docList.add(doc);
            this.verbose(Msg.msg("XI.documentCached", string, System.currentTimeMillis() - l));
            this.collectIncludes(InclType.INCLUDED, null, document.getRootElement(), doc);
        }
        return doc.document;
    }

    private void verbose(String string) {
        if (this.console != null) {
            this.console.showMessage("XIncluder: " + string, Console.MessageType.VERBOSE);
        }
    }

    private void debug(String string) {
        if (this.console != null) {
            this.console.showMessage("XIncluder: " + string, Console.MessageType.DEBUG);
        }
    }

    @Override
    public Element findElementById(Document document, String string) {
        URL uRL = document.getSourceURL();
        if (uRL == null) {
            return null;
        }
        Doc doc = this.urlToDoc.get(uRL);
        if (doc == null) {
            return null;
        }
        return doc.findElementById(string);
    }

    private static final class Doc {
        public final Document document;
        public final boolean isWorkingCopy;
        public HashMap<String, IdEntry> ids;
        public ArrayList<Incl> inclList;
        public ArrayList<Incl> processList;

        public Doc(Document document, boolean bl) {
            this.document = document;
            this.isWorkingCopy = bl;
            this.ids = null;
            this.inclList = new ArrayList();
            this.processList = new ArrayList();
        }

        public Element findElementById(String string) {
            IdEntry idEntry;
            if (this.ids == null) {
                this.ids = new HashMap();
                DocumentTypeUtil.collectIds(DocumentTypeUtil.getDocumentType(this.document), this.document.getRootElement(), this.ids);
            }
            if ((idEntry = this.ids.get(string)) == null) {
                return null;
            }
            return idEntry.elements[0];
        }
    }

    private static final class Incl {
        public final InclType type;
        public final int[] id;
        public final XInclusion xInclusion;
        public final Node[] replacedNodes;
        public final Node[] directiveNodes;
        public Node[] replacementNodes;

        public Incl(InclType inclType, int[] nArray, XInclusion xInclusion, Node[] nodeArray) {
            this.type = inclType;
            this.id = nArray;
            this.xInclusion = xInclusion;
            this.replacedNodes = nodeArray;
            Node[] nodeArray2 = null;
            if (inclType == InclType.UPDATED) {
                nodeArray2 = xInclusion.uninclude(nodeArray[0], nodeArray[nodeArray.length - 1]);
                if (nodeArray2 != null && nodeArray2.length == 0) {
                    nodeArray2 = null;
                }
                if (nodeArray2 != null) {
                    XIncluder.replaceNodes(nodeArray, nodeArray2);
                }
            }
            this.directiveNodes = nodeArray2;
        }
    }

    private static enum InclType {
        INCLUDED,
        UPDATED,
        NESTED;

    }
}

