/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.TextNode;
import com.xmlmind.xml.load.SpaceProcessor;
import com.xmlmind.xml.validate.AttributeUtil;
import java.util.Stack;

public final class SpaceTrimmer
extends SpaceProcessor {
    private final Stack<Boolean> stack = new Stack();
    private static final SpaceTrimmer INSTANCE = new SpaceTrimmer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trimSpace(Element element) {
        SpaceTrimmer spaceTrimmer = INSTANCE;
        synchronized (spaceTrimmer) {
            INSTANCE.processSpace(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSpace(Element element) {
        Element element2 = element.getParentElement();
        Boolean bl = element2 == null ? Boolean.FALSE : (AttributeUtil.hasPreserveSpace(element2) ? Boolean.TRUE : Boolean.FALSE);
        this.stack.push(bl);
        try {
            this.doProcessSpace(element);
        }
        finally {
            while (!this.stack.empty()) {
                this.stack.pop();
            }
        }
    }

    @Override
    protected void doProcessSpace(Element element) {
        boolean bl;
        String string = AttributeUtil.getSpaceAttribute(element);
        if (string == null) {
            Boolean bl2 = this.stack.peek();
            this.stack.push(bl2);
            bl = bl2;
        } else if (string.trim().equals("preserve")) {
            this.stack.push(Boolean.TRUE);
            bl = true;
        } else {
            this.stack.push(Boolean.FALSE);
            bl = false;
        }
        if (!bl) {
            Node node;
            Node node2;
            boolean bl3 = false;
            block3: for (node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getType() != Node.Type.TEXT) continue;
                node = (Text)node2;
                int n = ((TextNode)node).getTextLength();
                if (n > 0) {
                    char[] cArray = ((TextNode)node).getTextChars();
                    block4: for (int i = 0; i < n; ++i) {
                        switch (cArray[i]) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                continue block4;
                            }
                            default: {
                                bl3 = false;
                                break block3;
                            }
                        }
                    }
                }
                bl3 = true;
            }
            if (bl3) {
                node2 = element.getFirstChild();
                while (node2 != null) {
                    node = node2.getNextSibling();
                    if (node2.getType() == Node.Type.TEXT) {
                        element.removeChild(node2);
                    }
                    node2 = node;
                }
            } else {
                for (node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getType() != Node.Type.TEXT) continue;
                    node = (Text)node2;
                    ((TextNode)node).setText(XMLText.compressWhiteSpace(((TextNode)node).getText()));
                }
            }
        }
        this.doProcessSpaceInDescendants(element);
        this.stack.pop();
    }
}

