/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.TextNode;
import com.xmlmind.xml.load.SpaceProcessor;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.validate.AnyAttributeType;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.AnyElementType;
import com.xmlmind.xml.validate.AttributeType;
import com.xmlmind.xml.validate.AttributeUtil;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.ContentTypeUtil;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.Item;
import com.xmlmind.xml.validate.LaxElementType;
import com.xmlmind.xml.validate.PreserveSpaceDefaultValue;
import com.xmlmind.xml.validate.Structure;
import com.xmlmind.xml.validate.TextItem;
import java.util.Iterator;
import java.util.Stack;

public final class SpaceNormalizer
extends SpaceProcessor {
    private DocumentType documentType;
    private final Stack<State> stack;
    private Structure structure = new Structure();
    private boolean[] guessed = new boolean[1];
    private static final Item[] SINGLE_TEXT_ITEM = new Item[]{TextItem.INSTANCE};

    public SpaceNormalizer(DocumentType documentType) {
        this.setDocumentType(documentType);
        this.stack = new Stack();
    }

    public void setDocumentType(DocumentType documentType) {
        if (documentType == null) {
            documentType = AnyDocumentType.INSTANCE;
        }
        this.documentType = documentType;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    @Override
    public void processSpace(Element element) {
        ElementType elementType = this.documentType.getElementType(element);
        if (elementType == null) {
            elementType = AnyElementType.INSTANCE;
        }
        this.processSpace(element, elementType, element.getParentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSpace(Element element, ElementType elementType, Element element2) {
        Object object;
        if (element2 == null || element.getParent() != element2) {
            object = this.topState(elementType, element2);
            this.stack.push((State)object);
        } else {
            object = this.documentType.getElementType(element2);
            if (object == null) {
                object = AnyElementType.INSTANCE;
            }
            State state = this.topState((ElementType)object, element2.getParentElement());
            this.doPushElement(element2, state);
        }
        try {
            this.doProcessSpace(element);
        }
        finally {
            while (!this.stack.empty()) {
                this.stack.pop();
            }
        }
    }

    private State topState(ElementType elementType, Element element) {
        String string;
        State state = new State();
        state.childElementTypes = new ElementType[]{elementType};
        state.hasPreserveSpace = element == null ? false : ((string = this.documentType.lookupElementAttribute(element, Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE)) == null ? false : string.trim().equals("preserve"));
        return state;
    }

    @Override
    protected void doProcessSpace(Element element) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        State state = this.pushElement(element);
        Iterator iterator = state.nameToAttrType.keys();
        while (iterator.hasNext()) {
            object4 = (Name)iterator.next();
            String string = element.getAttribute((Name)object4);
            object3 = state.nameToAttrType.get((Name)object4);
            object2 = object3.getAttributeDataType();
            object = object2.normalizeWhiteSpace(string);
            if (object == string || ((String)object).equals(string)) continue;
            element.putAttribute((Name)object4, (String)object);
        }
        state.nameToAttrType = null;
        object4 = state.getElementContentType(this.guessed);
        boolean bl = this.guessed[0];
        switch (1.$SwitchMap$com$xmlmind$xml$validate$ContentType[((Enum)object4).ordinal()]) {
            case 1: {
                if (state.hasPreserveSpace) break;
                object3 = null;
                for (object2 = element.getFirstChild(); object2 != null; object2 = ((Node)object2).getNextSibling()) {
                    if (((Node)object2).getType() != Node.Type.TEXT) continue;
                    if (object3 == null) {
                        object3 = (Text)object2;
                        continue;
                    }
                    object3 = null;
                    break;
                }
                if (object3 == null) break;
                object = ((TextNode)object3).getText();
                DataType dataType = state.elementType.getElementDataType();
                String string = dataType.normalizeWhiteSpace((String)object);
                if (string == object || string.equals(object)) break;
                ((TextNode)object3).setText(string);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                int n;
                if (state.hasPreserveSpace) break;
                for (object3 = element.getFirstChild(); object3 != null; object3 = ((Node)object3).getNextSibling()) {
                    String string;
                    if (((Node)object3).getType() != Node.Type.TEXT || (string = XMLText.compressWhiteSpace((String)(object = ((TextNode)(object2 = (Text)object3)).getText()))).equals(object)) continue;
                    ((TextNode)object2).setText(string);
                }
                object2 = (State)this.stack.get(this.stack.size() - 2);
                if (((State)object2).elementType != null && ((State)object2).getElementContentType() != ContentType.ELEMENT_ONLY) break;
                object3 = element.getFirstChild();
                if (object3 != null && ((Node)object3).getType() == Node.Type.TEXT && ((TextNode)(object = (Text)object3)).getTextLength() > 0 && ((TextNode)object).getTextChar(0) == ' ') {
                    ((TextNode)object).deleteText(0, 1);
                    if (((TextNode)object).getTextLength() == 0 && element.getContentChildCount() > 1) {
                        element.removeChild((Node)object);
                    }
                }
                if ((object3 = element.getLastChild()) == null || ((Node)object3).getType() != Node.Type.TEXT || (n = ((TextNode)(object = (Text)object3)).getTextLength() - 1) < 0 || ((TextNode)object).getTextChar(n) != ' ') break;
                ((TextNode)object).deleteText(n, 1);
                if (((TextNode)object).getTextLength() != 0 || element.getContentChildCount() <= 1) break;
                element.removeChild((Node)object);
                break;
            }
            case 5: 
            case 6: {
                Object object5;
                if (bl && state.hasPreserveSpace) break;
                boolean bl2 = false;
                block15: for (object2 = element.getFirstChild(); object2 != null; object2 = ((Node)object2).getNextSibling()) {
                    if (((Node)object2).getType() != Node.Type.TEXT) continue;
                    object = (Text)object2;
                    int n = ((TextNode)object).getTextLength();
                    if (n > 0) {
                        object5 = ((TextNode)object).getTextChars();
                        block16: for (int i = 0; i < n; ++i) {
                            switch (object5[i]) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    continue block16;
                                }
                                default: {
                                    bl2 = false;
                                    break block15;
                                }
                            }
                        }
                    }
                    bl2 = true;
                }
                if (bl2) {
                    object2 = element.getFirstChild();
                    while (object2 != null) {
                        object = ((Node)object2).getNextSibling();
                        if (((Node)object2).getType() == Node.Type.TEXT) {
                            element.removeChild((Node)object2);
                        }
                        object2 = object;
                    }
                } else {
                    for (object2 = element.getFirstChild(); object2 != null; object2 = ((Node)object2).getNextSibling()) {
                        String string;
                        if (((Node)object2).getType() != Node.Type.TEXT || ((String)(object5 = (Object)XMLText.compressWhiteSpace(string = ((TextNode)(object = (Text)object2)).getText()))).equals(string)) continue;
                        ((TextNode)object).setText((String)object5);
                    }
                }
                break;
            }
        }
        if (element.hasNoContent() && !(state.elementType instanceof AnyElementType)) {
            switch (1.$SwitchMap$com$xmlmind$xml$validate$ContentType[((Enum)object4).ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    element.appendChild(new Text());
                    break;
                }
                case 4: {
                    if (!state.mayAddTextPlaceholder) break;
                    element.appendChild(new Text());
                }
            }
        }
        this.doProcessSpaceInDescendants(element);
        this.stack.pop();
    }

    private State pushElement(Element element) {
        return this.doPushElement(element, this.stack.peek());
    }

    private State doPushElement(Element element, State state) {
        Object object;
        int n;
        State state2 = new State();
        state2.element = element;
        if (state.element == null) {
            state2.elementType = state.childElementTypes[0];
        } else {
            int n2 = state.element.indexOfChildElement(element);
            state2.elementType = state.childElementTypes[n2];
        }
        if (!state2.elementType.getStructure(element, true, this.structure)) {
            state2.elementType = new LaxElementType(state2.elementType);
            state2.elementType.getStructure(element, true, this.structure);
        }
        Name[] nameArray = this.structure.attributeNames;
        Field[] fieldArray = this.structure.attributeFields;
        int n3 = this.structure.attributeFieldCount;
        state2.nameToAttrType = new IdentityLinearHashtable();
        for (int i = 0; i < n3; ++i) {
            AttributeType attributeType = state2.elementType.getAttributeType(fieldArray[i], nameArray[i]);
            if (attributeType == null) {
                attributeType = AnyAttributeType.INSTANCE;
            }
            state2.nameToAttrType.put(nameArray[i], attributeType);
        }
        Item[] itemArray = this.structure.childNodeItems;
        int n4 = this.structure.childNodeItemCount;
        int n5 = 0;
        for (n = 0; n < n4; ++n) {
            if (!(itemArray[n] instanceof Field)) continue;
            ++n5;
        }
        state2.childElementTypes = new ElementType[n5];
        n5 = 0;
        for (n = 0; n < n4; ++n) {
            if (!(itemArray[n] instanceof Field)) continue;
            object = (Element)element.getChild(n);
            ElementType elementType = state2.elementType.getChildElementType((Field)itemArray[n], (Element)object);
            if (elementType == null) {
                elementType = AnyElementType.INSTANCE;
            }
            state2.childElementTypes[n5++] = elementType;
        }
        String string = AttributeUtil.getSpaceAttribute(element);
        state2.hasPreserveSpace = string == null ? ((object = state2.elementType.getAttributeDefaultValue(Name.XML_SPACE)) != null ? object.formatData(element).equals("preserve") : state.hasPreserveSpace) : string.trim().equals("preserve");
        if (state2.elementType != null && state2.elementType.getElementContentType() == ContentType.OTHER) {
            state2.mayAddTextPlaceholder = state2.elementType.checkElementStructure(this.structure.attributeFields, this.structure.attributeFieldCount, SINGLE_TEXT_ITEM, 1);
        }
        this.stack.push(state2);
        return state2;
    }

    private static final class State {
        public Element element;
        public ElementType elementType;
        public IdentityLinearHashtable<Name, AttributeType> nameToAttrType;
        public ElementType[] childElementTypes;
        public boolean hasPreserveSpace;
        public boolean mayAddTextPlaceholder;

        private State() {
        }

        public ContentType getElementContentType() {
            return this.getElementContentType(null);
        }

        public ContentType getElementContentType(boolean[] blArray) {
            if (this.elementType == null || this.elementType instanceof AnyElementType) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return ContentTypeUtil.guessContentType(this.element);
            }
            if (blArray != null) {
                blArray[0] = false;
            }
            return this.elementType.getElementContentType();
        }
    }
}

