/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.LinearHashtable;
import com.xmlmind.util.Log;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.load.DocumentManager;
import com.xmlmind.xml.load.LoadDocument;
import com.xmlmind.xml.load.LoadError;
import com.xmlmind.xml.load.LoadErrorImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocumentCache
implements DocumentManager {
    private static DateFormat dateFormat = null;
    private static Date date = null;
    public static final int DEFAULT_CAPACITY = 100;
    public static final int DEFAULT_LOAD_OPTIONS = 4352;
    protected int capacity;
    protected int defaultLoadOptions;
    protected HashMap<URL, Entry> entries;
    protected Entry first;
    protected Entry last;
    protected int size;
    protected Listener[] listeners;
    protected Event event;
    private static final DocumentCache[] globalCache = new DocumentCache[]{new DocumentCache()};

    public DocumentCache() {
        this(100, 4352);
    }

    public DocumentCache(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        this.capacity = n;
        this.defaultLoadOptions = n2;
        this.entries = new HashMap(n + 1);
        this.listeners = new Listener[0];
        this.event = new Event(this);
    }

    public synchronized void setCapacity(int n) {
        if (n < 0) {
            n = 0;
        }
        this.capacity = n;
        while (this.size > n) {
            this.removeEntry(this.first);
        }
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setDefaultLoadOptions(int n) {
        this.defaultLoadOptions = n;
    }

    public synchronized int getDefaultLoadOptions() {
        return this.defaultLoadOptions;
    }

    public synchronized void addListener(Listener listener) {
        int n = ArrayUtil.find(this.listeners, listener);
        if (n < 0) {
            this.listeners = ArrayUtil.append(this.listeners, listener);
        }
    }

    public synchronized void removeListener(Listener listener) {
        int n = ArrayUtil.find(this.listeners, listener);
        if (n >= 0) {
            this.listeners = ArrayUtil.removeAt(this.listeners, n);
        }
    }

    public synchronized Listener[] getListeners() {
        return this.listeners;
    }

    protected void notifyListeners() {
        Listener[] listenerArray = this.listeners;
        for (int i = listenerArray.length - 1; i >= 0; --i) {
            listenerArray[i].documentCacheEvent(this.event);
        }
    }

    @Override
    public Document getDocument(URL uRL) throws IOException {
        return this.get(uRL);
    }

    public Document get(URL uRL) throws IOException {
        return this.get(uRL, this.defaultLoadOptions);
    }

    public Document get(URL uRL, int n) throws IOException {
        Entry entry = this.getEntry(uRL, n);
        return entry == null ? null : entry.document;
    }

    public Entry getEntry(URL uRL) throws IOException {
        return this.getEntry(uRL, this.defaultLoadOptions);
    }

    public Entry getEntry(URL uRL, int n) throws IOException {
        return this.accessEntry(uRL, true, n);
    }

    public Document fetch(URL uRL) {
        Entry entry = this.fetchEntry(uRL);
        return entry == null ? null : entry.document;
    }

    public Entry fetchEntry(URL uRL) {
        try {
            return this.accessEntry(uRL, false, 0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Entry accessEntry(URL uRL, boolean bl, int n) throws IOException {
        if (uRL.getRef() != null) {
            uRL = URLUtil.setFragment(uRL, null);
        }
        if (this.listeners.length > 0) {
            this.event.init(bl ? EventType.GETTING_DOCUMENT : EventType.FETCHING_DOCUMENT, uRL, null);
            this.notifyListeners();
        }
        Entry entry = null;
        try {
            entry = this.doAccessEntry(uRL, bl, n);
        }
        catch (Throwable throwable) {
            if (this.listeners.length > 0) {
                this.event.init(bl ? EventType.GOT_ENTRY : EventType.FETCHED_ENTRY, uRL, entry);
                this.notifyListeners();
            }
            throw throwable;
        }
        if (this.listeners.length > 0) {
            this.event.init(bl ? EventType.GOT_ENTRY : EventType.FETCHED_ENTRY, uRL, entry);
            this.notifyListeners();
        }
        return entry;
    }

    protected Entry doAccessEntry(URL uRL, boolean bl, int n) throws IOException {
        Object var4_4 = null;
        long l = -1L;
        long l2 = -1L;
        Entry entry = this.entries.get(uRL);
        if (entry != null) {
            boolean bl2 = false;
            if (entry.lastModified <= 0L || entry.size < 0L || bl && entry.loadOptions != n) {
                bl2 = true;
            } else if (entry.file != null) {
                if (!entry.file.isFile() || entry.file.lastModified() != entry.lastModified || entry.file.length() != entry.size) {
                    bl2 = true;
                }
            } else {
                block15: {
                    try {
                        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
                        if (uRLConnection instanceof HttpURLConnection) {
                            ((HttpURLConnection)uRLConnection).setRequestMethod("HEAD");
                            uRLConnection = URLUtil.checkHttpConnection(uRLConnection, true);
                        } else {
                            uRLConnection.connect();
                        }
                        l = uRLConnection.getLastModified();
                        l2 = uRLConnection.getContentLength();
                        uRLConnection = null;
                    }
                    catch (IOException iOException) {
                        if (!bl) break block15;
                        throw iOException;
                    }
                }
                if (l != entry.lastModified || l2 != entry.size) {
                    bl2 = true;
                }
            }
            if (bl2) {
                this.removeEntry(entry);
                entry = null;
            }
        }
        if (entry != null) {
            this.detachEntry(entry);
            this.attachEntry(entry);
        } else if (bl) {
            entry = this.loadEntry(uRL, n);
            this.checkedAddEntry(entry);
        }
        return entry;
    }

    protected Entry createEntry(URL uRL, Document document, int n, File file, long l, long l2) {
        return new Entry(uRL, document, n, file, l, l2);
    }

    protected Entry loadEntry(URL uRL, int n) throws IOException {
        File file = URLUtil.urlToFile(uRL);
        long l = -1L;
        long l2 = -1L;
        Document document = null;
        if (file != null) {
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getPath());
            }
            l = file.lastModified();
            l2 = file.length();
            FileInputStream fileInputStream = new FileInputStream(file);
            document = this.loadDocument(fileInputStream, uRL, n);
        } else {
            URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
            uRLConnection.connect();
            l = uRLConnection.getLastModified();
            l2 = uRLConnection.getContentLength();
            InputStream inputStream = uRLConnection.getInputStream();
            document = this.loadDocument(inputStream, uRL, n);
            uRLConnection = null;
        }
        return this.createEntry(uRL, document, n, file, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document loadDocument(InputStream inputStream, URL uRL, int n) throws IOException {
        ArrayList<LoadError> arrayList = null;
        ArrayList<LoadError> arrayList2 = null;
        if (this.listeners.length > 0) {
            this.event.init(EventType.LOADING_DOCUMENT, uRL, null);
            this.notifyListeners();
            arrayList = new ArrayList<LoadError>();
            arrayList2 = new ArrayList<LoadError>();
        }
        inputStream = new BufferedInputStream(inputStream, 65535);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(uRL.toExternalForm());
        Document document = null;
        String string = null;
        try {
            document = this.doLoadDocument(inputSource, uRL, n, arrayList, arrayList2);
        }
        catch (SAXParseException sAXParseException) {
            string = DocumentLoader.format(sAXParseException);
        }
        catch (Exception exception) {
            string = ThrowableUtil.reason(exception);
        }
        finally {
            inputSource.getByteStream().close();
        }
        if (this.listeners.length > 0) {
            this.event.init(uRL, document, string, arrayList, arrayList2);
            this.notifyListeners();
        }
        if (string != null) {
            throw new IOException(string);
        }
        return document;
    }

    protected Document doLoadDocument(InputSource inputSource, URL uRL, int n, List<LoadError> list, List<LoadError> list2) throws SAXException, IOException {
        return LoadDocument.load(inputSource, uRL, n, null, list, list2);
    }

    protected boolean checkedAddEntry(Entry entry) {
        while (this.size >= this.capacity && this.size > 0) {
            this.removeEntry(this.first);
        }
        if (this.size + 1 <= this.capacity) {
            this.addEntry(entry);
            return true;
        }
        return false;
    }

    protected void addEntry(Entry entry) {
        this.doAddEntry(entry);
        if (this.listeners.length > 0) {
            this.event.init(EventType.ADDED_ENTRY, entry.url, entry);
            this.notifyListeners();
        }
    }

    protected void doAddEntry(Entry entry) {
        this.entries.put(entry.url, entry);
        this.attachEntry(entry);
    }

    protected void attachEntry(Entry entry) {
        assert (entry.previous == null && entry.next == null && entry != this.last);
        if (this.last == null) {
            this.first = this.last = entry;
        } else {
            this.last.next = entry;
            entry.previous = this.last;
            this.last = entry;
        }
        ++this.size;
    }

    public Document remove(URL uRL) {
        Entry entry = this.removeEntry(uRL);
        return entry == null ? null : entry.document;
    }

    public synchronized Entry removeEntry(URL uRL) {
        Entry entry;
        if (uRL.getRef() != null) {
            uRL = URLUtil.setFragment(uRL, null);
        }
        if ((entry = this.entries.get(uRL)) != null) {
            this.removeEntry(entry);
        }
        return entry;
    }

    protected void removeEntry(Entry entry) {
        this.doRemoveEntry(entry);
        if (this.listeners.length > 0) {
            this.event.init(EventType.REMOVED_ENTRY, entry.url, entry);
            this.notifyListeners();
        }
    }

    protected void doRemoveEntry(Entry entry) {
        this.entries.remove(entry.url);
        this.detachEntry(entry);
    }

    protected void detachEntry(Entry entry) {
        assert (entry.previous != null || entry.next != null || entry == this.last);
        Entry entry2 = entry.previous;
        Entry entry3 = entry.next;
        entry.previous = null;
        entry.next = null;
        if (entry2 == null) {
            this.first = entry3;
        } else {
            entry2.next = entry3;
        }
        if (entry3 == null) {
            this.last = entry2;
        } else {
            entry3.previous = entry2;
        }
        --this.size;
    }

    public synchronized void clear() {
        Entry entry = this.first;
        this.doClear();
        if (this.listeners.length > 0) {
            Entry entry2 = entry;
            while (entry2 != null) {
                this.event.init(EventType.REMOVED_ENTRY, entry2.url, entry2);
                this.notifyListeners();
                entry2 = entry2.next;
            }
        }
    }

    protected void doClear() {
        this.entries.clear();
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public synchronized int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCache(DocumentCache documentCache) {
        DocumentCache[] documentCacheArray = globalCache;
        synchronized (globalCache) {
            if (documentCache == null) {
                documentCache = new DocumentCache();
            }
            DocumentCache.globalCache[0] = documentCache;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentCache getCache() {
        DocumentCache[] documentCacheArray = globalCache;
        synchronized (globalCache) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return globalCache[0];
        }
    }

    public static interface Listener {
        public void documentCacheEvent(Event var1);
    }

    public static class Event
    implements Cloneable {
        public final DocumentCache documentCache;
        private EventType type;
        private URL url;
        private Document document;
        private String ioError;
        private List<LoadError> loadErrors;
        private List<LoadError> loadWarnings;
        private Entry entry;

        public Event(DocumentCache documentCache) {
            this.documentCache = documentCache;
        }

        public Event copy() {
            try {
                return (Event)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public EventType getType() {
            return this.type;
        }

        public URL getURL() {
            return this.url;
        }

        public Entry getEntry() {
            return this.entry;
        }

        public Document getDocument() {
            return this.document;
        }

        public String getIOError() {
            return this.ioError;
        }

        public List<LoadError> getLoadErrors() {
            return this.loadErrors;
        }

        public List<LoadError> getLoadWarnings() {
            return this.loadWarnings;
        }

        private void init(EventType eventType, URL uRL, Entry entry) {
            this.type = eventType;
            this.url = uRL;
            this.document = null;
            this.ioError = null;
            this.loadErrors = null;
            this.loadWarnings = null;
            this.entry = entry;
        }

        private void init(URL uRL, Document document, String string, List<LoadError> list, List<LoadError> list2) {
            this.type = EventType.LOADED_DOCUMENT;
            this.url = uRL;
            this.document = document;
            this.ioError = string;
            this.loadErrors = list;
            this.loadWarnings = list2;
            this.entry = null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Event[type=");
            stringBuilder.append((Object)this.type);
            if (this.url != null) {
                stringBuilder.append(",url=");
                stringBuilder.append(this.url);
            }
            if (this.document != null) {
                stringBuilder.append(",document=");
                stringBuilder.append(this.document.getSourceURL());
            }
            if (this.ioError != null) {
                stringBuilder.append(",ioError=");
                stringBuilder.append(this.ioError);
            }
            if (this.loadErrors != null) {
                for (LoadError loadError : this.loadErrors) {
                    stringBuilder.append(",loadError=");
                    stringBuilder.append(LoadErrorImpl.format(loadError, false));
                }
            }
            if (this.loadWarnings != null) {
                for (LoadError loadError : this.loadWarnings) {
                    stringBuilder.append(",loadWarning=");
                    stringBuilder.append(LoadErrorImpl.format(loadError, true));
                }
            }
            if (this.entry != null) {
                stringBuilder.append(",entry=");
                stringBuilder.append(this.entry);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        public void log(Log log) {
            log.debug(this.getMessage());
            if (this.type == EventType.LOADED_DOCUMENT) {
                if (this.ioError != null) {
                    log.error(this.ioError);
                }
                if (this.loadErrors != null) {
                    for (LoadError loadError : this.loadErrors) {
                        log.error(LoadErrorImpl.format(loadError, false));
                    }
                }
                if (this.loadWarnings != null) {
                    for (LoadError loadError : this.loadWarnings) {
                        log.warning(LoadErrorImpl.format(loadError, true));
                    }
                }
            }
        }

        public String getMessage() {
            switch (this.type) {
                case FETCHING_DOCUMENT: {
                    return "Fetching \"" + String.valueOf(this.url) + "\"...";
                }
                case GETTING_DOCUMENT: {
                    return "Getting \"" + String.valueOf(this.url) + "\"...";
                }
                case LOADING_DOCUMENT: {
                    return "Loading \"" + String.valueOf(this.url) + "\"...";
                }
                case REMOVED_ENTRY: {
                    return "Discarded \"" + String.valueOf(this.url) + "\"" + this.entryInfo() + ".";
                }
                case ADDED_ENTRY: {
                    return "Cached \"" + String.valueOf(this.url) + "\"" + this.entryInfo() + ".";
                }
                case FETCHED_ENTRY: {
                    if (this.entry == null) {
                        return "Did not fetch \"" + String.valueOf(this.url) + "\".";
                    }
                    return "Fetched \"" + String.valueOf(this.url) + "\"" + this.entryInfo() + ".";
                }
                case GOT_ENTRY: {
                    if (this.entry == null) {
                        return "Did not get \"" + String.valueOf(this.url) + "\".";
                    }
                    return "Got \"" + String.valueOf(this.url) + "\"" + this.entryInfo() + ".";
                }
                case LOADED_DOCUMENT: {
                    if (this.document == null) {
                        return "Did not load \"" + String.valueOf(this.url) + "\".";
                    }
                    return "Loaded \"" + String.valueOf(this.url) + "\".";
                }
            }
            return this.toString();
        }

        private String entryInfo() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" (");
            if (this.entry.size >= 0L) {
                stringBuilder.append(Long.toString(this.entry.size));
                stringBuilder.append("bytes");
            }
            if (this.entry.lastModified > 0L) {
                if (this.entry.size >= 0L) {
                    stringBuilder.append(", ");
                }
                if (dateFormat == null) {
                    dateFormat = DateFormat.getDateTimeInstance(3, 2);
                    date = new Date();
                }
                date.setTime(this.entry.lastModified);
                stringBuilder.append(dateFormat.format(date));
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    public static enum EventType {
        FETCHING_DOCUMENT,
        GETTING_DOCUMENT,
        LOADING_DOCUMENT,
        REMOVED_ENTRY,
        ADDED_ENTRY,
        FETCHED_ENTRY,
        GOT_ENTRY,
        LOADED_DOCUMENT;

    }

    public static class Entry {
        private Entry previous;
        private Entry next;
        public final URL url;
        public final Document document;
        public final int loadOptions;
        public final File file;
        public final long lastModified;
        public final long size;
        private LinearHashtable<Object, Object> properties;

        public Entry(URL uRL, Document document, int n, File file, long l, long l2) {
            this.url = uRL;
            this.document = document;
            this.loadOptions = n;
            this.file = file;
            this.lastModified = l;
            this.size = l2;
            this.properties = new LinearHashtable();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Entry[url=");
            stringBuilder.append(this.url);
            stringBuilder.append(",document=");
            stringBuilder.append(System.identityHashCode(this.document));
            stringBuilder.append(",loadOptions=0x");
            stringBuilder.append(Integer.toHexString(this.loadOptions));
            if (this.file != null) {
                stringBuilder.append(",file=");
                stringBuilder.append(this.file);
            }
            stringBuilder.append(",lastModified=");
            stringBuilder.append(this.lastModified);
            stringBuilder.append(",size=");
            stringBuilder.append(this.size);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getProperty(Object object) {
            LinearHashtable<Object, Object> linearHashtable = this.properties;
            synchronized (linearHashtable) {
                return this.properties.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object setProperty(Object object, Object object2) {
            LinearHashtable<Object, Object> linearHashtable = this.properties;
            synchronized (linearHashtable) {
                if (object2 == null) {
                    return this.properties.remove(object);
                }
                return this.properties.put(object, object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addProperty(Object object, Supplier<Object> supplier) {
            LinearHashtable<Object, Object> linearHashtable = this.properties;
            synchronized (linearHashtable) {
                Object object2 = this.properties.get(object);
                if (object2 == null) {
                    object2 = supplier.get();
                    this.properties.put(object, object2);
                }
                return object2;
            }
        }
    }
}

