/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.clipboard;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.KeyValuePair;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Comment;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.save.DocumentWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ClipboardFormat {
    public static final Namespace CLIPBOARD_NAMESPACE = Namespace.get("http://www.xmlmind.com/xmleditor/namespace/clipboard");
    public static final Name ENVELOPE_NAME = Name.get(CLIPBOARD_NAMESPACE, "clipboard");
    public static final Name TEXT_PLACEHOLDER_NAME = Name.get(CLIPBOARD_NAMESPACE, "textPlaceholder");
    public static final Name[] INCLUSION_PROPERTIES = new Name[]{Constants.INCLUSION_PROPERTY, Constants.SOURCE_URL_PROPERTY, Constants.READ_ONLY_PROPERTY};
    private static final Class<?>[] STRING_PARAMETER = new Class[]{String.class};

    private ClipboardFormat() {
    }

    public static Node[] parse(String string) {
        if (!string.startsWith("<?xml ")) {
            return null;
        }
        InputSource inputSource = new InputSource(new StringReader(string));
        URL uRL = FileUtil.fileToURL(new File("(string)"));
        inputSource.setSystemId(uRL.toExternalForm());
        return ClipboardFormat.parse(inputSource);
    }

    public static Node[] parse(File file) throws IOException {
        return ClipboardFormat.parse(FileUtil.fileToURL(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node[] parse(URL uRL) throws IOException {
        try (InputStream inputStream = URLUtil.openStreamNoCache(uRL);){
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL.toExternalForm());
            Node[] nodeArray = ClipboardFormat.parse(inputSource);
            return nodeArray;
        }
    }

    public static Node[] parse(InputSource inputSource) {
        Document document = null;
        DocumentLoader documentLoader = new DocumentLoader();
        try {
            document = documentLoader.load(inputSource);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document == null) {
            return null;
        }
        return ClipboardFormat.docToNodes(document);
    }

    public static Node[] docToNodes(Document document) {
        PrefixEntry[] prefixEntryArray = null;
        PrefixPreferences prefixPreferences = (PrefixPreferences)document.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY);
        if (prefixPreferences != null) {
            prefixPreferences.remove(CLIPBOARD_NAMESPACE);
            prefixPreferences.remove(Constants.PROPERTY_NAMESPACE);
            prefixEntryArray = prefixPreferences.getAll();
            if (prefixEntryArray.length == 0) {
                prefixEntryArray = null;
            }
        }
        Element element = document.getRootElement();
        document.removeChild(element);
        Object object = ClipboardFormat.discardEnvelope(element);
        Node[] nodeArray = object instanceof Node ? new Node[]{(Node)object} : (Node[])object;
        if (prefixEntryArray != null) {
            for (Node node : nodeArray) {
                if (node.getType() != Node.Type.ELEMENT) continue;
                node.putProperty(Constants.DECLARED_PREFIXES_PROPERTY, prefixEntryArray);
            }
        }
        return nodeArray;
    }

    private static Object discardEnvelope(Node node) {
        if (node.getType() == Node.Type.ELEMENT) {
            Element element = (Element)node;
            Name name = element.getName();
            if (name == ENVELOPE_NAME) {
                Object[] objectArray = ClipboardFormat.envelopeProperties(element);
                Node[] nodeArray = new Node[element.getChildCount()];
                int n = 0;
                Node node2 = element.getFirstChild();
                while (node2 != null) {
                    Node node3 = node2.getNextSibling();
                    element.removeChild(node2);
                    Object object = ClipboardFormat.discardEnvelope(node2);
                    if (object instanceof Node) {
                        nodeArray[n] = (Node)object;
                        if (objectArray != null) {
                            ClipboardFormat.addProperties(objectArray, nodeArray[n]);
                        }
                        ++n;
                    } else {
                        Node[] nodeArray2 = (Node[])object;
                        Node[] nodeArray3 = new Node[nodeArray.length + nodeArray2.length - 1];
                        System.arraycopy(nodeArray, 0, nodeArray3, 0, n);
                        nodeArray = nodeArray3;
                        for (int i = 0; i < nodeArray2.length; ++i) {
                            nodeArray[n] = nodeArray2[i];
                            if (objectArray != null) {
                                ClipboardFormat.addProperties(objectArray, nodeArray[n]);
                            }
                            ++n;
                        }
                    }
                    node2 = node3;
                }
                assert (n == nodeArray.length);
                return nodeArray;
            }
            if (name == TEXT_PLACEHOLDER_NAME) {
                return new Text();
            }
            Node node4 = element.getFirstChild();
            while (node4 != null) {
                Node node5 = node4.getNextSibling();
                Object object = ClipboardFormat.discardEnvelope(node4);
                if (object != node4) {
                    element.removeChild(node4);
                    if (object instanceof Node) {
                        element.insertChild(node5, (Node)object);
                    } else {
                        Node[] nodeArray = (Node[])object;
                        for (int i = 0; i < nodeArray.length; ++i) {
                            element.insertChild(node5, nodeArray[i]);
                        }
                    }
                }
                node4 = node5;
            }
            return element;
        }
        return node;
    }

    private static Object[] envelopeProperties(Element element) {
        int n = element.getAttributeCount();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new Object[2 * n];
        n = 0;
        Iterator<Attribute> iterator = element.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            Name name = attribute.name;
            String string = attribute.value;
            Object object = null;
            if (name == Constants.SOURCE_URL_PROPERTY) {
                try {
                    object = URLUtil.newURL(string);
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (name == Constants.READ_ONLY_PROPERTY) {
                if ("true".equals(string)) {
                    object = Boolean.TRUE;
                }
            } else if (name == Constants.INCLUSION_PROPERTY) {
                int n2 = string.indexOf(58);
                if (n2 >= 0) {
                    String string2 = string.substring(0, n2);
                    String string3 = string.substring(n2 + 1);
                    try {
                        Class<?> clazz = Class.forName(string2);
                        Constructor<?> constructor = clazz.getConstructor(STRING_PARAMETER);
                        object = (Inclusion)constructor.newInstance(string3);
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                object = string;
            }
            if (object == null) continue;
            objectArray[n++] = name;
            objectArray[n++] = object;
        }
        return objectArray;
    }

    private static void addProperties(Object[] objectArray, Node node) {
        for (int i = 0; i < objectArray.length; i += 2) {
            node.putProperty((Name)objectArray[i], objectArray[i + 1]);
        }
    }

    public static String format(Node[] nodeArray, int n, PrefixEntry[] prefixEntryArray, boolean bl) {
        Object object;
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            object = nodeArray[i];
            if (((Node)object).getType() == Node.Type.TEXT && (((Node)object).getInclusion() == null || !bl)) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            if (n == 1) {
                return ((Text)nodeArray[0]).getText();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(((Text)nodeArray[i]).getText());
            }
            return stringBuilder.toString();
        }
        StringWriter stringWriter = new StringWriter();
        object = new DocumentWriter(stringWriter);
        if (prefixEntryArray != null) {
            ((DocumentWriter)object).setPrefixPreferences(prefixEntryArray);
        }
        Node[] nodeArray2 = ClipboardFormat.copyNodes(nodeArray, n, bl);
        Document document = new Document();
        if (nodeArray2.length == 1 && nodeArray2[0].getType() == Node.Type.ELEMENT) {
            document.appendChild(nodeArray2[0]);
        } else {
            Element element = new Element(ENVELOPE_NAME);
            for (int i = 0; i < nodeArray2.length; ++i) {
                element.appendChild(nodeArray2[i]);
            }
            document.appendChild(element);
        }
        stringWriter.write("<?xml version=\"1.0\"?>\n");
        try {
            ((DocumentWriter)object).write(document);
            ((DocumentWriter)object).flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return stringWriter.toString();
    }

    private static Node[] copyNodes(Node[] nodeArray, int n, boolean bl) {
        Node[] nodeArray2 = new Node[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Node node;
            Inclusion inclusion;
            int n3;
            Inclusion inclusion2;
            Node node2 = nodeArray[i];
            if (!bl || (inclusion2 = (Inclusion)node2.getProperty(Constants.INCLUSION_PROPERTY)) == null) {
                nodeArray2[n2++] = ClipboardFormat.copyNode(node2, bl, 0);
                continue;
            }
            Element element = new Element(ENVELOPE_NAME);
            element.putAttribute(Constants.INCLUSION_PROPERTY, ClipboardFormat.inclusionValue(inclusion2));
            element.putAttribute(Constants.READ_ONLY_PROPERTY, "true");
            int n4 = 1;
            URL uRL = (URL)node2.getProperty(Constants.SOURCE_URL_PROPERTY);
            boolean bl2 = true;
            for (n3 = i + 1; n3 < n && (inclusion = (Inclusion)(node = nodeArray[n3]).getProperty(Constants.INCLUSION_PROPERTY)) == inclusion2; ++n3) {
                URL uRL2;
                ++n4;
                if (!bl2 || (uRL2 = (URL)node.getProperty(Constants.SOURCE_URL_PROPERTY)) == null || uRL2.equals(uRL)) continue;
                bl2 = false;
            }
            if (bl2) {
                if (uRL != null) {
                    element.putAttribute(Constants.SOURCE_URL_PROPERTY, uRL.toExternalForm());
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    element.appendChild(ClipboardFormat.copyNode(nodeArray[i + n3], true, 1));
                }
            } else {
                for (n3 = 0; n3 < n4; ++n3) {
                    element.appendChild(ClipboardFormat.copyNode(nodeArray[i + n3], true, 2));
                }
            }
            i += n4 - 1;
            nodeArray2[n2++] = element;
        }
        return ArrayUtil.trimToSize(nodeArray2, n2);
    }

    private static Node copyNode(Node node, boolean bl, int n) {
        Object object;
        Tree tree = null;
        if (bl) {
            switch (n) {
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    object = (URL)node.getProperty(Constants.SOURCE_URL_PROPERTY);
                    if (object == null) break;
                    if (tree == null) {
                        tree = new Element(ENVELOPE_NAME);
                    }
                    ((Element)tree).putAttribute(Constants.SOURCE_URL_PROPERTY, ((URL)object).toExternalForm());
                }
            }
        }
        if (node.getPropertyCount() > 0) {
            object = node.getProperties();
            while (object.hasNext()) {
                KeyValuePair keyValuePair = (KeyValuePair)object.next();
                Name name = (Name)keyValuePair.key;
                if (!name.localPart.endsWith("__")) continue;
                if (tree == null) {
                    tree = new Element(ENVELOPE_NAME);
                }
                ((Element)tree).putAttribute(name, keyValuePair.value.toString());
            }
        }
        object = ClipboardFormat.doCopyNode(node, bl, n);
        if (tree != null) {
            tree.appendChild((Node)object);
            return tree;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Node doCopyNode(Node var0, boolean var1_1, int var2_2) {
        switch (1.$SwitchMap$com$xmlmind$xml$doc$Node$Type[var0.getType().ordinal()]) {
            case 1: {
                var3_3 = (Text)var0;
                if (var3_3.getTextLength() == 0) {
                    return new Element(ClipboardFormat.TEXT_PLACEHOLDER_NAME);
                }
                return new Text(var3_3.getText());
            }
            case 2: {
                var3_4 = (Comment)var0;
                return new Comment(var3_4.getText());
            }
            case 3: {
                var3_5 = (ProcessingInstruction)var0;
                return new ProcessingInstruction(var3_5.getTarget(), var3_5.getText());
            }
            case 4: {
                var3_6 = (Element)var0;
                var4_7 = new Element(var3_6.getName());
                if (var3_6.getAttributeCount() > 0) {
                    var5_8 = var3_6.getAttributes();
                    while (var5_8.hasNext()) {
                        var6_9 /* !! */  = (Attribute)var5_8.next();
                        var4_7.putAttribute(var6_9 /* !! */ .name, var6_9 /* !! */ .value);
                    }
                }
                var5_8 = var3_6.getFirstChild();
                while (var5_8 != null) {
                    var6_9 /* !! */  = var5_8.getNextSibling();
                    if (var1_1 && (var7_10 = (Inclusion)var5_8.getProperty(Constants.INCLUSION_PROPERTY)) != null) ** GOTO lbl29
                    var4_7.appendChild(ClipboardFormat.copyNode((Node)var5_8, var1_1, var2_2));
                    ** GOTO lbl59
lbl29:
                    // 1 sources

                    var8_11 = new Element(ClipboardFormat.ENVELOPE_NAME);
                    var8_11.putAttribute(Constants.INCLUSION_PROPERTY, ClipboardFormat.inclusionValue(var7_10));
                    var8_11.putAttribute(Constants.READ_ONLY_PROPERTY, "true");
                    var9_12 = var5_8;
                    var10_13 = (URL)var5_8.getProperty(Constants.SOURCE_URL_PROPERTY);
                    var11_14 = true;
                    for (var12_15 = var5_8.getNextSibling(); var12_15 != null && (var13_16 = (Inclusion)var12_15.getProperty(Constants.INCLUSION_PROPERTY)) == var7_10; var12_15 = var12_15.getNextSibling()) {
                        var9_12 = var12_15;
                        if (!var11_14 || (var14_17 = (URL)var12_15.getProperty(Constants.SOURCE_URL_PROPERTY)) == null || var14_17.equals(var10_13)) continue;
                        var11_14 = false;
                    }
                    if (!var11_14) ** GOTO lbl52
                    if (var10_13 != null) {
                        var8_11.putAttribute(Constants.SOURCE_URL_PROPERTY, var10_13.toExternalForm());
                    }
                    for (var12_15 = var5_8; var12_15 != null; var12_15 = var12_15.getNextSibling()) {
                        var8_11.appendChild(ClipboardFormat.copyNode((Node)var12_15, true, 1));
                        if (var12_15 != var9_12) {
                            continue;
                        }
                        ** GOTO lbl57
                    }
                    ** GOTO lbl57
lbl52:
                    // 2 sources

                    for (var12_15 = var5_8; var12_15 != null; var12_15 = var12_15.getNextSibling()) {
                        var8_11.appendChild(ClipboardFormat.copyNode((Node)var12_15, true, 2));
                        if (var12_15 != var9_12) {
                            continue;
                        }
                        break;
                    }
lbl57:
                    // 4 sources

                    var6_9 /* !! */  = var9_12.getNextSibling();
                    var4_7.appendChild(var8_11);
lbl59:
                    // 2 sources

                    var5_8 = var6_9 /* !! */ ;
                }
                return var4_7;
            }
        }
        if (!ClipboardFormat.$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private static String inclusionValue(Inclusion inclusion) {
        StringBuilder stringBuilder = new StringBuilder(inclusion.getClass().getName());
        stringBuilder.append(':');
        stringBuilder.append(inclusion.toClipboardForm());
        return stringBuilder.toString();
    }

    public static Node[] checkForFormat(Node[] nodeArray, int n) {
        Node node;
        Node node2;
        if (nodeArray == null || n == 0) {
            return nodeArray;
        }
        boolean bl = false;
        Inclusion inclusion = null;
        Inclusion inclusion2 = null;
        Node node3 = nodeArray[0];
        for (int i = 1; i < n; ++i) {
            node2 = nodeArray[i];
            if (node2.getPreviousSibling() != node3) {
                bl = true;
                break;
            }
            node3 = node2;
        }
        if (!bl) {
            Node node4 = nodeArray[0];
            node3 = node4.getPreviousSibling();
            inclusion = (Inclusion)node4.getProperty(Constants.INCLUSION_PROPERTY);
            if (!Node.sameInclusion(node4, node3)) {
                inclusion = null;
            }
            node2 = nodeArray[n - 1];
            node = node2.getNextSibling();
            inclusion2 = (Inclusion)node2.getProperty(Constants.INCLUSION_PROPERTY);
            if (!Node.sameInclusion(node2, node)) {
                inclusion2 = null;
            }
        }
        if (bl || inclusion != null || inclusion2 != null) {
            Node[] nodeArray2 = new Node[n];
            for (int i = 0; i < n; ++i) {
                node = nodeArray[i];
                Inclusion inclusion3 = (Inclusion)node.getProperty(Constants.INCLUSION_PROPERTY);
                if (inclusion3 != null && (bl || inclusion3 == inclusion || inclusion3 == inclusion2)) {
                    node = node.copy();
                    node.removeProperties(INCLUSION_PROPERTIES, true);
                }
                nodeArray2[i] = node;
            }
            nodeArray = nodeArray2;
        }
        return nodeArray;
    }
}

