/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URIComponent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

final class Util {
    public static final String EMACS_UTF8_DECL = "// -*- coding: utf-8 -*-\n\n";
    private static final String[] KNOWN_IMAGE_TYPES = new String[]{"image/apng apng", "image/avif avif", "image/gif gif", "image/jpeg jpeg jpg jfif pjpeg pjp", "image/png png", "image/svg+xml svg svgz", "image/webp webp", "image/bmp bmp", "image/x-icon ico cur", "image/tiff tiff tif"};
    private static final HashMap<String, String> IMAGE_EXT_TO_TYPE = new HashMap();

    private Util() {
    }

    public static String getImageType(String string) {
        String string2;
        String string3 = null;
        if (string != null && string.length() > 0 && (string2 = URIComponent.getExtension(string)) != null && string2.length() > 0) {
            string3 = IMAGE_EXT_TO_TYPE.get(string2);
        }
        return string3;
    }

    public static void appendJSString(String string, StringBuilder stringBuilder) {
        stringBuilder.append('\"');
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append('\"');
    }

    public static String compactJS(String string) {
        return Util.compact(string, false);
    }

    public static String compactCSS(String string) {
        return Util.compact(string, true);
    }

    private static String compact(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        State state = State.NORMAL_CHARS;
        block48: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            switch (c) {
                case '/': {
                    char c2;
                    switch (state) {
                        case MULTI_LINE_COMMENT: {
                            if (i <= 0 || cArray[i - 1] != '*') break;
                            state = State.NORMAL_CHARS;
                            break;
                        }
                        case LINE_COMMENT: {
                            break;
                        }
                        case STRING_QUOTE: 
                        case STRING_APOS: {
                            cArray2[n2++] = c;
                            break;
                        }
                        case SPACE_CHARS: 
                        case NORMAL_CHARS: {
                            if (i + 1 < n) {
                                c2 = cArray[i + 1];
                                if (c2 == '*') {
                                    ++i;
                                    state = State.MULTI_LINE_COMMENT;
                                    break;
                                }
                                if (c2 == '/' && !bl) {
                                    ++i;
                                    state = State.LINE_COMMENT;
                                    break;
                                }
                                if (!bl) {
                                    int n3 = Util.lastREOffset(cArray, i, n);
                                    if (n3 > i) {
                                        assert (cArray[n3] == '/');
                                        int n4 = n3 - i + 1;
                                        System.arraycopy(cArray, i, cArray2, n2, n4);
                                        n2 += n4;
                                        i = n3;
                                    } else {
                                        cArray2[n2++] = c;
                                    }
                                } else {
                                    cArray2[n2++] = c;
                                }
                                state = State.NORMAL_CHARS;
                                break;
                            }
                            cArray2[n2++] = c;
                            state = State.NORMAL_CHARS;
                        }
                    }
                    continue block48;
                }
                case '\"': {
                    switch (state) {
                        case MULTI_LINE_COMMENT: 
                        case LINE_COMMENT: {
                            break;
                        }
                        case STRING_QUOTE: {
                            cArray2[n2++] = c;
                            state = State.NORMAL_CHARS;
                            break;
                        }
                        case STRING_APOS: {
                            cArray2[n2++] = c;
                            break;
                        }
                        case SPACE_CHARS: 
                        case NORMAL_CHARS: {
                            cArray2[n2++] = c;
                            state = State.STRING_QUOTE;
                        }
                    }
                    continue block48;
                }
                case '\'': {
                    switch (state) {
                        case MULTI_LINE_COMMENT: 
                        case LINE_COMMENT: {
                            break;
                        }
                        case STRING_QUOTE: {
                            cArray2[n2++] = c;
                            break;
                        }
                        case STRING_APOS: {
                            cArray2[n2++] = c;
                            state = State.NORMAL_CHARS;
                            break;
                        }
                        case SPACE_CHARS: 
                        case NORMAL_CHARS: {
                            cArray2[n2++] = c;
                            state = State.STRING_APOS;
                        }
                    }
                    continue block48;
                }
                case '\n': {
                    switch (state) {
                        case MULTI_LINE_COMMENT: {
                            break;
                        }
                        case STRING_QUOTE: 
                        case STRING_APOS: {
                            cArray2[n2++] = c;
                            state = State.SPACE_CHARS;
                            break;
                        }
                        case LINE_COMMENT: 
                        case SPACE_CHARS: 
                        case NORMAL_CHARS: {
                            if (n2 > 0 && cArray2[n2 - 1] != '\n') {
                                cArray2[n2++] = c;
                            }
                            state = State.SPACE_CHARS;
                        }
                    }
                    continue block48;
                }
                case '\t': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    switch (state) {
                        case MULTI_LINE_COMMENT: 
                        case LINE_COMMENT: {
                            break;
                        }
                        case STRING_QUOTE: 
                        case STRING_APOS: {
                            cArray2[n2++] = c;
                            break;
                        }
                        case SPACE_CHARS: {
                            break;
                        }
                        case NORMAL_CHARS: {
                            cArray2[n2++] = 32;
                            state = State.SPACE_CHARS;
                        }
                    }
                    continue block48;
                }
                case '\\': {
                    char c2;
                    switch (state) {
                        case MULTI_LINE_COMMENT: 
                        case LINE_COMMENT: {
                            break;
                        }
                        case STRING_QUOTE: 
                        case STRING_APOS: {
                            if (i + 1 < n) {
                                c2 = cArray[i + 1];
                                if (c2 == '\"' || c2 == '\'') {
                                    cArray2[n2++] = c;
                                    cArray2[n2++] = c2;
                                    ++i;
                                    break;
                                }
                                if (c2 == '\n' && !bl) {
                                    cArray2[n2++] = c;
                                    cArray2[n2++] = c2;
                                    ++i;
                                    break;
                                }
                                cArray2[n2++] = c;
                                break;
                            }
                            cArray2[n2++] = c;
                            break;
                        }
                        case SPACE_CHARS: {
                            cArray2[n2++] = c;
                            state = State.NORMAL_CHARS;
                            break;
                        }
                        case NORMAL_CHARS: {
                            cArray2[n2++] = c;
                        }
                    }
                    continue block48;
                }
                default: {
                    switch (state) {
                        case MULTI_LINE_COMMENT: 
                        case LINE_COMMENT: {
                            continue block48;
                        }
                        case SPACE_CHARS: {
                            cArray2[n2++] = c;
                            state = State.NORMAL_CHARS;
                            continue block48;
                        }
                        case STRING_QUOTE: 
                        case STRING_APOS: 
                        case NORMAL_CHARS: {
                            cArray2[n2++] = c;
                        }
                    }
                }
            }
        }
        return new String(cArray2, 0, n2);
    }

    private static int lastREOffset(char[] cArray, int n, int n2) {
        assert (cArray[n] == '/');
        block5: for (int i = n + 1; i < n2; ++i) {
            switch (cArray[i]) {
                case '\\': {
                    if (i + 1 >= n2 || cArray[i + 1] != '/') continue block5;
                    ++i;
                    continue block5;
                }
                case '/': {
                    if (i + 1 < n2) {
                        char c = cArray[i + 1];
                        if (c == '*' || c == '/') {
                            return -1;
                        }
                        return i;
                    }
                    return i;
                }
                case '\n': {
                    return -1;
                }
            }
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        File file = null;
        if (stringArray.length != 2 || !(file = new File(stringArray[0])).isFile()) {
            System.err.println("Usage: java -cp whc.jar com.xmlmind.whc.Util in_css_or_js_file out_file");
            System.exit(1);
        }
        File file2 = new File(stringArray[1]);
        try {
            String string = FileUtil.loadString(file, "UTF-8");
            String string2 = Util.compact(string, stringArray[0].endsWith(".css"));
            FileUtil.saveString(string2, file2, "UTF-8");
        }
        catch (IOException iOException) {
            System.err.println("Cannot compact '" + file + "': " + ThrowableUtil.reason(iOException));
            System.exit(2);
        }
    }

    static {
        for (String string : KNOWN_IMAGE_TYPES) {
            String[] stringArray = StringUtil.split(string);
            if (stringArray.length < 2) continue;
            String string2 = stringArray[0];
            for (int i = stringArray.length - 1; i > 0; --i) {
                IMAGE_EXT_TO_TYPE.put(stringArray[i], string2);
            }
        }
    }

    private static enum State {
        MULTI_LINE_COMMENT,
        LINE_COMMENT,
        STRING_QUOTE,
        STRING_APOS,
        SPACE_CHARS,
        NORMAL_CHARS;

    }
}

