/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import com.xmlmind.whc.DOMUtil;
import com.xmlmind.whc.NodeLocation;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

final class SAXToDOM
extends DefaultHandler2 {
    public final Document doc;
    private Stack<Node> nodeStack;
    private StringBuilder buffer;
    private Locator locator;

    public SAXToDOM(Document document) {
        this.doc = document;
        this.nodeStack = new Stack();
        this.nodeStack.push(document);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
        DocumentType documentType = this.doc.getImplementation().createDocumentType(string, string2, string3);
        this.doc.appendChild(documentType);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.flushBuffer();
        Node node = this.nodeStack.peek();
        Element element = this.createElement(node, string, string3, attributes);
        node.appendChild(element);
        this.nodeStack.push(element);
    }

    private Element createElement(Node node, String string, String string2, Attributes attributes) {
        String string3;
        Element element = this.doc.createElementNS(string == null || string.length() == 0 ? null : string, string2);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            string3 = attributes.getQName(i);
            if (string3.startsWith("xmlns")) continue;
            String string4 = attributes.getURI(i);
            element.setAttributeNS(string4 == null || string4.length() == 0 ? null : string4, string3, attributes.getValue(i));
        }
        NodeLocation nodeLocation = null;
        if (this.locator != null && (string3 = this.locator.getSystemId()) != null) {
            nodeLocation = new NodeLocation(string3, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        if (nodeLocation != null) {
            element.setUserData("NODE_LOCATION", nodeLocation, DOMUtil.COPY_USER_DATA);
        }
        return element;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.flushBuffer();
        this.nodeStack.pop();
    }

    private void flushBuffer() {
        if (this.buffer != null) {
            Node node = this.nodeStack.peek();
            node.appendChild(this.doc.createTextNode(this.buffer.toString()));
            this.buffer = null;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        }
        this.buffer.append(cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        }
        this.buffer.append(cArray, n, n2);
    }
}

