/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.w2x.processor.ConsoleErrorListener;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.xml.resolve.XMLCatalogs;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public final class XSLTCache {
    private static final HashMap<URL, Templates> cache = new HashMap();
    private static TransformerFactory transformerFactory;

    private XSLTCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transformer newTransformer(URL uRL, Console console) throws Exception {
        HashMap<URL, Templates> hashMap = cache;
        synchronized (hashMap) {
            Templates templates = cache.get(uRL);
            if (templates == null) {
                if (console != null) {
                    console.showMessage(Msg.msg("loadingXSLT", uRL), Console.MessageType.DEBUG);
                }
                TransformerFactory transformerFactory = XSLTCache.getTransformerFactory(console);
                templates = transformerFactory.newTemplates(new StreamSource(uRL.toExternalForm()));
                cache.put(uRL, templates);
            }
            return templates.newTransformer();
        }
    }

    private static TransformerFactory getTransformerFactory(Console console) throws Exception {
        Object object;
        if (transformerFactory == null) {
            try {
                transformerFactory = TransformerFactory.newInstance("com.icl.saxon.TransformerFactoryImpl", null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (transformerFactory == null) {
                transformerFactory = TransformerFactory.newInstance();
            }
            object = XMLCatalogs.getURIResolver();
            transformerFactory.setURIResolver((URIResolver)object);
        }
        object = new ConsoleErrorListener(console);
        transformerFactory.setErrorListener((ErrorListener)object);
        return transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        HashMap<URL, Templates> hashMap = cache;
        synchronized (hashMap) {
            cache.clear();
        }
    }
}

