/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.NoProgressMonitor;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.w2x.processor.CanceledException;
import com.xmlmind.w2x.processor.ConvertStep;
import com.xmlmind.w2x.processor.EditStep;
import com.xmlmind.w2x.processor.LoadStep;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.Plugin;
import com.xmlmind.w2x.processor.ProcessStep;
import com.xmlmind.w2x.processor.RegisterCmds;
import com.xmlmind.w2x.processor.SaveStep;
import com.xmlmind.w2x.processor.SplitStep;
import com.xmlmind.w2x.processor.TransformStep;
import com.xmlmind.w2x.processor.UsageException;
import com.xmlmind.w2x.processor.XPathFunctions;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.xpath.ExprParser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Processor {
    private static final boolean[] resolverInitalized;
    private static final HashMap<String, Plugin> pluginMap;
    private static Plugin[] pluginList;
    private static final String[][] SHORTHAND_OPTION_SPECS;
    private static final HashMap<String, String[]> SHORTHAND_OPTION_MAP;
    private static final String STOCK_FORMATS;
    private static final String OPTIONS_HELP_TEMPLATE = "-o format\n    This option automatically adds all the steps needed to convert\n    input DOCX file to an output file having specified format.\n    Possible formats are: %FORMATS%.\n\n-p name value\n    Set parameter name to value.\n    Use parameter step_name.param_name to parametrize the step\n    called step_name.\n-pu name URL_or_file\n    Same as '-p', except that parameter value URL_or_file is first\n    converted to an URL.\n    URL_or_file is an absolute or relative URL (relative to current\n    '-f' options file if any, to current working directory\n    otherwise) or the filename of an existing file or directory.\n\n-c\n    Add or replace 'convert' step. This step converts input\n    DOCX file to an in-memory XHTML+CSS document.\n-l\n    Add or replace 'load' step. This step, mainly used to test\n    XED scripts, loads input XML file.\n-e xed_URL_or_file\n    Add or replace 'edit' step. This step edits in place input\n    XHTML document using XED script xed_URL_or_file.\n-e2 xed_URL_or_file\n    Add or replace 'edit2' step. This step edits in place input\n    XHTML document using XED script xed_URL_or_file.\n-t xslt_URL_or_file\n    Add or replace 'transform' step. This step transforms input\n    XML document or file using XSLT stylesheet xslt_URL_or_file.\n    The output file is specified by parameter 'transform.out-file'.\n-t2 xslt_URL_or_file\n    Add or replace 'transform2' step. This step transforms input\n    XML document or file using XSLT stylesheet xslt_URL_or_file.\n    The output file is specified by parameter 'transform2.out-file'.\n-s\n    Add or replace 'save' step. This step saves to disk input\n    XHTML document.\n    The output file is specified by parameter 'save.out-file'.\n-step:java_class_name:step_name\n    Add or replace step called step_name by an instance of\n    Java class java_class_name.\n\n-f options_URL_or_file\n    Load one or more of the above options from options_URL_or_file,\n    a plain UTF-8 text file.";
    protected static String optionsHelp;
    public final List<ProcessStep> stepList = new ArrayList<ProcessStep>();
    public final Map<String, String> parameterMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void initResolver(URL uRL) {
        boolean[] blArray = resolverInitalized;
        synchronized (resolverInitalized) {
            if (!resolverInitalized[0]) {
                Object object = XMLCatalogs.resolveURI("w2x:xed/");
                if (object != null) {
                    Processor.resolverInitalized[0] = true;
                } else {
                    if (uRL == null) {
                        uRL = Processor.class.getResource("/w2x_resources/");
                    }
                    if (uRL != null) {
                        object = uRL.toExternalForm();
                        if (!((String)object).endsWith("/")) {
                            object = (String)object + "/";
                        }
                        XMLCatalogs.addRewriteURIEntry("w2x:", (String)object);
                        Processor.resolverInitalized[0] = true;
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerPlugins(Plugin ... pluginArray) {
        HashMap<String, Plugin> hashMap = pluginMap;
        synchronized (hashMap) {
            pluginList = pluginArray;
            pluginMap.clear();
            for (Plugin plugin : pluginList) {
                pluginMap.put(plugin.name, plugin);
            }
            Processor.updateOptionsHelp(pluginList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Plugin[] getPlugins() {
        HashMap<String, Plugin> hashMap = pluginMap;
        synchronized (hashMap) {
            return pluginList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Plugin getPlugin(String string) {
        HashMap<String, Plugin> hashMap = pluginMap;
        synchronized (hashMap) {
            return pluginMap.get(string);
        }
    }

    protected static final void updateOptionsHelp(Plugin[] pluginArray) {
        StringBuilder stringBuilder = new StringBuilder(STOCK_FORMATS);
        if (pluginArray != null) {
            for (Plugin plugin : pluginArray) {
                stringBuilder.append(", ");
                stringBuilder.append(plugin.name);
            }
        }
        optionsHelp = StringUtil.replaceAll(OPTIONS_HELP_TEMPLATE, "%FORMATS%", stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String getOptionsHelp() {
        HashMap<String, Plugin> hashMap = pluginMap;
        synchronized (hashMap) {
            return optionsHelp;
        }
    }

    public Processor() {
        Processor.initResolver(null);
    }

    public int indexOfStep(String string) {
        for (int i = this.stepList.size() - 1; i >= 0; --i) {
            if (!this.stepList.get((int)i).stepName.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int configure(String[] stringArray) throws UsageException {
        return this.configure(stringArray, null);
    }

    protected int configure(String[] stringArray, StringBuilder stringBuilder) throws UsageException {
        Object object;
        Object object2;
        int n;
        int n2;
        this.stepList.clear();
        this.parameterMap.clear();
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            String string = stringArray[n2];
            if ("-f".equals(string)) {
                if (n2 + 1 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                URL object32 = Processor.urlOrFile(stringArray[++n2], null);
                Processor.loadOptionsFile(object32, arrayList);
                continue;
            }
            if ("-c".equals(string) || "-l".equals(string) || "-s".equals(string) || string.startsWith("-step:")) {
                arrayList.add(string);
                continue;
            }
            if ("-o".equals(string) || "-e".equals(string) || "-e2".equals(string) || "-t".equals(string) || "-t2".equals(string)) {
                if (n2 + 1 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                arrayList.add(string);
                arrayList.add(stringArray[++n2]);
                continue;
            }
            if ("-p".equals(string) || "-pu".equals(string)) {
                if (n2 + 2 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                arrayList.add(string);
                arrayList.add(stringArray[++n2]);
                arrayList.add(stringArray[++n2]);
                continue;
            }
            if ("-liststeps".equals(string)) {
                bl = true;
                break;
            }
            if ("-printenv".equals(string) || "-batch".equals(string) || !string.startsWith("-")) break;
            Processor.usage(Msg.msg("unknownOption", string), null);
            break;
        }
        stringArray = arrayList.toArray(StringUtil.EMPTY_LIST);
        arrayList.clear();
        n3 = stringArray.length;
        for (n = 0; n < n3; ++n) {
            String string = stringArray[n];
            if (string.startsWith("-step:")) {
                arrayList.add(string);
                continue;
            }
            if ("-c".equals(string) || "-l".equals(string) || "-s".equals(string)) {
                arrayList.add(string);
                continue;
            }
            if ("-e".equals(string) || "-e2".equals(string) || "-t".equals(string) || "-t2".equals(string)) {
                if (n + 1 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                arrayList.add(string);
                arrayList.add(stringArray[++n]);
                continue;
            }
            if ("-o".equals(string)) {
                if (n + 1 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                if ((object2 = Processor.getPlugin((String)(object = stringArray[++n]))) != null) {
                    for (String string2 : ((Plugin)object2).w2xArguments) {
                        arrayList.add(string2);
                    }
                    continue;
                }
                arrayList.add(string);
                arrayList.add((String)object);
                continue;
            }
            if ("-p".equals(string) || "-pu".equals(string)) {
                if (n + 2 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                arrayList.add(string);
                arrayList.add(stringArray[++n]);
                arrayList.add(stringArray[++n]);
                continue;
            }
            Processor.usage(Msg.msg("unknownOption", string), null);
        }
        stringArray = arrayList.toArray(StringUtil.EMPTY_LIST);
        arrayList.clear();
        n3 = stringArray.length;
        for (n = 0; n < n3; ++n) {
            String string = stringArray[n];
            if (string.startsWith("-step:")) {
                arrayList.add(string);
                continue;
            }
            if ("-c".equals(string) || "-l".equals(string) || "-s".equals(string)) {
                this.addShorthand(arrayList, string, null);
                continue;
            }
            if ("-e".equals(string) || "-e2".equals(string) || "-t".equals(string) || "-t2".equals(string)) {
                if (n + 1 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                this.addShorthand(arrayList, string, stringArray[++n]);
                continue;
            }
            if ("-o".equals(string)) {
                if (n + 1 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                this.addShorthand(arrayList, stringArray[++n], null);
                continue;
            }
            if ("-p".equals(string) || "-pu".equals(string)) {
                if (n + 2 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                arrayList.add(string);
                arrayList.add(stringArray[++n]);
                arrayList.add(stringArray[++n]);
                continue;
            }
            Processor.usage(Msg.msg("unknownOption", string), null);
        }
        stringArray = arrayList.toArray(StringUtil.EMPTY_LIST);
        arrayList.clear();
        n3 = stringArray.length;
        for (n = 0; n < n3; ++n) {
            Object object3;
            String string = stringArray[n];
            if (string.startsWith("-step:")) {
                object = null;
                object2 = null;
                object3 = StringUtil.split(string, ':');
                if (((String[])object3).length == 3) {
                    object = object3[1].trim();
                    if (((String)object).length() == 0) {
                        object = null;
                    }
                    if (((String)(object2 = object3[2].trim())).length() == 0) {
                        object2 = null;
                    }
                }
                if (object == null || object2 == null) {
                    Processor.usage(Msg.msg("invalidOption", string), null);
                }
                ProcessStep processStep = null;
                try {
                    Class<?> clazz = Class.forName((String)object);
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    processStep = (ProcessStep)constructor.newInstance(object2);
                }
                catch (Exception exception) {
                    Processor.usage(Msg.msg("invalidOption2", string, "cannot instantiate step class '" + (String)object + "': " + ThrowableUtil.reason(exception)), null);
                }
                int n4 = this.indexOfStep((String)object2);
                if (n4 < 0) {
                    this.stepList.add(processStep);
                    continue;
                }
                this.stepList.set(n4, processStep);
                continue;
            }
            if ("-p".equals(string) || "-pu".equals(string)) {
                if (n + 2 >= n3) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string), null);
                }
                object = stringArray[++n];
                object2 = stringArray[++n];
                if ("-pu".equals(string)) {
                    object3 = Processor.urlOrFile((String)object2, null);
                    object2 = ((URL)object3).toExternalForm();
                }
                this.parameterMap.put((String)object, (String)object2);
                continue;
            }
            Processor.usage(Msg.msg("unknownOption", string), null);
        }
        if (this.stepList.size() == 0) {
            ConvertStep convertStep = new ConvertStep("convert");
            convertStep.defaultStep = true;
            this.stepList.add(convertStep);
            EditStep editStep = new EditStep("edit");
            editStep.defaultStep = true;
            this.stepList.add(editStep);
            if (!this.parameterMap.containsKey("edit.xed-url-or-file")) {
                this.parameterMap.put("edit.xed-url-or-file", "w2x:xed/main-styled.xed");
            }
            object = new SaveStep("save");
            ((SaveStep)object).defaultStep = true;
            this.stepList.add((ProcessStep)object);
        }
        if (bl && stringBuilder != null) {
            for (ProcessStep processStep : this.stepList) {
                stringBuilder.append("-step:");
                stringBuilder.append(processStep.getClass().getName());
                stringBuilder.append(':');
                stringBuilder.append(processStep.stepName);
                stringBuilder.append('\n');
                object = processStep.joinAllParameters(this.parameterMap, "-p ", " ", "\n");
                if (object == null) continue;
                stringBuilder.append((String)object);
            }
        }
        return n2;
    }

    protected static void usage(String string, URL uRL) throws UsageException {
        throw new UsageException(Processor.getOptionsHelp(), string, uRL);
    }

    protected static void loadOptionsFile(URL uRL, List<String> list) throws UsageException {
        String string = null;
        try {
            string = URLUtil.loadString(uRL, "UTF-8");
        }
        catch (IOException iOException) {
            Processor.usage(Msg.msg("cannotLoad", URLUtil.toLabel(uRL), ThrowableUtil.reason(iOException)), uRL);
        }
        Processor.parseOptions(string, uRL, list);
    }

    protected static void parseOptions(String string, URL uRL, List<String> list) throws UsageException {
        String[] stringArray = Processor.splitOptions(string);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            URL uRL2;
            String string2;
            String string3 = stringArray[i];
            if ("-c".equals(string3) || "-l".equals(string3) || "-s".equals(string3) || string3.startsWith("-step:")) {
                list.add(string3);
                continue;
            }
            if ("-o".equals(string3) || "-e".equals(string3) || "-e2".equals(string3) || "-t".equals(string3) || "-t2".equals(string3)) {
                if (i + 1 >= n) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string3), uRL);
                }
                list.add(string3);
                string2 = stringArray[++i];
                if (!"-o".equals(string3)) {
                    uRL2 = Processor.urlOrFile(string2, uRL);
                    string2 = uRL2.toExternalForm();
                }
                list.add(string2);
                continue;
            }
            if ("-p".equals(string3) || "-pu".equals(string3)) {
                if (i + 2 >= n) {
                    Processor.usage(Msg.msg("tooFewOptionArgs", string3), uRL);
                }
                list.add("-p");
                list.add(stringArray[++i]);
                string2 = stringArray[++i];
                if ("-pu".equals(string3)) {
                    uRL2 = Processor.urlOrFile(string2, uRL);
                    string2 = uRL2.toExternalForm();
                }
                list.add(string2);
                continue;
            }
            Processor.usage(Msg.msg("unknownOption", string3), uRL);
        }
    }

    public static String[] splitOptions(String string) {
        if (string.indexOf(35) >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : StringUtil.split(string, '\n')) {
                if (string2.trim().startsWith("#")) continue;
                stringBuilder.append(string2);
                stringBuilder.append('\n');
            }
            string = stringBuilder.toString();
        }
        return StringUtil.splitArguments(string);
    }

    protected static URL urlOrFile(String string, URL uRL) throws UsageException {
        URL uRL2 = ProcessStep.urlOrFile(string, uRL);
        if (uRL2 == null) {
            Processor.usage(Msg.msg("notAnURLOrFile", string), uRL);
        }
        return uRL2;
    }

    protected void addShorthand(List<String> list, String string, String string2) throws UsageException {
        String[] stringArray = SHORTHAND_OPTION_MAP.get(string);
        if (stringArray == null) {
            Processor.usage(Msg.msg("invalidOption", string.startsWith("-") ? string : "-o " + string), null);
        }
        for (String string3 : stringArray) {
            if (string3.indexOf("%{0}") >= 0) {
                string3 = StringUtil.replaceAll(string3, "%{0}", string2);
            }
            list.add(string3);
        }
    }

    public static String[] loadOptionsFile(File file) throws UsageException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Processor.loadOptionsFile(FileUtil.fileToURL(file), arrayList);
        return arrayList.toArray(StringUtil.EMPTY_LIST);
    }

    public static String[] parseOptions(String string, URL uRL) throws UsageException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (uRL == null) {
            uRL = FileUtil.fileToURL(new File("."));
        }
        Processor.parseOptions(string, uRL, arrayList);
        return arrayList.toArray(StringUtil.EMPTY_LIST);
    }

    /*
     * WARNING - void declaration
     */
    public Object process(Object object, File file, ProgressMonitor progressMonitor) throws Exception {
        Object object2;
        Object object3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file2 = null;
        if (object instanceof File) {
            file2 = ((File)object).getAbsoluteFile();
        }
        if (file != null) {
            file = file.getAbsoluteFile();
        }
        for (Map.Entry<String, String> object4 : this.parameterMap.entrySet()) {
            object3 = object4.getKey();
            object2 = object4.getValue();
            if (((String)object2).indexOf("%{") >= 0) {
                object2 = Processor.substituteVars((String)object2, file2, file, this.parameterMap);
            }
            hashMap.put((String)object3, (String)object2);
        }
        if (file != null) {
            String string;
            void var7_14;
            ProcessStep processStep = this.stepList.get(0);
            if (processStep instanceof ConvertStep) {
                String string2;
                String string3;
                if (processStep.defaultStep && (string3 = FileUtil.getExtension(file)) != null && (string3.startsWith("htm") || string3.startsWith("shtm")) && !hashMap.containsKey(object3 = processStep.stepName + ".charset")) {
                    hashMap.put((String)object3, "UTF-8");
                }
                if (!hashMap.containsKey(string2 = processStep.stepName + ".xhtml-file")) {
                    object2 = (String)hashMap.get(processStep.stepName + ".charset");
                    object3 = "UTF-8".equalsIgnoreCase((String)object2) ? "html" : "xhtml";
                    File file3 = FileUtil.setExtension(file, (String)object3);
                    hashMap.put(string2, file3.getPath());
                }
            }
            Object var7_12 = null;
            for (int i = this.stepList.size() - 1; !(i < 0 || (object2 = this.stepList.get(i)) instanceof ConvertStep || object2 instanceof LoadStep || object2 instanceof EditStep); --i) {
                if (!(object2 instanceof SaveStep) && !(object2 instanceof TransformStep) && !(object2 instanceof SplitStep)) continue;
                Object object4 = object2;
                break;
            }
            if (var7_14 != null && !hashMap.containsKey(string = var7_14.stepName + ".out-file")) {
                hashMap.put(string, file.getPath());
            }
        }
        return this.executeSteps(object, hashMap, progressMonitor);
    }

    protected static final String substituteVars(String string, File file, File file2, Map<String, String> map) {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while ((n2 = string.indexOf("%{", n3)) >= 0 && (n = string.indexOf(125, n2 + 2)) >= 0) {
            if (n2 > n3) {
                stringBuilder.append(string.substring(n3, n2));
            }
            n3 = n + 1;
            String string2 = string.substring(n2 + 2, n);
            String string3 = map.get(string2);
            if (string3 == null && (string3 = System.getProperty(string2)) == null) {
                URL uRL = null;
                File file3 = null;
                if ("i".equals(string2) || string2.startsWith("~") && string2.endsWith("i")) {
                    uRL = file == null ? null : FileUtil.fileToURL(file);
                } else if ("o".equals(string2) || string2.startsWith("~") && string2.endsWith("o")) {
                    uRL = file2 == null ? null : FileUtil.fileToURL(file2);
                } else if ("I".equals(string2) || string2.startsWith("~") && string2.endsWith("I")) {
                    file3 = file;
                } else if ("O".equals(string2) || string2.startsWith("~") && string2.endsWith("O")) {
                    file3 = file2;
                }
                if (uRL != null || file3 != null) {
                    String string4 = null;
                    if (string2.startsWith("~") && (string4 = string2.substring(1, string2.length() - 1)).length() == 0) {
                        string4 = null;
                    }
                    string3 = uRL != null ? Processor.urlVarValue(uRL, string4) : Processor.fileVarValue(file3, string4);
                }
            }
            if (string3 == null) {
                string3 = "";
            }
            stringBuilder.append(string3);
        }
        if (n3 < string.length()) {
            stringBuilder.append(string.substring(n3));
        }
        return stringBuilder.toString();
    }

    protected static final String urlVarValue(URL uRL, String string) {
        Object object = null;
        if (string == null) {
            object = uRL.toExternalForm();
        } else if ("n".equals(string)) {
            if ((uRL = URLUtil.setRawExtension(uRL, null)) != null) {
                object = URLUtil.getRawBaseName(uRL);
            }
        } else if ("x".equals(string)) {
            object = URLUtil.getRawExtension(uRL);
            if (object != null && ((String)object).length() > 0) {
                object = "." + (String)object;
            }
        } else if ("p".equals(string)) {
            if ((uRL = URLUtil.getParent(uRL)) != null) {
                object = uRL.toExternalForm();
            }
        } else if ("nx".equals(string)) {
            object = URLUtil.getRawBaseName(uRL);
        } else if ("pn".equals(string)) {
            if ((uRL = URLUtil.setRawExtension(uRL, null)) != null) {
                object = uRL.toExternalForm();
            }
        } else if ("pnx".equals(string)) {
            object = uRL.toExternalForm();
        }
        return object;
    }

    protected static final String fileVarValue(File file, String string) {
        assert (file.isAbsolute());
        Object object = null;
        if (string == null) {
            object = file.getPath();
        } else if ("n".equals(string)) {
            object = FileUtil.setExtension(file, null).getName();
        } else if ("x".equals(string)) {
            object = FileUtil.getExtension(file);
            if (object != null && ((String)object).length() > 0) {
                object = "." + (String)object;
            }
        } else if ("p".equals(string)) {
            object = file.getParent();
        } else if ("nx".equals(string)) {
            object = file.getName();
        } else if ("pn".equals(string)) {
            object = FileUtil.setExtension(file, null).getPath();
        } else if ("pnx".equals(string)) {
            object = file.getPath();
        }
        return object;
    }

    public static final String fileURLToPath(String string) {
        try {
            URL uRL = URLUtil.createURL(string);
            File file = URLUtil.urlToFile(uRL);
            if (file != null) {
                string = file.getPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public Object executeSteps(Object object, Map<String, String> map, ProgressMonitor progressMonitor) throws Exception {
        if (progressMonitor == null) {
            progressMonitor = new NoProgressMonitor();
        }
        Object object2 = null;
        Object[] objectArray = new Object[]{object};
        int[] nArray = new int[1];
        progressMonitor.start();
        try {
            if (progressMonitor.stepCount(this.stepList.size())) {
                for (ProcessStep processStep : this.stepList) {
                    processStep.process(objectArray, map, nArray, progressMonitor);
                }
                object2 = objectArray[0];
            }
        }
        catch (CanceledException canceledException) {
            progressMonitor.message(canceledException.getMessage(), Console.MessageType.INFO);
        }
        catch (Exception exception) {
            boolean bl = exception instanceof NullPointerException || exception instanceof IndexOutOfBoundsException;
            progressMonitor.message(Msg.msg("conversionFailed", bl ? ThrowableUtil.detailedReason(exception) : ThrowableUtil.reason(exception)), Console.MessageType.ERROR);
            throw exception;
        }
        finally {
            progressMonitor.stop();
        }
        return object2;
    }

    static {
        ExprParser.setSimpleFunctionTable(Namespace.NONE, new XPathFunctions());
        RegisterCmds.registerAll();
        resolverInitalized = new boolean[1];
        pluginMap = new HashMap();
        pluginList = Plugin.EMPTY_LIST;
        SHORTHAND_OPTION_SPECS = new String[][]{{"-c", "-step:com.xmlmind.w2x.processor.ConvertStep:convert"}, {"-l", "-step:com.xmlmind.w2x.processor.LoadStep:load"}, {"-s", "-step:com.xmlmind.w2x.processor.SaveStep:save"}, {"-e", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "%{0}"}, {"-e2", "-step:com.xmlmind.w2x.processor.EditStep:edit2", "-pu", "edit2.xed-url-or-file", "%{0}"}, {"-t", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "%{0}"}, {"-t2", "-step:com.xmlmind.w2x.processor.TransformStep:transform2", "-pu", "transform2.xslt-url-or-file", "%{0}"}, {"docbook", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/docbook.xslt"}, {"docbook5", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.create-mathml-object", "no", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/docbook5.xslt"}, {"assembly", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.create-mathml-object", "no", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/docbook5.xslt", "-p", "transform.hierarchyName", "book", "-p", "transform.docbook-version", "5.1", "-p", "transform.out-file", "%{~pnO}.db51", "-step:com.xmlmind.w2x.processor.TransformStep:transform2", "-pu", "transform2.xslt-url-or-file", "w2x:xslt/assembly.xslt", "-p", "transform2.output-path", "%{~po}", "-p", "transform2.output-name", "%{~nO}", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}.db51"}, {"topic", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.create-mathml-object", "no", "-p", "convert.set-column-number", "yes", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/topic.xslt"}, {"map", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.create-mathml-object", "no", "-p", "convert.set-column-number", "yes", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/topic.xslt", "-p", "transform.single-topic", "no", "-p", "transform.out-file", "%{~pnO}.dita", "-step:com.xmlmind.w2x.processor.TransformStep:transform2", "-pu", "transform2.xslt-url-or-file", "w2x:xslt/map.xslt", "-p", "transform2.output-path", "%{~po}", "-p", "transform2.topic-type", "%{transform.topic-type}", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}.dita"}, {"bookmap", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.create-mathml-object", "no", "-p", "convert.set-column-number", "yes", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/topic.xslt", "-p", "transform.single-topic", "no", "-p", "transform.out-file", "%{~pnO}.dita", "-step:com.xmlmind.w2x.processor.TransformStep:transform2", "-pu", "transform2.xslt-url-or-file", "w2x:xslt/bookmap.xslt", "-p", "transform2.output-path", "%{~po}", "-p", "transform2.topic-type", "%{transform.topic-type}", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}.dita"}, {"xhtml_css", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main-styled.xed", "-step:com.xmlmind.w2x.processor.SaveStep:save"}, {"xhtml_strict", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml_strict.xslt"}, {"xhtml_loose", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.before-save.allow-flow", "yes", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml_loose.xslt"}, {"xhtml1_1", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml1_1.xslt"}, {"xhtml5", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.create-mathml-object", "no", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.before-save.allow-flow", "yes", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml5.xslt"}, {"frameset", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main-styled.xed", "-p", "edit.remove-pis.except", "counter", "-step:com.xmlmind.w2x.processor.SplitStep:split"}, {"webhelp", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main-styled.xed", "-pu", "edit.before.remove-pis", "w2x:xed/index.xed", "-p", "edit.remove-pis.except", "counter", "-step:com.xmlmind.w2x.processor.WebHelpStep:webhelp"}, {"epub", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.version", "1.1", "-p", "convert.create-mathml-object", "no", "-p", "convert.lower-case-resource-names", "true", "-p", "convert.xhtml-file", "%{~pnO}__epub/%{~nO}.xhtml", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main-styled.xed", "-p", "edit.remove-pis.except", "counter", "-p", "edit.do.expand-tabs", "", "-step:com.xmlmind.w2x.processor.EpubStep:epub"}, {"frameset_strict", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.do.sections", "", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml_strict.xslt", "-p", "transform.out-file", "%{~pnO}_tmp.xhtml", "-step:com.xmlmind.w2x.processor.LoadStep:load", "-step:com.xmlmind.w2x.processor.SplitStep:split", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}_tmp.xhtml"}, {"frameset_loose", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.before-save.allow-flow", "yes", "-p", "edit.do.sections", "", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml_loose.xslt", "-p", "transform.out-file", "%{~pnO}_tmp.xhtml", "-step:com.xmlmind.w2x.processor.LoadStep:load", "-step:com.xmlmind.w2x.processor.SplitStep:split", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}_tmp.xhtml"}, {"frameset1_1", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.do.sections", "", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml1_1.xslt", "-p", "transform.out-file", "%{~pnO}_tmp.xhtml", "-step:com.xmlmind.w2x.processor.LoadStep:load", "-step:com.xmlmind.w2x.processor.SplitStep:split", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}_tmp.xhtml"}, {"frameset5", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.create-mathml-object", "no", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.before-save.allow-flow", "yes", "-p", "edit.do.sections", "", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml5.xslt", "-p", "transform.out-file", "%{~pnO}_tmp.xhtml", "-step:com.xmlmind.w2x.processor.LoadStep:load", "-step:com.xmlmind.w2x.processor.SplitStep:split", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}_tmp.xhtml"}, {"epub1_1", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.create-mathml-object", "no", "-p", "convert.lower-case-resource-names", "true", "-p", "convert.xhtml-file", "%{~pnO}__epub/%{~nO}.xhtml", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.do.sections", "", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml1_1.xslt", "-p", "transform.out-file", "%{~pnO}__epub/%{~nO}.xhtml", "-step:com.xmlmind.w2x.processor.LoadStep:load", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}__epub/%{~nO}.xhtml", "-step:com.xmlmind.w2x.processor.EpubStep:epub"}, {"webhelp_strict", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.do.sections", "", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml_strict.xslt", "-p", "transform.discard-index-terms", "no", "-p", "transform.out-file", "%{~pnO}_tmp.xhtml", "-step:com.xmlmind.w2x.processor.LoadStep:load", "-step:com.xmlmind.w2x.processor.WebHelpStep:webhelp", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}_tmp.xhtml"}, {"webhelp_loose", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.before-save.allow-flow", "yes", "-p", "edit.do.sections", "", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml_loose.xslt", "-p", "transform.discard-index-terms", "no", "-p", "transform.out-file", "%{~pnO}_tmp.xhtml", "-step:com.xmlmind.w2x.processor.LoadStep:load", "-step:com.xmlmind.w2x.processor.WebHelpStep:webhelp", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}_tmp.xhtml"}, {"webhelp1_1", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.do.sections", "", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml1_1.xslt", "-p", "transform.discard-index-terms", "no", "-p", "transform.out-file", "%{~pnO}_tmp.xhtml", "-step:com.xmlmind.w2x.processor.LoadStep:load", "-step:com.xmlmind.w2x.processor.WebHelpStep:webhelp", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}_tmp.xhtml"}, {"webhelp5", "-step:com.xmlmind.w2x.processor.ConvertStep:convert", "-p", "convert.create-mathml-object", "no", "-step:com.xmlmind.w2x.processor.EditStep:edit", "-pu", "edit.xed-url-or-file", "w2x:xed/main.xed", "-p", "edit.before-save.allow-flow", "yes", "-p", "edit.do.sections", "", "-p", "edit.title.keep-title", "yes", "-step:com.xmlmind.w2x.processor.TransformStep:transform", "-pu", "transform.xslt-url-or-file", "w2x:xslt/xhtml5.xslt", "-p", "transform.discard-index-terms", "no", "-p", "transform.out-file", "%{~pnO}_tmp.xhtml", "-step:com.xmlmind.w2x.processor.LoadStep:load", "-step:com.xmlmind.w2x.processor.WebHelpStep:webhelp", "-step:com.xmlmind.w2x.processor.DeleteFilesStep:cleanUp", "-p", "cleanUp.files", "%{~pnO}_tmp.xhtml"}};
        SHORTHAND_OPTION_MAP = new HashMap();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String[] stringArray : SHORTHAND_OPTION_SPECS) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            SHORTHAND_OPTION_MAP.put(stringArray[0], stringArray2);
            if (stringArray[0].startsWith("-")) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[0]);
        }
        STOCK_FORMATS = stringBuilder.toString();
        Processor.updateOptionsHelp(null);
    }
}

