/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.packaging.Part;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.XHTMLVersion;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentTypeDeclaration;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixPreferences;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class Util {
    private static final Name PART_PROP = Name.get(Constants.RELATIONSHIPS_NS[0], "PART");
    private static final DecimalFormat LENGTH_FORMAT = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.US));
    private static final int[] ROMAN_SPECIAL_NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN_UPPER_CASE_LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final String[] ROMAN_LOWER_CASE_LETTERS = new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"};

    private Util() {
    }

    public static void setPartProperty(Document document, Part part) {
        document.putProperty(PART_PROP, part);
    }

    public static Part getPartProperty(Node node) {
        Part part = null;
        Document document = node.getDocument();
        if (document != null) {
            part = (Part)document.getProperty(PART_PROP);
        }
        return part;
    }

    public static void setDocumentType(Document document, XHTMLVersion xHTMLVersion) {
        document.insertChild(document.getFirstChild(), new DocumentTypeDeclaration("html", xHTMLVersion.getPublicId(), xHTMLVersion.getSystemId(), null));
    }

    public static PrefixPreferences createPrefixPreferences(int n) {
        PrefixPreferences prefixPreferences = new PrefixPreferences();
        prefixPreferences.add(Constants.WORDPROCESSINGML_NS[n], "w");
        prefixPreferences.add(Constants.RELATIONSHIPS_NS[n], "r");
        prefixPreferences.add(Constants.DRAWINGML_WORDPROCESSING_NS[n], "wp");
        prefixPreferences.add(Constants.DRAWINGML_MAIN_NS[n], "a");
        prefixPreferences.add(Constants.DRAWINGML_PICTURE_NS[n], "pic");
        prefixPreferences.add(Constants.DRAWINGML_SVG_NS[n], "asvg");
        prefixPreferences.add(Constants.CORE_PROPERTIES_NS[n], "cp");
        prefixPreferences.add(Constants.MATH_NS[n], "m");
        prefixPreferences.add(Constants.MARKUP_COMPATIBILITY_NS[n], "mc");
        prefixPreferences.add(Constants.VML_NS, "v");
        prefixPreferences.add(Constants.OFFICE_NS, "o");
        return prefixPreferences;
    }

    public static void appendText(String string, Element element) {
        Node node = element.getLastChild();
        if (node != null && node.getType() == Node.Type.TEXT) {
            ((Text)node).appendText(string);
        } else {
            element.appendChild(new Text(string));
        }
    }

    public static Element findAncestor(Element element, Name name) {
        Element element2 = null;
        for (element = element.getParentElement(); element != null; element = element.getParentElement()) {
            if (element.getName() != name) continue;
            element2 = element;
            break;
        }
        return element2;
    }

    public static Element findDescendant(Element element, Name ... nameArray) {
        Name name;
        Element element2;
        Element element3 = null;
        int n = nameArray.length - 1;
        for (int i = 0; i <= n && (element2 = Util.findDescendant(element, name = nameArray[i], false)) != null; ++i) {
            if (i == n) {
                element3 = element2;
                break;
            }
            element = element2;
        }
        return element3;
    }

    public static Element findDescendant(Element element, Name name, boolean bl) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element3 = (Element)node;
            if (element3.getName() == name) {
                return element3;
            }
            if (!bl || (element2 = Util.findDescendant(element3, name, true)) == null) continue;
            return element2;
        }
        return null;
    }

    public static void findAllDescendants(Element element, Name name, boolean bl, List<Element> list) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            if (element2.getName() == name) {
                list.add(element2);
            }
            if (!bl) continue;
            Util.findAllDescendants(element2, name, true, list);
        }
    }

    public static String getAnyAttribute(Element element, Name ... nameArray) {
        for (Name name : nameArray) {
            String string = element.getAttribute(name);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static String getNonEmptyAttribute(Element element, Name name) {
        String string = element.getAttribute(name);
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    public static String getNonEmptyTokenAttribute(Element element, Name name) {
        String string = element.getAttribute(name);
        if (string != null && (string = XMLText.collapseWhiteSpace(string)).length() == 0) {
            string = null;
        }
        return string;
    }

    public static long getLengthAttribute(Element element, Name name, long l) {
        long l2 = l;
        String string = element.getAttribute(name);
        if (string != null) {
            try {
                l2 = Long.parseLong(string.trim());
                l2 = Util.emuToPx(l2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l2;
    }

    public static long emuToPx(long l) {
        return (l * 96L + 914399L) / 914400L;
    }

    public static double getPercentageAttribute(Element element, Name name, double d) {
        double d2 = d;
        String string = element.getAttribute(name);
        if (string != null) {
            string = string.trim();
            try {
                d2 = string.endsWith("%") ? Double.parseDouble(string.substring(0, string.length() - 1)) : (double)Integer.parseInt(string) / 1000.0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d2;
    }

    public static String checkIntAttribute(Element element, Name name) {
        return Util.checkIntAttribute(element, name, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static String checkIntAttribute(Element element, Name name, int n, int n2) {
        String string = element.getAttribute(name);
        if (string != null) {
            try {
                int n3 = Integer.parseInt(string);
                string = n3 < n || n3 > n2 ? null : Integer.toString(n3);
            }
            catch (NumberFormatException numberFormatException) {
                string = null;
            }
        }
        return string;
    }

    public static void putStyleProperty(Element element, String string, String string2) {
        String string3 = element.getAttribute(Constants.STYLE_ATTR);
        if (string3 == null) {
            if (string2 == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(": ");
            stringBuilder.append(string2);
            stringBuilder.append(';');
            string3 = stringBuilder.toString();
        } else {
            string3 = Util.putStyleProperty(string3, string, string2);
        }
        element.putAttribute(Constants.STYLE_ATTR, string3);
    }

    public static String putStyleProperty(String string, String string2, String string3) {
        String string4 = string2 + ":";
        int n = string.indexOf(string4);
        int n2 = -1;
        if (n < 0) {
            if (string3 == null) {
                return string;
            }
        } else {
            n2 = string.indexOf(59, n + string4.length());
            n2 = n2 < 0 ? string.length() : ++n2;
        }
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.delete(n, n2);
            if (string3 != null) {
                stringBuilder.insert(n, ';');
                stringBuilder.insert(n, string3);
                stringBuilder.insert(n, ' ');
                stringBuilder.insert(n, string4);
                if (n > 0) {
                    stringBuilder.insert(n, ' ');
                }
            }
            return stringBuilder.toString().trim();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string4);
        stringBuilder.append(' ');
        stringBuilder.append(string3);
        stringBuilder.append(';');
        String string5 = stringBuilder.toString();
        Object[] objectArray = Util.splitStyleProps(string);
        int n3 = Arrays.binarySearch(objectArray, string5);
        if (n3 >= 0) {
            objectArray[n3] = string5;
        } else {
            objectArray = StringList.insertAt((String[])objectArray, string5, -(n3 + 1));
        }
        return Util.joinStyleProps((String[])objectArray);
    }

    public static String getStyleProperty(Element element, String string) {
        String string2 = element.getAttribute(Constants.STYLE_ATTR);
        if (string2 == null) {
            return null;
        }
        return Util.getStyleProperty(string2, string);
    }

    public static String getStyleProperty(String string, String object) {
        int n = string.indexOf((String)(object = (String)object + ":"));
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(59, n += ((String)object).length());
        String string2 = n2 < 0 ? string.substring(n) : string.substring(n, n2);
        if ((string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public static String checkBorderWidth(String string) {
        try {
            double d = Util.convertLengthToPx(string);
            if (d > 0.0 && d < 1.0) {
                string = "1px";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string;
    }

    public static int lengthToPx(String string) {
        int n = -1;
        try {
            double d = Util.convertLengthToPx(string);
            n = (int)Math.rint(d);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private static double convertLengthToPx(String string) throws NumberFormatException {
        double d = string.endsWith("in") ? Util.parseLength(string) * 96.0 : (string.endsWith("cm") ? Util.parseLength(string) / 2.54 * 96.0 : (string.endsWith("mm") ? Util.parseLength(string) / 25.4 * 96.0 : (string.endsWith("pt") ? Util.parseLength(string) / 72.0 * 96.0 : (string.endsWith("pc") ? Util.parseLength(string) / 6.0 * 96.0 : (string.endsWith("px") ? Util.parseLength(string) : Double.parseDouble(string))))));
        return d;
    }

    private static double parseLength(String string) throws NumberFormatException {
        return Double.parseDouble(string.substring(0, string.length() - 2));
    }

    public static boolean hasUnit(String string) {
        return string != null && (string.endsWith("pt") || string.endsWith("in") || string.endsWith("mm") || string.endsWith("cm") || string.endsWith("pc") || string.endsWith("pi"));
    }

    public static String parsePt(String string, int n) {
        return Util.parsePt(string, n, false);
    }

    public static String parsePt(String string, int n, boolean bl) {
        double d = Util.doParsePt(string, n, bl);
        if (Double.isNaN(d)) {
            return null;
        }
        return Util.formatDouble(d) + "pt";
    }

    public static double doParsePt(String string, int n, boolean bl) {
        double d = Double.NaN;
        try {
            int n2 = string.length();
            if (n2 > 0 && Character.isDigit(string.charAt(n2 - 1))) {
                d = Double.parseDouble(string);
                if (n > 1) {
                    d /= (double)n;
                }
            } else if (n2 > 2) {
                d = Double.parseDouble(string.substring(0, n2 - 2));
                if (!string.endsWith("pt")) {
                    if (string.endsWith("in")) {
                        d *= 72.0;
                    } else if (string.endsWith("mm")) {
                        d = d / 25.4 * 72.0;
                    } else if (string.endsWith("cm")) {
                        d = d / 2.54 * 72.0;
                    } else if (string.endsWith("pc") || string.endsWith("pi")) {
                        d *= 12.0;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!Double.isNaN(d) && bl) {
            d = -d;
        }
        return d;
    }

    public static String formatDouble(double d) {
        return LENGTH_FORMAT.format(d);
    }

    public static String parseEm(String string, int n) {
        return Util.parseEm(string, n, false);
    }

    public static String parseEm(String string, int n, boolean bl) {
        try {
            double d = Double.parseDouble(string);
            if (n > 1) {
                d /= (double)n;
            }
            if (bl) {
                d = -d;
            }
            return Util.formatDouble(d) + "em";
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String toCSSString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        if (string.indexOf(34) >= 0) {
            string = StringUtil.replaceAll(string, "\"", "\\\"");
        }
        stringBuilder.append(string);
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String toCSSURL(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("url(");
        stringBuilder.append(string);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static void addClass(Element element, String string) {
        Util.addClass(element, string, false);
    }

    public static void addClass(Element element, String string, boolean bl) {
        String string2 = element.getAttribute(Constants.CLASS_ATTR);
        if (string2 == null) {
            string2 = string;
        } else {
            String[] stringArray = XMLText.splitList(string2);
            int n = StringList.indexOf(stringArray, string);
            if (n < 0) {
                stringArray = bl ? StringList.prepend(stringArray, string) : StringList.append(stringArray, string);
                string2 = StringUtil.join(' ', stringArray);
            }
        }
        element.putAttribute(Constants.CLASS_ATTR, string2);
    }

    public static void removeClass(Element element, String string) {
        String string2 = element.getAttribute(Constants.CLASS_ATTR);
        if (string2 == null) {
            return;
        }
        String[] stringArray = XMLText.splitList(string2);
        int n = StringList.indexOf(stringArray, string);
        if (n < 0) {
            return;
        }
        if ((stringArray = StringList.removeAt(stringArray, n)).length == 0) {
            element.removeAttribute(Constants.CLASS_ATTR);
        } else {
            element.putAttribute(Constants.CLASS_ATTR, StringUtil.join(' ', stringArray));
        }
    }

    public static void addStyleProp(Element element, String string, String string2) {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        String string3 = stringBuilder.toString();
        String string4 = element.getAttribute(Constants.STYLE_ATTR);
        if (string4 == null) {
            objectArray = new String[]{string3};
        } else {
            objectArray = Util.splitStyleProps(string4);
            int n = Util.indexOfStyleProp((String[])objectArray, string);
            if (n < 0) {
                n = Arrays.binarySearch(objectArray, string3);
                if (n >= 0) {
                    objectArray[n] = string3;
                } else {
                    objectArray = StringList.insertAt((String[])objectArray, string3, -(n + 1));
                }
            }
        }
        element.putAttribute(Constants.STYLE_ATTR, Util.joinStyleProps((String[])objectArray));
    }

    public static String[] splitStyleProps(String string) {
        return Util.splitStyleProps(string, null);
    }

    public static String[] splitStyleProps(String string, int[] nArray) {
        String string2;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\u0000';
        StringBuilder stringBuilder = null;
        int n2 = string.length();
        int n3 = n = nArray == null ? 0 : nArray[0];
        block4: while (n < n2) {
            char c2 = string.charAt(n);
            switch (c2) {
                case ';': 
                case '}': {
                    if (c != '\u0000') {
                        stringBuilder.append(c2);
                        break;
                    }
                    if (stringBuilder == null) break;
                    String string3 = stringBuilder.toString().trim();
                    if (string3.length() > 0) {
                        arrayList.add(string3);
                    }
                    stringBuilder = null;
                    if (c2 != '}') break;
                    ++n;
                    break block4;
                }
                case '\"': 
                case '\'': {
                    if (c != '\u0000') {
                        int n4;
                        if (c2 == c && ((n4 = stringBuilder.length() - 1) < 0 || stringBuilder.charAt(n4) != '\\')) {
                            c = '\u0000';
                        }
                    } else {
                        c = c2;
                    }
                }
                default: {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(c2);
                }
            }
            ++n;
        }
        if (nArray != null) {
            nArray[0] = n;
        }
        if (stringBuilder != null && (string2 = stringBuilder.toString().trim()).length() > 0) {
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    private static int indexOfStyleProp(String[] stringArray, String string) {
        String string2 = string + ":";
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith(string2)) continue;
            return i;
        }
        return -1;
    }

    private static String joinStyleProps(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : stringArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public static String getStyleProp(Element element, String string) {
        String string2 = element.getAttribute(Constants.STYLE_ATTR);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = Util.splitStyleProps(string2);
        int n = Util.indexOfStyleProp(stringArray, string);
        if (n < 0) {
            return null;
        }
        String string3 = stringArray[n].substring(string.length() + 1).trim();
        if (string3.length() == 0) {
            string3 = null;
        }
        return string3;
    }

    public static void removeStyleProp(Element element, String string) {
        String string2 = element.getAttribute(Constants.STYLE_ATTR);
        if (string2 == null) {
            return;
        }
        String[] stringArray = Util.splitStyleProps(string2);
        int n = Util.indexOfStyleProp(stringArray, string);
        if (n < 0) {
            return;
        }
        if ((stringArray = StringList.removeAt(stringArray, n)).length == 0) {
            element.removeAttribute(Constants.STYLE_ATTR);
        } else {
            element.putAttribute(Constants.STYLE_ATTR, Util.joinStyleProps(stringArray));
        }
    }

    public static String normalizeFieldCode(String object) {
        String string;
        String string2;
        int n = ((String)(object = Util.trimLeft((String)object))).indexOf(32);
        if (n < 0) {
            string2 = object;
            string = null;
        } else {
            string2 = ((String)object).substring(0, n);
            string = ((String)object).substring(n);
        }
        String string3 = string2.toUpperCase(Locale.US);
        if (!string3.equals(string2)) {
            object = string3;
            if (string != null) {
                object = (String)object + string;
            }
        }
        return object;
    }

    public static final String trimLeft(String string) {
        if (string.indexOf(32) != 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() > 0 && stringBuilder.charAt(0) == ' ') {
            stringBuilder.deleteCharAt(0);
        }
        return stringBuilder.toString();
    }

    public static String processFieldCodeIdref(String string, Map<String, String> map) {
        String[] stringArray = new String[]{"HYPERLINK", "\\l", "NOTEREF", null, "PAGEREF", null, "REF", null};
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            if (!string.startsWith(string2)) continue;
            String[] stringArray2 = StringUtil.splitArguments(string);
            if (stringArray2.length < 2 || !stringArray2[0].equals(string2)) break;
            int n = -1;
            if (string3 == null) {
                n = 1;
            } else {
                n = StringList.indexOf(stringArray2, string3);
                if (n > 0) {
                    ++n;
                }
            }
            if (n <= 0 || n >= stringArray2.length) break;
            if (map != null) {
                String string4 = map.get(stringArray2[n]);
                if (string4 != null) {
                    stringArray2[n] = string4;
                }
            } else {
                stringArray2[n] = XMLText.checkId(stringArray2[n]);
            }
            return StringUtil.joinArguments(stringArray2);
        }
        return string;
    }

    public static Node unwrapElement(Element element) {
        Node node = null;
        Tree tree = element.getParent();
        if (tree != null) {
            Node node2 = element.getNextSibling();
            tree.removeChild(element);
            Node node3 = element.getFirstChild();
            while (node3 != null) {
                Node node4 = node3.getNextSibling();
                element.removeChild(node3);
                tree.insertChild(node2, node3);
                if (node == null) {
                    node = node3;
                }
                node3 = node4;
            }
        }
        return node;
    }

    public static void numberToAlpha(int n, boolean bl, StringBuilder stringBuilder) {
        if (n <= 0) {
            stringBuilder.append(Integer.toString(n));
            return;
        }
        int n2 = stringBuilder.length();
        while (n > 0) {
            int n3 = --n % 26;
            char c = (char)(65 + n3);
            if (bl) {
                c = Character.toLowerCase(c);
            }
            stringBuilder.insert(n2, c);
            n /= 26;
        }
    }

    public static void numberToRoman(int n, boolean bl, StringBuilder stringBuilder) {
        if (n <= 0) {
            stringBuilder.append(Integer.toString(n));
            return;
        }
        String[] stringArray = bl ? ROMAN_LOWER_CASE_LETTERS : ROMAN_UPPER_CASE_LETTERS;
        for (int i = 0; i < ROMAN_SPECIAL_NUMBERS.length; ++i) {
            while (n >= ROMAN_SPECIAL_NUMBERS[i]) {
                stringBuilder.append(stringArray[i]);
                n -= ROMAN_SPECIAL_NUMBERS[i];
            }
        }
    }
}

