/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

final class SpanHelper {
    private Row[] rows = new Row[0];
    private int rowCount = 0;
    private int nextRow = 0;

    SpanHelper() {
    }

    public void reset() {
        for (int i = 0; i < this.rowCount; ++i) {
            this.rows[i].reset();
        }
        this.nextRow = 0;
        this.rowCount = 0;
    }

    public void addRow() {
        if (this.nextRow == this.rowCount) {
            this.checkRowCapacity(++this.rowCount);
        }
        ++this.nextRow;
    }

    public void addCell(int n, int n2) {
        this.addCell(n, n2, -1);
    }

    public void addCell(int n, int n2, int n3) {
        Row row;
        int n4;
        int n5 = this.nextRow - 1;
        int n6 = n5 + n;
        if (n6 > this.rowCount) {
            this.checkRowCapacity(n6);
            this.rowCount = n6;
        }
        if (n3 > (n4 = (row = this.rows[n5]).getNextColumn())) {
            n4 = n3;
        }
        int n7 = n4 + n2;
        for (int i = n5; i < n6; ++i) {
            Row row2 = this.rows[i];
            if (n7 > row2.cellCount) {
                row2.checkCellCapacity(n7);
                row2.cellCount = n7;
            }
            for (int j = n4; j < n7; ++j) {
                row2.cells[j] = true;
            }
        }
        row.nextColumn = n7;
    }

    private void checkRowCapacity(int n) {
        if (n <= this.rows.length) {
            return;
        }
        int n2 = Math.max(n, 2 * this.rows.length);
        Row[] rowArray = new Row[n2];
        System.arraycopy(this.rows, 0, rowArray, 0, this.rows.length);
        for (int i = this.rows.length; i < n2; ++i) {
            rowArray[i] = new Row();
        }
        this.rows = rowArray;
    }

    public int getNextRow() {
        return this.nextRow;
    }

    public int getNextColumn() {
        return this.nextRow == 0 ? 0 : this.rows[this.nextRow - 1].getNextColumn();
    }

    private static final class Row {
        public boolean[] cells = new boolean[0];
        public int cellCount = 0;
        public int nextColumn = 0;

        private Row() {
        }

        public void reset() {
            for (int i = 0; i < this.cellCount; ++i) {
                this.cells[i] = false;
            }
            this.nextColumn = 0;
            this.cellCount = 0;
        }

        public int getNextColumn() {
            int n;
            for (n = this.nextColumn; n < this.cellCount && this.cells[n]; ++n) {
            }
            return n;
        }

        public void checkCellCapacity(int n) {
            if (n <= this.cells.length) {
                return;
            }
            int n2 = Math.max(n, 2 * this.cells.length);
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.cells, 0, blArray, 0, this.cells.length);
            this.cells = blArray;
        }
    }
}

