/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.name.Name;
import java.util.HashMap;
import java.util.Map;

final class SimplifyLang {
    SimplifyLang() {
    }

    public static void process(Document document, String string, String string2) {
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.BODY_ELEM, false);
        if (element2 == null) {
            return;
        }
        HashMap<String, LangCounter> hashMap = new HashMap<String, LangCounter>();
        SimplifyLang.setLangInP(element2, element2.getAttribute(Name.LANG), hashMap);
        String string3 = SimplifyLang.setLang(element2, hashMap);
        if (string != null) {
            element2.putAttribute(Name.LANG, string);
            string3 = string;
        } else if (string2 != null && string3 == null) {
            string3 = string2;
        }
        if (string3 != null) {
            element.putAttribute(Name.LANG, string3);
        }
        SimplifyLang.factorizeLang(element, null);
    }

    private static void setLangInP(Element element, String string, Map<String, LangCounter> map) {
        HashMap<String, LangCounter> hashMap = new HashMap<String, LangCounter>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            if (element2.getName() == Constants.P_ELEM) {
                String string2 = SimplifyLang.doSetLangInP(element2, string, hashMap);
                if (string2 == null) continue;
                LangCounter langCounter = map.get(string2);
                if (langCounter == null) {
                    langCounter = new LangCounter(string2);
                    map.put(string2, langCounter);
                }
                ++langCounter.count;
                continue;
            }
            SimplifyLang.setLangInP(element2, string, hashMap);
        }
    }

    private static String doSetLangInP(Element element, String string, Map<String, LangCounter> map) {
        String string2 = element.getAttribute(Name.LANG);
        if (string2 == null) {
            string2 = string;
        }
        map.clear();
        SimplifyLang.countLangInP(element, string2, map);
        return SimplifyLang.setLang(element, map);
    }

    private static void countLangInP(Element element, String string, Map<String, LangCounter> map) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            if (element2.getName() == Constants.SPAN_ELEM) {
                int n;
                String string2 = element2.getAttribute(Name.LANG);
                if (string2 == null && (string2 = string) != null) {
                    element2.putAttribute(Name.LANG, string2);
                }
                if ((n = SimplifyLang.getTextLength(element2)) == 0) {
                    element2.removeAttribute(Name.LANG);
                    string2 = null;
                }
                if (string2 != null) {
                    LangCounter langCounter = map.get(string2);
                    if (langCounter == null) {
                        langCounter = new LangCounter(string2);
                        map.put(string2, langCounter);
                    }
                    langCounter.count += n;
                }
            }
            SimplifyLang.countLangInP(element2, string, map);
        }
    }

    private static int getTextLength(Element element) {
        int n = 0;
        block7: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    continue block7;
                }
                case TEXT: {
                    char[] cArray = ((Text)node).getTextChars();
                    int n2 = cArray.length;
                    block8: for (int i = 0; i < n2; ++i) {
                        switch (cArray[i]) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': 
                            case '\u00a0': {
                                continue block8;
                            }
                            default: {
                                ++n;
                            }
                        }
                    }
                    continue block7;
                }
                default: {
                    n = 0;
                    break block7;
                }
            }
        }
        return n;
    }

    private static String setLang(Element element, Map<String, LangCounter> map) {
        if (map.size() == 0) {
            element.removeAttribute(Name.LANG);
            return null;
        }
        String string = null;
        int n = 0;
        for (LangCounter langCounter : map.values()) {
            if (langCounter.count <= n) continue;
            n = langCounter.count;
            string = langCounter.lang;
        }
        if (string != null) {
            element.putAttribute(Name.LANG, string);
        }
        return string;
    }

    private static void factorizeLang(Element element, String string) {
        String string2 = element.getAttribute(Name.LANG);
        if (string2 == null) {
            string2 = string;
        } else if (string2.equals(string)) {
            element.removeAttribute(Name.LANG);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            SimplifyLang.factorizeLang((Element)node, string2);
        }
    }

    private static final class LangCounter {
        public final String lang;
        public int count;

        public LangCounter(String string) {
            this.lang = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.lang);
            stringBuilder.append(':');
            stringBuilder.append(Integer.toString(this.count));
            return stringBuilder.toString();
        }
    }
}

