/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.TextNode;
import com.xmlmind.xml.name.Name;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SimplifyAnchors {
    SimplifyAnchors() {
    }

    public static void process(Document document, Pattern pattern) {
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.BODY_ELEM, false);
        if (element2 == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (pattern != null) {
            Matcher matcher = pattern.matcher("");
            SimplifyAnchors.anchorToId(element2, matcher, hashMap);
        }
        SimplifyAnchors.anchorToId(element2, null, hashMap);
        SimplifyAnchors.updateIdrefs(element2, hashMap);
    }

    private static void anchorToId(Element element, Matcher matcher, Map<String, String> map) {
        Object object;
        if (element.getName() == Constants.A_ELEM && (object = element.getAttribute(Constants.ID_ATTR)) != null) {
            boolean bl = false;
            if (matcher != null) {
                matcher.reset((CharSequence)object);
                if (matcher.find()) {
                    bl = true;
                }
            }
            if (!bl) {
                SimplifyAnchors.addId((String)object, element, map);
                element.getParent().removeChild(element);
            }
            return;
        }
        object = element.getFirstChild();
        while (object != null) {
            Node node = ((Node)object).getNextSibling();
            if (((Node)object).getType() == Node.Type.ELEMENT) {
                SimplifyAnchors.anchorToId((Element)object, matcher, map);
            }
            object = node;
        }
    }

    private static boolean addId(String string, Element element, Map<String, String> map) {
        while (element != null) {
            Element element2 = element.getParentElement();
            Element element3 = SimplifyAnchors.precedingIdHolder(element);
            if (element3 == null && element2 != null && SimplifyAnchors.isIdHolder(element2)) {
                SimplifyAnchors.setId(element2, string, map);
                return true;
            }
            Element element4 = SimplifyAnchors.followingIdHolder(element);
            if (element4 != null) {
                SimplifyAnchors.setId(element4, string, map);
                return true;
            }
            if (element3 != null) {
                SimplifyAnchors.setId(element3, string, map);
                return true;
            }
            element = element2;
        }
        return false;
    }

    private static boolean isIdHolder(Element element) {
        String string;
        Name name = element.getName();
        if (name == Constants.P_ELEM) {
            return SimplifyAnchors.hasContents(element);
        }
        if (name == Constants.TD_ELEM || name == Constants.TR_ELEM || name == Constants.TBODY_ELEM || name == Constants.THEAD_ELEM || name == Constants.TABLE_ELEM || name == Constants.BODY_ELEM) {
            return true;
        }
        return name == Constants.DIV_ELEM && ((string = element.getAttribute(Constants.CLASS_ATTR)) == null || string.indexOf("role-footnotes") < 0 && string.indexOf("role-endnotes") < 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean hasContents(Element element) {
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            switch (node.getType()) {
                case TEXT: {
                    if (((Text)node).isXMLSpace()) break;
                    return true;
                }
                case ELEMENT: {
                    Element element2 = (Element)node;
                    Name name = element2.getName();
                    if (name == Constants.IMG_ELEM) {
                        return true;
                    }
                    bl = SimplifyAnchors.hasContents(element2);
                    if (!bl) break;
                    return bl;
                }
            }
            node = node.getNextSibling();
        }
        return bl;
    }

    private static Element precedingIdHolder(Element element) {
        for (Node node = element.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getType() != Node.Type.ELEMENT || !SimplifyAnchors.isIdHolder((Element)node)) continue;
            return (Element)node;
        }
        return null;
    }

    private static Element followingIdHolder(Element element) {
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || !SimplifyAnchors.isIdHolder((Element)node)) continue;
            return (Element)node;
        }
        return null;
    }

    private static void setId(Element element, String string, Map<String, String> map) {
        String string2 = element.getAttribute(Constants.ID_ATTR);
        if (string2 == null) {
            element.putAttribute(Constants.ID_ATTR, string);
        } else {
            map.put(string, string2);
        }
    }

    private static void updateIdrefs(Element element, Map<String, String> map) {
        Object object;
        String string;
        Object object2;
        if (element.getName() == Constants.A_ELEM && (object2 = element.getAttribute(Constants.HREF_ATTR)) != null && ((String)object2).startsWith("#") && (string = map.get(object = ((String)object2).substring(1))) != null && !string.equals(object)) {
            element.putAttribute(Constants.HREF_ATTR, "#" + string);
        }
        block4: for (object2 = element.getFirstChild(); object2 != null; object2 = ((Node)object2).getNextSibling()) {
            switch (((Node)object2).getType()) {
                case PROCESSING_INSTRUCTION: {
                    String string2;
                    String string3;
                    object = (ProcessingInstruction)object2;
                    string = ((ProcessingInstruction)object).getTarget();
                    if (!"field-code".equals(string) && !"field".equals(string) || (string3 = ((TextNode)object).getText()) == null || (string2 = Util.processFieldCodeIdref(string3, map)) == null || string2.equals(string3)) continue block4;
                    ((TextNode)object).setText(string2);
                    continue block4;
                }
                case ELEMENT: {
                    SimplifyAnchors.updateIdrefs((Element)object2, map);
                }
            }
        }
    }
}

