/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.Console;
import com.xmlmind.w2x.docx.packaging.Part;
import com.xmlmind.w2x.docx.toxhtml.BasicPattern;
import com.xmlmind.w2x.docx.toxhtml.Binding;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Msg;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixPreferences;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;

final class RemoveAnnotations {
    private static final String[] SDT_TYPES = new String[]{"bibliography", "citation", "comboBox", "date", "docPartList", "docPartObj", "dropDownList", "equation", "group", "picture", "richText", "text"};
    private static final String[] QNAMES = new String[]{"mc:AlternateContent", "mc:Choice", "mc:Fallback", "w:cellDel", "w:del", "w:docPartCategory", "w:docPartGallery", "w:element", "w:moveFrom", "w:p", "w:pPr", "w:rPr", "w:sdtPr", "w:tcPr", "w:trPr", "w:uri", "w:val"};
    private Name name_mc_AlternateContent;
    private Name name_mc_Choice;
    private Name name_mc_Fallback;
    private Name name_w_cellDel;
    private Name name_w_del;
    private Name name_w_docPartCategory;
    private Name name_w_docPartGallery;
    private Name name_w_element;
    private Name name_w_moveFrom;
    private Name name_w_p;
    private Name name_w_pPr;
    private Name name_w_rPr;
    private Name name_w_sdtPr;
    private Name name_w_tcPr;
    private Name name_w_trPr;
    private Name name_w_uri;
    private Name name_w_val;
    private static final String[] PROCESSING_SPEC = new String[]{"w:tr", "process_w_tr", "w:tc", "process_w_tc", "w:p", "process_w_p", "w:cellIns", "deleteChange", "w:cellMerge", "deleteChange", "w:ins", "unwrapChange", "w:del", "deleteChange", "w:moveFromRangeStart", "deleteChange", "w:moveFrom", "deleteChange", "w:moveFromRangeEnd", "deleteChange", "w:moveToRangeStart", "deleteChange", "w:moveTo", "unwrapChange", "w:moveToRangeEnd", "deleteChange", "w:customXmlDelRangeStart", "deleteChange", "w:customXmlDelRangeEnd", "deleteChange", "w:customXmlInsRangeStart", "deleteChange", "w:customXmlInsRangeEnd", "deleteChange", "w:customXmlMoveFromRangeStart", "deleteChange", "w:customXmlMoveFromRangeEnd", "deleteChange", "w:customXmlMoveToRangeEnd", "deleteChange", "w:customXmlMoveToRangeStart", "deleteChange", "w:pPrChange", "deleteChange", "w:rPrChange", "deleteChange", "w:sectPrChange", "deleteChange", "w:tblGridChange", "deleteChange", "w:tblPrChange", "deleteChange", "w:tblPrExChange", "deleteChange", "w:tcPrChange", "deleteChange", "w:trPrChange", "deleteChange", "w:numberingChange", "deleteChange", "w:commentRangeStart", "delete", "w:commentRangeEnd", "delete", "w:permStart", "delete", "w:permEnd", "delete", "w:proofErr", "delete", "mc:AlternateContent", "process_mc_AlternateContent", "w:customXml", "delete", "w:smartTag", "process_w_smartTag", "w:smartTagPr", "delete", "w:sdt", "process_w_sdt", "w:sdtPr", "delete", "w:sdtEndPr", "delete", "w:sdtContent", "unwrap", "m:oMathPara", "process_m_oMath", "m:oMath", "process_m_oMath"};
    private final int docxVersion;
    private final Console console;
    private final IdentityHashMap<Name, Binding[]> bindingMap;
    private boolean warnAboutRevisions;
    private String docSystemId;
    private int delimitCounter;

    public RemoveAnnotations(int n, Console console) {
        this.docxVersion = n;
        this.console = console;
        this.bindingMap = new IdentityHashMap();
        PrefixPreferences prefixPreferences = Util.createPrefixPreferences(n);
        try {
            Object object;
            Object object2;
            String string;
            String[] stringArray = QNAMES;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                string = stringArray[i];
                object2 = Name.parse(string, true, prefixPreferences);
                if (object2 == null) {
                    throw new RuntimeException("'" + string + "', not a Name");
                }
                object = "name_" + string.replace(':', '_');
                Field field = RemoveAnnotations.class.getDeclaredField((String)object);
                field.set(this, object2);
            }
            int n3 = PROCESSING_SPEC.length;
            for (n2 = 0; n2 < n3; n2 += 2) {
                String string2 = PROCESSING_SPEC[n2];
                string = PROCESSING_SPEC[n2 + 1];
                object2 = BasicPattern.parse(string2, prefixPreferences);
                object = RemoveAnnotations.class.getDeclaredMethod(string, Element.class);
                Binding.bind((BasicPattern)object2, (Method)object, this.bindingMap);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void process(Document document) {
        this.warnAboutRevisions = true;
        this.docSystemId = Part.getDocumentURI(document);
        if (this.docSystemId == null) {
            this.docSystemId = "???";
        }
        this.process(document.getRootElement());
    }

    private Node process(Element element) {
        Node node;
        Method method = Binding.getMethod(this.bindingMap, element);
        if (method != null) {
            try {
                node = (Node)method.invoke((Object)this, element);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            node = this.traverse(element);
        }
        return node;
    }

    private Node traverse(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2;
            Node node3 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT && (node2 = this.process((Element)node)) != null) {
                node3 = node2;
            }
            node = node3;
        }
        return null;
    }

    private Node unwrapChange(Element element) {
        this.warnAboutRevisions();
        return this.unwrap(element);
    }

    private void warnAboutRevisions() {
        if (this.warnAboutRevisions) {
            this.warnAboutRevisions = false;
            if (this.console != null) {
                this.console.showMessage(Msg.msg("containsRevisionInfo", this.docSystemId), Console.MessageType.WARNING);
            }
        }
    }

    private Node unwrap(Element element) {
        return Util.unwrapElement(element);
    }

    private Node deleteChange(Element element) {
        this.warnAboutRevisions();
        return this.delete(element);
    }

    private Node delete(Element element) {
        Tree tree = element.getParent();
        if (tree != null) {
            tree.removeChild(element);
        }
        return null;
    }

    private Node process_w_smartTag(Element element) {
        String string;
        String string2 = element.getAttribute(this.name_w_uri);
        String string3 = element.getAttribute(this.name_w_element);
        if (string2 == null) {
            string = string3;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            stringBuilder.append(string2);
            stringBuilder.append("}");
            stringBuilder.append(string3);
            string = stringBuilder.toString();
        }
        return this.delimit(element, "smartTag", string);
    }

    private Node process_w_sdt(Element element) {
        String string = null;
        Element element2 = Util.findDescendant(element, this.name_w_sdtPr, false);
        if (element2 != null) {
            Namespace namespace = Constants.WORDPROCESSINGML_NS[this.docxVersion];
            for (String string2 : SDT_TYPES) {
                String string3;
                Element element3 = Util.findDescendant(element2, Name.get(namespace, string2), false);
                if (element3 == null) continue;
                string = string2;
                if (!"docPartList".equals(string2) && !"docPartObj".equals(string2)) break;
                StringBuilder stringBuilder = new StringBuilder(string2);
                String string4 = this.getVal(element3, this.name_w_docPartGallery);
                if (string4 != null) {
                    stringBuilder.append("/");
                    stringBuilder.append(string4);
                }
                if ((string3 = this.getVal(element3, this.name_w_docPartCategory)) != null) {
                    if (string4 == null) {
                        stringBuilder.append("/?");
                    }
                    stringBuilder.append("/");
                    stringBuilder.append(string3);
                }
                string = stringBuilder.toString();
                break;
            }
        }
        if (string == null) {
            string = "richText";
        }
        return this.delimit(element, "sdt", string);
    }

    private String getVal(Element element, Name name) {
        String string = null;
        Element element2 = Util.findDescendant(element, name, false);
        if (element2 != null) {
            string = element2.getAttribute(this.name_w_val);
        }
        return string;
    }

    private Node delimit(Element element, String string, String object) {
        if (object == null) {
            object = "";
        }
        object = (String)object + "#" + Integer.toString(this.delimitCounter++);
        ProcessingInstruction processingInstruction = new ProcessingInstruction("begin-" + string, (String)object);
        element.insertChild(element.getFirstChild(), processingInstruction);
        processingInstruction = new ProcessingInstruction("end-" + string, (String)object);
        element.appendChild(processingInstruction);
        return Util.unwrapElement(element);
    }

    private Node process_w_tr(Element element) {
        if (Util.findDescendant(element, this.name_w_trPr, this.name_w_del) != null) {
            return this.delete(element);
        }
        return this.traverse(element);
    }

    private Node process_w_tc(Element element) {
        if (Util.findDescendant(element, this.name_w_tcPr, this.name_w_cellDel) != null) {
            return this.delete(element);
        }
        return this.traverse(element);
    }

    private Node process_w_p(Element element) {
        Node node;
        if (Util.findDescendant(element, this.name_w_pPr, this.name_w_rPr, this.name_w_moveFrom) != null) {
            return this.delete(element);
        }
        Element element2 = Util.findDescendant(element, this.name_w_pPr, this.name_w_rPr, this.name_w_del);
        if (element2 != null && (node = element.getNextSibling()) != null && node.getType() == Node.Type.ELEMENT && ((Element)node).getName() == this.name_w_p) {
            this.delete(element2);
            Element element3 = (Element)node;
            Element element4 = Util.findDescendant(element3, this.name_w_pPr, false);
            if (element4 != null) {
                this.delete(element4);
            }
            Node node2 = element3.getFirstChild();
            Node node3 = element.getFirstChild();
            while (node3 != null) {
                Node node4 = node3.getNextSibling();
                element.removeChild(node3);
                element3.insertChild(node2, node3);
                node3 = node4;
            }
            this.delete(element);
            return element3;
        }
        return this.traverse(element);
    }

    private Node process_mc_AlternateContent(Element element) {
        Element element2 = Util.findDescendant(element, this.name_mc_Choice);
        if (element2 == null || !"v".equals(element2.getAttribute(Constants.REQUIRES_ATTR))) {
            element2 = Util.findDescendant(element, this.name_mc_Fallback);
        }
        if (element2 == null) {
            return this.delete(element);
        }
        Node node = null;
        Tree tree = element.getParent();
        if (tree != null) {
            Node node2 = element.getNextSibling();
            tree.removeChild(element);
            Node node3 = element2.getFirstChild();
            while (node3 != null) {
                Node node4 = node3.getNextSibling();
                element2.removeChild(node3);
                tree.insertChild(node2, node3);
                if (node == null) {
                    node = node3;
                }
                node3 = node4;
            }
        }
        return node;
    }

    private Node process_m_oMath(Element element) {
        Element element2 = element.getParentElement();
        if (element2 != null && element2.getName() == this.name_w_p) {
            return null;
        }
        return this.delete(element);
    }
}

