/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Traversal;
import com.xmlmind.xml.doc.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Range {
    public final int id;
    public final String name;
    public final ProcessingInstruction startPI;
    public final ProcessingInstruction endPI;
    private static final Pattern RANGE_RE = Pattern.compile("\\\\r\\s+((\"[^\"]+\")|(\\S+))");
    private static final PrecedingParaFinder PRECEDING_PARA_FINDER = new PrecedingParaFinder();
    private static final FollowingParaFinder FOLLOWING_PARA_FINDER = new FollowingParaFinder();

    public static Range create(int n, String string) {
        ProcessingInstruction processingInstruction = new ProcessingInstruction("start-range", string);
        ProcessingInstruction processingInstruction2 = new ProcessingInstruction("end-range", string);
        return new Range(n, string, processingInstruction, processingInstruction2);
    }

    private Range(int n, String string, ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        this.id = n;
        this.name = string;
        this.startPI = processingInstruction;
        this.endPI = processingInstruction2;
    }

    public static void simplifyAll(Document document, Map<Integer, Range> map, boolean bl) {
        Cloneable cloneable;
        int n = map.size();
        if (n == 0) {
            return;
        }
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.BODY_ELEM, false);
        if (element2 == null) {
            return;
        }
        if (!bl) {
            cloneable = new HashMap();
            for (Range object : map.values()) {
                ((HashMap)cloneable).put(object.name, object);
            }
            Range.processRangeRefs(element2, (Map<String, Range>)((Object)cloneable));
            for (Range range : ((HashMap)cloneable).values()) {
                Tree tree = range.startPI.getParent();
                if (tree != null) {
                    tree.removeChild(range.startPI);
                }
                if ((tree = range.endPI.getParent()) == null) continue;
                tree.removeChild(range.endPI);
            }
            n -= ((HashMap)cloneable).size();
        }
        if (n > 0) {
            cloneable = new ArrayList();
            Range.collectPIs(element2, cloneable);
            Iterator<Range> iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)((Object)iterator.next());
                if (Range.hasParaAncestor(processingInstruction) || Range.movePIToPara(processingInstruction, "end-range".equals(processingInstruction.getTarget()))) continue;
                processingInstruction.getParent().removeChild(processingInstruction);
            }
        }
    }

    private static void processRangeRefs(Element element, Map<String, Range> map) {
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case PROCESSING_INSTRUCTION: {
                    String string;
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    String string2 = processingInstruction.getTarget();
                    if (!"field-code".equals(string2) && !"field".equals(string2) || (string = Range.processRangeRef(processingInstruction)) == null) continue block4;
                    map.remove(string);
                    continue block4;
                }
                case ELEMENT: {
                    Range.processRangeRefs((Element)node, map);
                }
            }
        }
    }

    private static String processRangeRef(ProcessingInstruction processingInstruction) {
        Matcher matcher;
        String string = null;
        String string2 = processingInstruction.getText();
        if (string2 != null && (string2 = string2.trim()).startsWith("XE") && (matcher = RANGE_RE.matcher(string2)).find(2)) {
            int n = matcher.start(1);
            int n2 = matcher.end(1);
            string = string2.charAt(n) == '\"' ? string2.substring(n + 1, n2 - 1) : string2.substring(n, n2);
            string = XMLText.checkId(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2.substring(0, n));
            stringBuilder.append('\"');
            stringBuilder.append(string);
            stringBuilder.append('\"');
            stringBuilder.append(string2.substring(n2));
            String string3 = stringBuilder.toString();
            if (!string3.equals(string2)) {
                processingInstruction.setText(string3);
            }
        }
        return string;
    }

    private static void collectPIs(Element element, List<ProcessingInstruction> list) {
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case PROCESSING_INSTRUCTION: {
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    String string = processingInstruction.getTarget();
                    if (!"start-range".equals(string) && !"end-range".equals(string)) continue block4;
                    list.add(processingInstruction);
                    continue block4;
                }
                case ELEMENT: {
                    Range.collectPIs((Element)node, list);
                }
            }
        }
    }

    private static boolean hasParaAncestor(Node node) {
        Element element;
        while ((element = node.getParentElement()) != null) {
            if (element.getName() == Constants.P_ELEM) {
                return true;
            }
            node = element;
        }
        return false;
    }

    private static boolean movePIToPara(Node node, boolean bl) {
        Element element = null;
        if (bl) {
            element = Range.findPrecedingPara(node);
            if (element == null) {
                element = Range.findFollowingPara(node);
            }
        } else {
            element = Range.findFollowingPara(node);
            if (element == null) {
                element = Range.findPrecedingPara(node);
            }
        }
        if (element == null) {
            return false;
        }
        Tree tree = node.getParent();
        assert (tree != null);
        tree.removeChild(node);
        if (bl) {
            element.appendChild(node);
        } else {
            Node node2;
            for (node2 = element.getFirstChild(); node2 != null && node2.getType() == Node.Type.PROCESSING_INSTRUCTION && "start-range".equals(((ProcessingInstruction)node2).getTarget()); node2 = node2.getNextSibling()) {
            }
            element.insertChild(node2, node);
        }
        return true;
    }

    private static boolean isFootnote(Element element) {
        if (element.getName() != Constants.DIV_ELEM) {
            return false;
        }
        String string = element.getAttribute(Constants.CLASS_ATTR);
        return string != null && ("role-footnote".equals(string) || "role-endnote".equals(string));
    }

    private static Element findPrecedingPara(Node node) {
        Object object = Traversal.traverseBeforeEx(node, PRECEDING_PARA_FINDER);
        return object != null && object instanceof Element ? (Element)object : null;
    }

    private static Element findFollowingPara(Node node) {
        Object object = Traversal.traverseAfter(node, FOLLOWING_PARA_FINDER);
        return object != null && object instanceof Element ? (Element)object : null;
    }

    private static class FollowingParaFinder
    extends Traversal.HandlerBase {
        private FollowingParaFinder() {
        }

        @Override
        public Object enterElement(Element element) {
            if (element.getName() == Constants.P_ELEM) {
                return element;
            }
            if (Range.isFootnote(element)) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private static class PrecedingParaFinder
    extends Traversal.HandlerBase {
        private PrecedingParaFinder() {
        }

        @Override
        public Object leaveElement(Element element) {
            if (element.getName() == Constants.P_ELEM) {
                return element;
            }
            if (Range.isFootnote(element)) {
                return Boolean.FALSE;
            }
            return null;
        }
    }
}

