/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.packaging;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.w2x.docx.packaging.Package;
import com.xmlmind.w2x.docx.packaging.PartInputStream;
import com.xmlmind.w2x.docx.packaging.PartNameUtil;
import com.xmlmind.w2x.docx.packaging.Related;
import com.xmlmind.w2x.docx.packaging.Util;
import com.xmlmind.xml.doc.Document;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.ZipEntry;

public final class Part
implements Comparable<Part> {
    public final Package container;
    public final String name;
    public final String contentType;
    private final ZipEntry[] zipEntries;
    HashMap<String, Related> idToRelated;
    private HashMap<String, Related[]> typeToRelated;
    public static final Part[] EMPTY_LIST = new Part[0];

    public Part(Package package_, String string, String string2, ZipEntry[] zipEntryArray) {
        this.container = package_;
        this.name = string;
        this.contentType = string2;
        this.zipEntries = zipEntryArray;
    }

    @Override
    public int compareTo(Part part) {
        return this.name.compareTo(part.name);
    }

    public InputStream getInputStream() throws IOException {
        return new PartInputStream(this.container.zip, this.zipEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument() throws IOException {
        Document document = null;
        String string = PartNameUtil.partNameToSystemId(this.container.docxURI, this.name);
        try (InputStream inputStream = this.getInputStream();){
            document = Util.loadDocument(inputStream, string);
        }
        return document;
    }

    public static String getDocumentURI(Document document) {
        return (String)document.getProperty(Util.SYSTEM_ID_PROPERTY);
    }

    public Related getRelated(String string) {
        return this.idToRelated == null ? null : this.idToRelated.get(string);
    }

    public Related[] getAllRelated() {
        Object[] objectArray;
        if (this.idToRelated == null) {
            objectArray = Related.EMPTY_LIST;
        } else {
            objectArray = new Related[this.idToRelated.size()];
            this.idToRelated.values().toArray(objectArray);
            if (objectArray.length > 1) {
                Arrays.sort(objectArray);
            }
        }
        return objectArray;
    }

    public Part getRelatedPart(String string) {
        Related related = this.getRelated(string);
        return related == null || related.external ? null : this.container.getPart(related.target);
    }

    public Related[] getRelatedByRelation(String string) {
        Object[] objectArray = null;
        if (this.idToRelated != null) {
            if (this.typeToRelated == null) {
                this.typeToRelated = new HashMap();
                for (Related related : this.idToRelated.values()) {
                    Related[] relatedArray = this.typeToRelated.get(related.type);
                    relatedArray = relatedArray == null ? new Related[]{related} : ArrayUtil.append(relatedArray, related);
                    this.typeToRelated.put(related.type, relatedArray);
                }
            }
            objectArray = this.typeToRelated.get(string);
        }
        if (objectArray == null) {
            objectArray = Related.EMPTY_LIST;
        } else if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public Part[] getRelatedPartByRelation(String string) {
        Part[] partArray;
        Related[] relatedArray = this.getRelatedByRelation(string);
        if (relatedArray.length == 0) {
            partArray = EMPTY_LIST;
        } else {
            partArray = new Part[relatedArray.length];
            int n = 0;
            for (Related related : relatedArray) {
                if (related.external) continue;
                partArray[n++] = this.container.getPart(related.target);
            }
            if (n != partArray.length) {
                partArray = ArrayUtil.trimToSize(partArray, n);
            }
        }
        return partArray;
    }
}

