/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.packaging;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.FileUtil;
import com.xmlmind.w2x.docx.packaging.ContentTypeMap;
import com.xmlmind.w2x.docx.packaging.Msg;
import com.xmlmind.w2x.docx.packaging.PackageException;
import com.xmlmind.w2x.docx.packaging.Part;
import com.xmlmind.w2x.docx.packaging.PartInputStream;
import com.xmlmind.w2x.docx.packaging.PartNameUtil;
import com.xmlmind.w2x.docx.packaging.Related;
import com.xmlmind.w2x.docx.packaging.Util;
import com.xmlmind.xml.doc.Document;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Package {
    public final File docxFile;
    public final URI docxURI;
    final ZipFile zip;
    private final ContentTypeMap contentTypeMap;
    private final HashMap<String, Part> parts;
    private final HashMap<String, Related> idToRelated;
    private HashMap<String, Related[]> typeToRelated;

    public Package(File file) throws IOException, PackageException {
        Object object;
        Object object2;
        this.docxFile = file;
        this.docxURI = FileUtil.fileToURI(file);
        this.zip = new ZipFile(file);
        HashMap<String, Entry> hashMap = new HashMap<String, Entry>();
        Enumeration<? extends ZipEntry> enumeration = this.zip.entries();
        while (enumeration.hasMoreElements()) {
            Entry entry;
            object2 = enumeration.nextElement();
            if (((ZipEntry)object2).isDirectory()) continue;
            object = new Piece((ZipEntry)object2);
            String string = Package.getZipEntryName((ZipEntry)object2);
            if (((Piece)object).number >= 0) {
                int n = string.lastIndexOf("/[");
                assert (n > 0);
                string = string.substring(0, n);
            }
            if ((entry = (Entry)hashMap.get(string)) == null) {
                hashMap.put(string, new Entry(string, (Piece)object));
                continue;
            }
            entry.addPiece((Piece)object);
        }
        this.contentTypeMap = new ContentTypeMap();
        object2 = (Entry)hashMap.remove("[Content_Types].xml");
        if (object2 != null) {
            this.loadContentTypes((Entry)object2);
        }
        if ((object = (Entry)hashMap.remove("_rels/.rels")) != null) {
            this.idToRelated = new HashMap();
            this.loadRelated((Entry)object, "/", this.idToRelated);
        } else {
            this.idToRelated = null;
        }
        this.parts = new HashMap();
        this.loadParts(hashMap);
    }

    private static String getZipEntryName(ZipEntry zipEntry) {
        return zipEntry.getName();
    }

    private static int getPieceNumber(ZipEntry zipEntry) {
        int n = -1;
        String string = Package.getZipEntryName(zipEntry);
        int n2 = string.lastIndexOf("/[");
        if (n2 > 0) {
            int n3 = -1;
            if (string.endsWith("].last.piece")) {
                n3 = string.length() - 12;
            } else if (string.endsWith("].piece")) {
                n3 = string.length() - 7;
            }
            if (n3 > (n2 += 2)) {
                try {
                    n = Integer.parseInt(string.substring(n2, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    private void loadContentTypes(Entry entry) throws IOException, PackageException {
        this.contentTypeMap.loadFrom(this.loadDocument(entry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadDocument(Entry entry) throws IOException, PackageException {
        Document document = null;
        InputStream inputStream = this.createInputStream(entry);
        String string = PartNameUtil.zipToPartName(entry.prefix);
        string = PartNameUtil.partNameToSystemId(this.docxURI, string);
        try {
            document = Util.loadDocument(inputStream, string);
        }
        finally {
            inputStream.close();
        }
        return document;
    }

    private InputStream createInputStream(Entry entry) throws IOException, PackageException {
        return new PartInputStream(this.zip, entry.getZipEntries());
    }

    private void loadRelated(Entry entry, String string, Map<String, Related> map) throws IOException, PackageException {
        Related.loadFrom(this.loadDocument(entry), string, this.docxURI, map);
    }

    private void loadParts(Map<String, Entry> map) throws IOException, PackageException {
        for (Entry entry : map.values()) {
            String string;
            Part part;
            String string2 = entry.prefix;
            if (string2.endsWith(".rels")) continue;
            String string3 = PartNameUtil.zipToPartName(string2);
            Part part2 = this.parts.put(string3, part = new Part(this, string3, string = this.contentTypeMap.getContentType(string3), entry.getZipEntries()));
            if (part2 != null) {
                throw new PackageException(Msg.msg("duplicatePart", this.docxFile, string3));
            }
            String string4 = Package.toRelsName(string2);
            Entry entry2 = map.get(string4);
            if (entry2 == null) continue;
            part.idToRelated = new HashMap();
            this.loadRelated(entry2, string3, part.idToRelated);
        }
    }

    private static String toRelsName(String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf(47);
        if (n < 0) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append("_rels/");
        stringBuilder.append(string2);
        stringBuilder.append(".rels");
        return stringBuilder.toString();
    }

    public Part getPart(String string) {
        return this.parts.get(string);
    }

    public Part[] getAllParts() {
        Object[] objectArray = new Part[this.parts.size()];
        this.parts.values().toArray(objectArray);
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public Related getRelated(String string) {
        return this.idToRelated == null ? null : this.idToRelated.get(string);
    }

    public Related[] getAllRelated() {
        Object[] objectArray;
        if (this.idToRelated == null) {
            objectArray = Related.EMPTY_LIST;
        } else {
            objectArray = new Related[this.idToRelated.size()];
            this.idToRelated.values().toArray(objectArray);
            if (objectArray.length > 1) {
                Arrays.sort(objectArray);
            }
        }
        return objectArray;
    }

    public Part getRelatedPart(String string) {
        Related related = this.getRelated(string);
        return related == null || related.external ? null : this.getPart(related.target);
    }

    public Related[] getRelatedByRelation(String string) {
        Object[] objectArray = null;
        if (this.idToRelated != null) {
            if (this.typeToRelated == null) {
                this.typeToRelated = new HashMap();
                for (Related related : this.idToRelated.values()) {
                    Related[] relatedArray = this.typeToRelated.get(related.type);
                    relatedArray = relatedArray == null ? new Related[]{related} : ArrayUtil.append(relatedArray, related);
                    this.typeToRelated.put(related.type, relatedArray);
                }
            }
            objectArray = this.typeToRelated.get(string);
        }
        if (objectArray == null) {
            objectArray = Related.EMPTY_LIST;
        } else if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public Part[] getRelatedPartByRelation(String string) {
        Part[] partArray;
        Related[] relatedArray = this.getRelatedByRelation(string);
        if (relatedArray.length == 0) {
            partArray = Part.EMPTY_LIST;
        } else {
            partArray = new Part[relatedArray.length];
            int n = 0;
            for (Related related : relatedArray) {
                if (related.external) continue;
                partArray[n++] = this.getPart(related.target);
            }
            if (n != partArray.length) {
                partArray = ArrayUtil.trimToSize(partArray, n);
            }
        }
        return partArray;
    }

    public void close() throws IOException {
        this.zip.close();
    }

    private final class Entry {
        public final String prefix;
        public Piece[] pieces;

        public Entry(String string, Piece piece) {
            this.prefix = string;
            this.pieces = new Piece[]{piece};
        }

        public void addPiece(Piece piece) {
            this.pieces = ArrayUtil.append(this.pieces, piece);
        }

        public ZipEntry[] getZipEntries() throws PackageException {
            if (!this.sortPieces()) {
                throw new PackageException(Msg.msg("inconsistentMultiPieceEntry", this.prefix, Package.this.docxFile));
            }
            int n = this.pieces.length;
            ZipEntry[] zipEntryArray = new ZipEntry[n];
            for (int i = 0; i < n; ++i) {
                zipEntryArray[i] = this.pieces[i].zipEntry;
            }
            return zipEntryArray;
        }

        private boolean sortPieces() {
            boolean bl = true;
            if (this.pieces.length > 1) {
                Arrays.sort(this.pieces);
                int n = -1;
                for (Piece piece : this.pieces) {
                    int n2 = piece.number;
                    if (n2 != n + 1) {
                        bl = false;
                        break;
                    }
                    n = n2;
                }
            }
            return bl;
        }
    }

    private static final class Piece
    implements Comparable<Piece> {
        public final int number;
        public final ZipEntry zipEntry;

        public Piece(ZipEntry zipEntry) {
            this.number = Package.getPieceNumber(zipEntry);
            this.zipEntry = zipEntry;
        }

        @Override
        public int compareTo(Piece piece) {
            return this.number - piece.number;
        }
    }
}

