/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.image;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.w2x.docx.image.ImageConverter;
import com.xmlmind.w2x.docx.image.ImageConverterFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.FileImageOutputStream;

public final class ImageConverterFactoryImpl
implements ImageConverterFactory {
    private final String[] conversions;

    public ImageConverterFactoryImpl() {
        Object[] objectArray;
        Object object;
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<ImageReaderSpi> iterator = null;
        try {
            iterator = iIORegistry.getServiceProviders(ImageReaderSpi.class, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                ImageReaderSpi imageReaderSpi = iterator.next();
                String[] stringArray = imageReaderSpi.getFileSuffixes();
                if (stringArray == null) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    if (((String)object).startsWith(".")) {
                        object = ((String)object).substring(1);
                    }
                    if (((String)object).length() <= 0) continue;
                    hashSet.add(((String)object).toLowerCase());
                }
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        Iterator<ImageWriterSpi> iterator2 = null;
        try {
            iterator2 = iIORegistry.getServiceProviders(ImageWriterSpi.class, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                object = iterator2.next();
                objectArray = ((ImageReaderWriterSpi)object).getMIMETypes();
                if (objectArray == null) continue;
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = ((String)objectArray[i]).toLowerCase();
                    if ("image/png".equals(string)) {
                        bl = true;
                        continue;
                    }
                    if (!"image/jpeg".equals(string)) continue;
                    bl2 = true;
                }
            }
        }
        object = new ArrayList();
        objectArray = hashSet.toArray(StringUtil.EMPTY_LIST);
        Arrays.sort(objectArray);
        for (Object object2 : objectArray) {
            if (bl2 && !"jpg".equals(object2) && !"jpeg".equals(object2)) {
                ((ArrayList)object).add(object2);
                ((ArrayList)object).add("jpg");
                ((ArrayList)object).add(object2);
                ((ArrayList)object).add("jpeg");
            }
            if (!bl || "png".equals(object2)) continue;
            ((ArrayList)object).add(object2);
            ((ArrayList)object).add("png");
        }
        this.conversions = ((ArrayList)object).toArray(StringUtil.EMPTY_LIST);
    }

    @Override
    public void setParameter(String string, String string2) {
    }

    @Override
    public String getParameter(String string) {
        return null;
    }

    @Override
    public String[] getImageConversions() {
        return this.conversions;
    }

    @Override
    public ImageConverter createImageConverter(String string, final String string2) throws Exception {
        return new ImageConverter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void convertImage(File file, File file2) throws Exception {
                BufferedImage bufferedImage = ImageIO.read(file);
                ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
                ImageWriter imageWriter = ImageConverterFactoryImpl.getImageWriter(imageTypeSpecifier, string2);
                if (imageWriter == null) {
                    throw new RuntimeException("don't know how to convert the image read from " + String.valueOf(file) + " to format " + string2.toUpperCase());
                }
                try {
                    file2.delete();
                    try (FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file2);){
                        imageWriter.setOutput(fileImageOutputStream);
                        imageWriter.write(bufferedImage);
                        fileImageOutputStream.flush();
                    }
                }
                finally {
                    imageWriter.dispose();
                }
            }
        };
    }

    private static ImageWriter getImageWriter(final ImageTypeSpecifier imageTypeSpecifier, final String string) throws IOException {
        ImageWriter imageWriter = null;
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        Iterator<ImageWriterSpi> iterator = null;
        try {
            iterator = iIORegistry.getServiceProviders(ImageWriterSpi.class, new ServiceRegistry.Filter(){

                @Override
                public boolean filter(Object object) {
                    ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
                    if (!imageWriterSpi.canEncodeImage(imageTypeSpecifier)) {
                        return false;
                    }
                    String[] stringArray = imageWriterSpi.getFileSuffixes();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].equalsIgnoreCase(string)) continue;
                        return true;
                    }
                    return false;
                }
            }, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (iterator != null && iterator.hasNext()) {
            ImageWriterSpi imageWriterSpi = (ImageWriterSpi)iterator.next();
            imageWriter = imageWriterSpi.createWriterInstance();
        }
        return imageWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cropImage(File file, double d, double d2, double d3, double d4, File file2) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        String string = FileUtil.getExtension(file2);
        if (string == null || (string = string.trim()).length() == 0) {
            return false;
        }
        string = string.toLowerCase();
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            return false;
        }
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        int n7 = n5;
        int n8 = n6;
        int n9 = (int)Math.rint((double)n5 * d4 / 100.0);
        int n10 = 0;
        if (n9 < 0) {
            n7 += -n9;
            n10 = -n9;
            n9 = 0;
        } else {
            n7 -= n9;
        }
        int n11 = (int)Math.rint((double)n6 * d / 100.0);
        int n12 = 0;
        if (n11 < 0) {
            n8 += -n11;
            n12 = -n11;
            n11 = 0;
        } else {
            n8 -= n11;
        }
        int n13 = (int)Math.rint((double)n5 * d2 / 100.0);
        if (n13 < 0) {
            n4 = n5 - 1;
            n3 = n7 - 1;
            n7 += -n13;
        } else {
            n4 = n5 - n13 - 1;
            n3 = (n7 -= n13) - 1;
        }
        int n14 = (int)Math.rint((double)n6 * d3 / 100.0);
        if (n14 < 0) {
            n2 = n6 - 1;
            n = n8 - 1;
            n8 += -n14;
        } else {
            n2 = n6 - n14 - 1;
            n = (n8 -= n14) - 1;
        }
        boolean bl = bufferedImage.getTransparency() == 3;
        BufferedImage bufferedImage2 = new BufferedImage(n7, n8, bl ? 2 : 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setColor(bl ? new Color(255, 255, 255, 0) : Color.white);
            graphics2D.fillRect(0, 0, n7, n8);
            graphics2D.drawImage(bufferedImage, n10, n12, n3, n, n9, n11, n4, n2, null);
        }
        finally {
            graphics2D.dispose();
        }
        return ImageIO.write((RenderedImage)bufferedImage2, string, file2);
    }
}

