/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.RegexMatch;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class VersionNumber
implements Comparable<VersionNumber> {
    public int major;
    public int minor;
    public int micro;
    public LevelType levelType;
    public int level;
    public static final VersionNumber MIN_VERSION_NUMBER = new VersionNumber();

    public static VersionNumber fromString(String string) {
        return VersionNumber.fromString(string, false);
    }

    public static VersionNumber fromString(String string, boolean bl) {
        Object object;
        if (bl) {
            string = string.trim();
            try {
                RegexMatch[] regexMatchArray;
                object = Pattern.compile("(\\d+)(\\.\\d+)?(\\.\\d+)?(\\_\\d+)?.*");
                Matcher matcher = ((Pattern)object).matcher(string);
                if (matcher.matches() && (regexMatchArray = RegexMatch.getAll(matcher)).length > 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 1; i < regexMatchArray.length; ++i) {
                        stringBuilder.append(regexMatchArray[i].text);
                    }
                    string = stringBuilder.toString();
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                patternSyntaxException.printStackTrace();
            }
        }
        object = new VersionNumber();
        try {
            VersionNumber.parse(string, (VersionNumber)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = null;
        }
        return object;
    }

    public static void parse(String string, VersionNumber versionNumber) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "._-", true);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("empty specification");
        }
        String string2 = stringTokenizer.nextToken();
        int n = VersionNumber.parseNumber(string2, 0, 999, -1);
        if (n < 0) {
            throw new IllegalArgumentException("invalid major '" + string2 + "'");
        }
        int n2 = 0;
        int n3 = 0;
        LevelType levelType = LevelType.PATCH;
        int n4 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!".".equals(string2)) {
                throw new IllegalArgumentException("expected '.', found '" + string2 + "'");
            }
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("expected a number after '.'");
            }
            string2 = stringTokenizer.nextToken();
            n2 = VersionNumber.parseNumber(string2, 0, 999, -1);
            if (n2 < 0) {
                throw new IllegalArgumentException("invalid minor '" + string2 + "'");
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!".".equals(string2)) {
                    throw new IllegalArgumentException("expected '.', found '" + string2 + "'");
                }
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IllegalArgumentException("expected a number after '.'");
                }
                string2 = stringTokenizer.nextToken();
                n3 = VersionNumber.parseNumber(string2, 0, 999, -1);
                if (n3 < 0) {
                    throw new IllegalArgumentException("invalid micro '" + string2 + "'");
                }
                if (stringTokenizer.hasMoreTokens()) {
                    boolean bl;
                    string2 = stringTokenizer.nextToken();
                    if ("_".equals(string2)) {
                        bl = true;
                    } else if ("-".equals(string2)) {
                        bl = false;
                    } else {
                        throw new IllegalArgumentException("expected '_' or '-', found '" + string2 + "'");
                    }
                    if (!stringTokenizer.hasMoreTokens()) {
                        if (bl) {
                            throw new IllegalArgumentException("expected a number after '_'");
                        }
                        throw new IllegalArgumentException("expected 'alpha', 'beta' or 'rc' after '-'");
                    }
                    string2 = stringTokenizer.nextToken();
                    if (bl) {
                        levelType = LevelType.PATCH;
                    } else if (string2.startsWith("rc")) {
                        levelType = LevelType.RELEASE_CANDIDATE;
                        string2 = string2.substring(2);
                    } else if (string2.startsWith("beta")) {
                        levelType = LevelType.BETA;
                        string2 = string2.substring(4);
                    } else if (string2.startsWith("alpha")) {
                        levelType = LevelType.ALPHA;
                        string2 = string2.substring(5);
                    } else {
                        throw new IllegalArgumentException("expected 'alpha', 'beta' or 'rc' after '-'");
                    }
                    n4 = VersionNumber.parseNumber(string2, 0, 999, -1);
                    if (n4 < 0) {
                        throw new IllegalArgumentException("invalid " + String.valueOf((Object)levelType) + " level '" + string2 + "'");
                    }
                }
            }
        }
        versionNumber.major = n;
        versionNumber.minor = n2;
        versionNumber.micro = n3;
        versionNumber.levelType = levelType;
        versionNumber.level = n4;
    }

    private static final int parseNumber(String string, int n, int n2, int n3) {
        int n4;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n3;
        }
        if (n4 < n || n4 > n2) {
            return n3;
        }
        return n4;
    }

    public VersionNumber() {
        this(0, 0, 0, LevelType.ALPHA, 0);
    }

    public VersionNumber(int n, int n2, int n3) {
        this(n, n2, n3, LevelType.PATCH, 0);
    }

    public VersionNumber(int n, int n2, int n3, int n4) {
        this(n, n2, n3, LevelType.PATCH, n4);
    }

    public VersionNumber(int n, int n2, int n3, LevelType levelType, int n4) {
        if (n < 0 || n >= 1000) {
            throw new IllegalArgumentException("invalid major " + n);
        }
        if (n2 < 0 || n2 >= 1000) {
            throw new IllegalArgumentException("invalid minor " + n2);
        }
        if (n3 < 0 || n3 >= 1000) {
            throw new IllegalArgumentException("invalid micro " + n3);
        }
        if (n4 < 0 || n4 >= 1000) {
            throw new IllegalArgumentException("invalid " + String.valueOf((Object)levelType) + " level " + n4);
        }
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.levelType = levelType;
        this.level = n4;
    }

    public int hashCode() {
        return (int)this.toLong();
    }

    private long toLong() {
        return 1000000000000L * (long)this.major + 1000000000L * (long)this.minor + 1000000L * (long)this.micro + 1000L * (long)(this.levelType.ordinal() + 1) + (long)this.level;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof VersionNumber)) {
            return false;
        }
        VersionNumber versionNumber = (VersionNumber)object;
        return this.toLong() == versionNumber.toLong();
    }

    public VersionNumber noLevel() {
        return new VersionNumber(this.major, this.minor, this.micro, LevelType.PATCH, 0);
    }

    @Override
    public int compareTo(VersionNumber versionNumber) {
        long l = this.toLong() - versionNumber.toLong();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.major);
        stringBuilder.append('.');
        stringBuilder.append(this.minor);
        stringBuilder.append('.');
        stringBuilder.append(this.micro);
        boolean bl = true;
        switch (this.levelType) {
            case ALPHA: {
                stringBuilder.append("-alpha");
                break;
            }
            case BETA: {
                stringBuilder.append("-beta");
                break;
            }
            case RELEASE_CANDIDATE: {
                stringBuilder.append("-rc");
                break;
            }
            default: {
                if (this.level == 0) {
                    bl = false;
                    break;
                }
                stringBuilder.append('_');
            }
        }
        if (bl) {
            String string = Integer.toString(this.level);
            for (int i = string.length(); i < 2; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static enum LevelType {
        ALPHA,
        BETA,
        RELEASE_CANDIDATE,
        PATCH;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "alpha";
                }
                case 1: {
                    return "beta";
                }
                case 2: {
                    return "rc";
                }
                case 3: {
                    return "patch";
                }
            }
            return "???";
        }
    }
}

