/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ObjectUtil;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.URIComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Comparator;

public final class URLUtil {
    public static final URL[] EMPTY_LIST = new URL[0];
    public static final URLComparator COMPARATOR = new URLComparator();

    private URLUtil() {
    }

    public static URL createURL(String string) throws MalformedURLException {
        if (!string.startsWith("data:")) {
            string = URIComponent.encode(string);
        }
        return URLUtil.newURL(string);
    }

    public static URL createURL(URL uRL, String string) throws MalformedURLException {
        if (!string.startsWith("data:")) {
            string = URIComponent.encode(string);
        }
        return URLUtil.newURL(uRL, string);
    }

    public static URL createURL(URL uRL, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        if (!string.startsWith("data:")) {
            string = URIComponent.encode(string);
        }
        return URLUtil.newURL(uRL, string, uRLStreamHandler);
    }

    public static URL newURL(String string) throws MalformedURLException {
        return new URL(string);
    }

    public static URL newURL(URL uRL, String string) throws MalformedURLException {
        return new URL(uRL, string);
    }

    public static URL newURL(URL uRL, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        return new URL(uRL, string, uRLStreamHandler);
    }

    public static URL newURL(String string, String string2, String string3) throws MalformedURLException {
        return new URL(string, string2, string3);
    }

    public static URL newURL(String string, String string2, int n, String string3) throws MalformedURLException {
        return new URL(string, string2, n, string3);
    }

    public static URL newURL(String string, String string2, int n, String string3, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        return new URL(string, string2, n, string3, uRLStreamHandler);
    }

    public static boolean isFileURL(URL uRL) {
        return "file".equals(uRL.getProtocol());
    }

    public static boolean isJarURL(URL uRL) {
        return "jar".equals(uRL.getProtocol());
    }

    public static boolean isDataURL(URL uRL) {
        return "data".equals(uRL.getProtocol());
    }

    public static File urlToFile(URL uRL) {
        if (!URLUtil.isFileURL(uRL)) {
            return null;
        }
        if (SystemUtil.IS_WINDOWS) {
            String string = uRL.getHost();
            if (string != null && string.length() > 0 && !"localhost".equalsIgnoreCase(string)) {
                Object object;
                Comparable<URI> comparable;
                Object object2 = uRL.getPath();
                if (((String)object2).length() == 0) {
                    object2 = "/";
                }
                object2 = "file:/C:" + (String)object2;
                try {
                    comparable = new URI(URIComponent.encode((String)object2));
                    object = new File((URI)comparable).getPath();
                }
                catch (Exception exception) {
                    return null;
                }
                object = "\\\\" + string + ((String)object).substring(2);
                comparable = new File((String)object);
                try {
                    comparable = ((File)comparable).getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return comparable;
            }
            return URLUtil.convertURLToFile(uRL);
        }
        return URLUtil.convertURLToFile(uRL);
    }

    private static File convertURLToFile(URL uRL) {
        assert (URLUtil.isFileURL(uRL));
        try {
            Object object = uRL.getPath();
            if (((String)object).length() == 0) {
                object = "/";
            }
            object = "file://" + (String)object;
            URI uRI = new URI(URIComponent.encode((String)object));
            if (SystemUtil.IS_WINDOWS) {
                File file = new File(uRI);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return file;
            }
            uRI = uRI.normalize();
            return new File(uRI);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URI urlToURI(URL uRL) {
        String string = uRL.toExternalForm();
        try {
            return new URI(URIComponent.encode(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static URL urlOrFile(String string) {
        return URLUtil.urlOrFile(string, false, false, null);
    }

    public static URL urlOrFile(String string, boolean bl) {
        return URLUtil.urlOrFile(string, bl, false, null);
    }

    public static URL urlOrFile(String string, boolean bl, boolean bl2) {
        return URLUtil.urlOrFile(string, bl, bl2, null);
    }

    public static URL urlOrFile(String string, boolean bl, boolean bl2, URL uRL) {
        int n = string.indexOf(10);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        string = string.trim();
        URL uRL2 = null;
        try {
            uRL2 = URLUtil.createURL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL2 == null) {
            File file = new File(string);
            if (bl && !file.isAbsolute()) {
                return null;
            }
            if (bl2 ? !file.exists() : !file.isFile()) {
                return null;
            }
            uRL2 = FileUtil.fileToURL(file);
        }
        return uRL2;
    }

    public static boolean sameRoot(URL uRL, URL uRL2) {
        return ObjectUtil.equals(URLUtil.getRoot(uRL, true), URLUtil.getRoot(uRL2, true));
    }

    public static URL getRoot(URL uRL) {
        return URLUtil.getRoot(uRL, false);
    }

    private static URL getRoot(URL uRL, boolean bl) {
        String[] stringArray;
        int n = uRL.getPort();
        if (n < 0 && bl) {
            n = uRL.getDefaultPort();
        }
        if ((stringArray = URLUtil.splitPath(uRL)) == null) {
            stringArray = new String[]{null, "/"};
        }
        stringArray[1] = "/";
        String string = URIComponent.joinQuotedComponents(uRL.getProtocol(), uRL.getUserInfo(), null, uRL.getHost(), n, URLUtil.joinPath(stringArray), null, null);
        try {
            return URLUtil.newURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static boolean isAncestorOf(URL uRL, URL uRL2) {
        if (!URLUtil.sameRoot(uRL, uRL2)) {
            return false;
        }
        String[] stringArray = URLUtil.splitPath(uRL);
        if (stringArray == null) {
            return false;
        }
        String[] stringArray2 = URLUtil.splitPath(uRL2);
        if (stringArray2 == null) {
            return false;
        }
        if (!stringArray[1].endsWith("/")) {
            stringArray[1] = stringArray[1] + "/";
        }
        return stringArray2[1].startsWith(stringArray[1]);
    }

    private static String[] splitPath(URL uRL) {
        String string = uRL.getPath();
        if (string.length() == 0) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        if (URLUtil.isJarURL(uRL)) {
            int n = string.indexOf("!/");
            if (n < 0) {
                return null;
            }
            string2 = string.substring(0, n + 1);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        return new String[]{string2, string3};
    }

    private static String joinPath(String[] stringArray) {
        if (stringArray[0] == null) {
            return stringArray[1];
        }
        return stringArray[0] + stringArray[1];
    }

    public static URL getParent(URL uRL) {
        String[] stringArray = URLUtil.splitPath(uRL);
        if (stringArray == null) {
            return null;
        }
        stringArray[1] = URIComponent.getRawParentPath(stringArray[1]);
        if (stringArray[1] == null) {
            return null;
        }
        String string = URIComponent.joinQuotedComponents(uRL.getProtocol(), uRL.getUserInfo(), null, uRL.getHost(), uRL.getPort(), URLUtil.joinPath(stringArray), null, null);
        try {
            return URLUtil.newURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getPath(URL uRL) {
        String string = URLUtil.getRawPath(uRL);
        return string == null ? null : URIComponent.decode(string);
    }

    public static String getRawPath(URL uRL) {
        String[] stringArray = URLUtil.splitPath(uRL);
        return stringArray == null ? null : stringArray[1];
    }

    public static String getBaseName(URL uRL) {
        String string = URLUtil.getRawBaseName(uRL);
        return string == null ? null : URIComponent.decode(string);
    }

    public static String getRawBaseName(URL uRL) {
        String[] stringArray = URLUtil.splitPath(uRL);
        return stringArray == null ? null : URIComponent.getRawBaseName(stringArray[1]);
    }

    public static String getExtension(URL uRL) {
        String string = URLUtil.getRawExtension(uRL);
        return string == null ? null : URIComponent.decode(string);
    }

    public static String getRawExtension(URL uRL) {
        String[] stringArray = URLUtil.splitPath(uRL);
        return stringArray == null ? null : URIComponent.getRawExtension(stringArray[1]);
    }

    public static URL setExtension(URL uRL, String string) {
        if (string != null) {
            string = URIComponent.quotePath(string);
        }
        return URLUtil.setRawExtension(uRL, string);
    }

    public static URL setRawExtension(URL uRL, String string) {
        String[] stringArray = URLUtil.splitPath(uRL);
        if (stringArray == null || stringArray[1].endsWith("/")) {
            return uRL;
        }
        stringArray[1] = URIComponent.setRawExtension(stringArray[1], string);
        String string2 = URIComponent.joinQuotedComponents(uRL.getProtocol(), uRL.getUserInfo(), null, uRL.getHost(), uRL.getPort(), URLUtil.joinPath(stringArray), uRL.getQuery(), uRL.getRef());
        try {
            return URLUtil.newURL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getFragment(URL uRL) {
        String string = uRL.getRef();
        return string == null ? null : URIComponent.decode(string);
    }

    public static URL setFragment(URL uRL, String string) {
        if (string != null) {
            string = URIComponent.quoteFragment(string);
        }
        return URLUtil.setRawFragment(uRL, string);
    }

    public static URL setRawFragment(URL uRL, String string) {
        String[] stringArray = URLUtil.splitPath(uRL);
        if (stringArray == null) {
            return uRL;
        }
        String string2 = uRL.toExternalForm();
        string2 = URIComponent.setRawFragment(string2, string);
        try {
            return URLUtil.newURL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getUserName(URL uRL) {
        String string = URLUtil.getRawUserName(uRL);
        return string == null ? null : URIComponent.decode(string);
    }

    public static String getRawUserName(URL uRL) {
        String string = uRL.getUserInfo();
        if (string != null) {
            int n = string.indexOf(58);
            if (n < 0) {
                return string;
            }
            if (n > 0) {
                return string.substring(0, n);
            }
            return null;
        }
        return null;
    }

    public static String getUserPassword(URL uRL) {
        String string = URLUtil.getRawUserPassword(uRL);
        return string == null ? null : URIComponent.decode(string);
    }

    public static String getRawUserPassword(URL uRL) {
        String string = uRL.getUserInfo();
        if (string != null) {
            int n = string.indexOf(58);
            if (n + 1 < string.length()) {
                return string.substring(n + 1);
            }
            return null;
        }
        return null;
    }

    public static URL setUserInfo(URL uRL, String string, String string2) {
        if (string != null) {
            string = URIComponent.quoteUserInfo(string);
        }
        if (string2 != null) {
            string2 = URIComponent.quoteUserInfo(string2);
        }
        return URLUtil.setRawUserInfo(uRL, string, string2);
    }

    public static URL setRawUserInfo(URL uRL, String string, String string2) {
        if (string == null) {
            string2 = null;
        }
        String string3 = URIComponent.joinQuotedComponents(uRL.getProtocol(), string, string2, uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
        try {
            return URLUtil.newURL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getRawRelativePath(URL uRL, URL uRL2) {
        Object object;
        Object object2;
        if (SystemUtil.IS_WINDOWS && URLUtil.isFileURL(uRL) && URLUtil.isFileURL(uRL2)) {
            object2 = URLUtil.urlToFile(uRL);
            object = URLUtil.urlToFile(uRL2);
            if (object2 != null && object != null && FileUtil.getNonRelativePath((File)object2, (File)object, null) != null) {
                return uRL.toExternalForm();
            }
        }
        if ((object2 = URLUtil.splitPath(uRL)) == null || (object = URLUtil.splitPath(uRL2)) == null || !URLUtil.sameRoot(uRL, uRL2)) {
            return uRL.toExternalForm();
        }
        String string = URIComponent.getRawRelativePath(object2[1], object[1]);
        return URIComponent.joinQuotedComponents(null, null, null, null, -1, string, uRL.getQuery(), uRL.getRef());
    }

    public static String toLabel(URL uRL) {
        File file;
        if (uRL.getRef() == null && (file = URLUtil.urlToFile(uRL)) != null) {
            return file.getPath();
        }
        return URLUtil.toDisplayForm(uRL);
    }

    public static String toDisplayForm(URL uRL) {
        URI uRI;
        URI uRI2 = URLUtil.urlToURI(uRL);
        if (uRI2 == null || uRI2.isOpaque()) {
            return uRL.toExternalForm();
        }
        String string = URLUtil.hideUserInfo(uRI2);
        try {
            uRI = new URI(uRI2.getScheme(), string, uRI2.getHost(), uRI2.getPort(), uRI2.getPath(), uRI2.getQuery(), uRI2.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
        return uRI.toString();
    }

    private static String hideUserInfo(URI uRI) {
        String string = uRI.getUserInfo();
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!bl) {
                    stringBuilder.append(c);
                    if (c != ':') continue;
                    bl = true;
                    continue;
                }
                stringBuilder.append('*');
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static String toShortLabel(URL uRL, int n) {
        File file = URLUtil.urlToFile(uRL);
        if (file != null) {
            String string = file.getPath();
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            string = URIComponent.truncatePath(string, n);
            if (File.separatorChar != '/') {
                string = string.replace('/', File.separatorChar);
            }
            return string;
        }
        return URLUtil.toShortDisplayForm(uRL, n);
    }

    public static String toShortDisplayForm(URL uRL, int n) {
        URI uRI;
        if (URLUtil.isJarURL(uRL)) {
            URL uRL2;
            String string = uRL.toExternalForm();
            int n2 = string.indexOf("!/");
            if (n2 < 0) {
                return string;
            }
            String string2 = string.substring(4, n2);
            String string3 = string.substring(n2 + 1);
            try {
                uRL2 = URLUtil.newURL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                return string;
            }
            int n3 = Math.min((n -= 5) / 2, string3.length());
            int n4 = n - n3;
            if (n4 <= 0) {
                n4 = 10;
            }
            if (n3 <= 0) {
                n3 = 10;
            }
            StringBuilder stringBuilder = new StringBuilder("jar:");
            stringBuilder.append(URLUtil.toShortDisplayForm(uRL2, n4));
            stringBuilder.append('!');
            stringBuilder.append(URIComponent.truncatePath(string3, n3));
            return stringBuilder.toString();
        }
        URI uRI2 = URLUtil.urlToURI(uRL);
        if (uRI2 == null || uRI2.isOpaque()) {
            return uRL.toExternalForm();
        }
        String string = URLUtil.hideUserInfo(uRI2);
        try {
            uRI = new URI(uRI2.getScheme(), string, uRI2.getHost(), uRI2.getPort(), "/", null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
        int n5 = 2 * n / 3;
        if (n5 <= 0) {
            n5 = 10;
        }
        n5 = Math.max(n5, n - uRI.toString().length());
        String string4 = URIComponent.truncatePath(uRI2.getPath(), n5);
        try {
            uRI = new URI(uRI2.getScheme(), string, uRI2.getHost(), uRI2.getPort(), string4, uRI2.getQuery(), uRI2.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
        return uRI.toString();
    }

    public static boolean exists(URL uRL) {
        boolean bl = false;
        try {
            bl = URLUtil.exists(uRL, true, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(URL uRL, boolean bl, int n) throws IOException {
        File file;
        if (uRL.getRef() != null) {
            uRL = URLUtil.setRawFragment(uRL, null);
        }
        if ((file = URLUtil.urlToFile(uRL)) != null) {
            return file.exists();
        }
        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
        if (n >= 0) {
            uRLConnection.setConnectTimeout(n);
            uRLConnection.setReadTimeout(n);
        }
        boolean bl2 = false;
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).setRequestMethod("HEAD");
            URLUtil.checkHttpConnection(uRLConnection, bl);
            bl2 = true;
        } else {
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                inputStream.read();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            bl2 = true;
        }
        return bl2;
    }

    public static long lastModified(URL uRL) {
        long l = -1L;
        try {
            l = URLUtil.lastModified(uRL, true, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    public static long lastModified(URL uRL, boolean bl, int n) throws IOException {
        File file;
        if (uRL.getRef() != null) {
            uRL = URLUtil.setRawFragment(uRL, null);
        }
        if ((file = URLUtil.urlToFile(uRL)) != null) {
            return file.lastModified();
        }
        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
        if (n >= 0) {
            uRLConnection.setConnectTimeout(n);
            uRLConnection.setReadTimeout(n);
        }
        long l = -1L;
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).setRequestMethod("HEAD");
            URLUtil.checkHttpConnection(uRLConnection, bl);
        } else {
            uRLConnection.connect();
        }
        l = uRLConnection.getLastModified();
        return l;
    }

    public static URLConnection checkHttpConnection(URLConnection uRLConnection, boolean bl) throws IOException {
        if (!(uRLConnection instanceof HttpURLConnection)) {
            return uRLConnection;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        int n = 200;
        for (int i = 0; i < 10; ++i) {
            httpURLConnection.setInstanceFollowRedirects(bl);
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0");
            httpURLConnection.setRequestProperty("Accept-Language", "en-US,en;q=0.9,*;q=0.5");
            httpURLConnection.connect();
            n = httpURLConnection.getResponseCode();
            boolean bl2 = false;
            if (n != 200 && bl) {
                switch (n) {
                    case 301: 
                    case 302: {
                        bl2 = true;
                    }
                }
            }
            if (!bl2) break;
            String string = httpURLConnection.getHeaderField("Location");
            String string2 = httpURLConnection.getRequestMethod();
            String string3 = httpURLConnection.getHeaderField("Set-Cookie");
            URL uRL = null;
            try {
                uRL = URLUtil.newURL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null) break;
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod(string2);
            httpURLConnection.setRequestProperty("Cookie", string3);
        }
        if (n != 200) {
            StringBuilder stringBuilder = new StringBuilder("cannot access \"");
            stringBuilder.append(httpURLConnection.getURL());
            stringBuilder.append("\": error ");
            stringBuilder.append(n);
            String string = httpURLConnection.getResponseMessage();
            if (string != null) {
                stringBuilder.append(": ");
                stringBuilder.append(string);
            }
            throw new IOException(stringBuilder.toString());
        }
        return httpURLConnection;
    }

    public static byte[] loadBytes(URL uRL) throws IOException {
        return URLUtil.loadBytes(uRL, true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(URL uRL, boolean bl, int n) throws IOException {
        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
        if (n >= 0) {
            uRLConnection.setConnectTimeout(n);
            uRLConnection.setReadTimeout(n);
        }
        uRLConnection = URLUtil.checkHttpConnection(uRLConnection, bl);
        byte[] byArray = null;
        try (InputStream inputStream = uRLConnection.getInputStream();){
            byArray = FileUtil.loadBytes(inputStream);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyFile(String string, String string2) throws IllegalArgumentException, IOException {
        URL uRL = FileUtil.fileToURL(new File("."));
        URL uRL2 = null;
        try {
            uRL2 = URLUtil.createURL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL2 == null) {
            throw new IllegalArgumentException("'" + string + "', not an URL");
        }
        File file = null;
        try {
            file = URLUtil.urlToFile(URLUtil.createURL(uRL, string2));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (file == null) {
            throw new IllegalArgumentException("'" + string2 + "', not a 'file:' URL");
        }
        int n = 0;
        try (InputStream inputStream = URLUtil.openStreamNoCache(uRL2);
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n2;
            byte[] byArray = new byte[65536];
            while ((n2 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
                n += n2;
            }
            fileOutputStream.flush();
        }
        return n;
    }

    public static String loadString(URL uRL) throws IOException {
        return URLUtil.loadString(uRL, null, true, -1);
    }

    public static String loadString(URL uRL, String string) throws IOException {
        return URLUtil.loadString(uRL, string, true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(URL uRL, String string, boolean bl, int n) throws IOException {
        String string2;
        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
        if (n >= 0) {
            uRLConnection.setConnectTimeout(n);
            uRLConnection.setReadTimeout(n);
        }
        uRLConnection = URLUtil.checkHttpConnection(uRLConnection, bl);
        if (string == null && (string2 = uRLConnection.getContentType()) != null) {
            string = URLUtil.contentTypeToCharset(string2);
        }
        string2 = null;
        try (InputStream inputStream = uRLConnection.getInputStream();){
            string2 = FileUtil.loadString(inputStream, string);
        }
        return string2;
    }

    public static String contentTypeToCharset(String string) {
        int n;
        int n2;
        String string2 = null;
        if (string != null && (n2 = (string = string.toLowerCase()).indexOf("charset=")) >= 0 && n2 + 8 < string.length() - 1 && (n = (string2 = string.substring(n2 + 8).trim()).length()) >= 2 && string2.charAt(0) == '\"') {
            string2 = string2.substring(1, n - 1);
        }
        return string2;
    }

    public static String contentTypeToMedia(String string) {
        String string2 = null;
        if (string != null) {
            int n = (string = string.toLowerCase()).lastIndexOf(59);
            if (n < 0) {
                string2 = string.trim();
            } else if (n > 0) {
                string2 = string.substring(0, n).trim();
            }
        }
        return string2;
    }

    public static String normalizeContentType(String string, String string2) {
        String string3 = URLUtil.contentTypeToMedia(string);
        if (string3 == null) {
            return null;
        }
        String string4 = URLUtil.contentTypeToCharset(string);
        if (string4 == null && string2 != null) {
            string4 = string2.toLowerCase();
        }
        if (string4 == null) {
            return string3;
        }
        StringBuilder stringBuilder = new StringBuilder(string3);
        stringBuilder.append(";charset=");
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    public static boolean sameContentType(String string, String string2, String string3) {
        string = URLUtil.normalizeContentType(string, string3);
        string2 = URLUtil.normalizeContentType(string2, string3);
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    public static URLConnection openConnectionNoCache(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        return uRLConnection;
    }

    public static InputStream openStreamNoCache(URL uRL) throws IOException {
        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
        return uRLConnection.getInputStream();
    }

    public static URLConnection openConnectionUseCache(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(true);
        return uRLConnection;
    }

    public static InputStream openStreamUseCache(URL uRL) throws IOException {
        URLConnection uRLConnection = URLUtil.openConnectionUseCache(uRL);
        return uRLConnection.getInputStream();
    }

    public static final class URLComparator
    implements Comparator<URL> {
        @Override
        public int compare(URL uRL, URL uRL2) {
            return uRL.toExternalForm().compareTo(uRL2.toExternalForm());
        }
    }
}

