/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;

public final class URIComponent {
    private static final int[] fromHexDigit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    private URIComponent() {
    }

    public static String getRawParentPath(String string) {
        return URIComponent.getRawParentPath(string, true);
    }

    public static String getRawParentPath(String string, boolean bl) {
        int n;
        if ("/".equals(string)) {
            return null;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf(47)) < 0) {
            return null;
        }
        if (n == 0) {
            return "/";
        }
        return string.substring(0, bl ? n + 1 : n);
    }

    public static String getBaseName(String string) {
        String string2 = URIComponent.getRawBaseName(string);
        return string2 == null ? null : URIComponent.decode(string2);
    }

    public static String getRawBaseName(String string) {
        int n;
        if ("/".equals(string)) {
            return "";
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf(47)) < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getExtension(String string) {
        String string2 = URIComponent.getRawExtension(string);
        return string2 == null ? null : URIComponent.decode(string2);
    }

    public static String getRawExtension(String string) {
        int n = FileUtil.indexOfDot(string, '/');
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String setExtension(String string, String string2) {
        if (string2 != null) {
            string2 = URIComponent.quotePath(string2);
        }
        return URIComponent.setRawExtension(string, string2);
    }

    public static String setRawExtension(String string, String string2) {
        if (string.endsWith("/")) {
            return string;
        }
        int n = FileUtil.indexOfDot(string, '/');
        if (n < 0) {
            if (string2 == null) {
                return string;
            }
            return string + "." + string2;
        }
        if (string2 == null) {
            return string.substring(0, n);
        }
        return string.substring(0, n + 1) + string2;
    }

    public static String getFragment(String string) {
        String string2 = URIComponent.getRawFragment(string);
        return string2 == null ? null : URIComponent.decode(string2);
    }

    public static String getRawFragment(String string) {
        int n = string.lastIndexOf(35);
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String setFragment(String string, String string2) {
        if (string2 != null) {
            string2 = URIComponent.quoteFragment(string2);
        }
        return URIComponent.setRawFragment(string, string2);
    }

    public static String setRawFragment(String string, String string2) {
        int n = string.lastIndexOf(35);
        if (n < 0) {
            if (string2 == null) {
                return string;
            }
            return string + "#" + string2;
        }
        if (string2 == null) {
            return string.substring(0, n);
        }
        return string.substring(0, n + 1) + string2;
    }

    public static String getRawQuery(String string) {
        int n = string.lastIndexOf(63);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n + 1);
        if ((n = string2.lastIndexOf(35)) < 0) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public static String setRawQuery(String string, String string2) {
        int n = string.lastIndexOf(63);
        if (n < 0 && string2 == null) {
            return string;
        }
        String string3 = null;
        n = string.lastIndexOf(35);
        if (n >= 0) {
            string3 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        Object object = (n = string.lastIndexOf(63)) < 0 ? string + "?" + string2 : (string2 == null ? string.substring(0, n) : string.substring(0, n + 1) + string2);
        if (string3 != null) {
            object = (String)object + "#" + string3;
        }
        return object;
    }

    public static String getRawRelativePath(String string, String string2) {
        if (!string.startsWith("/") || !string2.startsWith("/")) {
            return string;
        }
        if ("/".equals(string)) {
            return "/";
        }
        if ("/".equals(string2)) {
            return string.substring(1);
        }
        if (!string2.endsWith("/")) {
            string2 = URIComponent.getRawParentPath(string2, true);
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (string2 != null) {
            String string3 = string2;
            if (string.startsWith(string3)) {
                stringBuilder.append(string.substring(string3.length()));
                break;
            }
            stringBuilder.append("../");
            string2 = URIComponent.getRawParentPath(string2, true);
        }
        return stringBuilder.toString();
    }

    public static String truncatePath(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        String[] stringArray = StringUtil.split(string, '/');
        if (stringArray.length <= 2) {
            return string;
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[n2]);
        ++n2;
        int n3 = stringArray.length - 1;
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(stringArray[n3]);
        --n3;
        int n4 = stringBuilder.length() + 3 + stringBuilder2.length();
        boolean bl = true;
        while (n2 < n3 && n4 < n) {
            if (bl) {
                stringBuilder2.insert(0, '/');
                stringBuilder2.insert(0, stringArray[n3]);
                --n3;
                bl = false;
            } else {
                stringBuilder.append('/');
                stringBuilder.append(stringArray[n2]);
                ++n2;
                bl = true;
            }
            n4 = stringBuilder.length() + 3 + stringBuilder2.length();
        }
        stringBuilder.append("/\u2026/");
        stringBuilder.append(stringBuilder2.toString());
        return stringBuilder.toString();
    }

    public static String joinQuotedComponents(String string, String string2, String string3, String string4, int n, String string5, String string6, String string7) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        if (string4 != null && string4.length() > 0) {
            stringBuilder.append("//");
            if (string2 != null && string2.length() > 0) {
                stringBuilder.append(string2);
                if (string3 != null && string3.length() > 0) {
                    stringBuilder.append(':');
                    stringBuilder.append(string3);
                }
                stringBuilder.append('@');
            }
            stringBuilder.append(string4);
            if (n >= 0) {
                stringBuilder.append(':');
                stringBuilder.append(n);
            }
        }
        if (string5 != null) {
            stringBuilder.append(string5);
        }
        if (string6 != null && string6.length() > 0) {
            stringBuilder.append('?');
            stringBuilder.append(string6);
        }
        if (string7 != null && string7.length() > 0) {
            stringBuilder.append('#');
            stringBuilder.append(string7);
        }
        return stringBuilder.toString();
    }

    public static String quoteUserInfo(String string) {
        URI uRI;
        try {
            uRI = new URI("http", string, "localhost", 80, "/x", null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
        return uRI.getRawUserInfo();
    }

    public static String quotePath(String string) {
        URI uRI;
        try {
            uRI = new URI("http", null, "localhost", 80, "/x" + string, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
        return uRI.getRawPath().substring(2);
    }

    public static String quoteFullPath(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        URIComponent.quoteFullPath(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void quoteFullPath(String string, StringBuilder stringBuilder) {
        String[] stringArray = StringUtil.split(string, '/');
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (i > 0) {
                stringBuilder.append('/');
            }
            if (string2.length() <= 0) continue;
            stringBuilder.append(URIComponent.quotePath(string2));
        }
    }

    public static String quoteQuery(String string) {
        URI uRI;
        try {
            uRI = new URI("http", null, "localhost", 80, "/x", string, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
        return uRI.getRawQuery();
    }

    public static String quoteFragment(String string) {
        URI uRI;
        try {
            uRI = new URI("http", null, "localhost", 80, "/x", null, string);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
        return uRI.getRawFragment();
    }

    public static String decode(String string) {
        return URIComponent.decode(string, "UTF-8");
    }

    public static String decode(String string, String string2) {
        byte[] byArray;
        if (string.indexOf(37) < 0) {
            return string;
        }
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            int n6 = byArray[i];
            if (n6 == 37 && i + 2 < n && (n5 = URIComponent.fromHexDigit(byArray[i + 1])) >= 0 && (n4 = URIComponent.fromHexDigit(byArray[i + 2])) >= 0) {
                n3 = n5 << 4 | n4;
                i += 2;
            } else {
                n3 = n6;
            }
            byArray2[n2++] = (byte)n3;
        }
        try {
            return new String(byArray2, 0, n2, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    private static final int fromHexDigit(int n) {
        if (n < 48 || n > 102) {
            return -1;
        }
        return fromHexDigit[n - 48];
    }

    public static String encode(String string) {
        return URIComponent.encode(string, "UTF-8");
    }

    public static String encode(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            byte[] byArray;
            char c = string.charAt(i);
            if (c <= '\u007f' && !Character.isSpaceChar(c) && !Character.isISOControl(c)) {
                stringBuilder.append(c);
                continue;
            }
            try {
                byArray = Character.toString(c).getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return null;
            }
            int n2 = byArray.length;
            for (int j = 0; j < n2; ++j) {
                String string3 = Integer.toHexString(byArray[j] & 0xFF);
                stringBuilder.append('%');
                if (string3.length() == 1) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string3.toUpperCase());
            }
        }
        return stringBuilder.toString();
    }
}

