/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import java.lang.reflect.Array;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static final <T> T[] trimToSize(T[] TArray, int n) {
        if (TArray.length == n) {
            return TArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
        System.arraycopy(TArray, 0, objectArray, 0, n);
        return objectArray;
    }

    public static final <T> T[] subArray(T[] TArray, int n) {
        return ArrayUtil.subArray(TArray, n, TArray.length);
    }

    public static final <T> T[] subArray(T[] TArray, int n, int n2) {
        if (n2 < 0 || n2 > TArray.length) {
            throw new IndexOutOfBoundsException("end=" + n2);
        }
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("start=" + n);
        }
        int n3 = n2 - n;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n3);
        System.arraycopy(TArray, n, objectArray, 0, n3);
        return objectArray;
    }

    public static final <T> T[] insert(T[] TArray, int n, T t) {
        int n2;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + 1);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        if ((n2 = TArray.length - n) > 0) {
            System.arraycopy(TArray, n, objectArray, n + 1, n2);
        }
        objectArray[n] = t;
        return objectArray;
    }

    public static final <T> T[] insert(T[] TArray, int n, T[] TArray2) {
        int n2;
        int n3 = TArray2.length;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + n3);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        if ((n2 = TArray.length - n) > 0) {
            System.arraycopy(TArray, n, objectArray, n + n3, n2);
        }
        for (int i = 0; i < n3; ++i) {
            objectArray[n + i] = TArray2[i];
        }
        return objectArray;
    }

    public static final <T> T[] prepend(T[] TArray, T t) {
        return ArrayUtil.insert(TArray, 0, t);
    }

    public static final <T> T[] append(T[] TArray, T t) {
        return ArrayUtil.insert(TArray, TArray.length, t);
    }

    public static final <T> T[] remove(T[] TArray, T t) {
        int n = ArrayUtil.indexOf(TArray, t);
        if (n < 0) {
            return TArray;
        }
        return ArrayUtil.removeAt(TArray, n);
    }

    public static final <T> int indexOf(T[] TArray, T t) {
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T t2 = TArray[i];
            if ((t2 != null || t != null) && (t2 == null || !t2.equals(t))) continue;
            return i;
        }
        return -1;
    }

    public static final <T> int find(T[] TArray, T t) {
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            if (TArray[i] != t) continue;
            return i;
        }
        return -1;
    }

    public static final <T> T[] removeAt(T[] TArray, int n) {
        return ArrayUtil.removeAt(TArray, n, 1);
    }

    public static final <T> T[] removeAt(T[] TArray, int n, int n2) {
        int n3;
        int n4;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length - n2);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        if ((n4 = TArray.length - (n3 = n + n2)) > 0) {
            System.arraycopy(TArray, n3, objectArray, n, n4);
        }
        return objectArray;
    }

    public static final <T> void reverse(T[] TArray) {
        int n = 0;
        for (int i = TArray.length - 1; n < i; ++n, --i) {
            T t = TArray[n];
            TArray[n] = TArray[i];
            TArray[i] = t;
        }
    }
}

