/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import com.xmlmind.netutil.AuthenticatorModule;
import com.xmlmind.netutil.ModularAuthenticator;
import com.xmlmind.util.Base64;
import com.xmlmind.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;

public class SimpleAuthenticatorModule
implements AuthenticatorModule {
    public final String host;
    public final int port;
    public final String prompt;
    public final String scheme;
    public final String username;
    public final char[] password;
    private ModularAuthenticator authenticator;

    public SimpleAuthenticatorModule(String string) throws IllegalArgumentException {
        String string2;
        String string3;
        String string4;
        byte[] byArray = Base64.decode(string);
        if (byArray == null) {
            throw new IllegalArgumentException("cannot decode base-64 data '" + string + "'");
        }
        String string5 = null;
        try {
            string5 = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
        String[] stringArray = StringUtil.split(string5, '\n');
        if (stringArray.length != 6) {
            throw new IllegalArgumentException("expected '" + string5 + "' to contain 6 fields: host, port, prompt, scheme, username and password");
        }
        String string6 = stringArray[0];
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        int n = -1;
        if (stringArray[1].length() > 0) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0 || n > 65535) {
                throw new IllegalArgumentException("'" + stringArray[1] + "' invalid port field");
            }
        }
        if ((string4 = stringArray[2]) != null && string4.length() == 0) {
            string4 = null;
        }
        if ((string3 = stringArray[3]) != null && string3.length() == 0) {
            string3 = null;
        }
        if ((string2 = stringArray[4]).length() == 0) {
            throw new IllegalArgumentException("field username cannot be empty");
        }
        String string7 = stringArray[5];
        if (string7.length() == 0) {
            throw new IllegalArgumentException("field password cannot be empty");
        }
        this.host = string6;
        this.port = n;
        this.prompt = string4;
        this.scheme = string3;
        this.username = string2;
        this.password = string7.toCharArray();
    }

    public SimpleAuthenticatorModule(String string, int n, String string2, String string3, String string4, char[] cArray) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        this.host = string;
        this.port = n;
        this.prompt = string2;
        this.scheme = string3;
        this.username = string4;
        this.password = cArray;
    }

    @Override
    public void setModularAuthenticator(ModularAuthenticator modularAuthenticator) {
        this.authenticator = modularAuthenticator;
    }

    @Override
    public ModularAuthenticator getModularAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void clearCredentials() {
    }

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        String string;
        String string2;
        int n;
        if (this.host != null) {
            InetAddress inetAddress;
            String string3 = this.authenticator.requestingHost();
            if (string3 == null && (inetAddress = this.authenticator.requestingSite()) != null) {
                string3 = inetAddress.getHostAddress();
            }
            if (string3 != null && !this.host.equalsIgnoreCase(string3)) {
                return null;
            }
        }
        if (this.port > 0 && (n = this.authenticator.requestingPort()) > 0 && this.port != n) {
            return null;
        }
        if (this.prompt != null && (string2 = this.authenticator.requestingPrompt()) != null && !this.prompt.equalsIgnoreCase(string2)) {
            return null;
        }
        if (this.scheme != null && (string = this.authenticator.requestingScheme()) != null && !this.scheme.equalsIgnoreCase(string)) {
            return null;
        }
        return new PasswordAuthentication(this.username, this.password);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append('[');
        stringBuilder.append("host=");
        stringBuilder.append(this.host);
        stringBuilder.append(", port=");
        stringBuilder.append(this.port);
        stringBuilder.append(", prompt=");
        stringBuilder.append(this.prompt);
        stringBuilder.append(", scheme=");
        stringBuilder.append(this.scheme);
        stringBuilder.append(", username=");
        stringBuilder.append(this.username);
        stringBuilder.append(", password=");
        stringBuilder.append(new String(this.password));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String encodeCredentials(String string, int n, String string2, String string3, String string4, char[] cArray) {
        if (string == null) {
            string = "";
        }
        String string5 = n <= 0 ? "" : Integer.toString(n);
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        String string6 = StringUtil.join('\n', string, string5, string2, string3, string4, new String(cArray));
        String string7 = null;
        try {
            string7 = Base64.encode(string6.getBytes("UTF-8")).trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string7;
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        String string = null;
        char[] cArray = null;
        String string2 = "";
        int n = -1;
        String string3 = "";
        String string4 = "";
        switch (stringArray.length) {
            case 5: {
                string4 = stringArray[4];
                if ("-".equals(string4)) {
                    string4 = null;
                }
            }
            case 4: {
                string3 = stringArray[3];
                if ("-".equals(string3)) {
                    string3 = null;
                }
            }
            case 3: {
                string2 = stringArray[2];
                int n2 = string2.lastIndexOf(58);
                if (n2 >= 0) {
                    String string5 = string2.substring(n2 + 1);
                    string2 = string2.substring(0, n2);
                    if (string5.length() > 0 && !"-".equals(string5)) {
                        try {
                            n = Integer.parseInt(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n <= 0 || n > 65535) {
                            bl = true;
                        }
                    }
                }
                if ("-".equals(string2)) {
                    string2 = null;
                }
            }
            case 2: {
                cArray = stringArray[1].toCharArray();
                string = stringArray[0];
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            SimpleAuthenticatorModule.usage();
        }
        String string6 = SimpleAuthenticatorModule.encodeCredentials(string2, n, string3, string4, string, cArray);
        System.out.println(string6);
    }

    private static void usage() {
        System.err.println("Usage: authvalue username password [host[:port]? [prompt [scheme]?]?]?\n\nConverts specified user credentials to an encoded string\nfor use by the \"-auth\" command-line option of XXE.\n\nusername\n  The username of the authenticated user.\npassword\n  The password of the authenticated user.\nhost\n  The hostname or address of the host. \"-\" matches any host.\nport\n  The port number of the service. \"-\" matches any port.\nprompt\n  The prompt (AKA realm) used by the service.\n  \"-\" matches any prompt\nscheme\n  The authentication scheme (BASIC, DIGEST, etc)\n  used by the service. \"-\" matches any scheme.");
        System.exit(1);
    }
}

