/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import com.xmlmind.netutil.FileContent;
import com.xmlmind.netutil.FileContentImpl;
import com.xmlmind.netutil.MultipartWriter;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;

public final class PostRequest {
    public static final String DEFAULT_CHAR_ENCODING = "UTF-8";
    private ArrayList<Parameter> parameterList = new ArrayList();
    private ArrayList<Header> headerList = new ArrayList();
    private String charEncoding;
    private CharsetEncoder charEncoder;

    public PostRequest() {
        this.setCharacterEncoding(null);
    }

    public void addParameter(String string, Object object) {
        this.parameterList.add(new Parameter(string, object));
    }

    public List<Parameter> getParameterList() {
        return this.parameterList;
    }

    public boolean isMultipartRequest() {
        for (Parameter parameter : this.parameterList) {
            if (!(parameter.value instanceof FileContent)) continue;
            return true;
        }
        return false;
    }

    public void addHeader(String string, String string2) {
        this.headerList.add(new Header(string, string2));
    }

    public List<Header> getHeaderList() {
        return this.headerList;
    }

    public void setCharacterEncoding(String string) {
        if (string == null) {
            string = DEFAULT_CHAR_ENCODING;
        }
        this.charEncoding = string;
        this.charEncoder = Charset.forName(this.charEncoding).newEncoder();
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public HttpURLConnection post(URL uRL) throws IOException {
        void var4_8;
        HttpURLConnection httpURLConnection = PostRequest.openConnection(uRL);
        for (Header object2 : this.headerList) {
            httpURLConnection.addRequestProperty(object2.name, object2.value);
        }
        Object object3 = null;
        Object var4_5 = null;
        boolean bl = this.isMultipartRequest();
        if (bl) {
            object3 = new MultipartWriter(httpURLConnection, this.charEncoding);
            OutputStream outputStream = ((MultipartWriter)object3).out;
        } else {
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream outputStream = httpURLConnection.getOutputStream();
        }
        try {
            boolean bl2 = true;
            for (Parameter parameter : this.parameterList) {
                Object object;
                String string = parameter.name;
                Object object2 = parameter.value;
                if (bl) {
                    if (object2 instanceof FileContent) {
                        object = (FileContent)object2;
                        ((MultipartWriter)object3).writePart(string, (FileContent)object);
                        continue;
                    }
                    object = PostRequest.textParamValue(string, object2, this.charEncoding);
                    ((MultipartWriter)object3).writePart(string, (String)object);
                    continue;
                }
                object = PostRequest.textParamValue(string, object2, this.charEncoding);
                if (bl2) {
                    bl2 = false;
                } else {
                    var4_8.write(38);
                }
                String string2 = PostRequest.urlEncode(string, this.charEncoding, this.charEncoder);
                var4_8.write(string2.getBytes("US-ASCII"));
                var4_8.write(61);
                string2 = PostRequest.urlEncode((String)object, this.charEncoding, this.charEncoder);
                var4_8.write(string2.getBytes("US-ASCII"));
            }
            if (bl) {
                ((MultipartWriter)object3).writeEndOfParts();
            }
            var4_8.flush();
        }
        finally {
            if (var4_8 != null) {
                var4_8.close();
            }
        }
        return httpURLConnection;
    }

    private static final String textParamValue(String string, Object object, String string2) {
        String string3 = object.toString();
        if ("_charset_".equals(string) && string3.length() == 0) {
            string3 = string2;
        }
        return string3;
    }

    private static final String urlEncode(String string, String string2, CharsetEncoder charsetEncoder) throws UnsupportedEncodingException {
        return URLEncoder.encode(MultipartWriter.escapeUnmappableChars(string, charsetEncoder), string2);
    }

    public static HttpURLConnection openConnection(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        return httpURLConnection;
    }

    public static int checkResponse(HttpURLConnection httpURLConnection) throws IOException {
        int n = httpURLConnection.getResponseCode();
        if (n >= 300) {
            StringBuilder stringBuilder = new StringBuilder("cannot POST to ");
            stringBuilder.append(httpURLConnection.getURL());
            stringBuilder.append(": error ");
            stringBuilder.append(n);
            String string = httpURLConnection.getResponseMessage();
            if (string != null) {
                stringBuilder.append(": ");
                stringBuilder.append(string);
            }
            throw new IOException(stringBuilder.toString());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadTextResponse(HttpURLConnection httpURLConnection, String string) throws IOException {
        String string2 = httpURLConnection.getContentType();
        if (string2 == null || !string2.toLowerCase().startsWith("text/")) {
            return null;
        }
        String string3 = URLUtil.contentTypeToCharset(string2);
        if (string3 == null) {
            string3 = string;
        }
        String string4 = null;
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            string4 = FileUtil.loadString(inputStream, string3);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveResponse(HttpURLConnection httpURLConnection, File file, String object) throws IOException {
        Object object2;
        Object object3;
        if (object == null && (object3 = httpURLConnection.getHeaderField("content-disposition")) != null && ((String)(object3 = ((String)object3).trim())).startsWith("attachment") && (object2 = (object2 = PostRequest.getParam((String)object3, "filename*")) != null ? PostRequest.decodeParam((String)object2) : PostRequest.getParam((String)object3, "filename")) != null) {
            object = object2;
        }
        object3 = object == null || ((String)(object = ((String)object).trim())).length() == 0 ? File.createTempFile("resp", ".dat", file) : new File(file, (String)object);
        object2 = httpURLConnection.getInputStream();
        try {
            FileUtil.copyFile((InputStream)object2, (File)object3);
        }
        finally {
            ((InputStream)object2).close();
        }
    }

    private static final String getParam(String string, String object) {
        int n = string.indexOf(59);
        if (n > 0) {
            int n2;
            ++n;
            n = string.indexOf((String)(object = (String)object + "="), n);
            if (n >= 0 && (n += ((String)object).length()) < (n2 = string.length())) {
                if (string.charAt(n) == '\"') {
                    int n3;
                    boolean bl = false;
                    boolean bl2 = false;
                    for (n3 = n + 1; n3 < n2; ++n3) {
                        if (string.charAt(n3) != '\"') continue;
                        if (string.charAt(n3 - 1) == '\\') {
                            bl2 = true;
                            continue;
                        }
                        bl = true;
                        break;
                    }
                    if (bl) {
                        String string2 = string.substring(n + 1, n3);
                        if (bl2) {
                            string2 = StringUtil.replaceAll(string2, "\\\"", "\"");
                        }
                        return string2;
                    }
                } else {
                    int n4 = string.indexOf(32, n);
                    if (n4 < 0) {
                        n4 = n2;
                    }
                    return string.substring(n, n4);
                }
            }
        }
        return null;
    }

    private static final String decodeParam(String string) {
        int n;
        int n2 = string.indexOf(39);
        if (n2 >= 0 && (n = string.indexOf(39, n2 + 1)) >= 0) {
            String string2 = string.substring(0, n2);
            if (string2.length() == 0) {
                string2 = DEFAULT_CHAR_ENCODING;
            }
            String string3 = string.substring(n + 1);
            return URIComponent.decode(string3, string2);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string;
        Object object;
        int n = stringArray.length;
        if (n < 5) {
            PostRequest.usage(null);
        }
        URL uRL = null;
        try {
            uRL = URLUtil.createURL(stringArray[0]);
        }
        catch (MalformedURLException malformedURLException) {
            PostRequest.usage("'" + stringArray[0] + "' not an URL");
        }
        if (!uRL.getProtocol().startsWith("http")) {
            PostRequest.usage("'" + String.valueOf(uRL) + "' not an HTTP URL");
        }
        File file = null;
        if (!"-".equals(stringArray[1])) {
            file = new File(stringArray[1]);
        }
        PostRequest postRequest = new PostRequest();
        int n2 = 2;
        if ("-e".equals(stringArray[n2])) {
            if (n2 + 1 >= n) {
                PostRequest.usage("missing encoding");
            }
            postRequest.setCharacterEncoding(stringArray[n2 + 1]);
            n2 += 2;
        }
        String string2 = null;
        while (n2 < n) {
            object = stringArray[n2];
            if ("-c".equals(object)) {
                if (n2 + 1 >= n) {
                    PostRequest.usage("missing content type");
                }
                string2 = stringArray[n2 + 1];
                n2 += 2;
                continue;
            }
            if ("-f".equals(object) || "-t".equals(object)) {
                if (n2 + 2 >= n) {
                    PostRequest.usage("missing field name/value");
                }
                string = stringArray[n2 + 1];
                String string3 = XMLText.unescapeXML(stringArray[n2 + 2]);
                if ("-f".equals(object)) {
                    postRequest.addParameter(string, new FileContentImpl(new File(string3), string2));
                } else {
                    postRequest.addParameter(string, string3);
                }
                n2 += 3;
                continue;
            }
            PostRequest.usage(null);
        }
        try {
            object = postRequest.post(uRL);
            PostRequest.checkResponse((HttpURLConnection)object);
            if (file == null) {
                string = PostRequest.loadTextResponse((HttpURLConnection)object, DEFAULT_CHAR_ENCODING);
                if (string == null) {
                    System.err.println("*** error: response does not contain text");
                    System.exit(2);
                }
                System.out.println(string);
            } else if (file.isDirectory()) {
                PostRequest.saveResponse((HttpURLConnection)object, file, null);
            } else {
                PostRequest.saveResponse((HttpURLConnection)object, file.getParentFile(), file.getName());
            }
        }
        catch (Exception exception) {
            System.err.println(ThrowableUtil.reason(exception));
            System.exit(3);
        }
    }

    private static void usage(String string) {
        if (string != null) {
            System.err.println("*** error: " + string);
        }
        System.err.println("java com.xmlmind.netutil.PostRequest http_request_url out_file_or_dir|-\n  [-e encoding] [-c content_type|-f field value|-t field value]+\nPOST request to 'http_request_url'.\nSave response to 'out_file_or_dir'.\nIf 'out_file_or_dir' is '-', print (textual) response on console.\nIf 'out_file_or_dir' is a directory, the basename of the save file\nis obtained from the 'Content-Disposition' header of the response.\nOptions:\n-e encoding\n   Specifies the encoding used for the request. Default: UTF-8.\n-c content_type\n   Specifies the content type of the following file fields.\n-f field value\n   Add to the request file field 'field'.\n   'value' is the path of a file.\n-t field value\n   Add to the request text field 'field'.\n(-f or -t field values may contain special characters\nexpressed as XML character entities.)");
        System.exit(1);
    }

    public static final class Header {
        public final String name;
        public final String value;

        public Header(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }

    public static final class Parameter {
        public final String name;
        public final Object value;

        public Parameter(String string, Object object) {
            this.name = string;
            this.value = object;
        }
    }
}

