/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.netutil.AuthenticationDialog;
import com.xmlmind.netutil.AuthenticatorModule;
import com.xmlmind.netutil.ModularAuthenticator;
import com.xmlmind.netutil.Msg;
import com.xmlmind.netutil.PasswordUtil;
import com.xmlmind.util.ObjectUtil;
import com.xmlmind.util.StringUtil;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public class AuthenticatorModuleImpl
implements AuthenticatorModule {
    private static final long CONFIRM_CREDENTIALS_DELAY;
    private static final char EMPTY_PROMPT_CHAR = '\ue007';
    private ModularAuthenticator authenticator;
    private HashMap<Entry, Entry> entries = new HashMap();
    private Entry probe = new Entry();
    private boolean interactive = true;
    private Component dialogParent;
    private AuthenticationDialog dialog;

    @Override
    public void setModularAuthenticator(ModularAuthenticator modularAuthenticator) {
        this.authenticator = modularAuthenticator;
    }

    @Override
    public ModularAuthenticator getModularAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void clearCredentials() {
        this.entries.clear();
    }

    public void setDialogParent(Component component) {
        this.dialogParent = component;
    }

    public Component getDialogParent() {
        return this.dialogParent;
    }

    public void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setPasswords(String string) {
        this.entries.clear();
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        Entry[] entryArray = Entry.parse(string);
        if (entryArray == null) {
            return;
        }
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            entry.save = true;
            this.entries.put(entry, entry);
        }
    }

    public String getPasswords() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : this.entries.values()) {
            if (!entry.save) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(entry);
        }
        return stringBuilder.toString();
    }

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        boolean bl;
        Object object;
        if (this.authenticator == null) {
            return null;
        }
        this.probe.host = this.authenticator.requestingHost();
        if (this.probe.host == null) {
            object = this.authenticator.requestingSite();
            if (object != null) {
                this.probe.host = ((InetAddress)object).getHostAddress();
            }
        } else {
            this.probe.host = this.probe.host.toLowerCase();
        }
        this.probe.port = this.authenticator.requestingPort();
        this.probe.prompt = this.authenticator.requestingPrompt();
        this.probe.scheme = this.authenticator.requestingScheme();
        if (this.probe.scheme != null) {
            this.probe.scheme = this.probe.scheme.toLowerCase();
        }
        if ((object = this.entries.get(this.probe)) == null) {
            object = new Entry();
            ((Entry)object).host = this.probe.host;
            ((Entry)object).port = this.probe.port;
            ((Entry)object).prompt = this.probe.prompt;
            ((Entry)object).scheme = this.probe.scheme;
            ((Entry)object).userName = null;
            ((Entry)object).password = null;
            ((Entry)object).save = false;
            ((Entry)object).timestamp = -1L;
            ((Entry)object).confirmed = false;
        } else if (this.interactive) {
            if (CONFIRM_CREDENTIALS_DELAY > 0L && !((Entry)object).confirmed) {
                if (((Entry)object).timestamp > 0L && System.currentTimeMillis() - ((Entry)object).timestamp >= CONFIRM_CREDENTIALS_DELAY) {
                    ((Entry)object).confirmed = true;
                } else {
                    ((Entry)object).timestamp = -1L;
                }
            }
        } else {
            ((Entry)object).confirmed = true;
        }
        if (((Entry)object).confirmed) {
            return new PasswordAuthentication(((Entry)object).userName, ((Entry)object).password);
        }
        if (((Entry)object).userName == null && ((Entry)object).password == null) {
            if ("ftp".equalsIgnoreCase(this.authenticator.requestingProtocol())) {
                ((Entry)object).userName = "anonymous";
                ((Entry)object).password = PasswordUtil.getAnonymousFTPPassword().toCharArray();
            } else {
                ((Entry)object).userName = PasswordUtil.getUserName();
            }
        }
        if (!(bl = this.dialogParent != null ? this.askUser((Entry)object) : this.promptUser((Entry)object, true))) {
            return null;
        }
        if (CONFIRM_CREDENTIALS_DELAY > 0L) {
            ((Entry)object).timestamp = System.currentTimeMillis();
        } else {
            ((Entry)object).confirmed = true;
        }
        this.entries.put((Entry)object, (Entry)object);
        return new PasswordAuthentication(((Entry)object).userName, ((Entry)object).password);
    }

    private boolean askUser(Entry entry) {
        final AuthenticationDialog.Info info = new AuthenticationDialog.Info();
        info.prompt = AuthenticatorModuleImpl.prompt(entry);
        info.userName = entry.userName;
        info.password = entry.password;
        info.save = entry.save;
        final AuthenticationDialog.Info[] infoArray = new AuthenticationDialog.Info[1];
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (AuthenticatorModuleImpl.this.dialog == null) {
                            AuthenticatorModuleImpl.this.dialog = new AuthenticationDialog(AuthenticatorModuleImpl.this.dialogParent, true);
                        }
                        infoArray[0] = AuthenticatorModuleImpl.this.dialog.getPassword(info);
                    }
                });
            }
            catch (Exception exception) {
                infoArray[0] = null;
            }
        } else {
            if (this.dialog == null) {
                this.dialog = new AuthenticationDialog(this.dialogParent, true);
            }
            infoArray[0] = this.dialog.getPassword(info);
        }
        if (infoArray[0] == null) {
            return false;
        }
        entry.userName = infoArray[0].userName;
        entry.password = infoArray[0].password;
        entry.save = infoArray[0].save;
        return true;
    }

    private static final String prompt(Entry entry) {
        String string = entry.prompt;
        if (string == null || string.length() == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            if (entry.host != null) {
                Object object = entry.host;
                if (entry.port >= 0) {
                    object = (String)object + ":" + entry.port;
                }
                stringBuilder.append(Msg.msg("host", object));
            }
            if (entry.scheme != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(Msg.msg("scheme", entry.scheme));
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private boolean promptUser(Entry entry, boolean bl) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println(Msg.msg("auth.prompt1"));
        System.out.println(Msg.msg("auth.prompt2", AuthenticatorModuleImpl.prompt(entry)));
        System.out.flush();
        String string = Msg.msg("yes");
        String string2 = Msg.msg("no");
        String string3 = Msg.msg("cancel");
        String[] stringArray = new String[]{DialogUtil.buttonLabel(Msg.msg("auth.userName")), entry.userName, DialogUtil.buttonLabel(Msg.msg("auth.password")), null, DialogUtil.buttonLabel(Msg.msg("auth.rememberUserInfo")) + " (" + string + "/" + string2 + "/" + string3 + ")", entry.save ? string : string2};
        boolean[] blArray = new boolean[]{false, false, true};
        boolean[] blArray2 = new boolean[]{false, bl, false};
        String[] stringArray2 = new String[3];
        block2: for (int i = 0; i < stringArray2.length; ++i) {
            String string4 = stringArray[2 * i];
            String string5 = stringArray[2 * i + 1];
            boolean bl2 = blArray[i];
            boolean bl3 = blArray2[i];
            while (true) {
                System.out.print(string4);
                if (string5 != null) {
                    System.out.print(" [" + string5 + "]");
                }
                System.out.print(": ");
                System.out.flush();
                try {
                    stringArray2[i] = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    stringArray2[i] = null;
                }
                if (stringArray2[i] == null) {
                    return false;
                }
                stringArray2[i] = stringArray2[i].trim();
                if (stringArray2[i].length() == 0) {
                    if (string5 != null) {
                        stringArray2[i] = string5;
                        continue block2;
                    }
                    if (!bl3) {
                        return false;
                    }
                    stringArray2[i] = "";
                    continue;
                }
                if (!bl2 || string.equals(stringArray2[i]) || string2.equals(stringArray2[i])) continue block2;
                if (string3.equals(stringArray2[i])) break;
            }
            return false;
        }
        entry.userName = stringArray2[0];
        entry.password = stringArray2[1].toCharArray();
        entry.save = string.equals(stringArray2[2]);
        return true;
    }

    static {
        long l = -1L;
        String string = System.getProperty("XXE_CONFIRM_CREDENTIALS_DELAY");
        if (string != null && (string = string.trim()).length() > 0) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        CONFIRM_CREDENTIALS_DELAY = l;
    }

    private static final class Entry {
        public String host;
        public int port = -1;
        public String prompt;
        public String scheme;
        public String userName;
        public char[] password;
        public boolean save;
        public long timestamp = -1L;
        public boolean confirmed;

        private Entry() {
        }

        public int hashCode() {
            int n = 0;
            if (this.host != null) {
                n ^= this.host.hashCode();
            }
            if (this.port >= 0) {
                n ^= this.port;
            }
            if (this.prompt != null) {
                n ^= this.prompt.hashCode();
            }
            if (this.scheme != null) {
                n ^= this.scheme.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return ObjectUtil.equals(this.host, entry.host) && this.port == entry.port && ObjectUtil.equals(this.prompt, entry.prompt) && ObjectUtil.equals(this.scheme, entry.scheme);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            stringBuilder.append("host=");
            if (this.host != null) {
                stringBuilder.append(this.host);
            }
            stringBuilder.append('\n');
            stringBuilder.append("port=");
            if (this.port >= 0) {
                stringBuilder.append(this.port);
            }
            stringBuilder.append('\n');
            stringBuilder.append("prompt=");
            if (this.prompt != null) {
                if (this.prompt.length() == 0) {
                    stringBuilder.append('\ue007');
                } else {
                    stringBuilder.append(this.prompt);
                }
            }
            stringBuilder.append('\n');
            stringBuilder.append("scheme=");
            if (this.scheme != null) {
                stringBuilder.append(this.scheme);
            }
            stringBuilder.append('\n');
            stringBuilder.append("userName=");
            stringBuilder.append(this.userName);
            stringBuilder.append('\n');
            stringBuilder.append("password=");
            if (this.password.length > 0) {
                PasswordUtil.escapePassword(new String(this.password), stringBuilder);
            }
        }

        public static Entry[] parse(String string) {
            Entry[] entryArray;
            int n;
            String[] stringArray = StringUtil.split(string, '\n');
            if (stringArray.length == 0 || stringArray.length % 6 != 0) {
                return null;
            }
            ArrayList<Entry[]> arrayList = new ArrayList<Entry[]>();
            for (n = 0; n < stringArray.length; n += 6) {
                entryArray = new Entry();
                String string2 = stringArray[n];
                if (!string2.startsWith("host=")) continue;
                if (string2.length() > 5) {
                    entryArray.host = string2.substring(5);
                }
                if (!(string2 = stringArray[n + 1]).startsWith("port=")) continue;
                if (string2.length() > 5) {
                    try {
                        entryArray.port = Integer.parseInt(string2.substring(5));
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                }
                if (!(string2 = stringArray[n + 2]).startsWith("prompt=")) continue;
                if (string2.length() > 7) {
                    entryArray.prompt = string2.substring(7);
                    if (entryArray.prompt.length() == 1 && entryArray.prompt.charAt(0) == '\ue007') {
                        entryArray.prompt = "";
                    }
                }
                if (!(string2 = stringArray[n + 3]).startsWith("scheme=")) continue;
                if (string2.length() > 7) {
                    entryArray.scheme = string2.substring(7);
                }
                if (!(string2 = stringArray[n + 4]).startsWith("userName=") || string2.length() == 9) continue;
                entryArray.userName = string2.substring(9);
                string2 = stringArray[n + 5];
                if (!string2.startsWith("password=")) continue;
                if (string2.length() > 9) {
                    String string3 = string2.substring(9);
                    String string4 = PasswordUtil.unescapePassword(string3);
                    if (string4 == null) continue;
                    entryArray.password = string4.toCharArray();
                } else {
                    entryArray.password = new char[0];
                }
                arrayList.add(entryArray);
            }
            n = arrayList.size();
            if (n == 0) {
                return null;
            }
            entryArray = new Entry[n];
            arrayList.toArray(entryArray);
            return entryArray;
        }
    }
}

