/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.jhelp;

import com.xmlmind.guiutil.PossiblyLengthyTask;
import com.xmlmind.jhelp.DefaultViewer;
import com.xmlmind.jhelp.DefaultViewerImpl;
import com.xmlmind.jhelp.HelpBrowser;
import com.xmlmind.jhelp.HelpEntry;
import com.xmlmind.jhelp.IdMap;
import com.xmlmind.jhelp.IdMaps;
import com.xmlmind.jhelp.Msg;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.SystemUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public final class JHelp {
    private static String helpBrowserTitle;
    private static IdMaps idMaps;
    private static DefaultViewer defaultViewer;
    private static HelpBrowser helpBrowser;
    private static boolean brokenHelpBrowser;
    private static final String TOPIC_ID_PROP_NAME = "com.xmlmind.jhelp.JHelp.topicId";

    public static void initialize(String string, URI uRI, DefaultViewer defaultViewer) {
        if (idMaps == null) {
            helpBrowserTitle = string;
            idMaps = new IdMaps(uRI);
            if (defaultViewer == null) {
                defaultViewer = new DefaultViewerImpl();
            }
            JHelp.defaultViewer = defaultViewer;
        }
    }

    public static String getHelpTitle() {
        return helpBrowserTitle;
    }

    public static URI getHelpBaseURI() {
        return idMaps == null ? null : JHelp.idMaps.helpBaseURI;
    }

    public static DefaultViewer getDefaultViewer() {
        return defaultViewer;
    }

    public static IdMap addIdMap(URL uRL) {
        if (idMaps == null) {
            throw new IllegalStateException("not initialized");
        }
        return idMaps.add(uRL);
    }

    public static IdMap[] getIdMaps() {
        if (idMaps == null) {
            return IdMap.EMPTY_LIST;
        }
        return idMaps.getAll();
    }

    public static void setHelpTopicId(Component component, String string) {
        if (component != null && component instanceof JComponent) {
            string = string == null ? "" : string.trim();
            ((JComponent)component).putClientProperty(TOPIC_ID_PROP_NAME, string);
        }
    }

    public static void unsetHelpTopicId(Component component) {
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).putClientProperty(TOPIC_ID_PROP_NAME, null);
        }
    }

    public static boolean hasHelpTopics() {
        return JHelp.getIdMaps().length > 0;
    }

    public static boolean configureHelpButton(final AbstractButton abstractButton, String string) {
        JHelp.unsetHelpTopicId(abstractButton);
        for (ActionListener actionListener : abstractButton.getActionListeners()) {
            abstractButton.removeActionListener(actionListener);
        }
        boolean bl = JHelp.hasHelpTopics();
        if (bl) {
            final String string2 = string == null ? "" : string.trim();
            JHelp.setHelpTopicId(abstractButton, string2);
            abstractButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JHelp.showHelpTopic(string2, abstractButton);
                }
            });
        }
        abstractButton.setEnabled(bl);
        return bl;
    }

    public static boolean showHelpTopic(String string, Component component) {
        return JHelp.showHelpTopic(string, true, component);
    }

    public static boolean showHelpTopic(String string, boolean bl, Component component) {
        Object object;
        Serializable serializable;
        Object[] objectArray;
        if (!JHelp.hasHelpTopics()) {
            return false;
        }
        boolean bl2 = idMaps.isCompileNeeded();
        if (bl2) {
            objectArray = new PossiblyLengthyTask(component, Msg.msg("loadingIdMaps"), new PossiblyLengthyTask.MonitoredRunnable(){

                @Override
                public void run() {
                    this.run(null);
                }

                @Override
                public void run(ProgressMonitor progressMonitor) {
                    idMaps.compile(progressMonitor);
                }

                @Override
                public String getMessageLog() {
                    return Msg.msg("jhelpLogName");
                }
            }, 1000);
            objectArray.execute();
        }
        objectArray = null;
        if ((bl2 || helpBrowser == null) && SystemUtil.hasJavaFX()) {
            serializable = new ArrayList();
            object = JHelp.getHelpBaseURI();
            for (IdMap idMap : idMaps.getAll()) {
                if (idMap.title == null) continue;
                URI uRI = idMap.uri;
                if (object != null) {
                    uRI = ((URI)object).resolve(uRI);
                }
                ((ArrayList)serializable).add(new HelpEntry(idMap.title, uRI, idMap.isMainIdMap()));
            }
            objectArray = ((ArrayList)serializable).toArray(HelpEntry.EMPTY_LIST);
            if (objectArray.length > 1) {
                Arrays.sort(objectArray);
            }
        }
        if ((serializable = idMaps.getHelpTopicURI(string, bl)) == null) {
            return false;
        }
        if (helpBrowser == null && SystemUtil.hasJavaFX() && !brokenHelpBrowser) {
            try {
                object = helpBrowserTitle;
                if (object == null) {
                    IdMap[] idMapArray = JHelp.getIdMaps();
                    if (idMapArray.length > 0) {
                        object = idMapArray[0].title;
                    }
                    if (object == null) {
                        object = Msg.msg("helpTitle");
                    }
                }
                helpBrowser = new HelpBrowser((String)object);
                helpBrowser.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        helpBrowser = null;
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                helpBrowser = null;
                brokenHelpBrowser = true;
            }
        }
        if (helpBrowser != null) {
            if (objectArray != null) {
                helpBrowser.setEntries((HelpEntry[])objectArray);
            }
            helpBrowser.showHelpTopic((URI)serializable);
        } else {
            defaultViewer.open((URI)serializable, component);
        }
        return true;
    }

    public static void pickHelpTopic(Component component) {
        if (!JHelp.hasHelpTopics()) {
            return;
        }
        RootPaneContainer rootPaneContainer = null;
        while (component != null) {
            if (component instanceof RootPaneContainer) {
                rootPaneContainer = (RootPaneContainer)((Object)component);
                break;
            }
            component = component.getParent();
        }
        if (rootPaneContainer == null) {
            return;
        }
        new ComponentPicker(rootPaneContainer);
    }

    private static final class ComponentPicker
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        private Component glassPane;
        private JLayeredPane layeredPane;
        private Cursor savedCursor;

        public ComponentPicker(RootPaneContainer rootPaneContainer) {
            this.glassPane = rootPaneContainer.getGlassPane();
            if (this.glassPane.isVisible()) {
                return;
            }
            this.layeredPane = rootPaneContainer.getLayeredPane();
            this.savedCursor = this.glassPane.getCursor();
            this.glassPane.setCursor(Cursor.getPredefinedCursor(12));
            this.glassPane.addKeyListener(this);
            this.glassPane.addMouseMotionListener(this);
            this.glassPane.addMouseListener(this);
            this.glassPane.setVisible(true);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Component component;
            String string = null;
            for (component = SwingUtilities.getDeepestComponentAt(this.layeredPane, mouseEvent.getX(), mouseEvent.getY()); !(component == null || component instanceof JComponent && (string = (String)((JComponent)component).getClientProperty(JHelp.TOPIC_ID_PROP_NAME)) != null); component = component.getParent()) {
            }
            if (string != null) {
                final String string2 = string;
                final Component component2 = component;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JHelp.showHelpTopic(string2, component2);
                    }
                });
            }
            this.glassPane.setCursor(this.savedCursor);
            this.glassPane.removeKeyListener(this);
            this.glassPane.removeMouseMotionListener(this);
            this.glassPane.removeMouseListener(this);
            this.glassPane.setVisible(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

