/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.jhelp;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class IdMap {
    public final URL sourceURL;
    public final String title;
    public final String href;
    public final URI uri;
    private boolean isMainIdMap;
    public static final IdMap[] EMPTY_LIST = new IdMap[0];

    public IdMap(URL uRL) {
        assert (uRL != null);
        this.sourceURL = uRL;
        this.title = null;
        this.href = null;
        this.uri = null;
    }

    public IdMap(URL uRL, String string, String string2) throws URISyntaxException {
        assert (uRL != null);
        assert (string != null);
        assert (string2 != null);
        this.sourceURL = uRL;
        this.title = string;
        this.href = string2;
        String string3 = string2;
        try {
            Class<?> clazz = Class.forName("com.xmlmind.xml.resolve.XMLCatalogs");
            Method method = clazz.getMethod("resolveURI", String.class);
            string3 = (String)method.invoke(null, string2);
            if (string3 == null) {
                string3 = string2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.uri = new URI(string3).normalize();
    }

    public void setMainIdMap(boolean bl) {
        this.isMainIdMap = bl;
    }

    public boolean isMainIdMap() {
        return this.isMainIdMap;
    }

    public URI getURI(URI uRI) {
        URI uRI2 = this.uri;
        if (uRI != null && uRI2 != null) {
            uRI2 = uRI.resolve(uRI2);
        }
        return uRI2;
    }

    public int hashCode() {
        return this.sourceURL.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IdMap)) {
            return false;
        }
        return this.sourceURL.equals(((IdMap)object).sourceURL);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("IdMap[sourceURL=");
        stringBuilder.append(this.sourceURL.toExternalForm());
        if (this.title != null) {
            stringBuilder.append(", title=\"");
            stringBuilder.append(this.title);
            stringBuilder.append('\"');
        }
        if (this.href != null) {
            stringBuilder.append(", href=");
            stringBuilder.append(this.href);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri.toASCIIString());
        }
        if (this.isMainIdMap) {
            stringBuilder.append(", isMainIdMap");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

