/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.jhelp;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.ImageResource;
import com.xmlmind.jhelp.HelpEntry;
import com.xmlmind.jhelp.IdMaps;
import com.xmlmind.jhelp.Msg;
import com.xmlmind.jhelp.SeparatorBorder;
import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.XMLText;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class HelpBrowser
extends JFrame
implements ActionListener {
    private final String helpBrowserTitle;
    private JComboBox<HelpEntry> entryCombo;
    private JButton reloadPageButton;
    private JButton goBackButton;
    private JButton goForwardButton;
    private WebView webView;
    private boolean selectingEntry;
    private static Rectangle windowBounds;
    private static int windowState;

    public HelpBrowser(String string) {
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.helpBrowserTitle = string;
        this.updateTitle(string);
        this.setIconImage(ImageResource.get(HelpBrowser.class, "helpIcon.png"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpBrowser.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.updateWindowBounds();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                this.updateWindowBounds();
            }

            private void updateWindowBounds() {
                if (HelpBrowser.this.getExtendedState() == 0) {
                    windowBounds = HelpBrowser.this.getBounds();
                }
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new SeparatorBorder());
        jPanel.add((Component)jPanel2, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        this.entryCombo = new JComboBox();
        this.setEntries(HelpEntry.EMPTY_LIST);
        this.entryCombo.setActionCommand("entrySelected");
        this.entryCombo.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(this.entryCombo, DialogUtil.px(gridBagConstraints));
        this.reloadPageButton = this.createButton("reloadPage");
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 10;
        jPanel2.add((Component)this.reloadPageButton, DialogUtil.px(gridBagConstraints));
        this.goBackButton = this.createButton("goBack");
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)this.goBackButton, DialogUtil.px(gridBagConstraints));
        this.goForwardButton = this.createButton("goForward");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.goForwardButton, DialogUtil.px(gridBagConstraints));
        if (Platform.isImplicitExit()) {
            Platform.setImplicitExit((boolean)false);
        }
        final JFXPanel jFXPanel = new JFXPanel();
        final Dimension dimension = DialogUtil.pxDimension(800, 600);
        jFXPanel.setPreferredSize(dimension);
        jPanel.add((Component)jFXPanel, "Center");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HelpBrowser.this.initWebViewPane(jFXPanel, dimension);
            }
        });
        this.pack();
        this.setResizable(true);
        DialogUtil.initGlassPane(this);
    }

    private void updateTitle(String string) {
        if (string == null) {
            string = "???";
        }
        if (!string.equals(this.getTitle())) {
            this.setTitle(string);
        }
    }

    private JButton createButton(String string) {
        IconResource iconResource = new IconResource(HelpBrowser.class, string + ".png");
        JButton jButton = new JButton(iconResource);
        jButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(jButton);
        jButton.setToolTipText(Msg.msg(string + "ToolTip"));
        jButton.addActionListener(this);
        jButton.setActionCommand(string);
        return jButton;
    }

    private void close() {
        this.setHidden();
        try {
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setHidden() {
        windowState = this.getExtendedState();
        this.setVisible(false);
    }

    private void setVisible() {
        if (windowBounds == null) {
            windowBounds = new Rectangle(0, 0, AWTUtil.px(800), AWTUtil.px(600));
            windowState = 0;
        }
        if (windowState == 1) {
            windowState = 0;
        }
        this.setBounds(windowBounds);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpBrowser.this.setExtendedState(windowState);
                HelpBrowser.this.toFront();
                HelpBrowser.this.entryCombo.requestFocus();
            }
        });
        this.setVisible(true);
    }

    private void initWebViewPane(JFXPanel jFXPanel, Dimension dimension) {
        double d;
        this.webView = new WebView();
        this.webView.setPrefSize((double)dimension.width, (double)dimension.height);
        int n = AWTUtil.getDisplayScaling();
        if (n > 100 && (d = (double)n / 100.0) > 1.0) {
            this.webView.setZoom(d);
        }
        Scene scene = new Scene((Parent)this.webView);
        jFXPanel.setScene(scene);
        WebEngine webEngine = this.webView.getEngine();
        webEngine.setJavaScriptEnabled(true);
        Worker worker = webEngine.getLoadWorker();
        worker.stateProperty().addListener((observableValue, state, state2) -> {
            Throwable throwable;
            String string = state2 == Worker.State.FAILED && (throwable = worker.getException()) != null ? ThrowableUtil.reason(throwable) : null;
            SwingUtilities.invokeLater(new Runnable((Worker.State)state2, string){
                final /* synthetic */ Worker.State val$newState;
                final /* synthetic */ String val$loadError;
                {
                    this.val$newState = state;
                    this.val$loadError = string;
                }

                @Override
                public void run() {
                    switch (this.val$newState) {
                        case RUNNING: {
                            DialogUtil.waitCursor(HelpBrowser.this, true);
                            break;
                        }
                        case FAILED: 
                        case CANCELLED: {
                            String string = "Loading help page ***" + String.valueOf(this.val$newState) + "***";
                            if (this.val$loadError != null) {
                                string = string + ": " + this.val$loadError;
                            }
                            System.err.println(string);
                            IdMaps.getLog().error(string);
                        }
                        case SUCCEEDED: {
                            DialogUtil.waitCursor(HelpBrowser.this, false);
                        }
                    }
                }
            });
        });
        webEngine.titleProperty().addListener((observableValue, string, string2) -> this.enableButtons());
        webEngine.getHistory().currentIndexProperty().addListener((observableValue, number, number2) -> this.enableButtons());
    }

    private void enableButtons() {
        WebHistory webHistory = this.webView.getEngine().getHistory();
        ObservableList observableList = webHistory.getEntries();
        int n = webHistory.getCurrentIndex();
        int n2 = observableList.size();
        WebHistory.Entry entry = null;
        if (n >= 0 && n < n2) {
            entry = (WebHistory.Entry)observableList.get(n);
        }
        final String string = entry == null ? null : entry.getTitle();
        final String string2 = entry == null ? null : entry.getUrl();
        int n3 = n - 1;
        entry = null;
        if (n3 >= 0 && n3 < n2) {
            entry = (WebHistory.Entry)observableList.get(n3);
        }
        final String string3 = entry == null ? null : entry.getTitle();
        final String string4 = entry == null ? null : entry.getUrl();
        int n4 = n + 1;
        entry = null;
        if (n4 >= 0 && n4 < n2) {
            entry = (WebHistory.Entry)observableList.get(n4);
        }
        final String string5 = entry == null ? null : entry.getTitle();
        final String string6 = entry == null ? null : entry.getUrl();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpBrowser.this.enableButtons(string, string2, string3, string4, string5, string6);
            }
        });
    }

    private void enableButtons(String string, String string2, String string3, String string4, String string5, String string6) {
        this.enableButton(this.reloadPageButton, "reloadPage", string, string2);
        this.enableButton(this.goBackButton, "goBack", string3, string4);
        this.enableButton(this.goForwardButton, "goForward", string5, string6);
        int n = 0;
        if (string2 != null) {
            String string7 = null;
            try {
                string7 = new URI(string2).normalize().toASCIIString();
                if (!string7.endsWith("/")) {
                    string7 = URIComponent.getRawParentPath(string7);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (string7 != null) {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.entryCombo.getModel();
                int n2 = defaultComboBoxModel.getSize();
                for (int i = 0; i < n2; ++i) {
                    HelpEntry helpEntry = (HelpEntry)defaultComboBoxModel.getElementAt(i);
                    if (!string7.equals(helpEntry.parentLocation)) continue;
                    n = i;
                    break;
                }
            }
        }
        this.selectingEntry = true;
        this.entryCombo.setSelectedIndex(n);
        this.selectingEntry = false;
        this.updateTitle(n == 0 ? string : this.helpBrowserTitle);
    }

    private void enableButton(JButton jButton, String string, String string2, String string3) {
        if (string2 == null && string3 == null) {
            jButton.setEnabled(false);
            jButton.setToolTipText(Msg.msg(string + "ToolTip"));
        } else {
            jButton.setEnabled(true);
            StringBuilder stringBuilder = new StringBuilder("<html><span>");
            XMLText.escapeXML(Msg.msg(string + "ToolTip"), stringBuilder);
            stringBuilder.append("</span>");
            if (string2 != null) {
                stringBuilder.append("<br>\n<b>");
                XMLText.escapeXML(string2, stringBuilder);
                stringBuilder.append("</b>");
            }
            if (string3 != null) {
                stringBuilder.append("<br>\n<tt style='font-size: 90%;'>");
                XMLText.escapeXML(string3, stringBuilder);
                stringBuilder.append("</tt>");
            }
            jButton.setToolTipText(stringBuilder.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("entrySelected".equals(string)) {
            HelpEntry helpEntry;
            if (!this.selectingEntry && (helpEntry = (HelpEntry)this.entryCombo.getSelectedItem()) != null && helpEntry.uri != null) {
                this.browse(helpEntry.uri.toASCIIString());
            }
        } else if ("reloadPage".equals(string)) {
            Platform.runLater(() -> this.webView.getEngine().reload());
        } else if ("goBack".equals(string)) {
            Platform.runLater(() -> {
                try {
                    this.webView.getEngine().getHistory().go(-1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            });
        } else if ("goForward".equals(string)) {
            Platform.runLater(() -> {
                try {
                    this.webView.getEngine().getHistory().go(1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            });
        }
    }

    public void setEntries(HelpEntry[] helpEntryArray) {
        helpEntryArray = ArrayUtil.prepend(helpEntryArray, new HelpEntry("-", null, false));
        this.entryCombo.setModel(new DefaultComboBoxModel<HelpEntry>(helpEntryArray));
        this.entryCombo.setSelectedIndex(0);
    }

    public void showHelpTopic(URI uRI) {
        this.enableButtons(null, null, null, null, null, null);
        this.setVisible();
        this.browse(uRI.toASCIIString());
    }

    private void browse(String string) {
        Platform.runLater(() -> this.webView.getEngine().load(string));
    }
}

