/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.guiutil.MultiLineJLabel;
import com.xmlmind.util.Console;
import com.xmlmind.util.Log;
import com.xmlmind.util.StoppableThread;
import com.xmlmind.util.ThrowableUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ThreadMonitorDialog
extends JDialog
implements ActionListener {
    protected Component parentComponent;
    protected Component dialogAnchor;
    protected JLabel iconLabel;
    protected MultiLineJLabel subTitleLabel;
    protected JTextComponent messages;
    protected JProgressBar progressBar;
    protected JButton cancelButton;
    protected String messageLog;
    protected int cancelMaxDuration;
    protected StoppableThread monitoredThread;
    protected Timer monitorTimer;
    protected boolean canceled;
    protected long cancelDate;
    protected static final int DEFAULT_CANCEL_MAX_DURATION = 10000;

    public ThreadMonitorDialog(Component component, String string, String string2, int n, int n2, boolean bl) {
        super(DialogUtil.getDialogOwner(component), string, Dialog.DEFAULT_MODALITY_TYPE);
        this.initialize(component, string2, n, n2, bl);
    }

    protected void initialize(Component component, String string, int n, int n2, boolean bl) {
        JComponent jComponent;
        this.messageLog = null;
        this.cancelMaxDuration = 10000;
        this.parentComponent = component;
        this.dialogAnchor = DialogUtil.getDialogAnchor(component);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ThreadMonitorDialog.this.cancel();
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        jPanel.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        this.iconLabel = new JLabel(ThreadMonitorDialog.getDefaultIcon());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.iconLabel, DialogUtil.px(gridBagConstraints));
        this.subTitleLabel = new MultiLineJLabel(string);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.subTitleLabel, DialogUtil.px(gridBagConstraints));
        if (n <= 0 || n2 <= 0) {
            this.messages = null;
            jComponent = new JPanel();
            jComponent.setPreferredSize(DialogUtil.pxDimension(250, 10));
        } else {
            this.messages = this.createMessages(n, n2);
            jComponent = this.createMessagesScroller(this.messages, n, n2);
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)jPanel2, DialogUtil.px(gridBagConstraints));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        if (bl) {
            this.progressBar = new JProgressBar(0, 100);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)this.progressBar, DialogUtil.px(gridBagConstraints));
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.left = 5;
        }
        this.cancelButton = new JButton();
        DialogUtil.setCancelText(this.cancelButton);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        jPanel2.add((Component)this.cancelButton, DialogUtil.px(gridBagConstraints));
        this.pack();
        this.setResizable(true);
    }

    protected JTextComponent createMessages(int n, int n2) {
        JTextArea jTextArea = new JTextArea(n, n2);
        jTextArea.setFont(AWTUtil.pxDeriveFont(jTextArea.getFont(), 0, -1));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(Color.white);
        jTextArea.setForeground(Color.black);
        return jTextArea;
    }

    protected JScrollPane createMessagesScroller(JTextComponent jTextComponent, int n, int n2) {
        return DialogUtil.createScrollPane(jTextComponent);
    }

    public void setIcon(Icon icon) {
        if (icon == null) {
            icon = ThreadMonitorDialog.getDefaultIcon();
        }
        this.iconLabel.setIcon(icon);
    }

    protected static Icon getDefaultIcon() {
        return new IconResource(ThreadMonitorDialog.class, "wait.png");
    }

    public Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    public void setIndeterminateProgressBar(boolean bl) {
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(bl);
        }
    }

    public boolean isIndeterminateProgressBar() {
        return this.progressBar == null ? false : this.progressBar.isIndeterminate();
    }

    public void setMessageLog(String string) {
        this.messageLog = string;
    }

    public String getMessageLog() {
        return this.messageLog;
    }

    public void setCancelMaxDuration(int n) {
        this.cancelMaxDuration = n;
    }

    public int getCancelMaxDuration() {
        return this.cancelMaxDuration;
    }

    public boolean startThread(StoppableThread stoppableThread) {
        return this.doAttachThread(stoppableThread, true);
    }

    public boolean attachThread(StoppableThread stoppableThread) {
        return this.doAttachThread(stoppableThread, false);
    }

    protected boolean doAttachThread(StoppableThread stoppableThread, boolean bl) {
        this.monitoredThread = stoppableThread;
        this.monitorTimer = new Timer(250, this);
        this.monitorTimer.setRepeats(true);
        this.monitorTimer.setCoalesce(true);
        this.canceled = false;
        this.cancelDate = -1L;
        this.doClearMessages();
        if (this.progressBar != null) {
            this.progressBar.setValue(0);
        }
        this.cancelButton.setEnabled(true);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        if (bl) {
            this.monitoredThread.start();
        }
        this.monitorTimer.start();
        this.setVisible(true);
        this.monitorTimer.stop();
        this.monitorTimer = null;
        this.monitoredThread = null;
        return !this.canceled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.monitorTimer) {
            this.monitor();
        } else {
            this.cancel();
        }
    }

    protected void monitor() {
        if (this.monitoredThread != null && this.monitoredThread.isAlive()) {
            int n = this.cancelMaxDuration;
            if (this.canceled && n > 0 && System.currentTimeMillis() - this.cancelDate >= (long)n) {
                this.monitoredThread.kill();
            }
        } else if (this.isShowing()) {
            if (this.canceled) {
                this.doAppendMessage(Msg.msg("TMD.taskCanceledByUser"), Log.Level.INFO);
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    protected void cancel() {
        if (this.cancelButton.isEnabled() && this.isShowing()) {
            this.cancelButton.setEnabled(false);
            this.canceled = true;
            if (this.monitoredThread != null) {
                this.monitoredThread.requestStop();
            }
            this.cancelDate = System.currentTimeMillis();
            Object object = "";
            int n = this.cancelMaxDuration;
            if (n > 0) {
                object = " " + Msg.msg("TMD.waitCancelAtMost", n / 1000);
            }
            this.doAppendMessage(Msg.msg("TMD.tryingToCancelTask", object), Log.Level.INFO);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setProgress(final int n, final int n2) {
        ThreadMonitorDialog.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ThreadMonitorDialog.this.doSetProgress(n, n2);
            }
        });
    }

    public void setMessage(String string) {
        this.setMessage(string, Log.Level.INFO);
    }

    public void setMessage(final String string, final Log.Level level) {
        ThreadMonitorDialog.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ThreadMonitorDialog.this.doSetMessage(string, level);
            }
        });
    }

    public static Log.Level toLogLevel(Console.MessageType messageType) {
        switch (messageType) {
            case ERROR: {
                return Log.Level.ERROR;
            }
            case WARNING: {
                return Log.Level.WARNING;
            }
            case INFO: {
                return Log.Level.INFO;
            }
            case VERBOSE: {
                return Log.Level.VERBOSE;
            }
        }
        return Log.Level.DEBUG;
    }

    public void appendMessage(String string) {
        this.appendMessage(string, Log.Level.INFO);
    }

    public void appendMessage(final String string, final Log.Level level) {
        ThreadMonitorDialog.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ThreadMonitorDialog.this.doAppendMessage(string, level);
            }
        });
    }

    public void animateLastLine(final String string, final boolean bl) {
        ThreadMonitorDialog.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ThreadMonitorDialog.this.doAnimateLastLine(string, bl);
            }
        });
    }

    protected static final void invokeAndWait(Runnable runnable) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            Exception exception2 = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getCause() : exception;
            System.err.println("internal error in ThreadMonitorDialog:");
            System.err.println(ThrowableUtil.detailedReason(exception2));
        }
    }

    protected void doSetProgress(int n, int n2) {
        if (this.progressBar == null) {
            return;
        }
        int n3 = n * 100 / n2;
        if (this.progressBar.getValue() != n3) {
            this.progressBar.setValue(n3);
        }
    }

    protected void doClearMessages() {
        if (this.messages == null) {
            return;
        }
        this.messages.setText("");
    }

    protected void doSetMessage(String string, Log.Level level) {
        if (this.messages == null) {
            return;
        }
        this.messages.setText(string + "\n");
        this.messages.setCaretPosition(0);
        if (this.messageLog != null) {
            Log.getLog(this.messageLog).log(level, string);
        }
    }

    protected void doAppendMessage(String string, Log.Level level) {
        if (this.messages == null) {
            return;
        }
        Document document = this.messages.getDocument();
        try {
            document.insertString(document.getLength(), string + "\n", null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.messages.setCaretPosition(document.getLength());
        if (this.messageLog != null) {
            Log.getLog(this.messageLog).log(level, string);
        }
    }

    protected void doAnimateLastLine(String string, boolean bl) {
        int n;
        int n2;
        JTextArea jTextArea = this.messageArea();
        if (jTextArea == null) {
            return;
        }
        if (bl) {
            jTextArea.append(string);
            return;
        }
        int n3 = jTextArea.getLineCount();
        if (n3 <= 0) {
            return;
        }
        --n3;
        try {
            n2 = jTextArea.getLineStartOffset(n3);
            n = jTextArea.getLineEndOffset(n3);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return;
        }
        jTextArea.replaceRange(string, n2, n);
    }

    protected JTextArea messageArea() {
        if (this.messages == null || !(this.messages instanceof JTextArea)) {
            return null;
        }
        return (JTextArea)this.messages;
    }
}

