/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;

public class TextIcon
implements Icon {
    public static final Color STOCK_BLUE_FOREGROUND = new Color(22, 110, 177);
    private String text;
    private String[] lines;
    private Font font;
    private Color foreground;
    private Color background;
    private int width;
    private int height;
    private byte padding;
    private Color disabledForeground;
    private Color disabledBackground;
    private Dimension minSize;
    private int xOffset;
    private int yOffset;

    public TextIcon(String string, Font font, Color color, Color color2, Component component) {
        this.font = font;
        this.foreground = color;
        this.background = color2;
        this.setText(string, component);
    }

    public void setText(String string, Component component) {
        this.text = string;
        this.lines = string.indexOf(10) < 0 ? null : StringUtil.split(string, '\n');
        this.relayout(component);
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font, Component component) {
        this.font = font;
        this.relayout(component);
    }

    public Font getFont() {
        return this.font;
    }

    public void setPadding(int n, Component component) {
        if (n < 0) {
            n = 0;
        } else if (n > 127) {
            n = 127;
        }
        this.padding = (byte)n;
        this.relayout(component);
    }

    public int getPadding() {
        return this.padding;
    }

    private void relayout(Component component) {
        int n;
        FontMetrics fontMetrics = component.getFontMetrics(this.font);
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent();
        if (this.lines != null) {
            n = fontMetrics.stringWidth(this.lines[0]);
            int n3 = fontMetrics.getHeight();
            for (int i = 1; i < this.lines.length; ++i) {
                n = Math.max(n, fontMetrics.stringWidth(this.lines[i]));
                n2 += n3;
            }
        } else {
            n = fontMetrics.stringWidth(this.text);
        }
        if (n <= 0) {
            n = fontMetrics.charWidth('x');
        }
        this.width = n + 2 * this.padding;
        this.height = n2 + 2 * this.padding;
        if (this.minSize != null) {
            if (this.width < this.minSize.width) {
                this.width = this.minSize.width;
            }
            if (this.height < this.minSize.height) {
                this.height = this.minSize.height;
            }
        }
        this.xOffset = (this.width - n) / 2;
        this.yOffset = (this.height - n2) / 2;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setDisabledForeground(Color color) {
        this.disabledForeground = color;
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledBackground(Color color) {
        this.disabledBackground = color;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setMinSize(Dimension dimension, Component component) {
        this.minSize = dimension;
        this.relayout(component);
    }

    public Dimension getMinSize() {
        return this.minSize;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color;
        graphics = graphics.create();
        AWTUtil.setTextAntialiasing(graphics);
        boolean bl = component.isEnabled();
        Color color2 = null;
        if (this.background != null) {
            color = bl ? this.background : (this.disabledBackground != null ? (color2 = this.disabledBackground) : (color2 = AWTUtil.convertToGray(this.background, 0.0f, false)));
            graphics.setColor(color);
            graphics.fillRect(n, n2, this.width, this.height);
        }
        if (this.foreground != null) {
            color = bl ? this.foreground : (this.disabledForeground != null ? this.disabledForeground : (color2 != null ? AWTUtil.editHSB(color2, -1, 0.0f, -0.1f, true) : AWTUtil.convertToGray(this.foreground, 0.1f, false)));
            graphics.setColor(color);
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n += this.xOffset;
            n2 += this.yOffset + fontMetrics.getAscent();
            if (this.lines != null) {
                int n3 = fontMetrics.getHeight();
                for (int i = 0; i < this.lines.length; ++i) {
                    graphics.drawString(this.lines[i], n, n2);
                    n2 += n3;
                }
            } else {
                graphics.drawString(this.text, n, n2);
            }
        }
        graphics.dispose();
    }
}

