/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.Tab;
import com.xmlmind.guiutil.TabsEvent;
import com.xmlmind.guiutil.TabsListener;
import com.xmlmind.util.SystemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class TabbedSplitPane
extends JPanel
implements ItemSelectable {
    protected Tab[] tabs;
    private Tab.Side tabPlacement;
    private boolean showTabFrame;
    private int separatorSize;
    private boolean separatorRelief;
    private boolean separatorHandle;
    private boolean verticalSplit;
    private double horizontalRatio;
    private double verticalRatio;
    private boolean endTabAtOppositeSide;
    private DnDAction dndAction;
    private Class<? extends Tab>[] allowedTabClasses;
    private EventListenerList itemListeners;
    private EventListenerList tabsListeners;
    private Tab.Side startTabAreaSide;
    private int startTabAreaX;
    private int startTabAreaY;
    private int startTabAreaW;
    private int startTabAreaH;
    private int startButtonX;
    private int startButtonY;
    private int startButtonW;
    private int startButtonH;
    private int startFrameX;
    private int startFrameY;
    private int startFrameW;
    private int startFrameH;
    private int separatorX;
    private int separatorY;
    private int separatorW;
    private int separatorH;
    private Tab.Side endTabAreaSide;
    private int endTabAreaX;
    private int endTabAreaY;
    private int endTabAreaW;
    private int endTabAreaH;
    private int endButtonX;
    private int endButtonY;
    private int endButtonW;
    private int endButtonH;
    private int endFrameX;
    private int endFrameY;
    private int endFrameW;
    private int endFrameH;
    private static Cursor normalCursor;
    private static Cursor clickButtonCursor;
    private static Cursor verticalResizeCursor;
    private static Cursor horizontalResizeCursor;
    private static int BUTTON_GAP;
    private static int BUTTON_WIDTH;
    private static int BUTTON_HEIGHT;
    private static int COMPONENT_MARGIN;
    private static int SEPARATOR_MIN_SIZE;
    private static int HANDLE_SIZE;
    private static final DataFlavor[] TAB_DATA_FLAVORS;
    private static int DROP_AREA_SIZE;
    private static int DROP_MARK_PAD;
    private static Color DROP_MARK_COLOR1;
    private static Color DROP_MARK_COLOR2;

    public TabbedSplitPane() {
        if (normalCursor == null) {
            normalCursor = Cursor.getDefaultCursor();
            clickButtonCursor = Cursor.getPredefinedCursor(12);
            verticalResizeCursor = Cursor.getPredefinedCursor(11);
            horizontalResizeCursor = Cursor.getPredefinedCursor(8);
            BUTTON_GAP = AWTUtil.px(5);
            BUTTON_WIDTH = AWTUtil.px(11);
            BUTTON_HEIGHT = BUTTON_WIDTH = BUTTON_WIDTH / 2 * 2 + 1;
            COMPONENT_MARGIN = AWTUtil.px(3);
            SEPARATOR_MIN_SIZE = AWTUtil.px(5);
            HANDLE_SIZE = AWTUtil.px(3);
        }
        this.tabs = new Tab[0];
        this.tabPlacement = Tab.Side.TOP;
        this.showTabFrame = false;
        this.separatorSize = SEPARATOR_MIN_SIZE;
        this.separatorRelief = false;
        this.separatorHandle = false;
        this.verticalSplit = false;
        this.verticalRatio = 0.5;
        this.horizontalRatio = 0.5;
        this.endTabAtOppositeSide = true;
        this.dndAction = DnDAction.NONE;
        this.allowedTabClasses = null;
        this.setLayout(new Layout());
        this.setFont(UIManager.getFont("TabbedPane.font"));
        this.setToolTipText("(dynamic)");
        this.setCursor(normalCursor);
        this.itemListeners = new EventListenerList();
        this.tabsListeners = new EventListenerList();
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public void setShowTabFrame(boolean bl) {
        if (bl != this.showTabFrame) {
            this.showTabFrame = bl;
            this.repaint();
        }
    }

    public boolean getShowTabFrame() {
        return this.showTabFrame;
    }

    public void setSeparatorSize(int n) {
        if (n < SEPARATOR_MIN_SIZE) {
            n = SEPARATOR_MIN_SIZE;
        }
        if (n != this.separatorSize) {
            this.separatorSize = n;
            this.revalidate();
            this.repaint();
        }
    }

    public int getSeparatorSize() {
        return this.separatorSize;
    }

    public void setSeparatorRelief(boolean bl) {
        if (bl != this.separatorRelief) {
            this.separatorRelief = bl;
            this.repaint();
        }
    }

    public boolean getSeparatorRelief() {
        return this.separatorRelief;
    }

    public void setSeparatorHandle(boolean bl) {
        if (bl != this.separatorHandle) {
            this.separatorHandle = bl;
            int n = SEPARATOR_MIN_SIZE;
            if (bl) {
                n += HANDLE_SIZE;
            }
            this.setSeparatorSize(n);
            this.repaint();
        }
    }

    public boolean getSeparatorHandle() {
        return this.separatorHandle;
    }

    public boolean isVerticalTabPlacement() {
        switch (this.tabPlacement) {
            case RIGHT: 
            case LEFT: {
                return true;
            }
        }
        return false;
    }

    public void setTabPlacement(Tab.Side side) {
        if (this.tabPlacement != side) {
            this.tabPlacement = side;
            this.refresh();
        }
    }

    private void refresh() {
        this.updateTabSides();
        this.revalidate();
        this.repaint();
    }

    private void updateTabSides() {
        for (Tab tab : this.tabs) {
            tab.side = this.tabSide(tab.atStart);
        }
    }

    private Tab.Side tabSide(boolean bl) {
        boolean bl2 = this.isSplit();
        if (this.endTabAtOppositeSide) {
            switch (this.tabPlacement) {
                case RIGHT: {
                    if (this.verticalSplit || !bl2) {
                        if (bl) {
                            return Tab.Side.RIGHT;
                        }
                        return Tab.Side.LEFT;
                    }
                    return Tab.Side.RIGHT;
                }
                case LEFT: {
                    if (this.verticalSplit || !bl2) {
                        if (bl) {
                            return Tab.Side.LEFT;
                        }
                        return Tab.Side.RIGHT;
                    }
                    return Tab.Side.LEFT;
                }
                case BOTTOM: {
                    if (!this.verticalSplit || !bl2) {
                        if (bl) {
                            return Tab.Side.BOTTOM;
                        }
                        return Tab.Side.TOP;
                    }
                    return Tab.Side.BOTTOM;
                }
            }
            if (!this.verticalSplit || !bl2) {
                if (bl) {
                    return Tab.Side.TOP;
                }
                return Tab.Side.BOTTOM;
            }
            return Tab.Side.TOP;
        }
        switch (this.tabPlacement) {
            case RIGHT: {
                if (bl2 && this.verticalSplit) {
                    if (bl) {
                        return Tab.Side.RIGHT;
                    }
                    return Tab.Side.LEFT;
                }
                return Tab.Side.RIGHT;
            }
            case LEFT: {
                if (bl2 && this.verticalSplit) {
                    if (bl) {
                        return Tab.Side.LEFT;
                    }
                    return Tab.Side.RIGHT;
                }
                return Tab.Side.LEFT;
            }
            case BOTTOM: {
                if (bl2 && !this.verticalSplit) {
                    if (bl) {
                        return Tab.Side.BOTTOM;
                    }
                    return Tab.Side.TOP;
                }
                return Tab.Side.BOTTOM;
            }
        }
        if (bl2 && !this.verticalSplit) {
            if (bl) {
                return Tab.Side.TOP;
            }
            return Tab.Side.BOTTOM;
        }
        return Tab.Side.TOP;
    }

    public boolean isSplit() {
        boolean bl = false;
        boolean bl2 = false;
        for (Tab tab : this.tabs) {
            if (tab.atStart) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        return bl && bl2;
    }

    public Tab.Side getTabPlacement() {
        return this.tabPlacement;
    }

    public void setVerticalSplit(boolean bl) {
        if (this.verticalSplit != bl) {
            this.verticalSplit = bl;
            this.refresh();
        }
    }

    public boolean isVerticalSplit() {
        return this.verticalSplit;
    }

    public void setHorizontalRatio(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        if (this.horizontalRatio != d) {
            this.horizontalRatio = d;
            this.revalidate();
            this.repaint();
        }
    }

    public double getHorizontalRatio() {
        return this.horizontalRatio;
    }

    public void setVerticalRatio(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        if (this.verticalRatio != d) {
            this.verticalRatio = d;
            this.revalidate();
            this.repaint();
        }
    }

    public double getVerticalRatio() {
        return this.verticalRatio;
    }

    public void setEndTabAtOppositeSide(boolean bl) {
        if (bl != this.endTabAtOppositeSide) {
            this.endTabAtOppositeSide = bl;
            this.refresh();
        }
    }

    public boolean isEndTabAtOppositeSide() {
        return this.endTabAtOppositeSide;
    }

    public void setDnDAction(DnDAction dnDAction) {
        if (dnDAction == null) {
            dnDAction = DnDAction.NONE;
        }
        if (dnDAction != this.dndAction) {
            this.dndAction = dnDAction;
            this.setTransferHandler(this.dndAction == DnDAction.NONE ? null : new TabTransferHandler());
        }
    }

    public DnDAction getDnDAction() {
        return this.dndAction;
    }

    public void setAllowedTabClasses(Class<? extends Tab> ... classArray) {
        this.allowedTabClasses = classArray;
    }

    public Class<? extends Tab>[] getAllowedTabClasses() {
        return this.allowedTabClasses;
    }

    public void addTab(Tab tab) {
        this.addTab(tab, this.tabs.length);
    }

    public void addTab(Tab tab, int n) {
        int n2;
        Tab[] tabArray = new Tab[this.tabs.length + 1];
        if (n > 0) {
            System.arraycopy(this.tabs, 0, tabArray, 0, n);
        }
        if ((n2 = this.tabs.length - n) > 0) {
            System.arraycopy(this.tabs, n, tabArray, n + 1, n2);
        }
        tabArray[n] = tab;
        tab.pane = this;
        tab.selected = false;
        tab.component.setVisible(false);
        this.tabs = tabArray;
        super.addImpl(tab.component, null, n);
        this.fireTabsChanged(null, -1, false, tab, n, tab.atStart);
        this.tabsChanged();
    }

    private void tabsChanged() {
        this.checkSelected();
        this.refresh();
    }

    private void checkSelected() {
        Tab tab = null;
        Tab tab2 = null;
        Tab tab3 = null;
        Tab tab4 = null;
        for (Tab tab5 : this.tabs) {
            if (tab5.atStart) {
                if (tab == null) {
                    tab = tab5;
                }
                if (!tab5.selected) continue;
                if (tab2 == null) {
                    tab2 = tab5;
                    continue;
                }
                tab5.selected = false;
                tab5.component.setVisible(false);
                this.tabDeselected(tab5);
                continue;
            }
            if (tab3 == null) {
                tab3 = tab5;
            }
            if (!tab5.selected) continue;
            if (tab4 == null) {
                tab4 = tab5;
                continue;
            }
            tab5.selected = false;
            tab5.component.setVisible(false);
            this.tabDeselected(tab5);
        }
        if (tab != null && tab2 == null) {
            tab.selected = true;
            tab.component.setVisible(true);
            this.tabSelected(tab);
        }
        if (tab3 != null && tab4 == null) {
            tab3.selected = true;
            tab3.component.setVisible(true);
            this.tabSelected(tab3);
        }
    }

    public void removeTab(Tab tab) {
        int n = this.indexOfTab(tab);
        if (n < 0) {
            return;
        }
        this.removeTab(n);
    }

    public int indexOfTab(Tab tab) {
        int n = this.tabs.length;
        for (int i = 0; i < n; ++i) {
            if (tab != this.tabs[i]) continue;
            return i;
        }
        return -1;
    }

    public Tab removeTab(int n) {
        int n2;
        int n3;
        Tab tab = this.tabs[n];
        tab.pane = null;
        Tab[] tabArray = new Tab[this.tabs.length - 1];
        if (n > 0) {
            System.arraycopy(this.tabs, 0, tabArray, 0, n);
        }
        if ((n3 = this.tabs.length - (n2 = n + 1)) > 0) {
            System.arraycopy(this.tabs, n2, tabArray, n, n3);
        }
        this.tabs = tabArray;
        this.remove(n);
        this.fireTabsChanged(tab, n, tab.atStart, null, -1, false);
        this.tabsChanged();
        return tab;
    }

    public void removeAllTabs() {
        if (this.tabs.length == 0) {
            return;
        }
        for (int i = this.tabs.length - 1; i >= 0; --i) {
            Tab tab = this.tabs[i];
            tab.pane = null;
            this.fireTabsChanged(tab, i, tab.atStart, null, -1, false);
        }
        this.tabs = new Tab[0];
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    public int getTabCount() {
        return this.tabs.length;
    }

    public Tab getTab(int n) {
        return this.tabs[n];
    }

    public Tab[] getAllTabs() {
        return this.tabs;
    }

    public Tab findTab(Component component) {
        for (Tab tab : this.tabs) {
            if (tab.getComponent() != component) continue;
            return tab;
        }
        return null;
    }

    public Tab selectTab(int n) {
        Tab tab = this.tabs[n];
        if (!tab.selected) {
            tab.selected = true;
            tab.component.setVisible(true);
            this.tabSelected(tab);
            for (Tab tab2 : this.tabs) {
                if (tab2 == tab || !tab2.selected || tab2.atStart != tab.atStart) continue;
                tab2.selected = false;
                tab2.component.setVisible(false);
                this.tabDeselected(tab2);
            }
            if (this.isShowing()) {
                ((Layout)this.getLayout()).relayoutTabs(this, tab.atStart);
            } else {
                this.revalidate();
            }
            this.repaint();
        }
        return tab;
    }

    public void selectTab(Tab tab) {
        int n = this.indexOfTab(tab);
        if (n < 0) {
            return;
        }
        this.selectTab(n);
    }

    public Tab[] getSelectedTabs() {
        Tab[] tabArray = new Tab[2];
        int n = 0;
        for (Tab tab : this.tabs) {
            if (!tab.selected) continue;
            tabArray[n++] = tab;
        }
        if (n != 2) {
            Tab[] tabArray2 = new Tab[n];
            System.arraycopy(tabArray, 0, tabArray2, 0, n);
            tabArray = tabArray2;
        } else if (!tabArray[0].atStart) {
            Tab tab = tabArray[0];
            tabArray[0] = tabArray[1];
            tabArray[1] = tab;
        }
        return tabArray;
    }

    public Tab moveTab(int n, boolean bl) {
        Tab tab = this.tabs[n];
        if (tab.atStart != bl) {
            tab.atStart = bl;
            this.fireTabsChanged(tab, n, !bl, tab, n, bl);
            boolean bl2 = tab.selected;
            tab.selected = false;
            tab.component.setVisible(false);
            if (bl2) {
                this.tabDeselected(tab);
            }
            this.tabsChanged();
        }
        return tab;
    }

    public void moveTab(Tab tab, boolean bl) {
        int n = this.indexOfTab(tab);
        if (n < 0) {
            return;
        }
        this.moveTab(n, bl);
    }

    public boolean isVisibleTab(Tab tab) {
        if (tab.atStart) {
            if (this.isVerticalTabPlacement()) {
                return tab.y >= this.startTabAreaY && tab.y + tab.height <= this.startTabAreaY + this.startTabAreaH;
            }
            return tab.x >= this.startTabAreaX && tab.x + tab.width <= this.startTabAreaX + this.startTabAreaW;
        }
        if (this.isVerticalTabPlacement()) {
            return tab.y >= this.endTabAreaY && tab.y + tab.height <= this.endTabAreaY + this.endTabAreaH;
        }
        return tab.x >= this.endTabAreaX && tab.x + tab.width <= this.endTabAreaX + this.endTabAreaW;
    }

    public void repaintTab(Tab tab) {
        if (this.isVisibleTab(tab)) {
            this.repaint(tab.x, tab.y, tab.width, tab.height);
        }
    }

    public void repaintAllTabs() {
        if (this.startTabAreaW > 0 && this.startTabAreaH > 0) {
            this.repaint(this.startTabAreaX, this.startTabAreaY, this.startTabAreaW, this.startTabAreaH);
        }
        if (this.endTabAreaW > 0 && this.endTabAreaH > 0) {
            this.repaint(this.endTabAreaX, this.endTabAreaY, this.endTabAreaW, this.endTabAreaH);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.getSelectedTabs();
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListeners.add(ItemListener.class, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners.remove(ItemListener.class, itemListener);
    }

    private void tabSelected(Tab tab) {
        this.fireItemStateChanged(tab, 1);
    }

    private void tabDeselected(Tab tab) {
        this.fireItemStateChanged(tab, 2);
    }

    private void fireItemStateChanged(Tab tab, int n) {
        Object[] objectArray = this.itemListeners.getListenerList();
        if (objectArray.length == 0) {
            return;
        }
        ItemEvent itemEvent = new ItemEvent(this, 701, tab, n);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ItemListener.class) continue;
            ((ItemListener)objectArray[i + 1]).itemStateChanged(itemEvent);
        }
    }

    public void addTabsListener(TabsListener tabsListener) {
        this.tabsListeners.add(TabsListener.class, tabsListener);
    }

    public void removeTabsListener(TabsListener tabsListener) {
        this.tabsListeners.remove(TabsListener.class, tabsListener);
    }

    private void fireTabsChanged(Tab tab, int n, boolean bl, Tab tab2, int n2, boolean bl2) {
        Object[] objectArray = this.tabsListeners.getListenerList();
        if (objectArray.length == 0) {
            return;
        }
        TabsEvent tabsEvent = new TabsEvent(this, tab, n, bl, tab2, n2, bl2);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TabsListener.class) continue;
            ((TabsListener)objectArray[i + 1]).tabsChanged(tabsEvent);
        }
    }

    @Override
    public Component add(Component component) {
        throw new UnsupportedOperationException("use addTab");
    }

    @Override
    public Component add(String string, Component component) {
        throw new UnsupportedOperationException("use addTab");
    }

    @Override
    public Component add(Component component, int n) {
        throw new UnsupportedOperationException("use addTab");
    }

    @Override
    public void add(Component component, Object object) {
        throw new UnsupportedOperationException("use addTab");
    }

    @Override
    public void add(Component component, Object object, int n) {
        throw new UnsupportedOperationException("use addTab");
    }

    @Override
    public void remove(Component component) {
        throw new UnsupportedOperationException("use removeTab");
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (Tab tab : this.tabs) {
            if (n < tab.x || n >= tab.x + tab.width || n2 < tab.y || n2 >= tab.y + tab.height) continue;
            return tab.getToolTip();
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics = graphics.create();
        AWTUtil.setTextAntialiasing(graphics);
        this.doPaintComponent(graphics);
        graphics.dispose();
    }

    protected void doPaintComponent(Graphics graphics) {
        Color color = this.getBackground();
        Color color2 = AWTUtil.toHighlightColor(color);
        Color color3 = AWTUtil.toShadowColor(color);
        Color color4 = AWTUtil.toBorderColor(color);
        Color color5 = this.getForeground();
        Color color6 = color;
        Color color7 = color2;
        Color color8 = color3;
        Color color9 = color4;
        Color color10 = color;
        Color color11 = color2;
        Color color12 = color3;
        Color color13 = color4;
        if (this.tabs.length == 0) {
            graphics.setColor(color4);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            return;
        }
        for (Tab tab : this.tabs) {
            Color color14 = tab.getBackground();
            if (tab.selected) {
                if (color14 == null || !this.isVisibleTab(tab)) continue;
                if (tab.atStart) {
                    color6 = color14;
                    color7 = AWTUtil.toHighlightColor(color14);
                    color8 = AWTUtil.toShadowColor(color14);
                    color9 = AWTUtil.toBorderColor(color14);
                    continue;
                }
                color10 = color14;
                color11 = AWTUtil.toHighlightColor(color14);
                color12 = AWTUtil.toShadowColor(color14);
                color13 = AWTUtil.toBorderColor(color14);
                continue;
            }
            if (!this.isVisibleTab(tab)) continue;
            if (color14 != null) {
                Color color15 = AWTUtil.toHighlightColor(color14);
                Color color16 = AWTUtil.toShadowColor(color14);
                Color color17 = AWTUtil.toBorderColor(color14);
                tab.paint(graphics, color14, color17, color15, color16, color5);
                continue;
            }
            tab.paint(graphics, color, color4, color2, color3, color5);
        }
        if (this.startFrameW > 0 && this.startFrameH > 0) {
            if (this.showTabFrame) {
                this.paintTabFrame(graphics, true, color4);
            }
            this.paintFrame(graphics, color6, color9, color7, color8, color5, this.startFrameX, this.startFrameY, this.startFrameW, this.startFrameH);
        }
        if (this.endFrameW > 0 && this.endFrameH > 0) {
            if (this.showTabFrame) {
                this.paintTabFrame(graphics, false, color4);
            }
            this.paintFrame(graphics, color10, color13, color11, color12, color5, this.endFrameX, this.endFrameY, this.endFrameW, this.endFrameH);
        }
        if (this.separatorW > 0 && this.separatorH > 0) {
            this.paintSeparator(graphics, color, color4, color2, color3, color5, this.separatorX, this.separatorY, this.separatorW, this.separatorH);
        }
        for (Tab tab : this.tabs) {
            if (!tab.selected || !this.isVisibleTab(tab)) continue;
            if (tab.atStart) {
                tab.paint(graphics, color6, color9, color7, color8, color5);
                continue;
            }
            tab.paint(graphics, color10, color13, color11, color12, color5);
        }
        if (this.startButtonW > 0 && this.startButtonH > 0) {
            this.paintButton(graphics, color, color4, color2, color3, color5, this.startButtonX, this.startButtonY, this.startButtonW, this.startButtonH, this.tabSide(true));
        }
        if (this.endButtonW > 0 && this.endButtonH > 0) {
            this.paintButton(graphics, color, color4, color2, color3, color5, this.endButtonX, this.endButtonY, this.endButtonW, this.endButtonH, this.tabSide(false));
        }
    }

    private void paintTabFrame(Graphics graphics, boolean bl, Color color) {
        int n;
        int n2;
        int n3;
        int n4;
        Tab.Side side;
        if (this.tabs.length == 0) {
            return;
        }
        if (bl) {
            side = this.startTabAreaSide;
            n4 = this.startTabAreaX;
            n3 = this.startTabAreaY;
            switch (side) {
                case RIGHT: 
                case LEFT: {
                    n2 = this.startTabAreaW;
                    n = this.startFrameH;
                    break;
                }
                default: {
                    n2 = this.startFrameW;
                    n = this.startTabAreaH;
                    break;
                }
            }
        } else {
            side = this.endTabAreaSide;
            n4 = this.endTabAreaX;
            n3 = this.endTabAreaY;
            switch (side) {
                case RIGHT: 
                case LEFT: {
                    n2 = this.endTabAreaW;
                    n = this.endFrameH;
                    break;
                }
                default: {
                    n2 = this.endFrameW;
                    n = this.endTabAreaH;
                }
            }
        }
        switch (side) {
            case RIGHT: {
                --n4;
                ++n2;
                break;
            }
            case LEFT: {
                ++n2;
                break;
            }
            case BOTTOM: {
                --n3;
                ++n;
                break;
            }
            default: {
                ++n;
            }
        }
        graphics.setColor(color);
        graphics.drawRect(n4, n3, n2 - 1, n - 1);
    }

    private void paintFrame(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, int n, int n2, int n3, int n4) {
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(n, n2, n3, n4);
        }
        graphics.setColor(color2);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        graphics.setColor(color4);
        graphics.drawLine(--n5, ++n2, n5, --n6);
        graphics.drawLine(n5, n6, ++n, n6);
        graphics.setColor(color3);
        graphics.drawLine(n5, n2, n, n2);
        graphics.drawLine(n, n2, n, n6);
    }

    private void paintSeparator(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, int n, int n2, int n3, int n4) {
        block7: {
            if (this.separatorRelief) {
                this.paintFrame(graphics, color, color2, color3, color4, color5, n, n2, n3, n4);
            }
            if (!this.separatorHandle) break block7;
            if (this.verticalSplit) {
                int n5 = n + (n3 - HANDLE_SIZE) / 2;
                int n6 = n5 + HANDLE_SIZE - 1;
                int n7 = n2;
                int n8 = n7 + n4 - 1;
                int n9 = n8 - n7 + 1;
                int n10 = Math.min(n9, AWTUtil.px(30));
                n8 = (n7 += (n9 - n10) / 2) + n10 - 1;
                boolean bl = true;
                while (n7 <= n8) {
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.drawLine(n5, n7, n6, n7);
                        graphics.setColor(color3);
                        graphics.drawLine(n5 + 1, n7 + 1, n6 + 1, n7 + 1);
                    }
                    n7 += 2;
                    bl = !bl;
                }
            } else {
                int n11 = n;
                int n12 = n11 + n3 - 1;
                int n13 = n2 + (n4 - HANDLE_SIZE) / 2;
                int n14 = n13 + HANDLE_SIZE - 1;
                int n15 = n12 - n11 + 1;
                int n16 = Math.min(n15, AWTUtil.px(30));
                n12 = (n11 += (n15 - n16) / 2) + n16 - 1;
                boolean bl = true;
                while (n11 <= n12) {
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.drawLine(n11, n13, n11, n14);
                        graphics.setColor(color3);
                        graphics.drawLine(n11 + 1, n13 + 1, n11 + 1, n14 + 1);
                    }
                    n11 += 2;
                    bl = !bl;
                }
            }
        }
    }

    private void paintButton(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, int n, int n2, int n3, int n4, Tab.Side side) {
        int n5 = Math.min(n3 / 2, n4 / 2);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        switch (side) {
            case RIGHT: 
            case LEFT: {
                nArray[0] = n += (n3 - (2 * n5 + 1)) / 2;
                nArray2[0] = n2 += 1 + (n4 - (n5 + 1)) / 2;
                nArray[1] = n + n5;
                nArray2[1] = n2 + n5;
                nArray[2] = n + 2 * n5;
                nArray2[2] = n2;
                break;
            }
            default: {
                nArray[0] = n += 1 + (n3 - (n5 + 1)) / 2;
                nArray2[0] = n2 += (n4 - (2 * n5 + 1)) / 2;
                nArray[1] = n + n5;
                nArray2[1] = n2 + n5;
                nArray[2] = n;
                nArray2[2] = n2 + 2 * n5;
            }
        }
        graphics.setColor(color5);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    static {
        TAB_DATA_FLAVORS = new DataFlavor[1];
        try {
            TabbedSplitPane.TAB_DATA_FLAVORS[0] = new DataFlavor("application/x-java-jvm-local-objectref; class=" + Tab.class.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final class MouseHandler
    extends MouseInputAdapter {
        private Tab targetTab = null;
        private Rectangle targetButton = null;
        private int targetButtonIndex = -1;
        private boolean dragging = false;
        private int dragX = -1;
        private int dragY = -1;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.targetTab = null;
            this.targetButton = null;
            this.targetButtonIndex = -1;
            TabTransferHandler tabTransferHandler = null;
            if (TabbedSplitPane.this.dndAction != DnDAction.NONE) {
                tabTransferHandler = (TabTransferHandler)TabbedSplitPane.this.getTransferHandler();
                tabTransferHandler.setTransferableTab(null);
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            for (Tab tab : TabbedSplitPane.this.tabs) {
                Rectangle[] rectangleArray;
                if (n < tab.x || n >= tab.x + tab.width || n2 < tab.y || n2 >= tab.y + tab.height || !TabbedSplitPane.this.isVisibleTab(tab)) continue;
                if (tab.selected && (rectangleArray = tab.getButtons()) != null) {
                    for (int i = 0; i < rectangleArray.length; ++i) {
                        Rectangle rectangle = rectangleArray[i];
                        if (n < rectangle.x || n >= rectangle.x + rectangle.width || n2 < rectangle.y || n2 >= rectangle.y + rectangle.height) continue;
                        this.targetTab = tab;
                        this.targetButton = rectangle;
                        this.targetButtonIndex = i;
                        break;
                    }
                }
                if (this.targetButton == null) {
                    if (tab.selected && TabbedSplitPane.this.dndAction != DnDAction.NONE && mouseEvent.getModifiersEx() == 1024) {
                        tabTransferHandler.setTransferableTab(tab);
                        tabTransferHandler.exportAsDrag(TabbedSplitPane.this, mouseEvent, 2);
                        return;
                    }
                    this.targetTab = tab;
                    this.targetButton = new Rectangle(tab.x, tab.y, tab.width, tab.height);
                    this.targetButtonIndex = -1;
                }
                tab.mousePressed(mouseEvent, this.targetButtonIndex);
                return;
            }
            if (this.popupMenu(mouseEvent)) {
                return;
            }
            if (TabbedSplitPane.this.separatorW > 0) {
                this.startDrag(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.targetButton != null) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (n >= this.targetButton.x && n < this.targetButton.x + this.targetButton.width && n2 >= this.targetButton.y && n2 < this.targetButton.y + this.targetButton.height) {
                    this.targetTab.mouseReleased(mouseEvent, this.targetButtonIndex);
                }
                this.targetButton = null;
                this.targetButtonIndex = -1;
                this.targetTab = null;
                return;
            }
            this.endDrag(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private boolean popupMenu(MouseEvent mouseEvent) {
            int n;
            int n2;
            boolean bl;
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            if (TabbedSplitPane.this.startButtonW > 0 && n3 >= TabbedSplitPane.this.startButtonX && n3 < TabbedSplitPane.this.startButtonX + TabbedSplitPane.this.startButtonW && n4 >= TabbedSplitPane.this.startButtonY && n4 < TabbedSplitPane.this.startButtonY + TabbedSplitPane.this.startButtonH) {
                bl = true;
                n2 = TabbedSplitPane.this.startButtonX;
                n = TabbedSplitPane.this.startButtonY + TabbedSplitPane.this.startButtonH;
            } else if (TabbedSplitPane.this.endButtonW > 0 && n3 >= TabbedSplitPane.this.endButtonX && n3 < TabbedSplitPane.this.endButtonX + TabbedSplitPane.this.endButtonW && n4 >= TabbedSplitPane.this.endButtonY && n4 < TabbedSplitPane.this.endButtonY + TabbedSplitPane.this.endButtonH) {
                bl = false;
                n2 = TabbedSplitPane.this.endButtonX;
                n = TabbedSplitPane.this.endButtonY + TabbedSplitPane.this.endButtonH;
            } else {
                return false;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            MenuHandler menuHandler = new MenuHandler();
            int n5 = TabbedSplitPane.this.tabs.length;
            for (int i = 0; i < n5; ++i) {
                Tab tab = TabbedSplitPane.this.tabs[i];
                if (tab.atStart != bl) continue;
                Object object = tab.getLabel();
                if (object == null) {
                    object = "#" + Integer.toString(1 + i);
                }
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((String)object, tab.selected);
                jCheckBoxMenuItem.addActionListener(menuHandler);
                jCheckBoxMenuItem.setActionCommand(Integer.toString(i));
                jPopupMenu.add(jCheckBoxMenuItem);
            }
            jPopupMenu.show(TabbedSplitPane.this, n2, n);
            return true;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateCursor(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (TabbedSplitPane.this.getCursor() != normalCursor) {
                TabbedSplitPane.this.setCursor(normalCursor);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateCursor(mouseEvent);
        }

        private void updateCursor(MouseEvent mouseEvent) {
            Cursor cursor = normalCursor;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (TabbedSplitPane.this.separatorW > 0 && n >= TabbedSplitPane.this.separatorX && n < TabbedSplitPane.this.separatorX + TabbedSplitPane.this.separatorW && n2 >= TabbedSplitPane.this.separatorY && n2 < TabbedSplitPane.this.separatorY + TabbedSplitPane.this.separatorH) {
                cursor = TabbedSplitPane.this.verticalSplit ? verticalResizeCursor : horizontalResizeCursor;
            } else {
                block0: for (Tab tab : TabbedSplitPane.this.tabs) {
                    Rectangle[] rectangleArray;
                    if (!tab.selected || n < tab.x || n >= tab.x + tab.width || n2 < tab.y || n2 >= tab.y + tab.height || !TabbedSplitPane.this.isVisibleTab(tab) || (rectangleArray = tab.getButtons()) == null) continue;
                    for (int i = 0; i < rectangleArray.length; ++i) {
                        Rectangle rectangle = rectangleArray[i];
                        if (n < rectangle.x || n >= rectangle.x + rectangle.width || n2 < rectangle.y || n2 >= rectangle.y + rectangle.height) continue;
                        cursor = clickButtonCursor;
                        continue block0;
                    }
                }
            }
            if (TabbedSplitPane.this.getCursor() != cursor) {
                TabbedSplitPane.this.setCursor(cursor);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.dragging) {
                this.doDrag(mouseEvent);
            }
        }

        private void startDrag(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n >= TabbedSplitPane.this.separatorX && n < TabbedSplitPane.this.separatorX + TabbedSplitPane.this.separatorW && n2 >= TabbedSplitPane.this.separatorY && n2 < TabbedSplitPane.this.separatorY + TabbedSplitPane.this.separatorH) {
                this.dragging = true;
                this.dragX = n;
                this.dragY = n2;
            }
        }

        private void doDrag(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.dragX;
            int n4 = n2 - this.dragY;
            this.dragX = n;
            this.dragY = n2;
            if (TabbedSplitPane.this.verticalSplit) {
                int n5;
                boolean bl;
                boolean bl2 = bl = TabbedSplitPane.this.tabPlacement != Tab.Side.RIGHT;
                if (!bl) {
                    n3 = -n3;
                }
                int n6 = 2 * COMPONENT_MARGIN + 1;
                if (!TabbedSplitPane.this.isVerticalTabPlacement()) {
                    n6 = Math.max(n6, BUTTON_GAP + BUTTON_WIDTH);
                }
                if ((n5 = TabbedSplitPane.this.startFrameW + n3) < n6) {
                    return;
                }
                int n7 = TabbedSplitPane.this.endFrameW - n3;
                if (n7 < n6) {
                    return;
                }
                double d = (double)n5 * TabbedSplitPane.this.verticalRatio / (double)TabbedSplitPane.this.startFrameW;
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                if (d != TabbedSplitPane.this.verticalRatio) {
                    TabbedSplitPane.this.setVerticalRatio(d);
                }
            } else {
                int n8;
                boolean bl;
                boolean bl3 = bl = TabbedSplitPane.this.tabPlacement != Tab.Side.BOTTOM;
                if (!bl) {
                    n4 = -n4;
                }
                int n9 = 2 * COMPONENT_MARGIN + 1;
                if (TabbedSplitPane.this.isVerticalTabPlacement()) {
                    n9 = Math.max(n9, BUTTON_GAP + BUTTON_HEIGHT);
                }
                if ((n8 = TabbedSplitPane.this.startFrameH + n4) < n9) {
                    return;
                }
                int n10 = TabbedSplitPane.this.endFrameH - n4;
                if (n10 < n9) {
                    return;
                }
                double d = (double)n8 * TabbedSplitPane.this.horizontalRatio / (double)TabbedSplitPane.this.startFrameH;
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                if (d != TabbedSplitPane.this.horizontalRatio) {
                    TabbedSplitPane.this.setHorizontalRatio(d);
                }
            }
        }

        private void endDrag(MouseEvent mouseEvent) {
            if (this.dragging) {
                this.dragY = -1;
                this.dragX = -1;
                this.dragging = false;
            }
        }

        private final class MenuHandler
        implements ActionListener {
            private MenuHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                TabbedSplitPane.this.selectTab(Integer.parseInt(string));
            }
        }
    }

    private final class TabTransferHandler
    extends TransferHandler {
        private Rectangle[] emptySideRects;
        private TabTransferable tabTransferable;
        private Image dragImage;
        private Rectangle dropMarkRect;
        private Timer eraseDropMarkTimer;

        public TabTransferHandler() {
            if (DROP_AREA_SIZE == 0) {
                DROP_AREA_SIZE = AWTUtil.px(5);
                DROP_MARK_PAD = AWTUtil.px(2);
                DROP_MARK_COLOR1 = new Color(0, 128, 0);
                DROP_MARK_COLOR2 = AWTUtil.toBorderColor(DROP_MARK_COLOR1);
            }
            this.emptySideRects = new Rectangle[4];
            for (int i = 0; i < 4; ++i) {
                this.emptySideRects[i] = new Rectangle();
            }
            this.eraseDropMarkTimer = new Timer(3000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TabTransferHandler.this.paintDropMark(null, null);
                }
            });
            this.eraseDropMarkTimer.setRepeats(false);
        }

        public void setTransferableTab(Tab tab) {
            this.tabTransferable = tab == null ? null : new TabTransferable(tab);
            this.dragImage = null;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            if (this.tabTransferable == null) {
                return 0;
            }
            if (this.dragImage == null) {
                this.dragImage = this.toImage(this.tabTransferable.tab);
                this.setDragImage(this.dragImage);
            }
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BufferedImage toImage(Tab tab) {
            BufferedImage bufferedImage = new BufferedImage(tab.width, tab.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                Color color = tab.getBackground();
                if (color == null) {
                    color = TabbedSplitPane.this.getBackground();
                }
                Color color2 = AWTUtil.toHighlightColor(color);
                Color color3 = AWTUtil.toShadowColor(color);
                Color color4 = AWTUtil.toBorderColor(color);
                graphics2D.translate(-tab.x, -tab.y);
                tab.paint(graphics2D, color, color4, color2, color3, TabbedSplitPane.this.getForeground());
            }
            finally {
                graphics2D.dispose();
            }
            return bufferedImage;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (this.tabTransferable == null) {
                return null;
            }
            return this.tabTransferable;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (transferable != null && (n == 0 || SystemUtil.IS_GENERIC_UNIX && n == 2)) {
                int n2;
                Tab tab = null;
                try {
                    tab = (Tab)transferable.getTransferData(TAB_DATA_FLAVORS[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tab != null && (n2 = TabbedSplitPane.this.indexOfTab(tab)) >= 0) {
                    Point point = MouseInfo.getPointerInfo().getLocation();
                    boolean bl = true;
                    for (Window window : Window.getWindows()) {
                        if (!window.isShowing() || !window.getBounds().contains(point)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        TabbedSplitPane.this.fireTabsChanged(tab, n2, tab.atStart, tab, n2, tab.atStart);
                    }
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDrop()) {
                return false;
            }
            TabDropInfo tabDropInfo = this.checkDrop(transferSupport);
            if (tabDropInfo == null) {
                this.paintDropMark(null, null);
                return this.forwardDrop(transferSupport, true);
            }
            this.paintDropMark(tabDropInfo, transferSupport.getDropLocation().getDropPoint());
            return true;
        }

        private boolean forwardDrop(TransferHandler.TransferSupport transferSupport, boolean bl) {
            DataFlavor[] dataFlavorArray = transferSupport.getDataFlavors();
            for (Container container = TabbedSplitPane.this.getParent(); container != null; container = container.getParent()) {
                JComponent jComponent;
                TransferHandler transferHandler;
                if (!(container instanceof JComponent) || (transferHandler = (jComponent = (JComponent)container).getTransferHandler()) == null || !transferHandler.canImport(jComponent, dataFlavorArray)) continue;
                if (bl) {
                    return true;
                }
                return transferHandler.importData(jComponent, transferSupport.getTransferable());
            }
            return false;
        }

        private TabDropInfo checkDrop(TransferHandler.TransferSupport transferSupport) {
            TabDropInfo tabDropInfo = this.checkDropLocation(transferSupport.getDropLocation().getDropPoint());
            if (tabDropInfo == null) {
                return null;
            }
            if (tabDropInfo.anchorTabIndex < 0) {
                tabDropInfo.anchorTab = null;
                tabDropInfo.newTabIndex = tabDropInfo.emptySideDropMark != null ? -1 : 0;
            } else {
                tabDropInfo.anchorTab = TabbedSplitPane.this.getTab(tabDropInfo.anchorTabIndex);
                if (tabDropInfo.anchorTab == null) {
                    return null;
                }
                tabDropInfo.newTabIndex = tabDropInfo.anchorTabIndex;
                if (tabDropInfo.afterAnchorTab) {
                    ++tabDropInfo.newTabIndex;
                }
            }
            try {
                if (transferSupport.isDataFlavorSupported(TAB_DATA_FLAVORS[0])) {
                    tabDropInfo.movedTab = (Tab)transferSupport.getTransferable().getTransferData(TAB_DATA_FLAVORS[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tabDropInfo.movedTab == null || tabDropInfo.movedTab.pane == null) {
                return null;
            }
            tabDropInfo.oldTabIndex = -1;
            if (tabDropInfo.movedTab.pane == TabbedSplitPane.this) {
                tabDropInfo.oldTabIndex = TabbedSplitPane.this.indexOfTab(tabDropInfo.movedTab);
                if (tabDropInfo.oldTabIndex < 0) {
                    return null;
                }
                if (tabDropInfo.newTabIndex >= 0) {
                    if (tabDropInfo.newTabIndex > tabDropInfo.oldTabIndex) {
                        --tabDropInfo.newTabIndex;
                    }
                    if (tabDropInfo.newTabIndex == tabDropInfo.oldTabIndex && tabDropInfo.movedTab.atStart == tabDropInfo.anchorTab.atStart) {
                        return null;
                    }
                }
            } else {
                if (TabbedSplitPane.this.dndAction != DnDAction.MOVE_TABS) {
                    return null;
                }
                Class<?> clazz = tabDropInfo.movedTab.getClass();
                if (TabbedSplitPane.this.allowedTabClasses != null) {
                    boolean bl = false;
                    for (Class<? extends Tab> clazz2 : TabbedSplitPane.this.allowedTabClasses) {
                        if (!clazz2.isAssignableFrom(clazz)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return null;
                    }
                }
            }
            return tabDropInfo;
        }

        /*
         * WARNING - void declaration
         */
        private TabDropInfo checkDropLocation(Point point) {
            boolean bl;
            int n;
            int n2 = TabbedSplitPane.this.tabs.length;
            if (n2 == 0) {
                return new TabDropInfo(-1, false, null, false);
            }
            int n3 = point.x;
            int n4 = point.y;
            block8: for (n = 0; n < n2; ++n) {
                Tab[] tabArray = TabbedSplitPane.this.tabs[n];
                if (!TabbedSplitPane.this.isVisibleTab((Tab)tabArray)) continue;
                switch (tabArray.side) {
                    case BOTTOM: 
                    case TOP: {
                        if (n4 < tabArray.y || n4 >= tabArray.y + tabArray.height) continue block8;
                        if (n3 >= tabArray.x && n3 < tabArray.x + DROP_AREA_SIZE) {
                            return new TabDropInfo(n, false, null, false);
                        }
                        if (n3 >= tabArray.x + tabArray.width || n3 < tabArray.x + tabArray.width - DROP_AREA_SIZE) continue block8;
                        return new TabDropInfo(n, true, null, false);
                    }
                    default: {
                        if (n3 < tabArray.x || n3 >= tabArray.x + tabArray.width) continue block8;
                        if (n4 >= tabArray.y && n4 < tabArray.y + DROP_AREA_SIZE) {
                            return new TabDropInfo(n, false, null, false);
                        }
                        if (n4 >= tabArray.y + tabArray.height || n4 < tabArray.y + tabArray.height - DROP_AREA_SIZE) continue block8;
                        return new TabDropInfo(n, true, null, false);
                    }
                }
            }
            n = 0;
            for (Tab object : TabbedSplitPane.this.tabs) {
                if (!object.atStart) continue;
                ++n;
            }
            boolean bl2 = bl = n == 0;
            if (n == n2 || bl) {
                void var9_16;
                Rectangle rectangle = this.emptySideRects[0];
                Rectangle rectangle2 = this.emptySideRects[1];
                Rectangle rectangle3 = this.emptySideRects[2];
                Rectangle rectangle4 = this.emptySideRects[3];
                if (bl) {
                    rectangle.setBounds(TabbedSplitPane.this.endFrameX, TabbedSplitPane.this.endFrameY - DROP_AREA_SIZE, TabbedSplitPane.this.endFrameW, 2 * DROP_AREA_SIZE);
                    rectangle2.setBounds(TabbedSplitPane.this.endFrameX, TabbedSplitPane.this.endFrameY + TabbedSplitPane.this.endFrameH - DROP_AREA_SIZE, TabbedSplitPane.this.endFrameW, 2 * DROP_AREA_SIZE);
                    rectangle3.setBounds(TabbedSplitPane.this.endFrameX - DROP_AREA_SIZE, TabbedSplitPane.this.endFrameY, 2 * DROP_AREA_SIZE, TabbedSplitPane.this.endFrameH);
                    rectangle4.setBounds(TabbedSplitPane.this.endFrameX + TabbedSplitPane.this.endFrameW - DROP_AREA_SIZE, TabbedSplitPane.this.endFrameY, 2 * DROP_AREA_SIZE, TabbedSplitPane.this.endFrameH);
                } else {
                    rectangle.setBounds(TabbedSplitPane.this.startFrameX, TabbedSplitPane.this.startFrameY - DROP_AREA_SIZE, TabbedSplitPane.this.startFrameW, 2 * DROP_AREA_SIZE);
                    rectangle2.setBounds(TabbedSplitPane.this.startFrameX, TabbedSplitPane.this.startFrameY + TabbedSplitPane.this.startFrameH - DROP_AREA_SIZE, TabbedSplitPane.this.startFrameW, 2 * DROP_AREA_SIZE);
                    rectangle3.setBounds(TabbedSplitPane.this.startFrameX - DROP_AREA_SIZE, TabbedSplitPane.this.startFrameY, 2 * DROP_AREA_SIZE, TabbedSplitPane.this.startFrameH);
                    rectangle4.setBounds(TabbedSplitPane.this.startFrameX + TabbedSplitPane.this.startFrameW - DROP_AREA_SIZE, TabbedSplitPane.this.startFrameY, 2 * DROP_AREA_SIZE, TabbedSplitPane.this.startFrameH);
                }
                switch (TabbedSplitPane.this.tabPlacement) {
                    case RIGHT: {
                        if (bl && TabbedSplitPane.this.endTabAtOppositeSide) {
                            Object var9_14 = null;
                            break;
                        }
                        rectangle4 = null;
                        break;
                    }
                    case LEFT: {
                        if (bl && TabbedSplitPane.this.endTabAtOppositeSide) {
                            rectangle4 = null;
                            break;
                        }
                        Object var9_15 = null;
                        break;
                    }
                    case BOTTOM: {
                        if (bl && TabbedSplitPane.this.endTabAtOppositeSide) {
                            rectangle = null;
                            break;
                        }
                        rectangle2 = null;
                        break;
                    }
                    default: {
                        if (bl && TabbedSplitPane.this.endTabAtOppositeSide) {
                            rectangle2 = null;
                            break;
                        }
                        rectangle = null;
                    }
                }
                if (rectangle != null && rectangle.contains(n3, n4)) {
                    return new TabDropInfo(-1, false, rectangle, bl);
                }
                if (rectangle2 != null && rectangle2.contains(n3, n4)) {
                    return new TabDropInfo(-1, false, rectangle2, bl);
                }
                if (var9_16 != null && var9_16.contains(n3, n4)) {
                    return new TabDropInfo(-1, false, (Rectangle)var9_16, bl);
                }
                if (rectangle4 != null && rectangle4.contains(n3, n4)) {
                    return new TabDropInfo(-1, false, rectangle4, bl);
                }
            }
            return null;
        }

        private void paintDropMark(TabDropInfo tabDropInfo, Point point) {
            Graphics graphics = null;
            if (this.dropMarkRect != null) {
                this.eraseDropMarkTimer.stop();
                Rectangle rectangle = this.dropMarkRect;
                this.dropMarkRect = null;
                graphics = TabbedSplitPane.this.getGraphics();
                if (graphics != null) {
                    graphics.setClip(rectangle);
                    TabbedSplitPane.super.paintComponent(graphics);
                    AWTUtil.setTextAntialiasing(graphics);
                    TabbedSplitPane.this.doPaintComponent(graphics);
                }
            }
            if (tabDropInfo != null) {
                int n;
                int n2;
                int n3;
                int n4;
                if (graphics == null) {
                    graphics = TabbedSplitPane.this.getGraphics();
                } else {
                    graphics.setClip(null);
                }
                Tab tab = tabDropInfo.anchorTab;
                if (tab == null) {
                    if (tabDropInfo.emptySideDropMark != null) {
                        n4 = tabDropInfo.emptySideDropMark.x;
                        n3 = tabDropInfo.emptySideDropMark.y;
                        n2 = tabDropInfo.emptySideDropMark.width;
                        n = tabDropInfo.emptySideDropMark.height;
                    } else {
                        n4 = point.x - DROP_AREA_SIZE;
                        n3 = point.y - DROP_AREA_SIZE;
                        n2 = n = 2 * DROP_AREA_SIZE;
                    }
                } else {
                    switch (tab.side) {
                        case BOTTOM: 
                        case TOP: {
                            n4 = tabDropInfo.afterAnchorTab ? tab.x + tab.width : tab.x;
                            n4 -= DROP_AREA_SIZE;
                            n2 = 2 * DROP_AREA_SIZE;
                            n3 = tab.y;
                            n = tab.height;
                            break;
                        }
                        default: {
                            n3 = tabDropInfo.afterAnchorTab ? tab.y + tab.height : tab.y;
                            n3 -= DROP_AREA_SIZE;
                            n = 2 * DROP_AREA_SIZE;
                            n4 = tab.x;
                            n2 = tab.width;
                        }
                    }
                }
                int n5 = 2 * DROP_MARK_PAD;
                if (n2 > n5 && n > n5) {
                    n4 += DROP_MARK_PAD;
                    n3 += DROP_MARK_PAD;
                    n2 -= n5;
                    n -= n5;
                }
                graphics.setColor(DROP_MARK_COLOR1);
                graphics.fillRect(n4, n3, n2, n);
                graphics.setColor(DROP_MARK_COLOR2);
                graphics.drawRect(n4, n3, n2 - 1, n - 1);
                this.dropMarkRect = new Rectangle(n4, n3, n2, n);
                this.eraseDropMarkTimer.restart();
            }
            if (graphics != null) {
                graphics.dispose();
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDrop()) {
                return false;
            }
            this.paintDropMark(null, null);
            TabDropInfo tabDropInfo = this.checkDrop(transferSupport);
            if (tabDropInfo == null) {
                return this.forwardDrop(transferSupport, false);
            }
            if (tabDropInfo.oldTabIndex >= 0 && (tabDropInfo.newTabIndex < 0 || tabDropInfo.oldTabIndex == tabDropInfo.newTabIndex)) {
                TabbedSplitPane.this.moveTab(tabDropInfo.oldTabIndex, !tabDropInfo.movedTab.atStart);
                TabbedSplitPane.this.selectTab(tabDropInfo.oldTabIndex);
            } else {
                tabDropInfo.movedTab.pane.removeTab(tabDropInfo.movedTab);
                if (tabDropInfo.newTabIndex < 0) {
                    int n = TabbedSplitPane.this.tabs.length;
                    TabbedSplitPane.this.addTab(tabDropInfo.movedTab, n);
                    if (tabDropInfo.movedTab.atStart != tabDropInfo.emptySideAtStart) {
                        TabbedSplitPane.this.moveTab(n, tabDropInfo.emptySideAtStart);
                    }
                    TabbedSplitPane.this.selectTab(n);
                } else {
                    boolean bl;
                    TabbedSplitPane.this.addTab(tabDropInfo.movedTab, tabDropInfo.newTabIndex);
                    boolean bl2 = bl = tabDropInfo.anchorTab == null ? true : tabDropInfo.anchorTab.atStart;
                    if (tabDropInfo.movedTab.atStart != bl) {
                        TabbedSplitPane.this.moveTab(tabDropInfo.newTabIndex, bl);
                    }
                    TabbedSplitPane.this.selectTab(tabDropInfo.newTabIndex);
                }
            }
            return true;
        }
    }

    private static final class TabDropInfo {
        public int anchorTabIndex;
        public boolean afterAnchorTab;
        public Rectangle emptySideDropMark;
        public boolean emptySideAtStart;
        public Tab anchorTab;
        public Tab movedTab;
        public int oldTabIndex;
        public int newTabIndex;

        public TabDropInfo(int n, boolean bl, Rectangle rectangle, boolean bl2) {
            this.anchorTabIndex = n;
            this.afterAnchorTab = bl;
            this.emptySideDropMark = rectangle;
            this.emptySideAtStart = bl2;
        }
    }

    private static final class TabTransferable
    implements Transferable {
        public final Tab tab;

        public TabTransferable(Tab tab) {
            this.tab = tab;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return TAB_DATA_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return TAB_DATA_FLAVORS[0].equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.tab;
        }
    }

    private static final class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.layoutSize((TabbedSplitPane)container, true);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.layoutSize((TabbedSplitPane)container, false);
        }

        private Dimension layoutSize(TabbedSplitPane tabbedSplitPane, boolean bl) {
            int n;
            int n2;
            Tab[] tabArray = tabbedSplitPane.tabs;
            int n3 = tabbedSplitPane.separatorSize;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (bl) {
                for (Tab tab : tabArray) {
                    if (tab.atStart) {
                        n5 = 1;
                        n4 = 1;
                        continue;
                    }
                    n7 = 1;
                    n6 = 1;
                }
            } else {
                for (Tab tab : tabArray) {
                    Dimension dimension = tab.component.getPreferredSize();
                    if (dimension.width < 1) {
                        dimension.width = 1;
                    }
                    if (dimension.height < 1) {
                        dimension.height = 1;
                    }
                    if (tab.atStart) {
                        n4 = Math.max(n4, dimension.width);
                        n5 = Math.max(n5, dimension.height);
                        continue;
                    }
                    n6 = Math.max(n6, dimension.width);
                    n7 = Math.max(n7, dimension.height);
                }
            }
            if (n4 > 0) {
                n4 += 2 * COMPONENT_MARGIN;
                n5 += 2 * COMPONENT_MARGIN;
            }
            if (n6 > 0) {
                n6 += 2 * COMPONENT_MARGIN;
                n7 += 2 * COMPONENT_MARGIN;
            }
            for (n2 = 0; n2 < 2; ++n2) {
                n = n2 == 0 ? 1 : 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                block13: for (Tab tab : tabArray) {
                    if (tab.atStart != n) continue;
                    if (bl) {
                        switch (tab.side) {
                            case RIGHT: {
                                n10 = 1;
                                n11 = 1;
                                break;
                            }
                            case LEFT: {
                                n14 = 1;
                                n15 = 1;
                                break;
                            }
                            case BOTTOM: {
                                n12 = 1;
                                n13 = 1;
                                break;
                            }
                            default: {
                                n8 = 1;
                                n9 = 1;
                                break;
                            }
                        }
                        continue;
                    }
                    Dimension dimension = tab.getIntrinsicSize();
                    switch (tab.side) {
                        case RIGHT: {
                            n10 = Math.max(n10, dimension.width);
                            n11 += dimension.height;
                            continue block13;
                        }
                        case LEFT: {
                            n14 = Math.max(n14, dimension.width);
                            n15 += dimension.height;
                            continue block13;
                        }
                        case BOTTOM: {
                            n12 += dimension.width;
                            n13 = Math.max(n13, dimension.height);
                            continue block13;
                        }
                        default: {
                            n8 += dimension.width;
                            n9 = Math.max(n9, dimension.height);
                        }
                    }
                }
                if (n10 > 0) {
                    n10 = Math.max(n10, BUTTON_WIDTH);
                    n11 = Math.max(n11, BUTTON_GAP + BUTTON_HEIGHT);
                }
                if (n14 > 0) {
                    n14 = Math.max(n14, BUTTON_WIDTH);
                    n15 = Math.max(n15, BUTTON_GAP + BUTTON_HEIGHT);
                }
                if (n12 > 0) {
                    n12 = Math.max(n12, BUTTON_GAP + BUTTON_WIDTH);
                    n13 = Math.max(n13, BUTTON_HEIGHT);
                }
                if (n8 > 0) {
                    n8 = Math.max(n8, BUTTON_GAP + BUTTON_WIDTH);
                    n9 = Math.max(n9, BUTTON_HEIGHT);
                }
                if (n != 0) {
                    n4 = Math.max(n4, Math.max(n8, n12)) + n14 + n10;
                    n5 = Math.max(n5, Math.max(n15, n11)) + n9 + n13;
                    continue;
                }
                n6 = Math.max(n6, Math.max(n8, n12)) + n14 + n10;
                n7 = Math.max(n7, Math.max(n15, n11)) + n9 + n13;
            }
            if (n4 > 0) {
                if (n6 > 0) {
                    if (tabbedSplitPane.verticalSplit) {
                        n2 = n4 + n3 + n6;
                        n = Math.max(n5, Math.max(n3, n7));
                    } else {
                        n2 = Math.max(n4, Math.max(n3, n6));
                        n = n5 + n3 + n7;
                    }
                } else {
                    n2 = n4;
                    n = n5;
                }
            } else {
                n2 = n6;
                n = n7;
            }
            Insets insets = tabbedSplitPane.getInsets();
            n += insets.top + insets.bottom;
            if ((n2 += insets.left + insets.right) < 1) {
                n2 = 1;
            }
            if (n < 1) {
                n = 1;
            }
            return new Dimension(n2, n);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            int n4;
            TabbedSplitPane tabbedSplitPane = (TabbedSplitPane)container;
            Tab[] tabArray = tabbedSplitPane.tabs;
            int n5 = tabbedSplitPane.separatorSize;
            tabbedSplitPane.startTabAreaSide = null;
            tabbedSplitPane.startTabAreaH = 0;
            tabbedSplitPane.startTabAreaW = 0;
            tabbedSplitPane.startTabAreaY = 0;
            tabbedSplitPane.startTabAreaX = 0;
            tabbedSplitPane.startButtonH = 0;
            tabbedSplitPane.startButtonW = 0;
            tabbedSplitPane.startButtonY = 0;
            tabbedSplitPane.startButtonX = 0;
            tabbedSplitPane.startFrameH = 0;
            tabbedSplitPane.startFrameW = 0;
            tabbedSplitPane.startFrameY = 0;
            tabbedSplitPane.startFrameX = 0;
            tabbedSplitPane.separatorH = 0;
            tabbedSplitPane.separatorW = 0;
            tabbedSplitPane.separatorY = 0;
            tabbedSplitPane.separatorX = 0;
            tabbedSplitPane.endTabAreaSide = null;
            tabbedSplitPane.endTabAreaH = 0;
            tabbedSplitPane.endTabAreaW = 0;
            tabbedSplitPane.endTabAreaY = 0;
            tabbedSplitPane.endTabAreaX = 0;
            tabbedSplitPane.endButtonH = 0;
            tabbedSplitPane.endButtonW = 0;
            tabbedSplitPane.endButtonY = 0;
            tabbedSplitPane.endButtonX = 0;
            tabbedSplitPane.endFrameH = 0;
            tabbedSplitPane.endFrameW = 0;
            tabbedSplitPane.endFrameY = 0;
            tabbedSplitPane.endFrameX = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            boolean bl = false;
            boolean bl2 = false;
            Tab[] tabArray2 = tabArray;
            int n10 = tabArray2.length;
            for (n4 = 0; n4 < n10; ++n4) {
                Tab tab = tabArray2[n4];
                Dimension dimension = tab.getIntrinsicSize();
                tab.width = dimension.width;
                tab.height = dimension.height;
                switch (tab.side) {
                    case RIGHT: {
                        n9 = Math.max(n9, tab.width);
                        break;
                    }
                    case LEFT: {
                        n8 = Math.max(n8, tab.width);
                        break;
                    }
                    case BOTTOM: {
                        n7 = Math.max(n7, tab.height);
                        break;
                    }
                    default: {
                        n6 = Math.max(n6, tab.height);
                    }
                }
                if (tab.atStart) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
            if (n9 > 0) {
                n9 = Math.max(n9, BUTTON_WIDTH);
            }
            if (n8 > 0) {
                n8 = Math.max(n8, BUTTON_WIDTH);
            }
            if (n7 > 0) {
                n7 = Math.max(n7, BUTTON_HEIGHT);
            }
            if (n6 > 0) {
                n6 = Math.max(n6, BUTTON_HEIGHT);
            }
            int n11 = n4 = bl && bl2 ? 1 : 0;
            if (n4 != 0) {
                if (tabbedSplitPane.verticalSplit) {
                    n3 = 4 * COMPONENT_MARGIN + 2 + n5;
                    n10 = Math.max(2 * COMPONENT_MARGIN + 1, n5);
                } else {
                    n3 = Math.max(2 * COMPONENT_MARGIN + 1, n5);
                    n10 = 4 * COMPONENT_MARGIN + 2 + n5;
                }
            } else {
                n3 = n10 = 2 * COMPONENT_MARGIN + 1;
            }
            if (n8 > 0 || n9 > 0) {
                n2 = n3 + n8 + n9;
                n = Math.max(n10, BUTTON_GAP + BUTTON_HEIGHT);
            } else {
                n2 = Math.max(n3, BUTTON_GAP + BUTTON_WIDTH);
                n = n10 + n6 + n7;
            }
            Insets insets = tabbedSplitPane.getInsets();
            int n12 = insets.left;
            int n13 = insets.top;
            int n14 = tabbedSplitPane.getWidth() - n12 - insets.right;
            int n15 = tabbedSplitPane.getHeight() - n13 - insets.bottom;
            if (n14 < n2) {
                n14 = n2;
            }
            if (n15 < n) {
                n15 = n;
            }
            int n16 = n12 + n8;
            int n17 = n13 + n6;
            int n18 = n14 - n8 - n9;
            int n19 = n15 - n6 - n7;
            if (n4 != 0) {
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25;
                int n26;
                if (tabbedSplitPane.verticalSplit) {
                    boolean bl3 = tabbedSplitPane.tabPlacement != Tab.Side.RIGHT;
                    n26 = n16;
                    n25 = n17;
                    double d = bl3 ? tabbedSplitPane.verticalRatio : 1.0 - tabbedSplitPane.verticalRatio;
                    int n27 = (int)Math.rint((double)(n18 - n5) * d);
                    if (n27 < 2 * COMPONENT_MARGIN + 1) {
                        n27 = 2 * COMPONENT_MARGIN + 1;
                    }
                    n24 = n19;
                    tabbedSplitPane.separatorX = n26 + n27;
                    tabbedSplitPane.separatorY = n17;
                    tabbedSplitPane.separatorW = n5;
                    tabbedSplitPane.separatorH = n19;
                    n23 = tabbedSplitPane.separatorX + tabbedSplitPane.separatorW;
                    n22 = n17;
                    n21 = n18 - n5 - n27;
                    if (n21 < 2 * COMPONENT_MARGIN + 1) {
                        n21 = 2 * COMPONENT_MARGIN + 1;
                    }
                    n20 = n19;
                    if (bl3) {
                        tabbedSplitPane.startFrameX = n26;
                        tabbedSplitPane.startFrameY = n25;
                        tabbedSplitPane.startFrameW = n27;
                        tabbedSplitPane.startFrameH = n24;
                        tabbedSplitPane.endFrameX = n23;
                        tabbedSplitPane.endFrameY = n22;
                        tabbedSplitPane.endFrameW = n21;
                        tabbedSplitPane.endFrameH = n20;
                    } else {
                        tabbedSplitPane.startFrameX = n23;
                        tabbedSplitPane.startFrameY = n22;
                        tabbedSplitPane.startFrameW = n21;
                        tabbedSplitPane.startFrameH = n20;
                        tabbedSplitPane.endFrameX = n26;
                        tabbedSplitPane.endFrameY = n25;
                        tabbedSplitPane.endFrameW = n27;
                        tabbedSplitPane.endFrameH = n24;
                    }
                } else {
                    boolean object = tabbedSplitPane.tabPlacement != Tab.Side.BOTTOM;
                    n26 = n16;
                    n25 = n17;
                    int n28 = n18;
                    double d = object ? tabbedSplitPane.horizontalRatio : 1.0 - tabbedSplitPane.horizontalRatio;
                    n24 = (int)Math.rint((double)(n19 - n5) * d);
                    if (n24 < 2 * COMPONENT_MARGIN + 1) {
                        n24 = 2 * COMPONENT_MARGIN + 1;
                    }
                    tabbedSplitPane.separatorX = n16;
                    tabbedSplitPane.separatorY = n25 + n24;
                    tabbedSplitPane.separatorW = n18;
                    tabbedSplitPane.separatorH = n5;
                    n23 = n16;
                    n22 = tabbedSplitPane.separatorY + tabbedSplitPane.separatorH;
                    n21 = n18;
                    n20 = n19 - n5 - n24;
                    if (n20 < 2 * COMPONENT_MARGIN + 1) {
                        n20 = 2 * COMPONENT_MARGIN + 1;
                    }
                    if (object) {
                        tabbedSplitPane.startFrameX = n26;
                        tabbedSplitPane.startFrameY = n25;
                        tabbedSplitPane.startFrameW = n28;
                        tabbedSplitPane.startFrameH = n24;
                        tabbedSplitPane.endFrameX = n23;
                        tabbedSplitPane.endFrameY = n22;
                        tabbedSplitPane.endFrameW = n21;
                        tabbedSplitPane.endFrameH = n20;
                    } else {
                        tabbedSplitPane.startFrameX = n23;
                        tabbedSplitPane.startFrameY = n22;
                        tabbedSplitPane.startFrameW = n21;
                        tabbedSplitPane.startFrameH = n20;
                        tabbedSplitPane.endFrameX = n26;
                        tabbedSplitPane.endFrameY = n25;
                        tabbedSplitPane.endFrameW = n28;
                        tabbedSplitPane.endFrameH = n24;
                    }
                }
            } else if (bl2) {
                tabbedSplitPane.endFrameX = n16;
                tabbedSplitPane.endFrameY = n17;
                tabbedSplitPane.endFrameW = n18;
                tabbedSplitPane.endFrameH = n19;
            } else {
                tabbedSplitPane.startFrameX = n16;
                tabbedSplitPane.startFrameY = n17;
                tabbedSplitPane.startFrameW = n18;
                tabbedSplitPane.startFrameH = n19;
            }
            for (Tab tab : tabArray) {
                if (tab.atStart) {
                    tab.component.setBounds(tabbedSplitPane.startFrameX + COMPONENT_MARGIN, tabbedSplitPane.startFrameY + COMPONENT_MARGIN, tabbedSplitPane.startFrameW - 2 * COMPONENT_MARGIN, tabbedSplitPane.startFrameH - 2 * COMPONENT_MARGIN);
                    continue;
                }
                tab.component.setBounds(tabbedSplitPane.endFrameX + COMPONENT_MARGIN, tabbedSplitPane.endFrameY + COMPONENT_MARGIN, tabbedSplitPane.endFrameW - 2 * COMPONENT_MARGIN, tabbedSplitPane.endFrameH - 2 * COMPONENT_MARGIN);
            }
            Object var25_32 = null;
            Tab tab = null;
            Tab tab2 = null;
            Tab tab3 = null;
            Tab tab4 = null;
            Tab tab5 = null;
            Tab tab6 = null;
            Tab tab7 = null;
            block17: for (Tab tab8 : tabArray) {
                if (tab8.atStart) {
                    switch (tab8.side) {
                        case RIGHT: {
                            if (tab == null) {
                                tabbedSplitPane.startTabAreaSide = Tab.Side.RIGHT;
                                tabbedSplitPane.startTabAreaX = tabbedSplitPane.startFrameX + tabbedSplitPane.startFrameW;
                                tabbedSplitPane.startTabAreaY = tabbedSplitPane.startFrameY;
                                tabbedSplitPane.startTabAreaW = n9;
                                tabbedSplitPane.startTabAreaH = tabbedSplitPane.startFrameH;
                                tab8.y = tabbedSplitPane.startTabAreaY;
                            } else {
                                tab8.y = tab.y + tab.height;
                            }
                            tab8.x = tabbedSplitPane.startTabAreaX;
                            tab = tab8;
                            break;
                        }
                        case LEFT: {
                            if (tab3 == null) {
                                tabbedSplitPane.startTabAreaSide = Tab.Side.LEFT;
                                tabbedSplitPane.startTabAreaX = tabbedSplitPane.startFrameX - n8;
                                tabbedSplitPane.startTabAreaY = tabbedSplitPane.startFrameY;
                                tabbedSplitPane.startTabAreaW = n8;
                                tabbedSplitPane.startTabAreaH = tabbedSplitPane.startFrameH;
                                tab8.y = tabbedSplitPane.startTabAreaY;
                            } else {
                                tab8.y = tab3.y + tab3.height;
                            }
                            tab8.x = tabbedSplitPane.startFrameX - tab8.width;
                            tab3 = tab8;
                            break;
                        }
                        case BOTTOM: {
                            if (tab2 == null) {
                                tabbedSplitPane.startTabAreaSide = Tab.Side.BOTTOM;
                                tabbedSplitPane.startTabAreaX = tabbedSplitPane.startFrameX;
                                tabbedSplitPane.startTabAreaY = tabbedSplitPane.startFrameY + tabbedSplitPane.startFrameH;
                                tabbedSplitPane.startTabAreaW = tabbedSplitPane.startFrameW;
                                tabbedSplitPane.startTabAreaH = n7;
                                tab8.x = tabbedSplitPane.startTabAreaX;
                            } else {
                                tab8.x = tab2.x + tab2.width;
                            }
                            tab8.y = tabbedSplitPane.startTabAreaY;
                            tab2 = tab8;
                            break;
                        }
                        default: {
                            void var25_33;
                            if (var25_33 == null) {
                                tabbedSplitPane.startTabAreaSide = Tab.Side.TOP;
                                tabbedSplitPane.startTabAreaX = tabbedSplitPane.startFrameX;
                                tabbedSplitPane.startTabAreaY = tabbedSplitPane.startFrameY - n6;
                                tabbedSplitPane.startTabAreaW = tabbedSplitPane.startFrameW;
                                tabbedSplitPane.startTabAreaH = n6;
                                tab8.x = tabbedSplitPane.startTabAreaX;
                            } else {
                                tab8.x = var25_33.x + var25_33.width;
                            }
                            tab8.y = tabbedSplitPane.startFrameY - tab8.height;
                            Tab tab9 = tab8;
                            break;
                        }
                    }
                    continue;
                }
                switch (tab8.side) {
                    case RIGHT: {
                        if (tab5 == null) {
                            tabbedSplitPane.endTabAreaSide = Tab.Side.RIGHT;
                            tabbedSplitPane.endTabAreaX = tabbedSplitPane.endFrameX + tabbedSplitPane.endFrameW;
                            tabbedSplitPane.endTabAreaY = tabbedSplitPane.endFrameY;
                            tabbedSplitPane.endTabAreaW = n9;
                            tabbedSplitPane.endTabAreaH = tabbedSplitPane.endFrameH;
                            tab8.y = tabbedSplitPane.endTabAreaY;
                        } else {
                            tab8.y = tab5.y + tab5.height;
                        }
                        tab8.x = tabbedSplitPane.endTabAreaX;
                        tab5 = tab8;
                        continue block17;
                    }
                    case LEFT: {
                        if (tab7 == null) {
                            tabbedSplitPane.endTabAreaSide = Tab.Side.LEFT;
                            tabbedSplitPane.endTabAreaX = tabbedSplitPane.endFrameX - n8;
                            tabbedSplitPane.endTabAreaY = tabbedSplitPane.endFrameY;
                            tabbedSplitPane.endTabAreaW = n8;
                            tabbedSplitPane.endTabAreaH = tabbedSplitPane.endFrameH;
                            tab8.y = tabbedSplitPane.endTabAreaY;
                        } else {
                            tab8.y = tab7.y + tab7.height;
                        }
                        tab8.x = tabbedSplitPane.endFrameX - tab8.width;
                        tab7 = tab8;
                        continue block17;
                    }
                    case BOTTOM: {
                        if (tab6 == null) {
                            tabbedSplitPane.endTabAreaSide = Tab.Side.BOTTOM;
                            tabbedSplitPane.endTabAreaX = tabbedSplitPane.endFrameX;
                            tabbedSplitPane.endTabAreaY = tabbedSplitPane.endFrameY + tabbedSplitPane.endFrameH;
                            tabbedSplitPane.endTabAreaW = tabbedSplitPane.endFrameW;
                            tabbedSplitPane.endTabAreaH = n7;
                            tab8.x = tabbedSplitPane.endTabAreaX;
                        } else {
                            tab8.x = tab6.x + tab6.width;
                        }
                        tab8.y = tabbedSplitPane.endTabAreaY;
                        tab6 = tab8;
                        continue block17;
                    }
                    default: {
                        if (tab4 == null) {
                            tabbedSplitPane.endTabAreaSide = Tab.Side.TOP;
                            tabbedSplitPane.endTabAreaX = tabbedSplitPane.endFrameX;
                            tabbedSplitPane.endTabAreaY = tabbedSplitPane.endFrameY - n6;
                            tabbedSplitPane.endTabAreaW = tabbedSplitPane.endFrameW;
                            tabbedSplitPane.endTabAreaH = n6;
                            tab8.x = tabbedSplitPane.endTabAreaX;
                        } else {
                            tab8.x = tab4.x + tab4.width;
                        }
                        tab8.y = tabbedSplitPane.endFrameY - tab8.height;
                        tab4 = tab8;
                    }
                }
            }
            if (bl) {
                this.relayoutTabs(tabbedSplitPane, true);
            }
            if (bl2) {
                this.relayoutTabs(tabbedSplitPane, false);
            }
        }

        public void relayoutTabs(TabbedSplitPane tabbedSplitPane, boolean bl) {
            boolean bl2;
            Dimension dimension;
            int n;
            int n2;
            Tab[] tabArray = tabbedSplitPane.tabs;
            Tab tab = null;
            Tab tab2 = null;
            boolean bl3 = tabbedSplitPane.isVerticalTabPlacement();
            if (bl3) {
                n2 = bl ? tabbedSplitPane.startTabAreaY : tabbedSplitPane.endTabAreaY;
                for (Tab tab3 : tabArray) {
                    if (tab3.atStart != bl) continue;
                    if (tab3.selected) {
                        tab2 = tab3;
                    }
                    n = tab3.width;
                    dimension = tab3.getIntrinsicSize();
                    tab3.width = dimension.width;
                    tab3.height = dimension.height;
                    tab3.y = n2;
                    n2 += tab3.height;
                    if (tab3.side == Tab.Side.LEFT) {
                        tab3.x -= dimension.width - n;
                    }
                    tab3.precedesSelected = false;
                    if (tab3.selected && tab != null) {
                        tab.precedesSelected = true;
                    }
                    tab = tab3;
                }
            } else {
                n2 = bl ? tabbedSplitPane.startTabAreaX : tabbedSplitPane.endTabAreaX;
                for (Tab tab3 : tabArray) {
                    if (tab3.atStart != bl) continue;
                    if (tab3.selected) {
                        tab2 = tab3;
                    }
                    n = tab3.height;
                    dimension = tab3.getIntrinsicSize();
                    tab3.width = dimension.width;
                    tab3.height = dimension.height;
                    tab3.x = n2;
                    n2 += tab3.width;
                    if (tab3.side == Tab.Side.TOP) {
                        tab3.y -= tab3.height - n;
                    }
                    tab3.precedesSelected = false;
                    if (tab3.selected && tab != null) {
                        tab.precedesSelected = true;
                    }
                    tab = tab3;
                }
            }
            n2 = 0;
            int n3 = 0;
            for (Tab tab4 : tabArray) {
                if (tab4.atStart != bl) continue;
                ++n2;
                if (!tabbedSplitPane.isVisibleTab(tab4)) continue;
                ++n3;
            }
            boolean bl4 = bl2 = n2 != n3;
            if (bl) {
                if (bl3) {
                    tabbedSplitPane.startTabAreaH = tabbedSplitPane.startFrameH;
                    if (bl2) {
                        tabbedSplitPane.startTabAreaH -= BUTTON_GAP + BUTTON_HEIGHT;
                    }
                } else {
                    tabbedSplitPane.startTabAreaW = tabbedSplitPane.startFrameW;
                    if (bl2) {
                        tabbedSplitPane.startTabAreaW -= BUTTON_GAP + BUTTON_WIDTH;
                    }
                }
            } else if (bl3) {
                tabbedSplitPane.endTabAreaH = tabbedSplitPane.endFrameH;
                if (bl2) {
                    tabbedSplitPane.endTabAreaH -= BUTTON_GAP + BUTTON_HEIGHT;
                }
            } else {
                tabbedSplitPane.endTabAreaW = tabbedSplitPane.endFrameW;
                if (bl2) {
                    tabbedSplitPane.endTabAreaW -= BUTTON_GAP + BUTTON_WIDTH;
                }
            }
            if (!bl2) {
                if (bl) {
                    tabbedSplitPane.startButtonH = 0;
                    tabbedSplitPane.startButtonW = 0;
                    tabbedSplitPane.startButtonY = 0;
                    tabbedSplitPane.startButtonX = 0;
                } else {
                    tabbedSplitPane.endButtonH = 0;
                    tabbedSplitPane.endButtonW = 0;
                    tabbedSplitPane.endButtonY = 0;
                    tabbedSplitPane.endButtonX = 0;
                }
                return;
            }
            int n4 = tabArray.length;
            for (int i = 0; i < n4 && !tabbedSplitPane.isVisibleTab(tab2); ++i) {
                Tab tab5;
                int n5;
                int n6;
                if (tabArray[i].atStart != tab2.atStart) continue;
                if (bl3) {
                    n6 = tabArray[i].height;
                    for (n5 = i; n5 < n4; ++n5) {
                        tab5 = tabArray[n5];
                        if (tab5.atStart != bl) continue;
                        tab5.y -= n6;
                    }
                    continue;
                }
                n6 = tabArray[i].width;
                for (n5 = i; n5 < n4; ++n5) {
                    tab5 = tabArray[n5];
                    if (tab5.atStart != bl) continue;
                    tab5.x -= n6;
                }
            }
            Tab tab6 = null;
            for (Tab tab7 : tabArray) {
                if (tab7.atStart != bl || !tabbedSplitPane.isVisibleTab(tab7)) continue;
                tab6 = tab7;
            }
            if (bl) {
                tabbedSplitPane.startButtonW = BUTTON_WIDTH;
                tabbedSplitPane.startButtonH = BUTTON_HEIGHT;
                if (bl3) {
                    tabbedSplitPane.startButtonY = tab6 == null ? tabbedSplitPane.startTabAreaY : tab6.y + tab6.height;
                    tabbedSplitPane.startButtonY += BUTTON_GAP;
                    tabbedSplitPane.startButtonX = tabbedSplitPane.startTabAreaX + (tabbedSplitPane.startTabAreaW - BUTTON_WIDTH) / 2;
                } else {
                    tabbedSplitPane.startButtonX = tab6 == null ? tabbedSplitPane.startTabAreaX : tab6.x + tab6.width;
                    tabbedSplitPane.startButtonX += BUTTON_GAP;
                    tabbedSplitPane.startButtonY = tabbedSplitPane.startTabAreaY + (tabbedSplitPane.startTabAreaH - BUTTON_HEIGHT) / 2;
                }
            } else {
                tabbedSplitPane.endButtonW = BUTTON_WIDTH;
                tabbedSplitPane.endButtonH = BUTTON_HEIGHT;
                if (bl3) {
                    tabbedSplitPane.endButtonY = tab6 == null ? tabbedSplitPane.endTabAreaY : tab6.y + tab6.height;
                    tabbedSplitPane.endButtonY += BUTTON_GAP;
                    tabbedSplitPane.endButtonX = tabbedSplitPane.endTabAreaX + (tabbedSplitPane.endTabAreaW - BUTTON_WIDTH) / 2;
                } else {
                    tabbedSplitPane.endButtonX = tab6 == null ? tabbedSplitPane.endTabAreaX : tab6.x + tab6.width;
                    tabbedSplitPane.endButtonX += BUTTON_GAP;
                    tabbedSplitPane.endButtonY = tabbedSplitPane.endTabAreaY + (tabbedSplitPane.endTabAreaH - BUTTON_HEIGHT) / 2;
                }
            }
        }
    }

    public static enum DnDAction {
        NONE,
        REORDER_TABS,
        MOVE_TABS;

    }
}

