/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.IconResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class SplitButton
extends JButton {
    protected JPopupMenu dropDownMenu;
    protected static int SEPARATOR_GAP1;
    protected static int SEPARATOR_GAP2;
    protected static int SEPARATOR_WIDTH;

    public SplitButton() {
        this((Icon)null);
    }

    public SplitButton(Icon icon) {
        super(icon);
        if (SEPARATOR_GAP1 == 0) {
            SEPARATOR_GAP1 = AWTUtil.px(4);
            SEPARATOR_WIDTH = AWTUtil.px(1);
            SEPARATOR_GAP2 = AWTUtil.px(2);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        if (icon != null && !(icon instanceof ComboIcon)) {
            icon = new ComboIcon(this, icon);
        }
        this.doSetIcon(icon);
    }

    protected void doSetIcon(Icon icon) {
        assert (icon == null || icon instanceof ComboIcon);
        super.setIcon(icon);
        this.setDisabledIcon(icon);
    }

    public void setDropDownMenu(JPopupMenu jPopupMenu) {
        this.dropDownMenu = jPopupMenu;
    }

    public JPopupMenu getDropDownMenu() {
        return this.dropDownMenu;
    }

    @Override
    protected void fireActionPerformed(ActionEvent actionEvent) {
        PointerInfo pointerInfo;
        if ((actionEvent.getModifiers() & 0x10) != 0 && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
            Icon icon;
            Point point = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(point, this);
            int n = this.getWidth();
            if (point.x >= 0 && point.x < n && point.y >= 0 && point.y < this.getHeight() && (icon = this.getIcon()) != null && icon instanceof ComboIcon) {
                Insets insets = this.getInsets();
                if (point.x >= (n -= insets.right + ComboIcon.menuIconWidth + SEPARATOR_GAP2 + SEPARATOR_WIDTH / 2)) {
                    this.showDropDownMenu();
                    return;
                }
            }
        }
        super.fireActionPerformed(actionEvent);
    }

    protected void showDropDownMenu() {
        if (this.dropDownMenu != null) {
            Dimension dimension = this.dropDownMenu.getPreferredSize();
            this.dropDownMenu.show(this, this.getWidth() - dimension.width, this.getHeight());
        }
    }

    protected static class ComboIcon
    implements Icon {
        public final Icon clientIcon;
        public final int clientIconWidth;
        public final int clientIconHeight;
        public final Icon clientDisabledIcon;
        private static Icon menuIcon;
        private static int menuIconWidth;
        private static int menuIconHeight;
        private static Icon menuDisabledIcon;

        public ComboIcon(JComponent jComponent, Icon icon) {
            this.clientIcon = icon;
            this.clientIconWidth = icon.getIconWidth();
            this.clientIconHeight = icon.getIconHeight();
            this.clientDisabledIcon = IconResource.createDisabledIcon(icon, jComponent);
            if (menuIcon == null) {
                menuIcon = new IconResource(ComboIcon.class, "combo.png", new JButton().getForeground(), null);
                menuIconWidth = menuIcon.getIconWidth();
                menuIconHeight = menuIcon.getIconHeight();
                menuDisabledIcon = menuIcon;
            }
        }

        @Override
        public int getIconWidth() {
            return this.clientIconWidth + SEPARATOR_GAP1 + SEPARATOR_WIDTH + SEPARATOR_GAP2 + menuIconWidth;
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.clientIconHeight, menuIconHeight);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl = !component.isEnabled();
            Icon icon = bl ? this.clientDisabledIcon : this.clientIcon;
            icon.paintIcon(component, graphics, n, n2);
            n += this.clientIconWidth + SEPARATOR_GAP1;
            Color color = component.getBackground();
            Color color2 = AWTUtil.toSeparatorColor(color);
            graphics.setColor(color2);
            int n3 = n2 + this.clientIconHeight - 1;
            for (int i = SEPARATOR_WIDTH; i > 0; --i) {
                graphics.drawLine(n, n2, n, n3);
                ++n;
            }
            icon = bl ? menuDisabledIcon : menuIcon;
            icon.paintIcon(component, graphics, n += SEPARATOR_GAP2, n2 += (this.clientIconHeight - menuIconHeight) / 2);
        }
    }
}

