/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public final class ReorderJList {
    private static DataFlavor LOCAL_OBJECTS_FLAVOR;
    private static DataFlavor[] LOCAL_OBJECTS_FLAVORS;

    private ReorderJList() {
    }

    public static void initDnD(JList<?> jList) {
        ReorderJList.initDnD(jList, false);
    }

    public static void initDnD(JList<?> jList, boolean bl) {
        jList.setDragEnabled(true);
        jList.setDropMode(DropMode.INSERT);
        jList.setTransferHandler(new ItemTransferHandler(jList, bl));
    }

    static {
        try {
            LOCAL_OBJECTS_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=\"" + Object[].class.getName() + "\"");
            LOCAL_OBJECTS_FLAVORS = new DataFlavor[]{LOCAL_OBJECTS_FLAVOR};
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static final class ItemTransferHandler
    extends TransferHandler {
        private final JList<?> list;
        private final boolean allowMove;

        public ItemTransferHandler(JList<?> jList, boolean bl) {
            this.list = jList;
            this.allowMove = bl;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            final Object[] objectArray = this.list.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            return new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return (DataFlavor[])LOCAL_OBJECTS_FLAVORS.clone();
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                    return dataFlavor.equals(LOCAL_OBJECTS_FLAVOR);
                }

                @Override
                public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                    if (dataFlavor.equals(LOCAL_OBJECTS_FLAVOR)) {
                        return objectArray;
                    }
                    throw new UnsupportedFlavorException(dataFlavor);
                }
            };
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
                int[] nArray = this.list.getSelectedIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    defaultListModel.removeElementAt(nArray[i]);
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return transferSupport.isDrop() && transferSupport.isDataFlavorSupported(LOCAL_OBJECTS_FLAVOR) && this.list.getModel() instanceof DefaultListModel;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            JList.DropLocation dropLocation;
            int n;
            int n2;
            if (!this.canImport(transferSupport)) {
                return false;
            }
            Object[] objectArray = null;
            try {
                objectArray = (Object[])transferSupport.getTransferable().getTransferData(LOCAL_OBJECTS_FLAVOR);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (objectArray == null || objectArray.length == 0) {
                return false;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
            if (!this.allowMove) {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    Object object = objectArray[i];
                    n2 = 0;
                    for (int j = defaultListModel.getSize() - 1; j >= 0; --j) {
                        Object e = defaultListModel.getElementAt(j);
                        if (e != object) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) continue;
                    return false;
                }
            }
            if ((n = (dropLocation = (JList.DropLocation)transferSupport.getDropLocation()).getIndex()) >= defaultListModel.getSize()) {
                n = defaultListModel.getSize();
            }
            for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                defaultListModel.insertElementAt(objectArray[n2], n);
                this.list.removeSelectionInterval(n, n);
            }
            return true;
        }
    }
}

